/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.LineMap;
import com.caucho.regexp.Regexp;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.util.IntMap;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoElement;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.Pattern;
import com.caucho.xpath.UnionPattern;
import com.caucho.xpath.XPath;
import com.caucho.xsl.FormatNumberFun;
import com.caucho.xsl.KeyFun;
import com.caucho.xsl.Sort;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.Template;
import com.caucho.xsl.Xsl;
import com.caucho.xsl.XslNumberFormat;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.XslParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

abstract class Generator {
    private static WriteStream dbg = LogStream.open("/caucho.com/xsl/generate");
    private static final String XSLNS = "http://www.w3.org/1999/XSL/Transform";
    private static final String XTPNS = "http://www.caucho.com/XTP/1.0";
    private static final int STYLESHEET = 0;
    private static final int OUTPUT = 1;
    private static final int IMPORT = 2;
    private static final int INCLUDE = 3;
    private static final int TEMPLATE = 4;
    private static final int STRIP_SPACE = 5;
    private static final int PRESERVE_SPACE = 6;
    private static final int KEY = 7;
    private static final int LOCALE = 8;
    private static final int ATTRIBUTE_SET = 9;
    private static final int NAMESPACE_ALIAS = 10;
    private static final int APPLY_TEMPLATES = 11;
    private static final int APPLY_IMPORTS = 12;
    private static final int CALL_TEMPLATE = 13;
    private static final int PARAM = 14;
    private static final int VARIABLE = 15;
    private static final int VALUE_OF = 16;
    private static final int COPY_OF = 17;
    private static final int FOR_EACH = 18;
    private static final int IF = 19;
    private static final int CHOOSE = 20;
    private static final int TEXT = 21;
    private static final int XSL_TEXT = 22;
    private static final int NUMBER = 23;
    private static final int COPY = 24;
    private static final int COPY_ELEMENT = 25;
    private static final int ELEMENT = 26;
    private static final int ATTRIBUTE = 27;
    private static final int PI = 28;
    private static final int COMMENT = 29;
    private static final int MESSAGE = 30;
    private static final int EXPRESSION = 31;
    private static final int SCRIPTLET = 32;
    private static final int DECLARATION = 33;
    private static final int DIRECTIVE_CACHE = 34;
    private static final int DIRECTIVE_PAGE = 35;
    private static final int IGNORE = 36;
    private static IntMap tags = new IntMap();
    private static IntMap xtpTags;
    private String version = "1.0";
    Path context;
    Path[] stylePath;
    CharBuffer text;
    HashMap names = new HashMap();
    int loopDepth;
    protected HashMap preserve = new HashMap();
    protected HashMap strip = new HashMap();
    HashMap attributeSets = new HashMap();
    protected HashMap namespaceAliases = new HashMap();
    protected HashMap excludedNamespaces = new HashMap();
    protected KeyFun keyFun;
    protected FormatNumberFun formatNumberFun;
    protected NamespaceContext namespace;
    boolean lineContent;
    int lineWs;
    String filename;
    int line;
    protected LineMap lineMap;
    private ArrayList frags;
    protected int destLine = 1;
    boolean defaultCacheable = true;
    boolean isCacheable;
    protected String encoding;
    HashMap templates = new HashMap();
    int minImportance;
    int importance;
    private IntArray vars = new IntArray();
    private ArrayList inits = new ArrayList();
    protected ArrayList depends = new ArrayList();
    protected ArrayList cacheDepends = new ArrayList();
    private boolean isCauchoXsl;
    protected boolean isRawText;
    protected String errorPage;
    boolean hasSession;
    protected Pattern nodeListContext;
    private boolean isTop;
    private ClassLoader loader;
    protected boolean isSpecial;
    HashMap outputAttributes;
    HashMap macros;
    HashMap files;
    protected ArrayList imports = new ArrayList();

    void init(String string) {
        this.lineMap = new LineMap(string);
    }

    void setErrorPage(String string) {
        this.errorPage = string;
    }

    void addImport(String string) {
        this.imports.add(string);
    }

    void setContentType(String string) {
    }

    public StylesheetImpl generate(Document document) throws Exception {
        CauchoElement cauchoElement = (CauchoElement)document.getDocumentElement();
        if (cauchoElement == null) {
            throw this.error(document, "xsl:stylesheet must be top");
        }
        this.isTop = true;
        this.files = new HashMap();
        this.scanFiles(cauchoElement);
        if (this.getXslLocal(cauchoElement) == "stylesheet" || this.getXslLocal(cauchoElement) == "transform") {
            this.generateStylesheet(cauchoElement, true);
        } else {
            this.printHeader();
            boolean bl = this.isCacheable;
            boolean bl2 = this.defaultCacheable;
            this.isCacheable = true;
            this.printTemplate(cauchoElement, null, "/", null, Double.NaN);
            this.isCacheable = bl;
            this.defaultCacheable = bl2;
        }
        StylesheetImpl stylesheetImpl = this.completeGenerate(this.inits);
        return stylesheetImpl;
    }

    private void scanFiles(Element element) throws IOException {
        Object object;
        String string;
        Node node;
        this.isCauchoXsl = element.getAttribute("xsl-caucho") != null;
        Iterator iterator = XPath.select("//xtp:directive.page/@*", element);
        while (iterator.hasNext()) {
            node = (Attr)iterator.next();
            string = node.getNodeName();
            object = node.getNodeValue();
            if (!string.equals("import")) continue;
            this.addImport((String)object);
        }
        iterator = XPath.select("//xsl:import|xsl:include", element);
        while (iterator.hasNext()) {
            node = (Element)iterator.next();
            string = node.getAttribute("href");
            object = this.getXslPath(string);
            Document document = this.readXsl((Path)object);
            this.files.put(object, document);
            CauchoElement cauchoElement = (CauchoElement)document.getDocumentElement();
            Path path = this.context;
            this.context = ((Path)object).getParent();
            this.scanFiles(cauchoElement);
            this.context = path;
        }
    }

    private void generateStylesheet(Element element, boolean bl) throws Exception {
        this.isCauchoXsl = !element.getAttribute("xsl-caucho").equals("");
        this.addNamespace(element);
        if (bl) {
            this.printHeader();
        }
        this.version = element.getAttribute("version");
        if (this.version.equals("")) {
            this.version = "1.0";
        }
        this.generateAttributeSets(element);
        this.excludeNamespaces(element);
        String string = element.getAttribute("xsl-space");
        CauchoNode cauchoNode = (CauchoNode)element.getFirstChild();
        while (cauchoNode != null) {
            block8: {
                int n;
                block7: {
                    String string2;
                    block6: {
                        n = -1;
                        string2 = this.getXslLocal(cauchoNode);
                        if (string2 == null) break block6;
                        n = tags.get(string2);
                        break block7;
                    }
                    string2 = this.getXtpLocal(cauchoNode);
                    if (string2 == null) break block8;
                    n = xtpTags.get(string2);
                }
                CauchoElement cauchoElement = (CauchoElement)cauchoNode;
                NamespaceContext namespaceContext = this.addNamespace(cauchoElement);
                this.generateTopLevelNode(n, cauchoElement);
                this.namespace = namespaceContext;
            }
            cauchoNode = (CauchoNode)cauchoNode.getNextSibling();
        }
    }

    private void excludeNamespaces(Element element) throws Exception {
        CauchoElement cauchoElement = (CauchoElement)element;
        String string = element.getAttribute("exclude-namespace-prefixes");
        if (!string.equals("")) {
            Regexp regexp = new Regexp("[,\\s]+");
            ArrayList arrayList = regexp.split(string);
            int n = 0;
            while (n < arrayList.size()) {
                String string2 = (String)arrayList.get(n);
                String string3 = cauchoElement.getNamespace(string2);
                if (string3 == null) {
                    throw this.error(cauchoElement, "`" + string2 + "' must be a namespace prefix");
                }
                this.excludedNamespaces.put(string3, "");
                ++n;
            }
        }
    }

    private void generateTopLevelNode(int n, CauchoElement cauchoElement) throws Exception {
        this.setLocation(cauchoElement.getFilename(), cauchoElement.getLine());
        switch (n) {
            case 21: {
                break;
            }
            case 4: {
                this.generateTemplate(cauchoElement);
                break;
            }
            case 1: {
                this.generateOutput(cauchoElement);
                break;
            }
            case 15: {
                this.inits.add(cauchoElement);
                break;
            }
            case 14: {
                this.inits.add(cauchoElement);
                break;
            }
            case 6: {
                this.generatePreserveSpace(cauchoElement);
                break;
            }
            case 5: {
                this.generateStripSpace(cauchoElement);
                break;
            }
            case 2: {
                this.generateImport(cauchoElement);
                break;
            }
            case 3: {
                this.generateInclude(cauchoElement);
                break;
            }
            case 7: {
                this.generateKey(cauchoElement);
                break;
            }
            case 8: {
                this.generateLocale(cauchoElement);
                break;
            }
            case 10: {
                this.generateNamespaceAlias(cauchoElement);
                break;
            }
            case 33: {
                this.printDeclaration(cauchoElement);
                break;
            }
            case 34: {
                this.addCacheDepends(cauchoElement.getAttribute("file"));
                if (!cauchoElement.getAttribute("no-cache").equals("")) {
                    this.isCacheable = false;
                    this.defaultCacheable = false;
                    break;
                }
                this.defaultCacheable = true;
                break;
            }
            case 9: 
            case 36: {
                break;
            }
            default: {
                if (n >= 0) {
                    throw this.error(cauchoElement, "xsl:stylesheet cannot contain `" + cauchoElement.getNodeName() + "'");
                }
                if (!cauchoElement.getNamespace().equals(XSLNS) || this.version == null || !this.version.equals("1.0")) break;
                throw this.error(cauchoElement, "unknown XSL element `" + cauchoElement.getNodeName() + "'");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addCacheDepends(String var1_1) {
        if (var1_1.equals("")) {
            return;
        }
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = var1_1.length();
        if (true) ** GOTO lbl9
        while (true) {
            ++var2_2;
lbl9:
            // 2 sources

            if (var2_2 < var4_4) {
                v0 = var1_1.charAt(var2_2);
                var3_3 = v0;
                if (XmlChar.isWhitespace(v0)) continue;
            }
            if (var3_3 != 44) break;
        }
        var5_5 = new CharBuffer();
        while (var2_2 < var4_4) {
            var5_5.clear();
            if (true) ** GOTO lbl23
            do {
                var5_5.append((char)var3_3);
                ++var2_2;
lbl23:
                // 2 sources

                if (var2_2 >= var4_4) break;
                v1 = var1_1.charAt(var2_2);
                var3_3 = v1;
            } while (!XmlChar.isWhitespace(v1) && var3_3 != 44);
            this.cacheDepends.add(var5_5.toString());
            if (true) ** GOTO lbl32
            while (true) {
                ++var2_2;
lbl32:
                // 2 sources

                if (var2_2 < var4_4) {
                    v2 = var1_1.charAt(var2_2);
                    var3_3 = v2;
                    if (XmlChar.isWhitespace(v2)) continue;
                }
                if (var3_3 != 44) break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void generateCacheDepends(String var1_1) throws Exception {
        if (var1_1.equals("")) {
            return;
        }
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = var1_1.length();
        if (true) ** GOTO lbl9
        while (true) {
            ++var2_2;
lbl9:
            // 2 sources

            if (var2_2 < var4_4) {
                v0 = var1_1.charAt(var2_2);
                var3_3 = v0;
                if (XmlChar.isWhitespace(v0)) continue;
            }
            if (var3_3 != 44) break;
        }
        var5_5 = new CharBuffer();
        while (var2_2 < var4_4) {
            var5_5.clear();
            if (true) ** GOTO lbl23
            do {
                var5_5.append((char)var3_3);
                ++var2_2;
lbl23:
                // 2 sources

                if (var2_2 >= var4_4) break;
                v1 = var1_1.charAt(var2_2);
                var3_3 = v1;
            } while (!XmlChar.isWhitespace(v1) && var3_3 != 44);
            this.printCacheDepends(var5_5.toString());
            if (true) ** GOTO lbl31
            while (true) {
                ++var2_2;
lbl31:
                // 2 sources

                if (var2_2 < var4_4) {
                    v2 = var1_1.charAt(var2_2);
                    var3_3 = v2;
                    if (XmlChar.isWhitespace(v2)) continue;
                }
                if (var3_3 != 44) break;
            }
        }
    }

    void generateTemplate(Element element) throws Exception {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("match");
        String string3 = element.getAttribute("mode");
        String string4 = element.getAttribute("priority");
        double d = Double.NaN;
        if (!string.equals("")) {
            this.macros.put(string, string);
        }
        if (string.equals("") && string2.equals("")) {
            throw this.error("xsl:template expects a `name' or a `match' attribute.");
        }
        if (!string4.equals("")) {
            try {
                d = Double.valueOf(string4);
            }
            catch (Exception exception) {
                throw this.error("xsl:template expects `priority' must be a double.");
            }
        }
        boolean bl = this.isCacheable;
        boolean bl2 = this.defaultCacheable;
        Pattern pattern = this.nodeListContext;
        if (!string2.equals("")) {
            this.nodeListContext = this.parseMatch(string2);
        }
        this.isCacheable = true;
        this.printTemplate(element, string, string2, string3, d);
        this.nodeListContext = pattern;
        this.isCacheable = bl;
        this.defaultCacheable = bl2;
    }

    void generateImport(Element element) throws Exception {
        String string = element.getAttribute("href");
        if (string.equals("")) {
            throw this.error("xsl:import expects `href' attribute.");
        }
        Path path = this.getXslPath(string);
        Document document = (Document)this.files.get(path);
        if (document == null) {
            throw new FileNotFoundException(path.toString());
        }
        CauchoElement cauchoElement = (CauchoElement)document.getDocumentElement();
        if (cauchoElement == null || this.getXslLocal(cauchoElement) != "stylesheet" && this.getXslLocal(cauchoElement) != "transform") {
            throw this.error("imported stylesheet `" + string + "' missing xsl:stylesheet.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:import must be empty");
        }
        int n = this.minImportance;
        Path path2 = this.context;
        this.minImportance = this.importance;
        this.context = path.getParent();
        boolean bl = this.isTop;
        boolean bl2 = this.isRawText;
        this.isTop = false;
        this.isRawText = false;
        this.generateStylesheet(cauchoElement, false);
        this.isRawText = bl2;
        this.isTop = bl;
        this.minImportance = n;
        this.context = path2;
        this.incrementImportance();
    }

    void generateInclude(Element element) throws Exception {
        String string = element.getAttribute("href");
        if (string.equals("")) {
            throw this.error("xsl:include expects `href' attribute.");
        }
        Path path = this.getXslPath(string);
        Document document = (Document)this.files.get(path);
        CauchoElement cauchoElement = (CauchoElement)document.getDocumentElement();
        if (cauchoElement == null || this.getXslLocal(cauchoElement) != "stylesheet" && this.getXslLocal(cauchoElement) != "transform") {
            throw this.error("imported stylesheet `" + string + "' missing xsl:stylesheet.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:include must be empty");
        }
        Path path2 = this.context;
        this.context = path.getParent();
        this.generateStylesheet(cauchoElement, false);
        this.context = path2;
    }

    void generateKey(Element element) throws Exception {
        String string = element.getAttribute("name");
        if (string.equals("")) {
            throw this.error("xsl:key expects `name' attribute.");
        }
        String string2 = element.getAttribute("match");
        if (string2.equals("")) {
            throw this.error("xsl:key expects `match' attribute.");
        }
        String string3 = element.getAttribute("use");
        if (string3.equals("")) {
            throw this.error("xsl:key expects `use' attribute.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:key must be empty");
        }
        this.keyFun.add(string, this.parseMatch(string2), this.parseExpr(string3));
    }

    void generateLocale(Element element) throws Exception {
        String string = element.getAttribute("name");
        if (string.equals("")) {
            string = "*";
        }
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        String string2 = element.getAttribute("decimal-separator");
        if (string2.length() > 0) {
            decimalFormatSymbols.setDecimalSeparator(string2.charAt(0));
        }
        if ((string2 = element.getAttribute("grouping-separator")).length() > 0) {
            decimalFormatSymbols.setGroupingSeparator(string2.charAt(0));
        }
        if (!(string2 = element.getAttribute("infinity")).equals("")) {
            decimalFormatSymbols.setInfinity(string2);
        }
        if ((string2 = element.getAttribute("minus-sign")).length() > 0) {
            decimalFormatSymbols.setMinusSign(string2.charAt(0));
        }
        if (!(string2 = element.getAttribute("NaN")).equals("")) {
            decimalFormatSymbols.setNaN(string2);
        }
        if ((string2 = element.getAttribute("percent")).length() > 0) {
            decimalFormatSymbols.setPercent(string2.charAt(0));
        }
        if ((string2 = element.getAttribute("per-mille")).length() > 0) {
            decimalFormatSymbols.setPerMill(string2.charAt(0));
        }
        if ((string2 = element.getAttribute("zero-digit")).length() > 0) {
            decimalFormatSymbols.setZeroDigit(string2.charAt(0));
        }
        if ((string2 = element.getAttribute("digit")).length() > 0) {
            decimalFormatSymbols.setDigit(string2.charAt(0));
        }
        if ((string2 = element.getAttribute("pattern-separator")).length() > 0) {
            decimalFormatSymbols.setPatternSeparator(string2.charAt(0));
        }
        this.formatNumberFun.addLocale(string, decimalFormatSymbols);
    }

    void generateNamespaceAlias(Element element) throws Exception {
        CauchoElement cauchoElement = (CauchoElement)element;
        String string = element.getAttribute("stylesheet-prefix");
        String string2 = element.getAttribute("result-prefix");
        if (string.equals("")) {
            throw this.error(element, "xsl:namespace-alias needs `stylesheet-prefix'");
        }
        if (string2.equals("")) {
            throw this.error(element, "xsl:namespace-alias needs `result-prefix'");
        }
        String string3 = cauchoElement.getNamespace(string);
        if (string.equals("#default")) {
            string3 = "";
        } else if (string3.equals("")) {
            throw this.error(element, "`" + string + "' is not a valid namespace prefix");
        }
        String string4 = cauchoElement.getNamespace(string2);
        if (string2.equals("#default")) {
            string2 = "";
            string4 = "";
        } else if (string4.equals("")) {
            throw this.error(element, "`" + string2 + "' is not a valid namespace prefix");
        }
        String[] stringArray = new String[]{string2, string4};
        this.namespaceAliases.put(string3, stringArray);
    }

    void generateAttributeSets(Element element) throws Exception {
        Node node = element.getFirstChild();
        while (node != null) {
            if (this.getXslLocal(node) == "attribute-set") {
                Object object;
                Object object2;
                CauchoElement cauchoElement = (CauchoElement)node;
                String string = cauchoElement.getAttribute("name");
                if (string.equals("")) {
                    throw this.error("xsl:attribute-set expects `name' attribute.");
                }
                HashMap hashMap = (HashMap)this.attributeSets.get(string);
                if (hashMap == null) {
                    hashMap = new HashMap();
                    this.attributeSets.put(string, hashMap);
                }
                Node node2 = cauchoElement.getFirstAttribute();
                while (node2 != null) {
                    if (node2.getNodeName().equals("xsl:use-attribute-sets")) {
                        object2 = (HashMap)this.attributeSets.get(node2.getNodeValue());
                        if (object2 == null) {
                            throw this.error("Unknown attribute-set `" + node2.getNodeValue() + "'");
                        }
                        object = ((HashMap)object2).keySet().iterator();
                        while (object.hasNext()) {
                            String string2 = (String)object.next();
                            hashMap.put(string2, ((HashMap)object2).get(string2));
                        }
                    }
                    node2 = node2.getNextSibling();
                }
                node2 = cauchoElement.getFirstChild();
                while (node2 != null) {
                    if (this.getXslLocal(node2) == "attribute") {
                        object2 = (Element)node2;
                        object = object2.getAttribute("name");
                        if (((String)object).equals("")) {
                            throw this.error("xsl:attribute expects `name' attribute.");
                        }
                        hashMap.put(object, ((CauchoElement)node2).getTextValue());
                    }
                    node2 = node2.getNextSibling();
                }
                node2 = cauchoElement.getFirstAttribute();
                while (node2 != null) {
                    if (!node2.getNodeName().equals("name") && !node2.getNodeName().equals("xsl:use-attribute-sets")) {
                        hashMap.put(node2.getNodeName(), node2.getNodeValue());
                    }
                    node2 = (Attr)node2.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
    }

    private void generateOutput(Element element) throws Exception {
        Node node = ((CauchoElement)element).getFirstAttribute();
        if (element.getFirstChild() != null) {
            throw this.error("xsl:output must be empty");
        }
        String string = element.getAttribute("disable-output-escaping");
        this.isRawText = !string.equals("") && !string.equals("no") && !string.equals("false");
        if (!this.isTop) {
            return;
        }
        if (this.outputAttributes == null) {
            this.outputAttributes = new HashMap();
        }
        while (node != null) {
            this.outputAttributes.put(node.getNodeName(), node.getNodeValue());
            node = node.getNextSibling();
        }
    }

    private void generatePreserveSpace(Element element) throws Exception {
        String string = element.getAttribute("elements");
        if (string.equals("")) {
            throw this.error("xsl:preserve-space expects `elements' attribute.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:preserve-space must be empty");
        }
        int n = 0;
        int n2 = string.length();
        while (n < n2 && XmlChar.isWhitespace(string.charAt(n))) {
            ++n;
        }
        CharBuffer charBuffer = new CharBuffer();
        while (n < n2) {
            charBuffer.clear();
            while (n < n2 && !XmlChar.isWhitespace(string.charAt(n))) {
                charBuffer.append(string.charAt(n));
                ++n;
            }
            this.preserve.put(charBuffer.toString(), "true");
            while (n < n2 && XmlChar.isWhitespace(string.charAt(n))) {
                ++n;
            }
        }
    }

    private void generateStripSpace(Element element) throws Exception {
        String string = element.getAttribute("elements");
        if (string.equals("")) {
            throw this.error("xsl:strip-space expects `elements' attribute.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:strip-space must be empty");
        }
        int n = 0;
        int n2 = string.length();
        while (n < n2 && XmlChar.isWhitespace(string.charAt(n))) {
            ++n;
        }
        CharBuffer charBuffer = new CharBuffer();
        while (n < n2) {
            charBuffer.clear();
            while (n < n2 && !XmlChar.isWhitespace(string.charAt(n))) {
                charBuffer.append(string.charAt(n));
                ++n;
            }
            this.strip.put(charBuffer.toString(), "true");
            while (n < n2 && XmlChar.isWhitespace(string.charAt(n))) {
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void generateChildren(Node node) throws Exception {
        this.vars.add(0);
        CauchoNode cauchoNode = (CauchoNode)node.getFirstChild();
        while (cauchoNode != null) {
            block10: {
                NamespaceContext namespaceContext;
                int n;
                block11: {
                    String string;
                    block8: {
                        block9: {
                            block7: {
                                string = this.getXslLocal(cauchoNode);
                                n = -1;
                                if (string == null) break block7;
                                n = tags.get(string);
                                break block8;
                            }
                            string = this.getXtpLocal(cauchoNode);
                            if (string == null) break block9;
                            n = xtpTags.get(string);
                            break block8;
                        }
                        if (this.macros.get(cauchoNode.getNodeName()) == null) break block8;
                        this.generateMacro((Element)((Object)cauchoNode));
                        break block10;
                    }
                    if (string != null) break block11;
                    if (cauchoNode.getNodeType() == 3) {
                        this.generateText(cauchoNode);
                        break block10;
                    } else if (cauchoNode.getNodeType() == 1) {
                        namespaceContext = this.addNamespace((CauchoElement)cauchoNode);
                        this.printLocation(cauchoNode.getFilename(), cauchoNode.getLine());
                        this.printElement((Element)((Object)cauchoNode));
                        this.namespace = namespaceContext;
                    }
                    break block10;
                }
                if (cauchoNode instanceof CauchoElement) {
                    namespaceContext = this.addNamespace((CauchoElement)cauchoNode);
                    this.generateChild(cauchoNode, n);
                    this.namespace = namespaceContext;
                } else {
                    this.generateChild(cauchoNode, n);
                }
            }
            cauchoNode = (CauchoNode)cauchoNode.getNextSibling();
        }
        int n = this.vars.pop();
        if (n > 0 && this.vars.size() > 0) {
            this.printPopScope(n);
        }
    }

    private void generateChild(CauchoNode cauchoNode, int n) throws Exception {
        this.setLocation(cauchoNode.getFilename(), cauchoNode.getLine());
        switch (n) {
            case 21: {
                this.generateText(cauchoNode);
                break;
            }
            case 22: {
                this.generateXslText((Element)((Object)cauchoNode));
                break;
            }
            case 11: {
                this.generateApplyTemplates((Element)((Object)cauchoNode));
                break;
            }
            case 12: {
                this.generateApplyImports((Element)((Object)cauchoNode));
                break;
            }
            case 13: {
                this.generateCallTemplate((Element)((Object)cauchoNode));
                break;
            }
            case 14: {
                this.generateParamVariable((Element)((Object)cauchoNode));
                break;
            }
            case 15: {
                this.generateVariable((Element)((Object)cauchoNode));
                break;
            }
            case 16: {
                this.generateValueOf((Element)((Object)cauchoNode));
                break;
            }
            case 17: {
                this.generateCopyOf((Element)((Object)cauchoNode));
                break;
            }
            case 18: {
                this.generateForEach((Element)((Object)cauchoNode));
                break;
            }
            case 19: {
                this.generateIf((Element)((Object)cauchoNode));
                break;
            }
            case 20: {
                this.generateChoose((Element)((Object)cauchoNode));
                break;
            }
            case 23: {
                this.generateNumber((Element)((Object)cauchoNode));
                break;
            }
            case 24: {
                this.printCopy((Element)((Object)cauchoNode));
                break;
            }
            case 25: {
                this.printCopyElement((Element)((Object)cauchoNode));
                break;
            }
            case 26: {
                this.generateElement((Element)((Object)cauchoNode));
                break;
            }
            case 27: {
                this.generateAttribute((Element)((Object)cauchoNode));
                break;
            }
            case 28: {
                this.printPi((Element)((Object)cauchoNode));
                break;
            }
            case 29: {
                this.printComment((Element)((Object)cauchoNode));
                break;
            }
            case 30: {
                this.printMessage((Element)((Object)cauchoNode));
                break;
            }
            case 31: {
                if (!this.defaultCacheable) {
                    this.isCacheable = false;
                }
                this.printExpression((Element)((Object)cauchoNode));
                break;
            }
            case 32: {
                if (!this.defaultCacheable) {
                    this.isCacheable = false;
                }
                this.printScriptlet((Element)((Object)cauchoNode));
                break;
            }
            case 34: {
                this.generateCacheDepends(((Element)((Object)cauchoNode)).getAttribute("file"));
                if (!((Element)((Object)cauchoNode)).getAttribute("no-cache").equals("")) {
                    this.isCacheable = false;
                    this.defaultCacheable = false;
                    break;
                }
                this.defaultCacheable = true;
                break;
            }
            case 36: {
                break;
            }
            default: {
                if (cauchoNode.getNamespace().equals(XSLNS) && this.version != null && this.version.equals("1.0")) {
                    throw this.error(cauchoNode, "unknown XSL element `" + cauchoNode.getNodeName() + "'");
                }
                Node node = cauchoNode.getFirstChild();
                boolean bl = false;
                while (node != null) {
                    String string = this.getXslLocal(node);
                    if (string != null && string.equals("fallback")) {
                        bl = true;
                        this.generateChildren(node);
                    }
                    node = node.getNextSibling();
                }
                if (bl) break;
                this.printError("expected xsl tag at `" + cauchoNode.getNodeName() + "'");
                break;
            }
        }
    }

    private void generateText(Node node) throws Exception {
        String string = node.getNodeValue();
        int n = string.length();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n && XmlChar.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        if (n2 == n && this.stripNode(node)) {
            return;
        }
        if (string != null && string.length() > 0) {
            this.setLocation(((CauchoNode)node).getFilename(), ((CauchoNode)node).getLine());
            this.writeText(string);
        }
    }

    private boolean stripNode(Node node) {
        node = node.getParentNode();
        while (node != null) {
            Element element;
            String string;
            if (node instanceof Element && !(string = (element = (Element)node).getAttribute("xml:space")).equals("")) {
                return !string.equals("preserve");
            }
            node = node.getParentNode();
        }
        return true;
    }

    void generateXslText(Element element) throws Exception {
        this.text.clear();
        Object object = element.getFirstChild();
        while (object != null) {
            if (object instanceof Text) {
                String string = object.getNodeValue();
                int n = string.length();
                this.text.append(string);
            }
            object = object.getNextSibling();
        }
        object = element.getAttribute("disable-output-escaping");
        if (((String)object).equals("")) {
            object = "no";
        }
        if (this.text.length() > 0) {
            if (!((String)object).equals("yes") && !((String)object).equals("true")) {
                this.writeText(this.text.toString());
            } else {
                this.startDisableEscaping();
                this.writeText(this.text.toString());
                this.endDisableEscaping();
            }
        }
    }

    private void generateApplyTemplates(Node node) throws Exception {
        Sort[] sortArray;
        CauchoElement cauchoElement = (CauchoElement)node;
        String string = cauchoElement.getAttribute("select");
        String string2 = cauchoElement.getAttribute("mode");
        Pattern pattern = null;
        if (!string.equals("")) {
            pattern = this.parseSelect(string);
        }
        if ((sortArray = this.generateSort(node)) != null && pattern == null) {
            pattern = this.parseSelect("*");
        }
        this.pushCall();
        this.generateArgs(cauchoElement);
        this.printApplyTemplates(pattern, string2, sortArray);
        this.popCall();
    }

    private void generateApplyImports(Node node) throws Exception {
        CauchoElement cauchoElement = (CauchoElement)node;
        String string = cauchoElement.getAttribute("mode");
        if (cauchoElement.getFirstChild() != null) {
            throw this.error("xsl:apply-imports must be empty");
        }
        this.pushCall();
        this.generateArgs(cauchoElement);
        this.printApplyImports(string, this.minImportance, this.importance);
        this.popCall();
    }

    private void generateCallTemplate(Element element) throws Exception {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("mode");
        if (string.equals("")) {
            throw this.error("xsl:call-template requires `name' attribute");
        }
        this.pushCall();
        this.generateArgs(element);
        this.printCallTemplate(string, string2);
        this.popCall();
    }

    private void generateMacro(Element element) throws Exception {
        CauchoElement cauchoElement = (CauchoElement)element;
        String string = element.getNodeName();
        String string2 = element.getAttribute("mode");
        this.pushCall();
        Node node = cauchoElement.getFirstAttribute();
        while (node != null) {
            String string3 = node.getNodeName();
            String string4 = node.getNodeValue();
            this.printParam(string3, string4, cauchoElement);
            node = node.getNextSibling();
        }
        this.printParam("contents", cauchoElement);
        this.printCallTemplate(string, string2);
        this.popCall();
    }

    private void generateArgs(Element element) throws Exception {
        Node node = element.getFirstChild();
        while (node != null) {
            String string = this.getXslLocal(node);
            if (string == "with-param") {
                String string2 = ((Element)node).getAttribute("name");
                String string3 = ((Element)node).getAttribute("select");
                if (string2.equals("")) {
                    throw this.error("xsl:with-param requires `name' attribute");
                }
                if (!string3.equals("")) {
                    this.printParam(string2, this.parseExpr(string3));
                } else {
                    this.printParam(string2, node);
                }
            }
            node = node.getNextSibling();
        }
    }

    private void generateParamVariable(Element element) throws Exception {
        int n = this.vars.size() - 1;
        this.vars.set(n, this.vars.get(n) + 1);
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("select");
        if (string.equals("")) {
            throw this.error("xsl:param expects `name' attribute.");
        }
        if (!string2.equals("")) {
            this.printParamVariable(string, this.parseExpr(string2));
        } else {
            this.printParamVariable(string, element);
        }
    }

    private void generateVariable(Element element) throws Exception {
        int n = this.vars.size() - 1;
        this.vars.set(n, this.vars.get(n) + 1);
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("select");
        if (string.equals("")) {
            throw this.error("xsl:variable expects `name' attribute.");
        }
        if (!string2.equals("")) {
            this.printVariable(string, this.parseExpr(string2));
        } else {
            this.printVariable(string, element);
        }
    }

    private void generateValueOf(Element element) throws Exception {
        String string = element.getAttribute("select");
        if (string.equals("")) {
            throw this.error("xsl:value-of expects `select' attribute.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:value-of must be empty");
        }
        String string2 = element.getAttribute("disable-output-escaping");
        boolean bl = string2.equals("yes");
        if (bl) {
            this.startDisableEscaping();
        }
        this.printSelectValue(string, element);
        if (bl) {
            this.endDisableEscaping();
        }
    }

    private void generateCopyOf(Element element) throws Exception {
        String string = element.getAttribute("select");
        if (string.equals("")) {
            throw this.error("xsl:copy-of expects `select' attribute.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:copy-of must be empty");
        }
        this.printCopyOf(string, element);
    }

    void generateForEach(Element element) throws Exception {
        String string = element.getAttribute("select");
        if (string.equals("")) {
            throw this.error("xsl:for-each expects `select' attribute.");
        }
        Sort[] sortArray = this.generateSort(element);
        if (sortArray != null) {
            this.printForEach(element, string, sortArray);
        } else {
            this.printForEach(element, string);
        }
    }

    private Sort[] generateSort(Node node) throws IOException {
        ArrayList<Sort> arrayList = new ArrayList<Sort>();
        Node node2 = node.getFirstChild();
        block0: while (node2 != null) {
            String string;
            if (node2.getNodeType() == 3) {
                string = node2.getNodeValue();
                int n = 0;
                while (n < string.length()) {
                    if (!XmlChar.isWhitespace(string.charAt(n))) break block0;
                    ++n;
                }
            } else {
                string = this.getXslLocal(node2);
                if (string != "sort") break;
                Element element = (Element)node2;
                String string2 = element.getAttribute("select");
                if (string2.equals("")) {
                    throw this.error("xsl:sort expects attribute `select'");
                }
                Expr expr = this.parseExpr(string2);
                String string3 = element.getAttribute("order");
                boolean bl = true;
                if (string3.equals("descending")) {
                    bl = false;
                }
                String string4 = element.getAttribute("data-type");
                boolean bl2 = true;
                if (string4.equals("number")) {
                    bl2 = false;
                }
                arrayList.add(Sort.create(expr, bl, bl2));
            }
            node2 = node2.getNextSibling();
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new Sort[arrayList.size()]);
        }
        return null;
    }

    void generateIf(Element element) throws Exception {
        String string = element.getAttribute("test");
        if (string.equals("")) {
            throw this.error("xsl:if expects `test' attribute.");
        }
        this.printIf(element, this.parseExpr(string));
    }

    void generateChoose(Element element) throws Exception {
        boolean bl = true;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                String string = this.getXslLocal(node);
                if (string == "when") {
                    Element element2 = (Element)node;
                    String string2 = element2.getAttribute("test");
                    if (string2.equals("")) {
                        throw this.error("xsl:when expects `test' attribute");
                    }
                    this.printChoose(element2, this.parseExpr(string2), bl);
                    bl = false;
                } else if (string == "otherwise") {
                    this.printOtherwise((Element)node, bl);
                } else {
                    throw this.error("xsl:choose expects `xsl:when' or `xsl:otherwise' at `" + node.getNodeName() + "'");
                }
            }
            node = node.getNextSibling();
        }
    }

    void generateElement(Element element) throws Exception {
        String string = element.getAttribute("name");
        if (string.equals("")) {
            throw this.error("xsl:element expects `name' attribute.");
        }
        Attr attr = element.getAttributeNode("namespace");
        this.printLocation(((CauchoNode)((Object)element)).getFilename(), ((CauchoNode)((Object)element)).getLine());
        if (attr == null) {
            this.printElement(element, string);
        } else {
            this.printElement(element, string, attr.getNodeValue());
        }
    }

    void generateAttribute(Element element) throws Exception {
        String string = element.getAttribute("name");
        if (string.equals("")) {
            throw this.error("xsl:attribute expects `name' attribute.");
        }
        Attr attr = element.getAttributeNode("namespace");
        boolean bl = this.isSpecial;
        this.isSpecial = true;
        if (attr == null) {
            this.printAttribute(element, string);
        } else {
            this.printAttribute(element, string, attr.getNodeValue());
        }
        this.isSpecial = bl;
    }

    void generateNumber(Element element) throws Exception {
        String string = element.getAttribute("value");
        String string2 = element.getAttribute("count");
        String string3 = element.getAttribute("from");
        String string4 = element.getAttribute("level");
        String string5 = element.getAttribute("format");
        String string6 = element.getAttribute("letter-value");
        String string7 = element.getAttribute("grouping-separator");
        String string8 = element.getAttribute("lang");
        String string9 = element.getAttribute("grouping-size");
        int n = 0;
        int n2 = 0;
        while (n2 < string9.length()) {
            char c = string9.charAt(n2);
            if (c >= '0' && c <= '9') {
                n = 10 * n + c - 48;
            }
            n2 += 1;
        }
        n2 = 1;
        if (!string6.equals("alphabetic")) {
            n2 = 0;
        }
        Pattern pattern = null;
        if (!string2.equals("")) {
            pattern = this.parseMatch(string2);
        }
        Pattern pattern2 = null;
        if (!string3.equals("")) {
            pattern2 = this.parseMatch(string3);
        }
        if (string4.equals("") || string4.equals("single")) {
            string4 = "single";
        } else if (!string4.equals("multiple") && !string4.equals("any")) {
            throw this.error("xsl:number cannot understand level=`" + string4 + "'");
        }
        XslNumberFormat xslNumberFormat = new XslNumberFormat(string5, string8, n2 != 0, string7, n);
        if (!string.equals("")) {
            this.printNumber(this.parseExpr(string), xslNumberFormat);
        } else {
            this.printNumber(string4, pattern, pattern2, xslNumberFormat);
        }
    }

    void printNumber(Expr expr, XslNumberFormat xslNumberFormat) throws Exception {
    }

    void printNumber(String string, Pattern pattern, Pattern pattern2, XslNumberFormat xslNumberFormat) throws Exception {
    }

    protected void setLocation(String string, int n) throws IOException {
        if (string != null) {
            this.filename = string;
            this.line = n;
            this.lineMap.add(string, n, this.destLine);
        }
    }

    int getTextLength() {
        return this.text.length();
    }

    protected void printHeader() throws IOException {
    }

    protected abstract void startDisableEscaping() throws Exception;

    protected abstract void endDisableEscaping() throws Exception;

    protected abstract void writeText(String var1) throws Exception;

    protected abstract void printTemplate(Element var1, String var2, String var3, String var4, double var5) throws Exception;

    protected abstract void printLocation(String var1, int var2) throws Exception;

    protected abstract void printElement(Node var1) throws Exception;

    protected abstract void printApplyTemplates(Pattern var1, String var2, Sort[] var3) throws Exception;

    protected abstract void printApplyImports(String var1, int var2, int var3) throws Exception;

    protected abstract void printCallTemplate(String var1, String var2) throws Exception;

    protected abstract void pushCall() throws Exception;

    protected abstract void popCall() throws Exception;

    protected abstract void printParam(String var1, Object var2) throws Exception;

    protected abstract void printParam(String var1, String var2, Element var3) throws Exception;

    protected abstract void printParamVariable(String var1, Expr var2) throws Exception;

    protected abstract void printParamVariable(String var1, Element var2) throws Exception;

    protected abstract void printVariable(String var1, Object var2) throws Exception;

    protected abstract void printPopScope(int var1) throws Exception;

    protected abstract void printCopyOf(String var1, Element var2) throws Exception;

    protected abstract void printSelectValue(String var1, Element var2) throws Exception;

    protected abstract void printForEach(Element var1, String var2) throws Exception;

    protected abstract void printForEach(Element var1, String var2, Sort[] var3) throws Exception;

    protected void printIf(Element element, Expr expr) throws Exception {
    }

    protected void printChoose(Element element, Expr expr, boolean bl) throws Exception {
    }

    protected void printOtherwise(Element element, boolean bl) throws Exception {
    }

    protected void printCopy(Element element) throws Exception {
    }

    protected void printCopyElement(Element element) throws Exception {
    }

    protected void printElement(Element element, String string) throws Exception {
    }

    protected void printElement(Element element, String string, String string2) throws Exception {
    }

    protected void printAttribute(Element element, String string) throws Exception {
    }

    protected void printAttribute(Element element, String string, String string2) throws Exception {
    }

    protected void printPi(Element element) throws Exception {
    }

    protected void printComment(Element element) throws Exception {
    }

    protected void printError(String string) throws Exception {
    }

    protected void printMessage(Element element) throws Exception {
    }

    protected void printExpression(Element element) throws Exception {
    }

    protected void printScriptlet(Element element) throws Exception {
    }

    protected void printDeclaration(Element element) throws Exception {
    }

    protected void printCacheDepends(String string) throws Exception {
    }

    private void incrementImportance() {
        ++this.importance;
    }

    void addPattern(Pattern pattern, String string, double d, String string2, int n) {
        if (pattern instanceof UnionPattern) {
            UnionPattern unionPattern = (UnionPattern)pattern;
            this.addPattern(unionPattern.getLeft(), string, d, string2, n);
            this.addPattern(unionPattern.getRight(), string, d, string2, n);
            return;
        }
        if (Double.isNaN(d)) {
            d = pattern.getPriority();
        }
        if (dbg.canWrite()) {
            dbg.log("add " + pattern.getNodeName() + " " + pattern + " fun:" + string2 + " mode:" + string + " priority:" + d);
        }
        Template template = new Template(pattern, string, this.minImportance, this.importance, d, string2, n);
        this.addTemplate(pattern.getNodeName(), template);
    }

    private void addTemplate(String string, Template template) {
        ArrayList<Template> arrayList = (ArrayList<Template>)this.templates.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Template>();
            this.templates.put(string, arrayList);
        }
        int n = 0;
        while (n < arrayList.size()) {
            Template template2 = (Template)arrayList.get(n);
            if (template.compareTo(template2) >= 0) {
                arrayList.add(n, template);
                return;
            }
            ++n;
        }
        arrayList.add(template);
    }

    protected Pattern parseMatch(String string) throws IOException {
        try {
            return XPath.parseMatch(string, this.namespace);
        }
        catch (Exception exception) {
            throw this.error(exception.toString() + " in pattern `" + string + "'");
        }
    }

    protected Pattern parseSelect(String string) throws IOException {
        try {
            return XPath.parseSelect(string, this.namespace);
        }
        catch (Exception exception) {
            throw this.error(exception);
        }
    }

    protected Expr parseExpr(String string) throws IOException {
        try {
            return XPath.parseExpr(string, this.namespace, this.nodeListContext);
        }
        catch (Exception exception) {
            throw this.error(exception);
        }
    }

    XslParseException error(String string) {
        return new XslParseException(this.filename + ":" + this.line + ": " + string);
    }

    XslParseException error(Exception exception) {
        if (exception.getMessage() != null) {
            return this.error(exception.getMessage());
        }
        exception.printStackTrace();
        if (dbg.canWrite()) {
            exception.printStackTrace(dbg.getPrintWriter());
        }
        return this.error(exception.toString());
    }

    XslParseException error(Node node, String string) {
        CauchoNode cauchoNode = (CauchoNode)node;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        CauchoNode cauchoNode2 = cauchoNode;
        if (cauchoNode2 != null) {
            if (cauchoNode2.getFilename() != null) {
                string2 = cauchoNode2.getFilename();
                n = cauchoNode2.getLine();
                n2 = cauchoNode2.getColumn();
            }
        }
        if (string2 != null) {
            return new XslParseException(string2 + ":" + n + ":" + (n2 == 0 ? " " : n2 + " ") + string);
        }
        return this.error(string);
    }

    Path getXslPath(String string) throws IOException {
        Path path = Xsl.findXslPath(string, this.stylePath, this.loader);
        if (path != null) {
            return path;
        }
        return this.context.lookup(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Document readXsl(Path path) throws IOException {
        Document document;
        ReadStream readStream;
        block4: {
            Document document2;
            block3: {
                readStream = path.openRead();
                this.addDepend(path);
                try {
                    if (this.isCauchoXsl) {
                        XslParser xslParser = new XslParser();
                        document2 = xslParser.parse(readStream);
                        Object var4_6 = null;
                        break block3;
                    }
                    document = new Xml().parse(readStream);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    readStream.close();
                    throw throwable;
                }
            }
            readStream.close();
            return document2;
        }
        Object var4_7 = null;
        readStream.close();
        return document;
    }

    private String getXslLocal(Node node) {
        if (!(node instanceof Element)) {
            return null;
        }
        CauchoElement cauchoElement = (CauchoElement)node;
        String string = cauchoElement.getNamespace();
        String string2 = cauchoElement.getPrefixName();
        if (string.startsWith(XSLNS) || string == "" && string2 == "xsl") {
            return cauchoElement.getLocalName();
        }
        return null;
    }

    private String getXtpLocal(Node node) {
        if (!(node instanceof Element)) {
            return null;
        }
        CauchoElement cauchoElement = (CauchoElement)node;
        String string = cauchoElement.getNamespace();
        String string2 = cauchoElement.getPrefixName();
        if (string.startsWith(XTPNS) || string == "" && string2 == "xtp") {
            return cauchoElement.getLocalName();
        }
        return null;
    }

    private Expr parseExpr(Node node, String string) throws Exception {
        try {
            return XPath.parseExpr(string, this.namespace, this.nodeListContext);
        }
        catch (Exception exception) {
            throw this.error(node, exception.getMessage());
        }
    }

    private NamespaceContext addNamespace(Element element) {
        NamespaceContext namespaceContext = this.namespace;
        Node node = ((CauchoElement)element).getFirstAttribute();
        while (node != null) {
            block7: {
                String string;
                block6: {
                    block5: {
                        string = node.getNodeName();
                        if (!string.startsWith("xmlns:")) break block5;
                        string = string.substring(6);
                        break block6;
                    }
                    if (!string.equals("xmlns")) break block7;
                    string = "";
                }
                String string2 = node.getNodeValue();
                if (string2.startsWith("quote:")) {
                    string2 = string2.substring(6);
                }
                this.namespace = new NamespaceContext(this.namespace, string, string2);
            }
            node = node.getNextSibling();
        }
        return namespaceContext;
    }

    void addDepend(Path path) {
        this.depends.add(path);
    }

    protected abstract StylesheetImpl completeGenerate(ArrayList var1) throws Exception;

    Generator(Path path, Path[] pathArray, ClassLoader classLoader) {
        this.addDepend(path);
        this.context = path.getParent();
        this.stylePath = pathArray;
        this.loader = classLoader;
        this.text = new CharBuffer();
        this.frags = new ArrayList();
        this.macros = new HashMap();
        this.keyFun = new KeyFun();
        this.formatNumberFun = new FormatNumberFun();
    }

    static {
        tags.put("stylesheet", 0);
        tags.put("transform", 0);
        tags.put("output", 1);
        tags.put("template", 4);
        tags.put("preserve-space", 6);
        tags.put("strip-space", 5);
        tags.put("import", 2);
        tags.put("include", 3);
        tags.put("key", 7);
        tags.put("decimal-format", 8);
        tags.put("attribute-set", 9);
        tags.put("namespace-alias", 10);
        tags.put("apply-templates", 11);
        tags.put("apply-imports", 12);
        tags.put("call-template", 13);
        tags.put("param", 14);
        tags.put("variable", 15);
        tags.put("for-each", 18);
        tags.put("if", 19);
        tags.put("choose", 20);
        tags.put("value-of", 16);
        tags.put("copy-of", 17);
        tags.put("text", 22);
        tags.put("#text", 21);
        tags.put("number", 23);
        tags.put("copy", 24);
        tags.put("element", 26);
        tags.put("attribute", 27);
        tags.put("pi", 28);
        tags.put("processing-instruction", 28);
        tags.put("comment", 29);
        tags.put("message", 30);
        tags.put("sort", 36);
        tags.put("fallback", 36);
        xtpTags = new IntMap();
        xtpTags.put("copy-element", 25);
        xtpTags.put("expression", 31);
        xtpTags.put("expr", 31);
        xtpTags.put("eval", 31);
        xtpTags.put("scriptlet", 32);
        xtpTags.put("script", 32);
        xtpTags.put("decl", 33);
        xtpTags.put("declaration", 33);
        xtpTags.put("directive.cache", 34);
    }
}

