/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.util.CharBuffer;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Node;

class StringExpr
extends Expr {
    private int code;
    private Expr left;
    private Expr right;
    private Expr third;
    private String value;
    private ArrayList args;

    public boolean isString() {
        return true;
    }

    public String getValue() {
        return this.value;
    }

    public String evalString(Env env, Node node, Node node2) {
        switch (this.code) {
            case 0: {
                return this.value;
            }
            case 37: {
                return this.left.evalString(env, node, node2);
            }
            case 38: {
                CharBuffer charBuffer = new CharBuffer();
                int n = 0;
                while (n < this.args.size()) {
                    String string = ((Expr)this.args.get(n)).evalString(env, node, node2);
                    charBuffer.append(string);
                    ++n;
                }
                return charBuffer.toString();
            }
            case 42: {
                String string = this.left.evalString(env, node, node2);
                String string2 = this.right.evalString(env, node, node2);
                int n = string.indexOf(string2);
                return n > 0 ? string.substring(0, n) : "";
            }
            case 43: {
                String string = this.left.evalString(env, node, node2);
                String string3 = this.right.evalString(env, node, node2);
                int n = string.indexOf(string3);
                return n >= 0 ? string.substring(n + 1) : "";
            }
            case 45: {
                String string = this.left.evalString(env, node, node2);
                return this.normalize(string);
            }
            case 46: {
                String string = this.left.evalString(env, node, node2);
                String string4 = this.right.evalString(env, node, node2);
                String string5 = this.third.evalString(env, node, node2);
                return this.translate(string, string4, string5);
            }
            case 47: {
                return this.left.evalString(env, node, node2);
            }
            case 48: {
                Object object = this.left.evalObject(env, node, node2);
                Node node3 = Expr.toNode(object);
                if (node3 != null) {
                    return ((CauchoNode)node3).getLocalName();
                }
                return "";
            }
            case 49: {
                Object object = this.left.evalObject(env, node, node2);
                Node node4 = Expr.toNode(object);
                if (node4 != null) {
                    return ((CauchoNode)node4).getNamespace();
                }
                return "";
            }
            case 50: {
                Object object = this.left.evalObject(env, node, node2);
                Node node5 = Expr.toNode(object);
                if (node5 != null) {
                    return ((CauchoNode)node5).getNodeName();
                }
                return "";
            }
            case 51: {
                Iterator iterator = this.left.evalNodeSet(env, node, node2);
                return "G" + String.valueOf(System.identityHashCode(iterator.next()));
            }
            case 53: {
                String string = this.left.evalString(env, node, node2);
                if (string == null) {
                    return "";
                }
                if (string.equals("xsl:version")) {
                    return "1.0";
                }
                return "";
            }
            case 41: {
                int n;
                String string = this.left.evalString(env, node, node2);
                if (string == null) {
                    string = "";
                }
                if ((n = (int)this.right.evalNumber(env, node, node2)) < 0) {
                    n = 0;
                } else if (n > string.length()) {
                    n = string.length();
                }
                int n2 = string.length();
                if (this.third != null) {
                    n2 = (int)this.third.evalNumber(env, node, node2);
                }
                if (n2 < n) {
                    n2 = n;
                } else if (n2 > string.length()) {
                    n2 = string.length();
                }
                return string.substring(n, n2);
            }
        }
        throw new RuntimeException("unknown code: " + this.code);
    }

    public boolean evalBoolean(Env env, Node node, Node node2) {
        String string = this.evalString(env, node, node2);
        return string != null && string.length() > 0;
    }

    public double evalNumber(Env env, Node node, Node node2) {
        return Expr.stringToNumber(this.evalString(env, node, node2));
    }

    public Object evalObject(Env env, Node node, Node node2) {
        return this.evalString(env, node, node2);
    }

    private String normalize(String string) {
        CharBuffer charBuffer = new CharBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2 && XmlChar.isWhitespace(string.charAt(n))) {
            ++n;
        }
        boolean bl = false;
        while (n < n2) {
            if (XmlChar.isWhitespace(string.charAt(n))) {
                bl = true;
            } else if (bl) {
                charBuffer.append(' ');
                charBuffer.append(string.charAt(n));
                bl = false;
            } else {
                charBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return charBuffer.toString();
    }

    private String translate(String string, String string2, String string3) {
        CharBuffer charBuffer = new CharBuffer();
        int n = 0;
        while (n < string.length()) {
            block4: {
                char c = string.charAt(n);
                int n2 = 0;
                while (n2 < string2.length()) {
                    if (c == string2.charAt(n2)) {
                        if (string3.length() > n2) {
                            charBuffer.append(string3.charAt(n2));
                        }
                        break block4;
                    }
                    ++n2;
                }
                charBuffer.append(c);
            }
            ++n;
        }
        return charBuffer.toString();
    }

    public String toString() {
        switch (this.code) {
            case 0: {
                CharBuffer charBuffer = CharBuffer.allocate();
                charBuffer.append("'");
                int n = 0;
                while (n < this.value.length()) {
                    char c = this.value.charAt(n);
                    switch (c) {
                        case '\n': {
                            charBuffer.append("\\n");
                            break;
                        }
                        case '\r': {
                            charBuffer.append("\\r");
                            break;
                        }
                        case '\\': {
                            charBuffer.append("\\\\");
                            break;
                        }
                        case '\'': {
                            charBuffer.append("\\'");
                        }
                        case '\"': {
                            charBuffer.append("\\\"");
                            break;
                        }
                        default: {
                            charBuffer.append(c);
                        }
                    }
                    ++n;
                }
                charBuffer.append("'");
                return charBuffer.toString();
            }
            case 37: {
                return "string(" + this.left + ")";
            }
            case 38: {
                String string = "concat(";
                int n = 0;
                while (n < this.args.size()) {
                    if (n > 0) {
                        string = string + ", ";
                    }
                    string = string + this.args.get(n);
                    ++n;
                }
                return string + ")";
            }
            case 42: {
                return "substring-before(" + this.left + ", " + this.right + ")";
            }
            case 43: {
                return "substring-after(" + this.left + ", " + this.right + ")";
            }
            case 45: {
                return "normalize(" + this.left + ")";
            }
            case 46: {
                return "translate(" + this.left + ", " + this.right + ", " + this.third + ")";
            }
            case 47: {
                return "format-number(" + this.left + ")";
            }
            case 48: {
                return "local-part(" + this.left + ")";
            }
            case 49: {
                return "namespace-uri(" + this.left + ")";
            }
            case 50: {
                return "name(" + this.left + ")";
            }
            case 51: {
                return "generate-id(" + this.left + ")";
            }
            case 53: {
                return "system-property(" + this.left + ")";
            }
            case 41: {
                return "substring(" + this.left + "," + this.right + (this.third == null ? "" : "," + this.third) + ")";
            }
        }
        return super.toString();
    }

    StringExpr(int n, Expr expr, Expr expr2, Expr expr3) {
        this.code = n;
        this.left = expr;
        this.right = expr2;
        this.third = expr3;
    }

    StringExpr(int n, Expr expr, Expr expr2) {
        this.code = n;
        this.left = expr;
        this.right = expr2;
    }

    StringExpr(int n, Expr expr) {
        this.code = n;
        this.left = expr;
    }

    StringExpr(String string) {
        this.code = 0;
        this.value = string;
    }

    StringExpr(int n, ArrayList arrayList) {
        this.code = n;
        this.args = arrayList;
        if (arrayList.size() > 0) {
            this.left = (Expr)arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            this.right = (Expr)arrayList.get(1);
        }
        if (arrayList.size() > 2) {
            this.third = (Expr)arrayList.get(2);
        }
    }
}

