/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoElement;
import com.caucho.xpath.Env;
import com.caucho.xpath.FromAny;
import com.caucho.xpath.FromContext;
import com.caucho.xpath.FromRoot;
import com.caucho.xpath.NamespaceNode;
import com.caucho.xpath.SelectIterator;
import com.caucho.xpath.XPath;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class Pattern {
    protected static WriteStream dbg = LogStream.open("/caucho.com/xpath/eval");
    Pattern parent;

    public Node find(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        Env env = XPath.createEnv();
        env.setCurrent(node);
        Iterator iterator = this.select(node, env, node, this);
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (!this.match(node2, env, node)) continue;
            XPath.freeEnv(env);
            return node2;
        }
        XPath.freeEnv(env);
        return null;
    }

    public Node find(Node node, Env env) {
        if (node == null) {
            throw new NullPointerException();
        }
        env.setCurrent(node);
        Iterator iterator = this.select(node, env, node, this);
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (!this.match(node2, env, node)) continue;
            return node2;
        }
        return null;
    }

    public Iterator select(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        Env env = XPath.createEnv();
        env.setCurrent(node);
        Iterator iterator = this.select(node, env, node, this);
        XPath.freeEnv(env);
        return iterator;
    }

    public Iterator select(Node node, Env env) {
        if (node == null) {
            throw new NullPointerException();
        }
        env.setCurrent(node);
        return this.select(node, env, node, this);
    }

    Iterator select(Node node, Env env, Node node2, Pattern pattern) {
        return new SelectIterator(node, env, node2, pattern);
    }

    public boolean isMatch(Node node) {
        return this.isMatch(node, null);
    }

    public boolean isMatch(Node node, Env env) {
        if (env == null) {
            env = XPath.createEnv();
            env.setCurrent(node);
            boolean bl = this.match(node, env, node);
            XPath.freeEnv(env);
            return bl;
        }
        env.setCurrent(node);
        return this.match(node, env, node);
    }

    public double getPriority() {
        return 0.5;
    }

    public String getNodeName() {
        return "*";
    }

    abstract boolean match(Node var1, Env var2, Node var3);

    boolean isAscending() {
        return true;
    }

    Node head(Node node, Env env, Node node2) {
        return this.parent.head(node, env, node2);
    }

    Node tail(Node node, Env env, Node node2) {
        return this.parent.tail(node, env, node2);
    }

    boolean allowAttr() {
        return false;
    }

    boolean allowNamespace() {
        return false;
    }

    boolean allowChildren(Node node, Env env, Node node2) {
        return this.parent.allowChildren(node, env, node2);
    }

    int position(Node node, Env env, Node node2, Pattern pattern) {
        return this.parent.position(node, env, node2, pattern);
    }

    int count(Node node, Env env, Node node2, Pattern pattern) {
        return this.parent.count(node, env, node2, pattern);
    }

    Node nextNode(Node node, Env env, Node node2, Node node3, boolean bl, boolean bl2) {
        if (node == null) {
            return null;
        }
        Node node4 = null;
        if (bl) {
            if (node instanceof CauchoElement) {
                node4 = ((CauchoElement)node).getFirstAttribute();
                if (node4 != null) {
                    return node4;
                }
            } else if (node instanceof Attr) {
                node4 = node.getNextSibling();
                if (node4 != null) {
                    return node4;
                }
                node = node.getParentNode();
            }
        }
        if (bl2) {
            if (node instanceof CauchoElement) {
                node4 = NamespaceNode.create(node);
                if (node4 != null) {
                    return node4;
                }
            } else if (node instanceof NamespaceNode) {
                node4 = node.getNextSibling();
                if (node4 != null) {
                    return node4;
                }
                node = node.getParentNode();
            }
        }
        if (this.allowChildren(node, env, node2)) {
            node4 = node.getFirstChild();
            if (node4 != null) {
                return node4;
            }
        } else {
            Node node5 = node3;
            while (node5 != null) {
                if (node == node5) {
                    return null;
                }
                node5 = node5.getParentNode();
            }
        }
        while (node != null && node != node3) {
            node4 = node.getNextSibling();
            if (node4 != null) {
                return node4;
            }
            node = node.getParentNode();
        }
        return null;
    }

    Node previousNode(Node node, Env env, Node node2, Node node3) {
        if (node == node3) {
            return null;
        }
        Node node4 = node.getPreviousSibling();
        if (node4 != null) {
            while (node4.getLastChild() != null && this.allowChildren(node4, env, node2)) {
                node4 = node4.getLastChild();
            }
            return node4 == node ? node.getParentNode() : node4;
        }
        return node.getParentNode();
    }

    protected String getPrefix() {
        if (this.parent == null || this.parent instanceof FromAny || this.parent instanceof FromContext) {
            return "";
        }
        if (this.parent instanceof FromRoot) {
            return "/";
        }
        return this.parent + "/";
    }

    public String toPatternString() {
        return this.toString();
    }

    Pattern(Pattern pattern) {
        this.parent = pattern;
    }
}

