/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xml.CauchoNode;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.Pattern;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Node;

class NumericExpr
extends Expr {
    private int code;
    private Expr left;
    private Expr right;
    private double value;
    private ArrayList args;
    private Pattern pattern;

    public Pattern getListContext() {
        switch (this.code) {
            case 34: 
            case 36: {
                return this.pattern;
            }
        }
        return null;
    }

    public boolean isNumber() {
        return true;
    }

    public double evalNumber(Env env, Node node, Node node2) {
        switch (this.code) {
            case 0: {
                return this.value;
            }
            case 17: {
                return -this.left.evalNumber(env, node, node2);
            }
            case 18: {
                return this.left.evalNumber(env, node, node2) + this.right.evalNumber(env, node, node2);
            }
            case 19: {
                return this.left.evalNumber(env, node, node2) - this.right.evalNumber(env, node, node2);
            }
            case 20: {
                return this.left.evalNumber(env, node, node2) * this.right.evalNumber(env, node, node2);
            }
            case 21: {
                return this.left.evalNumber(env, node, node2) / this.right.evalNumber(env, node, node2);
            }
            case 22: {
                return (int)(this.left.evalNumber(env, node, node2) / this.right.evalNumber(env, node, node2));
            }
            case 23: {
                return this.left.evalNumber(env, node, node2) % this.right.evalNumber(env, node, node2);
            }
            case 29: {
                return this.left.evalNumber(env, node, node2);
            }
            case 31: {
                return Math.floor(this.left.evalNumber(env, node, node2));
            }
            case 32: {
                return Math.ceil(this.left.evalNumber(env, node, node2));
            }
            case 33: {
                return Math.rint(this.left.evalNumber(env, node, node2));
            }
            case 30: {
                return this.sum(env, node, node2);
            }
            case 34: {
                return this.position(env, node, node2);
            }
            case 36: {
                return this.last(env, node, node2);
            }
            case 35: {
                return this.count(env, node, node2);
            }
            case 44: {
                String string = this.left.evalString(env, node, node2);
                if (string == null) {
                    return 0.0;
                }
                return string.length();
            }
        }
        throw new RuntimeException("unknown code: " + (char)this.code);
    }

    private int position(Env env, Node node, Node node2) {
        int n = this.pattern.position(node2, env, node, this.pattern);
        return n;
    }

    private int last(Env env, Node node, Node node2) {
        return this.pattern.count(node2, env, node, this.pattern);
    }

    private int count(Env env, Node node, Node node2) {
        int n = 0;
        Iterator iterator = this.pattern.select(node2, env, node2, this.pattern);
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    private int sum(Env env, Node node, Node node2) {
        int n = 0;
        Iterator iterator = this.pattern.select(node2, env, node2, this.pattern);
        while (iterator.hasNext()) {
            Node node3 = (Node)iterator.next();
            String string = ((CauchoNode)node3).getTextValue();
            n = (int)((double)n + Expr.stringToNumber(string));
        }
        return n;
    }

    public boolean evalBoolean(Env env, Node node, Node node2) {
        double d = this.evalNumber(env, node, node2);
        return d != 0.0 && !Double.isNaN(d);
    }

    public String evalString(Env env, Node node, Node node2) {
        double d = this.evalNumber(env, node, node2);
        if ((double)((int)d) == d) {
            return String.valueOf((int)d);
        }
        return String.valueOf(d);
    }

    public Object evalObject(Env env, Node node, Node node2) {
        return new Double(this.evalNumber(env, node, node2));
    }

    public String toString() {
        switch (this.code) {
            case 0: {
                return String.valueOf(this.value);
            }
            case 17: {
                return "-" + this.left;
            }
            case 18: {
                return "(" + this.left + " + " + this.right + ")";
            }
            case 19: {
                return "(" + this.left + " - " + this.right + ")";
            }
            case 20: {
                return "(" + this.left + " * " + this.right + ")";
            }
            case 21: {
                return "(" + this.left + " div " + this.right + ")";
            }
            case 22: {
                return "(" + this.left + " quo " + this.right + ")";
            }
            case 23: {
                return "(" + this.left + " mod " + this.right + ")";
            }
            case 29: {
                return "number(" + this.left + ")";
            }
            case 30: {
                return "sum(" + this.left + ")";
            }
            case 31: {
                return "floor(" + this.left + ")";
            }
            case 32: {
                return "ceiling(" + this.left + ")";
            }
            case 33: {
                return "round(" + this.left + ")";
            }
            case 34: {
                return "position(" + this.pattern.toString() + ")";
            }
            case 35: {
                return "count(" + this.pattern + ")";
            }
            case 36: {
                return "last()";
            }
        }
        return super.toString();
    }

    NumericExpr(int n, Expr expr, Expr expr2) {
        this.code = n;
        this.left = expr;
        this.right = expr2;
    }

    NumericExpr(int n, Expr expr) {
        this.code = n;
        this.left = expr;
    }

    NumericExpr(double d) {
        this.code = 0;
        this.value = d;
    }

    NumericExpr(int n, ArrayList arrayList) {
        this.code = n;
        this.args = arrayList;
        if (arrayList.size() > 0) {
            this.left = (Expr)arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            this.right = (Expr)arrayList.get(1);
        }
    }

    NumericExpr(int n, Pattern pattern) {
        this.code = n;
        this.pattern = pattern;
    }
}

