/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.util.CharBuffer;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.QDocumentType;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class IdExpr
extends Expr {
    private Expr expr;
    private Env lastEnv;
    private int lastUseCount;
    private Node lastContext;
    private ArrayList lastList;

    public boolean isNodeSet() {
        return true;
    }

    public double evalNumber(Env env, Node node, Node node2) {
        String string = this.evalString(env, node2, node2);
        return Expr.stringToNumber(string);
    }

    public boolean evalBoolean(Env env, Node node, Node node2) {
        Iterator iterator = this.evalNodeSet(env, node, node2);
        return iterator.hasNext();
    }

    public String evalString(Env env, Node node, Node node2) {
        Iterator iterator = this.evalNodeSet(env, node, node2);
        if (!iterator.hasNext()) {
            return "";
        }
        CauchoNode cauchoNode = (CauchoNode)iterator.next();
        return cauchoNode.getTextValue();
    }

    public Object evalObject(Env env, Node node, Node node2) {
        IdExpr idExpr = this;
        synchronized (idExpr) {
            if (env == this.lastEnv && node == this.lastContext && env.getUseCount() == this.lastUseCount) {
                ArrayList arrayList = this.lastList;
                Object var5_6 = null;
                return arrayList;
            }
        }
        ArrayList arrayList = this.id(env, node);
        idExpr = this;
        synchronized (idExpr) {
            this.lastEnv = env;
            this.lastUseCount = env.getUseCount();
            this.lastContext = node;
            this.lastList = arrayList;
        }
        return arrayList;
    }

    private ArrayList id(Env env, Node node) {
        ArrayList arrayList = this.getIdList(env, node);
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        Node node2 = node.getOwnerDocument();
        while ((node2 = XmlUtil.getNext(node2)) != null) {
            String string;
            if (!(node2 instanceof Element)) continue;
            Element element = (Element)node2;
            QDocumentType qDocumentType = (QDocumentType)element.getOwnerDocument().getDoctype();
            String string2 = null;
            if (qDocumentType != null) {
                string2 = qDocumentType.getElementId(element.getNodeName());
            }
            if (string2 == null || !arrayList.contains(string = element.getAttribute(string2)) || arrayList2.contains(element)) continue;
            arrayList2.add(element);
        }
        return arrayList2;
    }

    private ArrayList getIdList(Env env, Node node) {
        ArrayList arrayList = new ArrayList();
        Object object = this.expr.evalObject(env, node, node);
        if (object instanceof ArrayList) {
            ArrayList arrayList2 = (ArrayList)object;
            int n = 0;
            while (n < arrayList2.size()) {
                CauchoNode cauchoNode = (CauchoNode)arrayList2.get(n);
                this.addText(arrayList, cauchoNode.getTextValue());
                ++n;
            }
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                CauchoNode cauchoNode = (CauchoNode)iterator.next();
                this.addText(arrayList, cauchoNode.getTextValue());
            }
        } else {
            this.addText(arrayList, Expr.toString(object));
        }
        return arrayList;
    }

    private void addText(ArrayList arrayList, String string) {
        if (string.indexOf(32) < 0) {
            arrayList.add(string);
            return;
        }
        int n = string.length();
        CharBuffer charBuffer = new CharBuffer();
        int n2 = 0;
        boolean bl = false;
        while (n2 < n && XmlChar.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        while (n2 < n) {
            charBuffer.clear();
            while (n2 < n && !XmlChar.isWhitespace(string.charAt(n2))) {
                charBuffer.append(string.charAt(n2));
                ++n2;
            }
            arrayList.add(charBuffer.toString());
            while (n2 < n && XmlChar.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
        }
    }

    public String toString() {
        if (this.expr != null) {
            return "id(" + this.expr + ")";
        }
        return "id()";
    }

    IdExpr(ArrayList arrayList) {
        if (arrayList.size() > 0) {
            this.expr = (Expr)arrayList.get(0);
        }
    }
}

