/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xpath.Axis;
import com.caucho.xpath.Env;
import com.caucho.xpath.Pattern;
import org.w3c.dom.Node;

class FromAncestors
extends Axis {
    private boolean self;

    boolean match(Node node, Env env, Node node2) {
        if (node == null) {
            return false;
        }
        Node node3 = node.getNextSibling();
        if (node3 == null) {
            node3 = node.getParentNode();
        }
        if (!this.self) {
            node = this.parent.nextNode(node, env, node2, node3, false, false);
        }
        while (node != null && node != node3) {
            if (this.parent.match(node, env, node2)) {
                return true;
            }
            node = this.parent.nextNode(node, env, node2, node3, false, false);
        }
        return false;
    }

    boolean isAscending() {
        return false;
    }

    Node head(Node node, Env env, Node node2) {
        Node node3 = this.parent.head(node, env, node2);
        return node3.getOwnerDocument();
    }

    boolean allowChildren(Node node, Env env, Node node2) {
        if (this.self) {
            return this.parent.allowChildren(node, env, node2);
        }
        if (node != null) {
            return this.parent.allowChildren(node.getParentNode(), env, node2);
        }
        return true;
    }

    int position(Node node, Env env, Node node2, Pattern pattern) {
        int n = env.getPositionIndex();
        Node node3 = this.parent.nextNode(node, env, node2, node, false, false);
        while (n > 0) {
            node3 = this.parent.nextNode(node3, env, node2, node, false, false);
            --n;
        }
        if (this.parent.nextNode(node3, env, node2, node, false, false) != null) {
            env.setMorePositions(true);
        }
        if (node.getNextSibling() == node3) {
            return 1;
        }
        int n2 = 1;
        while (node3 != null && node != node3) {
            if (pattern.match(node3, env, node2)) {
                ++n2;
            }
            node3 = node3.getParentNode();
        }
        return n2;
    }

    int count(Node node, Env env, Node node2, Pattern pattern) {
        int n = env.getPositionIndex();
        Node node3 = this.parent.nextNode(node, env, node2, node, false, false);
        while (n > 0) {
            node3 = this.parent.nextNode(node3, env, node2, node, false, false);
            --n;
        }
        if (this.parent.nextNode(node3, env, node2, node, false, false) != null) {
            env.setMorePositions(true);
        }
        int n2 = 0;
        while (node3 != null) {
            if (pattern.match(node3, env, node2)) {
                ++n2;
            }
            node3 = node3.getParentNode();
        }
        return n2;
    }

    private Node getAxisContext(Node node, Env env, Node node2, Node node3) {
        if (node == null) {
            return null;
        }
        return this.parent.nextNode(node, env, node2, node3, false, false);
    }

    public String toString() {
        return this.getPrefix() + (this.self ? "ancestor-or-self::" : "ancestor::");
    }

    FromAncestors(Pattern pattern, boolean bl) {
        super(pattern);
        this.self = bl;
        if (pattern == null) {
            throw new RuntimeException();
        }
    }
}

