/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xpath.XPathFun;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Env {
    HashMap ids;
    HashMap idCache;
    Element lastElement;
    HashMap globals;
    HashMap functions;
    HashMap cache;
    String[] varKeys;
    Object[] varValues;
    int varSize;
    private int positionIndex;
    private boolean hasMorePositions;
    private int useCount;
    private Node current;
    private Env parent;

    void init() {
        this.clear();
        if (this.parent == null && this.globals != null) {
            this.globals.clear();
            this.functions.clear();
        } else {
            this.globals = new HashMap();
            this.functions = new HashMap();
        }
        this.parent = null;
    }

    void init(Env env) {
        this.clear();
        this.globals = env.globals;
        this.functions = env.functions;
        this.parent = env;
    }

    public void clear() {
        ++this.useCount;
        if (this.ids != null) {
            this.ids.clear();
            this.idCache.clear();
        }
        while (this.varSize > 0) {
            this.varKeys[this.varSize] = null;
            this.varValues[this.varSize] = null;
            --this.varSize;
        }
        this.lastElement = null;
        this.globals = null;
        this.functions = null;
        this.cache = null;
        this.current = null;
    }

    public Object getVar(String string) {
        int n = this.varSize - 1;
        while (n >= 0) {
            if (this.varKeys[n] == string) {
                return this.varValues[n];
            }
            --n;
        }
        return this.globals.get(string);
    }

    public void addVar(String string, Object object) {
        ++this.useCount;
        if (object instanceof Iterator) {
            object = this.iteratorToList((Iterator)object);
        }
        if (this.varKeys == null) {
            this.varKeys = new String[16];
            this.varValues = new Object[16];
        } else if (this.varSize == this.varKeys.length) {
            String[] stringArray = new String[2 * this.varKeys.length];
            Object[] objectArray = new Object[2 * this.varKeys.length];
            System.arraycopy(this.varKeys, 0, stringArray, 0, this.varSize);
            System.arraycopy(this.varValues, 0, objectArray, 0, this.varSize);
            this.varKeys = stringArray;
            this.varValues = objectArray;
        }
        this.varKeys[this.varSize] = string;
        this.varValues[this.varSize] = object;
        ++this.varSize;
    }

    /*
     * Unable to fully structure code
     */
    public void popVars(int var1_1) {
        ++this.useCount;
        if (this.varKeys != null) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            --this.varSize;
            this.varKeys[this.varSize] = null;
            this.varValues[this.varSize] = null;
            --var1_1;
lbl8:
            // 2 sources

            ** while (var1_1 > 0)
        }
lbl9:
        // 1 sources

    }

    public void setGlobal(String string, Object object) {
        ++this.useCount;
        if (object instanceof Iterator) {
            object = this.iteratorToList((Iterator)object);
        }
        this.globals.put(string, object);
    }

    private ArrayList iteratorToList(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public HashMap setFunctions(HashMap hashMap) {
        HashMap hashMap2 = this.functions;
        this.functions = hashMap;
        return hashMap2;
    }

    XPathFun getFunction(String string) {
        return (XPathFun)this.functions.get(string);
    }

    int setPositionIndex(int n) {
        int n2 = this.positionIndex;
        this.positionIndex = n;
        this.hasMorePositions = false;
        return n2;
    }

    int getPositionIndex() {
        return this.positionIndex;
    }

    boolean setMorePositions(boolean bl) {
        boolean bl2 = this.hasMorePositions;
        this.hasMorePositions = bl;
        return bl2;
    }

    boolean hasMorePositions() {
        return this.hasMorePositions;
    }

    public Object getCache(Object object) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(object);
    }

    public void setCache(Object object, Object object2) {
        if (this.cache == null) {
            this.cache = new HashMap();
        }
        this.cache.put(object, object2);
    }

    int getUseCount() {
        return this.useCount;
    }

    void setCurrent(Node node) {
        this.current = node;
    }

    Node getCurrent() {
        return this.current;
    }
}

