/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.SelectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BooleanExpr
extends Expr {
    private int code;
    private Expr left;
    private Expr right;
    private boolean value;
    private ArrayList args;

    public boolean isBoolean() {
        return true;
    }

    public boolean evalBoolean(Env env, Node node, Node node2) {
        switch (this.code) {
            case 0: {
                return this.value;
            }
            case 6: {
                return this.left.evalBoolean(env, node, node2) == this.right.evalBoolean(env, node, node2);
            }
            case 7: {
                return this.left.evalNumber(env, node, node2) == this.right.evalNumber(env, node, node2);
            }
            case 8: {
                String string = this.left.evalString(env, node, node2);
                String string2 = this.right.evalString(env, node, node2);
                return string.equals(string2);
            }
            case 5: {
                Object object = this.left.evalObject(env, node, node2);
                Object object2 = this.right.evalObject(env, node, node2);
                if (object == object2) {
                    return true;
                }
                return this.eq(object, object2);
            }
            case 10: {
                return this.left.evalBoolean(env, node, node2) != this.right.evalBoolean(env, node, node2);
            }
            case 11: {
                return this.left.evalNumber(env, node, node2) != this.right.evalNumber(env, node, node2);
            }
            case 12: {
                String string = this.left.evalString(env, node, node2);
                String string3 = this.right.evalString(env, node, node2);
                return !string.equals(string3);
            }
            case 9: {
                Object object = this.left.evalObject(env, node, node2);
                Object object3 = this.right.evalObject(env, node, node2);
                if (object == object3) {
                    return false;
                }
                return !this.eq(object, object3);
            }
            case 13: {
                return this.lt(this.left.evalObject(env, node, node2), this.right.evalObject(env, node, node2));
            }
            case 14: {
                return this.le(this.left.evalObject(env, node, node2), this.right.evalObject(env, node, node2));
            }
            case 15: {
                return this.lt(this.right.evalObject(env, node, node2), this.left.evalObject(env, node, node2));
            }
            case 16: {
                return this.le(this.right.evalObject(env, node, node2), this.left.evalObject(env, node, node2));
            }
            case 3: {
                return this.left.evalBoolean(env, node, node2) || this.right.evalBoolean(env, node, node2);
            }
            case 4: {
                return this.left.evalBoolean(env, node, node2) && this.right.evalBoolean(env, node, node2);
            }
            case 24: {
                return true;
            }
            case 25: {
                return false;
            }
            case 26: {
                return !this.left.evalBoolean(env, node, node2);
            }
            case 27: {
                return this.left.evalBoolean(env, node, node2);
            }
            case 39: {
                String string = this.left.evalString(env, node, node2);
                String string4 = this.right.evalString(env, node, node2);
                return string.startsWith(string4);
            }
            case 40: {
                String string = this.left.evalString(env, node, node2);
                String string5 = this.right.evalString(env, node, node2);
                return string.indexOf(string5) >= 0;
            }
            case 28: {
                String string = this.left.evalString(env, node, node2);
                while (node2 != null) {
                    String string6;
                    if (node2 instanceof Element && (string6 = ((Element)node2).getAttribute("xml:lang")) != null && string6.equals(string)) {
                        return true;
                    }
                    node2 = node2.getParentNode();
                }
                return false;
            }
            case 52: {
                return false;
            }
        }
        throw new RuntimeException("unknown code: " + this.code);
    }

    private boolean eq(Object object, Object object2) {
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            int n = 0;
            while (n < arrayList.size()) {
                if (this.eq(arrayList.get(n), object2)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                if (!this.eq(iterator.next(), object2)) continue;
                return true;
            }
            return false;
        }
        if (object2 instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object2;
            int n = 0;
            while (n < arrayList.size()) {
                if (this.eq(object, arrayList.get(n))) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (object2 instanceof SelectIterator) {
            Iterator iterator = null;
            iterator = (Iterator)((SelectIterator)object2).clone();
            while (iterator.hasNext()) {
                if (!this.eq(object, iterator.next())) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Boolean || object2 instanceof Boolean) {
            return Expr.toBoolean(object) == Expr.toBoolean(object2);
        }
        if (object instanceof Double || object2 instanceof Double) {
            return Expr.toDouble(object) == Expr.toDouble(object2);
        }
        return Expr.toString(object).equals(Expr.toString(object2));
    }

    private boolean lt(Object object, Object object2) {
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            int n = 0;
            while (n < arrayList.size()) {
                if (this.lt(arrayList.get(n), object2)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                if (!this.lt(iterator.next(), object2)) continue;
                return true;
            }
            return false;
        }
        if (object2 instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object2;
            int n = 0;
            while (n < arrayList.size()) {
                if (this.lt(object, arrayList.get(n))) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (object2 instanceof SelectIterator) {
            Iterator iterator = null;
            iterator = (Iterator)((SelectIterator)object2).clone();
            while (iterator.hasNext()) {
                if (!this.lt(object, iterator.next())) continue;
                return true;
            }
            return false;
        }
        return Expr.toDouble(object) < Expr.toDouble(object2);
    }

    private boolean le(Object object, Object object2) {
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            int n = 0;
            while (n < arrayList.size()) {
                if (this.le(arrayList.get(n), object2)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                if (!this.le(iterator.next(), object2)) continue;
                return true;
            }
            return false;
        }
        if (object2 instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object2;
            int n = 0;
            while (n < arrayList.size()) {
                if (this.le(object, arrayList.get(n))) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (object2 instanceof SelectIterator) {
            SelectIterator selectIterator = null;
            selectIterator = (SelectIterator)((SelectIterator)object2).clone();
            while (selectIterator.hasNext()) {
                if (!this.le(object, selectIterator.next())) continue;
                return true;
            }
            return false;
        }
        return Expr.toDouble(object) <= Expr.toDouble(object2);
    }

    public double evalNumber(Env env, Node node, Node node2) {
        if (this.evalBoolean(env, node, node2)) {
            return 1.0;
        }
        return 0.0;
    }

    public String evalString(Env env, Node node, Node node2) {
        if (this.evalBoolean(env, node, node2)) {
            return "true";
        }
        return "false";
    }

    public Object evalObject(Env env, Node node, Node node2) {
        return new Boolean(this.evalBoolean(env, node, node2));
    }

    public String toString() {
        switch (this.code) {
            case 0: {
                return String.valueOf(this.value);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return "(" + this.left.toString() + " = " + this.right.toString() + ")";
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return "(" + this.left.toString() + " != " + this.right.toString() + ")";
            }
            case 13: {
                return "(" + this.left.toString() + " < " + this.right.toString() + ")";
            }
            case 14: {
                return "(" + this.left.toString() + " <= " + this.right.toString() + ")";
            }
            case 15: {
                return "(" + this.left.toString() + " > " + this.right.toString() + ")";
            }
            case 16: {
                return "(" + this.left.toString() + " >= " + this.right.toString() + ")";
            }
            case 3: {
                return "(" + this.left.toString() + " or " + this.right.toString() + ")";
            }
            case 4: {
                return "(" + this.left.toString() + " and " + this.right.toString() + ")";
            }
            case 24: {
                return "true()";
            }
            case 25: {
                return "false()";
            }
            case 26: {
                return "not(" + this.left.toString() + ")";
            }
            case 27: {
                return "boolean(" + this.left.toString() + ")";
            }
            case 39: {
                return "starts-with(" + this.left + ", " + this.right + ")";
            }
            case 40: {
                return "contains(" + this.left + ", " + this.right + ")";
            }
            case 28: {
                return "lang(" + this.left + ")";
            }
            case 52: {
                return "function-available(" + this.left + ")";
            }
        }
        return super.toString();
    }

    BooleanExpr(int n, Expr expr, Expr expr2) {
        this.code = n;
        this.left = expr;
        this.right = expr2;
        if (n == 5) {
            this.code = expr.isNodeSet() || expr2.isNodeSet() ? 5 : (expr.isBoolean() || expr2.isBoolean() ? 6 : (expr.isNumber() || expr2.isNumber() ? 7 : (expr.isString() && expr2.isString() ? 8 : 5)));
        } else if (n == 9) {
            this.code = expr.isNodeSet() || expr2.isNodeSet() ? 9 : (expr.isBoolean() || expr2.isBoolean() ? 10 : (expr.isNumber() || expr2.isNumber() ? 11 : (expr.isString() && expr2.isString() ? 12 : 9)));
        }
    }

    BooleanExpr(int n, Expr expr) {
        this.code = n;
        this.left = expr;
    }

    BooleanExpr(boolean bl) {
        this.code = 0;
        this.value = bl;
    }

    BooleanExpr(int n, ArrayList arrayList) {
        this.code = n;
        this.args = arrayList;
        if (arrayList.size() > 0) {
            this.left = (Expr)arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            this.right = (Expr)arrayList.get(1);
        }
    }
}

