/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.IntMap;
import com.caucho.xml.Entities;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;

class XmlEntities
extends Entities {
    private static Entities xmlEntities = new XmlEntities();
    private IntMap entities = new IntMap();

    static Entities create() {
        return xmlEntities;
    }

    int getEntity(String string) {
        return this.entities.get(string);
    }

    void printText(XmlPrinter xmlPrinter, String string, boolean bl) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\t': {
                    xmlPrinter.print(c);
                    break;
                }
                case '\n': 
                case '\r': {
                    if (!bl) {
                        xmlPrinter.print(c);
                        break;
                    }
                    xmlPrinter.print("&#");
                    xmlPrinter.print((char)(c - 10 + 97));
                    xmlPrinter.print(";");
                    break;
                }
                case '<': {
                    if (!bl) {
                        xmlPrinter.print("&lt;");
                        break;
                    }
                    xmlPrinter.print("<");
                    break;
                }
                case '&': {
                    xmlPrinter.print("&amp;");
                    break;
                }
                case '\"': {
                    if (bl) {
                        xmlPrinter.print("&quot;");
                        break;
                    }
                    xmlPrinter.print('\"');
                    break;
                }
                default: {
                    if (c >= ' ' && c < '\u007f' || XmlChar.isChar(c)) {
                        try {
                            xmlPrinter.print(c);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            xmlPrinter.print("&#");
                            xmlPrinter.print((int)c);
                            xmlPrinter.print(';');
                        }
                        break;
                    }
                    xmlPrinter.print("&#");
                    xmlPrinter.print((int)c);
                    xmlPrinter.print(';');
                }
            }
            ++n2;
        }
    }

    protected XmlEntities() {
        this.entities.put("lt", 60);
        this.entities.put("gt", 62);
        this.entities.put("amp", 38);
        this.entities.put("quot", 34);
        this.entities.put("apos", 39);
    }
}

