/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.QAttr;
import com.caucho.xml.QDOMException;
import com.caucho.xml.QName;
import com.caucho.xml.QNamedNodeMap;
import com.caucho.xml.QNode;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class QAttributedNode
extends QNode {
    HashMap attributes;
    QAttr firstAttribute;
    QAttr lastAttribute;
    private QNamedNodeMap attributeMap;

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (this.attributeMap == null) {
            this.attributeMap = new QNamedNodeMap(this.attributes);
        }
        return this.attributeMap;
    }

    public Attr getFirstAttribute() {
        return this.firstAttribute;
    }

    public String getAttribute(String string) {
        if (this.attributes == null) {
            return "";
        }
        QAttr qAttr = (QAttr)this.attributes.get(string);
        return qAttr == null ? "" : qAttr.getValue();
    }

    public void setAttribute(String string, String string2) throws DOMException {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (!this.isNameValid(string)) {
            throw new QDOMException(5, "illegal attribute `" + string + "'");
        }
        this.setAttributeNode(this.owner.createAttribute(string, string2));
    }

    void setAttribute(QName qName, String string) throws DOMException {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.setAttributeNode(this.owner.createAttribute(qName, string));
    }

    public Iterator getAttributeNames() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes.keySet().iterator();
    }

    public void removeAttribute(String string) {
        if (this.attributes == null) {
            return;
        }
        if (!this.isNameValid(string)) {
            throw new QDOMException(5, "illegal attribute `" + string + "'");
        }
        QAttr qAttr = (QAttr)this.attributes.remove(string);
        if (qAttr != null) {
            qAttr.parent = null;
        }
    }

    public Attr getAttributeNode(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.get(string);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        QAttr qAttr = (QAttr)attr;
        if (qAttr.owner != this.owner) {
            throw new QDOMException(4, "attribute from wrong document");
        }
        if (qAttr.parent != null) {
            throw new QDOMException(10, "attribute `" + attr.getNodeName() + "' is in use");
        }
        qAttr.parent = this;
        qAttr.next = null;
        qAttr.previous = this.lastAttribute;
        if (this.lastAttribute == null) {
            this.firstAttribute = qAttr;
        } else {
            this.lastAttribute.next = qAttr;
        }
        this.lastAttribute = qAttr;
        this.attributes.put(attr.getNodeName(), attr);
        return attr;
    }

    public Attr removeAttributeNode(Attr attr) {
        this.removeAttribute(attr.getNodeName());
        return attr;
    }

    public abstract String getNodeName();

    public abstract short getNodeType();

    public abstract Node cloneNode(boolean var1);

    QAttributedNode() {
    }
}

