/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;

public class TempReadStream
extends StreamImpl {
    private TempBuffer cursor;
    private int offset;
    private Path backingDir;
    private Path backingFile;
    private ReadStream backingStream;

    public boolean canRead() {
        return true;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.cursor == null) {
            return -1;
        }
        if (this.cursor.length - this.offset < n2) {
            n2 = this.cursor.length - this.offset;
        }
        System.arraycopy(this.cursor.buf, this.offset, byArray, n, n2);
        if (this.offset + n2 >= this.cursor.length) {
            this.cursor = this.cursor.next;
            this.offset = 0;
        } else {
            this.offset += n2;
        }
        return n2;
    }

    public int getAvailable() throws IOException {
        if (this.cursor != null) {
            return this.cursor.length - this.offset;
        }
        return 0;
    }

    public void close() throws IOException {
        this.cursor = null;
    }

    public TempReadStream(TempBuffer tempBuffer) {
        this.cursor = tempBuffer;
        this.offset = 0;
    }

    TempReadStream(TempBuffer tempBuffer, Path path) {
        this.setPath(path);
        this.cursor = tempBuffer;
        this.offset = 0;
    }
}

