/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CauchoSystem;
import com.caucho.vfs.ConstPath;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.HttpPath;
import com.caucho.vfs.LogPath;
import com.caucho.vfs.MailtoPath;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.SchemeMap;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TcpPath;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public abstract class Path {
    private static Integer LOCK = new Integer(0);
    private static SchemeMap ROOT_SCHEME_MAP;
    protected SchemeMap schemeMap;

    public final Path lookup(String string) {
        return this.lookup(string, null);
    }

    public Path lookup(String string, Map map) {
        Path path;
        int n;
        if (string == null) {
            return this.lookup(this.getPath(), map);
        }
        String string2 = this.scanScheme(string);
        if (string2 == null) {
            return this.schemeWalk(string, map, string, 0);
        }
        if (CauchoSystem.isWindows() && (n = string2.length()) == 1 && string2.charAt(0) >= 'a' && string2.charAt(0) <= 'z' && (path = this.schemeMap.getScheme("file")) != null) {
            return path.schemeWalk(string, map, "/" + string, 0);
        }
        path = this.schemeMap.getScheme(string2);
        if (path == null) {
            return null;
        }
        return path.schemeWalk(string, map, string, string2.length() + 1);
    }

    public final Path lookupNative(String string) {
        return this.lookupNative(string, null);
    }

    public Path lookupNative(String string, Map map) {
        return this.lookup(string, map);
    }

    public Path getParent() {
        return this;
    }

    protected String scanScheme(String string) {
        int n = 0;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        char c = string.charAt(0);
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            n = 1;
            while (n < n2) {
                c = string.charAt(n);
                if (c == ':') {
                    return string.substring(0, n).toLowerCase();
                }
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '0' || c == '+' || c == '-' || c == '.')) break;
                ++n;
            }
        }
        return null;
    }

    protected abstract Path schemeWalk(String var1, Map var2, String var3, int var4);

    public String getURL() {
        return this.getPath();
    }

    public abstract String getScheme();

    public String getHost() {
        throw new UnsupportedOperationException();
    }

    public int getPort() {
        throw new UnsupportedOperationException();
    }

    public abstract String getPath();

    public String getTail() {
        throw new UnsupportedOperationException();
    }

    public String getQuery() {
        throw new UnsupportedOperationException();
    }

    public String getNativePath() {
        return this.getFullPath();
    }

    public String getUserPath() {
        return this.getPath();
    }

    public void setUserPath(String string) {
    }

    public String getFullPath() {
        return this.getPath();
    }

    public boolean exists() {
        return false;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public long getLength() {
        return 0L;
    }

    public long getLastModified() {
        return 0L;
    }

    public void setLastModified(long l) {
    }

    public boolean canRead() {
        return false;
    }

    public boolean canWrite() {
        return false;
    }

    public String[] list() throws IOException {
        return new String[0];
    }

    public Iterator iterator() throws IOException {
        Path path = this;
        if (path == null) {
            throw null;
        }
        return path.new ArrayIterator(this.list());
    }

    public boolean mkdir() throws IOException {
        return false;
    }

    public boolean mkdirs() throws IOException {
        return false;
    }

    public boolean remove() throws IOException {
        return false;
    }

    public boolean renameTo(Path path) throws IOException {
        return false;
    }

    public final boolean renameTo(String string) throws IOException {
        return this.renameTo(this.lookup(string));
    }

    public Path createRoot() {
        throw new UnsupportedOperationException("createRoot");
    }

    public void bind(Path path) {
        throw new UnsupportedOperationException("bind");
    }

    public void unbind() {
        throw new UnsupportedOperationException("unbind");
    }

    public Object getValue() throws Exception {
        throw new UnsupportedOperationException("getValue");
    }

    public void setValue(Object object) throws Exception {
        throw new UnsupportedOperationException("setValue");
    }

    public Object getAttribute(String string) throws IOException {
        return null;
    }

    public void setAttribute(String string, Object object) throws IOException {
    }

    public void removeAttribute(String string) throws IOException {
    }

    public Iterator getAttributeNames() throws IOException {
        return null;
    }

    public final ReadStream openRead() throws IOException {
        StreamImpl streamImpl = this.openReadImpl();
        return new ReadStream(streamImpl);
    }

    public final WriteStream openWrite() throws IOException {
        StreamImpl streamImpl = this.openWriteImpl();
        return new WriteStream(streamImpl);
    }

    public ReadWritePair openReadWrite() throws IOException {
        StreamImpl streamImpl = this.openReadWriteImpl();
        WriteStream writeStream = new WriteStream(streamImpl);
        ReadStream readStream = new ReadStream(streamImpl, writeStream);
        return new ReadWritePair(readStream, writeStream);
    }

    public WriteStream openAppend() throws IOException {
        StreamImpl streamImpl = this.openAppendImpl();
        return new WriteStream(streamImpl);
    }

    public boolean createNewFile() throws IOException {
        Integer n = LOCK;
        synchronized (n) {
            if (!this.exists()) {
                WriteStream writeStream = this.openWrite();
                writeStream.close();
                boolean bl = true;
                Object var2_4 = null;
                return bl;
            }
        }
        return false;
    }

    public Path createTempFile(String string, String string2) throws IOException {
        if (string == null || string.length() < 3) {
            throw new IllegalArgumentException("prefix too short: " + string);
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        this.mkdirs();
        if (!this.isDirectory()) {
            throw new IllegalArgumentException("must create temp file from dir");
        }
        Random random = new Random();
        int n = 0;
        while (n < 32768) {
            int n2 = Math.abs(random.nextInt());
            Path path = this.lookup(string + n2 + string2);
            if (path.createNewFile()) {
                return path;
            }
            ++n;
        }
        throw new IOException("cannot create temp file");
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        ReadStream readStream = this.openRead();
        try {
            readStream.writeToStream(outputStream);
        }
        finally {
            Object var4_3 = null;
            readStream.close();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Path)) {
            return false;
        }
        return this.getPath().equals(((Path)object).getPath());
    }

    public String toString() {
        return this.getPath();
    }

    protected StreamImpl openReadImpl() throws IOException {
        throw new UnsupportedOperationException("openRead");
    }

    protected StreamImpl openWriteImpl() throws IOException {
        throw new UnsupportedOperationException("openWrite");
    }

    protected StreamImpl openReadWriteImpl() throws IOException {
        throw new UnsupportedOperationException("openReadWrite");
    }

    protected StreamImpl openAppendImpl() throws IOException {
        throw new UnsupportedOperationException("openAppend");
    }

    protected Path(Path path) {
        if (path != null) {
            this.schemeMap = path.schemeMap;
            return;
        }
        if (ROOT_SCHEME_MAP == null) {
            ROOT_SCHEME_MAP = new SchemeMap();
            ROOT_SCHEME_MAP.setScheme("file", new FilePath(null));
            ROOT_SCHEME_MAP.setScheme("mailto", new MailtoPath(null, null, null, null));
            ROOT_SCHEME_MAP.setScheme("http", new HttpPath("127.0.0.1", 0));
            ROOT_SCHEME_MAP.setScheme("tcp", new TcpPath(null, null, "127.0.0.1", 0));
            ROOT_SCHEME_MAP.setScheme("log", new LogPath(null, "/", null, "/"));
            VfsStream vfsStream = new VfsStream(null, System.out);
            vfsStream.setCloseChildOnClose(false);
            vfsStream.setFlushOnNewline(true);
            VfsStream vfsStream2 = new VfsStream(null, System.err);
            vfsStream2.setCloseChildOnClose(false);
            vfsStream2.setFlushOnNewline(true);
            ROOT_SCHEME_MAP.setScheme("stdout", new ConstPath(null, vfsStream));
            ROOT_SCHEME_MAP.setScheme("stderr", new ConstPath(null, vfsStream2));
            VfsStream vfsStream3 = new VfsStream(null, null);
            ROOT_SCHEME_MAP.setScheme("null", new ConstPath(null, vfsStream3));
        }
        this.schemeMap = ROOT_SCHEME_MAP;
    }

    private class ArrayIterator
    implements Iterator {
        String[] list;
        int index;

        public boolean hasNext() {
            return this.index < this.list.length;
        }

        public Object next() {
            return this.index < this.list.length ? this.list[this.index++] : null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        ArrayIterator(String[] stringArray) {
            this.list = stringArray;
            this.index = 0;
        }
    }
}

