/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.ByteBuffer;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class MemoryPath
extends FilesystemPath {
    private Node rootNode;

    public Path fsWalk(String string, Map map, String string2) {
        return new MemoryPath(this.root, string, map, string2);
    }

    public String getScheme() {
        return "file";
    }

    public boolean exists() {
        Node node = this.rootNode;
        synchronized (node) {
            boolean bl = this.lookupAll() != null;
            Object var2_3 = null;
            return bl;
        }
    }

    private Node lookupAll() {
        Node node = this.lookupAllButTail();
        if (node == null) {
            return null;
        }
        String string = this.getTail();
        if (string == null || string.equals("")) {
            return node;
        }
        return node.lookup(string);
    }

    private Node lookupAllButTail() {
        String string = this.getFullPath();
        int n = 0;
        Node node = this.rootNode;
        while (node != null && n < string.length()) {
            int n2 = string.indexOf(47, n);
            if (n2 == -1) {
                return node;
            }
            if (n != n2) {
                node = node.lookup(string.substring(n, n2));
            }
            n = n2 + 1;
        }
        return node;
    }

    public boolean isDirectory() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            boolean bl = node2 != null && node2.type == 0;
            Object var2_4 = null;
            return bl;
        }
    }

    public boolean isFile() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            boolean bl = node2 != null && node2.type == 1;
            Object var2_4 = null;
            return bl;
        }
    }

    public boolean isObject() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            boolean bl = node2 != null && node2.type == 2;
            Object var2_4 = null;
            return bl;
        }
    }

    public long getLength() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            if (node2 != null && node2.type == 1) {
                long l = ((ByteBuffer)node2.data).length();
                Object var2_5 = null;
                return l;
            }
            long l = 0L;
            Object var2_6 = null;
            return l;
        }
    }

    public long getLastModified() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            long l = node2 == null ? 0L : node2.lastModified;
            Object var2_4 = null;
            return l;
        }
    }

    public boolean canRead() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            boolean bl = node2 != null;
            Object var2_4 = null;
            return bl;
        }
    }

    public boolean canWrite() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            boolean bl = node2 != null;
            Object var2_4 = null;
            return bl;
        }
    }

    public String[] list() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            if (node2 == null || node2.data != null) {
                String[] stringArray = new String[]{};
                Object var2_5 = null;
                return stringArray;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            Node node3 = node2.firstChild;
            while (node3 != null) {
                arrayList.add(node3.name);
                node3 = node3.next;
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            Object var2_6 = null;
            return stringArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean mkdir(boolean bl) {
        Node node = this.rootNode;
        synchronized (node) {
            String string = this.getFullPath();
            int n = 0;
            Node node2 = this.rootNode;
            while (node2 != null) {
                String string2;
                if (n >= string.length()) {
                    return false;
                }
                int n2 = string.indexOf(47, n);
                if (n2 == n) {
                    n = n2 + 1;
                    continue;
                }
                if (n2 == -1) {
                    string2 = string.substring(n);
                    if (node2.lookup(string2) != null) {
                        return false;
                    }
                    node2.createDir(string2);
                    return true;
                }
                string2 = string.substring(n, n2);
                Node node3 = node2.lookup(string2);
                if (node3 == null && bl) {
                    node3 = node2.createDir(string2);
                }
                if (node3 == null) return false;
                if (node3.type != 0) {
                    return false;
                }
                node2 = node3;
                n = n2 + 1;
            }
            return false;
        }
    }

    public boolean mkdir() {
        return this.mkdir(false);
    }

    public boolean mkdirs() {
        return this.mkdir(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean remove() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAllButTail();
            String string = this.getTail();
            if (node2 == null) {
                return false;
            }
            Node node3 = node2.lookup(string);
            if (node3 == null) return false;
            if (node3.firstChild != null) {
                return false;
            }
            node2.remove(string);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean renameTo(Path path) {
        Node node = this.rootNode;
        synchronized (node) {
            if (!(path instanceof MemoryPath)) {
                return false;
            }
            MemoryPath memoryPath = (MemoryPath)path;
            if (this.rootNode != memoryPath.rootNode) {
                return false;
            }
            Node node2 = this.lookupAllButTail();
            if (node2 == null) {
                return false;
            }
            Node node3 = node2.lookup(this.getTail());
            if (node3 == null) {
                return false;
            }
            Node node4 = memoryPath.lookupAllButTail();
            if (node4 == null) return false;
            if (node4.type != 0) {
                return false;
            }
            if (node4.lookup(memoryPath.getTail()) != null) {
                return false;
            }
            node2.remove(this.getTail());
            node3.name = memoryPath.getTail();
            node4.create(node3);
            return true;
        }
    }

    protected StreamImpl openReadImpl() throws IOException {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            if (node2 == null) {
                throw new FileNotFoundException(this.getPath());
            }
            if (node2.type != 1) {
                throw new IOException("is directory: " + this.getPath());
            }
            MemoryPath memoryPath = this;
            if (memoryPath == null) {
                throw null;
            }
            MemoryStream memoryStream = memoryPath.new MemoryStream(node2, (ByteBuffer)node2.data, false);
            Object var2_4 = null;
            return memoryStream;
        }
    }

    protected StreamImpl openWriteImpl() throws IOException {
        return this.openWriteImpl(false);
    }

    protected StreamImpl openAppendImpl() throws IOException {
        return this.openWriteImpl(true);
    }

    private StreamImpl openWriteImpl(boolean bl) throws IOException {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAllButTail();
            String string = this.getTail();
            if (node2 == null || node2.type != 0) {
                throw new IOException("cannot create file: " + this.getFullPath());
            }
            Node node3 = node2.lookup(string);
            if (node3 == null) {
                node3 = node2.createFile(string, new ByteBuffer(256));
            } else if (!bl) {
                node2.remove(string);
                node3 = node2.createFile(string, new ByteBuffer(256));
            } else if (node3.type != 1) {
                throw new IOException("cannot create file: " + this.getFullPath());
            }
            MemoryPath memoryPath = this;
            if (memoryPath == null) {
                throw null;
            }
            MemoryStream memoryStream = memoryPath.new MemoryStream(node3, (ByteBuffer)node3.data, true);
            Object var3_7 = null;
            return memoryStream;
        }
    }

    public Object getValue() throws IOException {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            if (node2 == null || node2.type != 2) {
                throw new IOException("no such object: " + this.getFullPath().toString());
            }
            Object object = node2.data;
            Object var2_4 = null;
            return object;
        }
    }

    public synchronized void setValue(Object object) throws IOException {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAllButTail();
            String string = this.getTail();
            if (node2 == null || node2.type != 0) {
                throw new IOException("cannot set object: " + this.getFullPath());
            }
            Node node3 = node2.lookup(string);
            if (node3 == null) {
                node3 = node2.createObject(string, object);
            } else if (node3.type == 2) {
                node3.data = object;
            } else {
                throw new IOException("cannot set object: " + this.getFullPath());
            }
        }
    }

    protected MemoryPath(FilesystemPath filesystemPath, String string, Map map, String string2) {
        super(filesystemPath, string, string2);
        if (filesystemPath instanceof MemoryPath) {
            this.rootNode = ((MemoryPath)filesystemPath).rootNode;
        } else {
            filesystemPath = this;
        }
    }

    public MemoryPath() {
        this(null, "/", null, "/");
        this.root = this;
        this.rootNode = new Node("", null, 0);
    }

    private static class Node {
        static final int DIR = 0;
        static final int FILE = 1;
        static final int OBJECT = 2;
        String name;
        Node next;
        Node firstChild;
        long lastModified;
        int type;
        Object data;

        Node lookup(String string) {
            Node node = this.firstChild;
            while (node != null) {
                if (node.name.equals(string)) {
                    return node;
                }
                node = node.next;
            }
            return null;
        }

        private Node create(String string, Object object, int n) {
            Node node = this.firstChild;
            while (node != null) {
                if (node.name.equals(string)) {
                    return null;
                }
                node = node.next;
            }
            node = new Node(string, object, n);
            node.next = this.firstChild;
            this.firstChild = node;
            this.lastModified = Alarm.getCurrentTime();
            return node;
        }

        Node createDir(String string) {
            return this.create(string, null, 0);
        }

        Node createFile(String string, ByteBuffer byteBuffer) {
            return this.create(string, byteBuffer, 1);
        }

        Node createObject(String string, Object object) {
            return this.create(string, object, 2);
        }

        Node create(Node node) {
            node.next = this.firstChild;
            this.firstChild = node;
            return node;
        }

        boolean remove(String string) {
            Node node = null;
            Node node2 = this.firstChild;
            while (node2 != null) {
                if (node2.name.equals(string)) {
                    if (node != null) {
                        node.next = node2.next;
                    } else {
                        this.firstChild = node2.next;
                    }
                    return true;
                }
                node = node2;
                node2 = node2.next;
            }
            return false;
        }

        Node(String string, Object object, int n) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.name = string;
            this.data = object;
            this.type = n;
            this.lastModified = Alarm.getCurrentTime();
        }
    }

    public class MemoryStream
    extends StreamImpl {
        Node node;
        ByteBuffer bb;
        int offset;
        boolean write;

        public int getAvailable() {
            return this.bb.length() - this.offset;
        }

        public boolean canRead() {
            return true;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            ByteBuffer byteBuffer = this.bb;
            synchronized (byteBuffer) {
                int n3 = this.bb.length() - this.offset;
                if (n2 < n3) {
                    n3 = n2;
                }
                if (n3 <= 0) {
                    int n4 = 0;
                    Object var5_8 = null;
                    return n4;
                }
                System.arraycopy(this.bb.getBuffer(), this.offset, byArray, n, n3);
                this.offset += n3;
                int n5 = n3;
                Object var5_9 = null;
                return n5;
            }
        }

        public int getPosition() {
            return this.offset;
        }

        public void setPosition(int n) {
            this.offset = n;
            if (this.offset < 0) {
                this.offset = 0;
            }
            if (this.offset > this.bb.length()) {
                this.offset = this.bb.length();
            }
        }

        public boolean canWrite() {
            return true;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            ByteBuffer byteBuffer = this.bb;
            synchronized (byteBuffer) {
                this.bb.add(byArray, n, n2);
            }
            this.node.lastModified = Alarm.getCurrentTime();
        }

        MemoryStream(Node node, ByteBuffer byteBuffer, boolean bl) {
            this.setPath(MemoryPath.this);
            this.node = node;
            if (bl) {
                node.lastModified = Alarm.getCurrentTime();
            }
            this.write = bl;
            this.bb = byteBuffer;
        }
    }
}

