/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.ChangeListener;
import com.caucho.util.QDate;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.Iterator;

public class LogStream
extends StreamImpl
implements ChangeListener {
    private String logId;
    private byte[] idBuf;
    private WriteStream dest;
    private String timestampFormat;
    private QDate calendar;

    public void handleChange(Object object) {
        if (this.dest != null) {
            try {
                this.dest.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.dest = null;
        this.init();
    }

    private void init() {
        Object object;
        Object object2;
        RegistryNode registryNode = Registry.lookup("/caucho.com");
        if (registryNode == null) {
            return;
        }
        Object object3 = "/";
        Object object4 = null;
        Iterator iterator = registryNode.select("log");
        while (iterator.hasNext()) {
            object2 = (RegistryNode)iterator.next();
            object = ((RegistryNode)object2).getValue();
            if (object == null) {
                object = "/";
            } else if (((String)object).length() == 0 || ((String)object).charAt(((String)object).length() - 1) != '/') {
                object = (String)object + "/";
            }
            if (!this.logId.startsWith((String)object) || !((String)object).startsWith((String)object3)) continue;
            object3 = object;
            object4 = object2;
        }
        if (object4 == null) {
            return;
        }
        object2 = ((RegistryNode)object4).getString("href", null);
        if (object2 == null) {
            return;
        }
        if (((RegistryNode)object4).lookup("timestamp") != null) {
            this.timestampFormat = ((RegistryNode)object4).getString("timestamp", "[%Y/%m/%d %H:%M:%S]");
        }
        try {
            object = Vfs.lookupNative((String)object2);
            ((Path)object).getParent().mkdirs();
            this.dest = ((Path)object).openAppend();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static WriteStream open(String string) {
        LogStream logStream = new LogStream(string);
        WriteStream writeStream = new WriteStream(logStream);
        writeStream.setFlushOnNewline(true);
        return writeStream;
    }

    public boolean canWrite() {
        return this.dest != null;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.dest != null) {
            WriteStream writeStream = this.dest;
            synchronized (writeStream) {
                if (this.timestampFormat != null) {
                    this.calendar.calculate(Alarm.getCurrentTime(), true);
                    String string = this.calendar.format(this.timestampFormat);
                    byte[] byArray2 = string.getBytes();
                    this.dest.write(byArray2, 0, byArray2.length);
                }
                this.dest.write(this.idBuf, 0, this.idBuf.length);
                this.dest.write(byArray, n, n2);
                this.dest.flush();
            }
        }
    }

    public void flush() {
    }

    public void close() {
    }

    LogStream(String string) {
        if (string.charAt(string.length() - 1) != '/') {
            string = string + "/";
        }
        this.logId = string;
        this.idBuf = (string + ": ").getBytes();
        this.calendar = new QDate();
        this.init();
        Registry.addListener(this);
    }
}

