/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.HttpStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.util.Map;

public class HttpPath
extends FilesystemPath {
    protected String host;
    protected int port;
    protected String query;

    public Path lookup(String string, Map map) {
        if (string == null) {
            return this.root.fsWalk(this.getPath(), map, "/");
        }
        int n = string.length();
        int n2 = string.indexOf(58);
        int n3 = string.indexOf(47);
        if (n2 != -1 && (n2 < n3 || n3 == -1)) {
            return super.lookup(string, map);
        }
        if (n3 == 0 && n > 1 && string.charAt(1) == '/') {
            return this.schemeWalk(string, map, string, 0);
        }
        String string2 = n3 == 0 ? FilesystemPath.normalizePath("/", string, 0, '/') : FilesystemPath.normalizePath(this.pathname, string, 0, '/');
        return this.root.fsWalk(string, map, string2);
    }

    protected Path schemeWalk(String string, Map map, String string2, int n) {
        int n2 = string2.length();
        if (n2 < 2 + n || string2.charAt(n) != '/' || string2.charAt(n + 1) != '/') {
            throw new RuntimeException("bad scheme");
        }
        CharBuffer charBuffer = CharBuffer.allocate();
        int n3 = 2 + n;
        char c = '\u0000';
        while (n3 < n2 && (c = string2.charAt(n3)) != ':' && c != '/' && c != '?') {
            charBuffer.append(c);
            ++n3;
        }
        String string3 = charBuffer.close();
        if (string3.length() == 0) {
            throw new RuntimeException("bad host");
        }
        int n4 = 0;
        if (c == ':') {
            ++n3;
            while (n3 < n2 && (c = string2.charAt(n3)) >= '0' && c <= '9') {
                n4 = 10 * n4 + string2.charAt(n3) - 48;
                ++n3;
            }
        }
        if (n4 == 0) {
            n4 = 80;
        }
        HttpPath httpPath = new HttpPath(string3, n4);
        return httpPath.fsWalk(string, map, string2.substring(n3));
    }

    protected Path fsWalk(String string, Map map, String string2) {
        String string3;
        String string4 = null;
        int n = string2.indexOf(63);
        if (n >= 0) {
            string3 = string2.substring(0, n);
            string4 = string2.substring(n + 1);
        } else {
            string3 = string2;
        }
        if (string3.length() == 0) {
            string3 = "/";
        }
        return new HttpPath(this.root, string, map, string3, string4);
    }

    public String getScheme() {
        return "http";
    }

    public String getURL() {
        int n = this.getPort();
        return this.getScheme() + "://" + this.getHost() + (n == 80 ? "" : ":" + this.getPort()) + this.getPath() + (this.query == null ? "" : "?" + this.query);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserPath() {
        return this.userPath;
    }

    public String getQuery() {
        return this.query;
    }

    public StreamImpl openReadImpl() throws IOException {
        return HttpStream.openRead(this);
    }

    public StreamImpl openReadWriteImpl() throws IOException {
        return HttpStream.openReadWrite(this);
    }

    public String toString() {
        return this.getURL();
    }

    public int hashCode() {
        return 983055 + super.hashCode();
    }

    HttpPath(String string, int n) {
        super(null, "/", "/");
        this.root = this;
        this.host = string;
        this.port = n == 0 ? 80 : n;
    }

    HttpPath(FilesystemPath filesystemPath, String string, Map map, String string2, String string3) {
        super(filesystemPath, string, string2);
        this.host = ((HttpPath)filesystemPath).host;
        this.port = ((HttpPath)filesystemPath).port;
        this.query = string3;
    }
}

