/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.BindPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.SchemeMap;
import java.util.Map;

public abstract class FilesystemPath
extends Path {
    protected FilesystemPath root;
    protected BindPath bindRoot;
    protected String pathname;
    protected String userPath;
    protected char separatorChar;

    public Path getParent() {
        if (this.pathname.length() <= 1) {
            return this.fsWalk("/", null, "/");
        }
        int n = this.pathname.lastIndexOf(47);
        if (n < 1) {
            return this.fsWalk("/", null, "/");
        }
        return this.fsWalk("..", null, this.pathname.substring(0, n));
    }

    protected Path schemeWalk(String string, Map map, String string2, int n) {
        String string3 = string2.length() > n && (string2.charAt(n) == '/' || string2.charAt(n) == this.separatorChar) ? FilesystemPath.normalizePath("/", string2, n, this.separatorChar) : FilesystemPath.normalizePath(this.pathname, string2, n, this.separatorChar);
        return this.fsWalk(string, map, string3);
    }

    protected abstract Path fsWalk(String var1, Map var2, String var3);

    protected static String normalizePath(String string, String string2, int n, char c) {
        CharBuffer charBuffer = CharBuffer.allocate();
        FilesystemPath.normalizePath(charBuffer, string, string2, n, c);
        return charBuffer.close();
    }

    protected static void normalizePath(CharBuffer charBuffer, String string, String string2, int n, char c) {
        charBuffer.clear();
        charBuffer.append(string);
        if (charBuffer.getLastChar() != '/') {
            charBuffer.append('/');
        }
        int n2 = string2.length();
        int n3 = n;
        while (n3 < n2) {
            char c2 = string2.charAt(n3);
            block0 : switch (c2) {
                default: {
                    if (c2 != c) {
                        charBuffer.append(c2);
                        ++n3;
                        break;
                    }
                }
                case '/': {
                    if (charBuffer.getLastChar() != '/') {
                        charBuffer.append('/');
                    }
                    ++n3;
                    break;
                }
                case '.': {
                    if (charBuffer.getLastChar() != '/') {
                        charBuffer.append('.');
                        ++n3;
                        break;
                    }
                    if (n3 + 1 >= n2) {
                        n3 += 2;
                        break;
                    }
                    switch (string2.charAt(n3 + 1)) {
                        default: {
                            if (string2.charAt(n3 + 1) != c) {
                                charBuffer.append('.');
                                ++n3;
                                break block0;
                            }
                        }
                        case '/': {
                            n3 += 2;
                            break block0;
                        }
                        case '.': 
                    }
                    if ((n3 + 2 >= n2 || string2.charAt(n3 + 2) == '/') && charBuffer.getLastChar() == '/') {
                        int n4 = charBuffer.lastIndexOf('/', charBuffer.length() - 2);
                        if (n4 == -1) {
                            charBuffer.clear();
                            charBuffer.append('/');
                        } else {
                            charBuffer.setLength(n4 + 1);
                        }
                        n3 += 3;
                        break;
                    }
                    charBuffer.append('.');
                    ++n3;
                    break;
                }
            }
        }
        if (charBuffer.length() > 1 && charBuffer.getLastChar() == '/') {
            charBuffer.setLength(charBuffer.length() - 1);
        }
    }

    public String getURL() {
        return this.getPath();
    }

    public String getPath() {
        return this.pathname;
    }

    public String getUserPath() {
        return this.userPath == null ? this.pathname : this.userPath;
    }

    public void setUserPath(String string) {
        this.userPath = string;
    }

    public String getFullPath() {
        if (this.root == this) {
            return this.getPath();
        }
        String string = this.root.getFullPath();
        String string2 = this.getPath();
        if (string.length() <= 1) {
            return string2;
        }
        if (string2.length() <= 1) {
            return string;
        }
        return string + string2;
    }

    public String getTail() {
        String string = this.getPath();
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public Path createRoot() {
        FilesystemPath filesystemPath = (FilesystemPath)this.copy();
        filesystemPath.schemeMap = new SchemeMap();
        filesystemPath.root = this;
        filesystemPath.pathname = "/";
        filesystemPath.userPath = "/";
        return filesystemPath;
    }

    public void bind(Path path) {
        if (this.bindRoot == null) {
            this.bindRoot = this.root.bindRoot;
        }
        if (this.bindRoot == null) {
            this.root.bindRoot = this.bindRoot = new BindPath(this.root);
        }
        this.bindRoot.bind(this.getPath(), path);
    }

    public Path copy() {
        return this.root.fsWalk(this.userPath, null, this.pathname);
    }

    public int hashCode() {
        return this.pathname.hashCode();
    }

    public boolean equals(Object object) {
        try {
            FilesystemPath filesystemPath = (FilesystemPath)object;
            return filesystemPath != null && this.pathname.equals(filesystemPath.pathname);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return this.getPath();
    }

    protected FilesystemPath(FilesystemPath filesystemPath, String string, String string2) {
        super(filesystemPath);
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.separatorChar = (char)47;
        this.pathname = string2;
        this.userPath = string;
        if (filesystemPath != null) {
            this.root = filesystemPath;
            this.bindRoot = filesystemPath.bindRoot;
            return;
        }
    }
}

