/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Pwd;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

public class FilePath
extends FilesystemPath {
    private static byte[] newline = CauchoSystem.getNewlineString().getBytes();
    private File file;

    private static String initialPath(String string) {
        if (string == null) {
            return FilePath.getPwd();
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            return string;
        }
        String string2 = FilePath.getPwd();
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '/') {
            return string2 + string;
        }
        return string2 + "/" + string;
    }

    private static String getPwd() {
        String string = CauchoSystem.getUserDir();
        string = string.replace(CauchoSystem.getFileSeparatorChar(), '/');
        if (CauchoSystem.isWindows()) {
            string = FilePath.convertFromWindowsPath(string);
        }
        return string;
    }

    private static String convertFromWindowsPath(String string) {
        if (string.indexOf(58) == 1 && string.charAt(0) != '/') {
            return "/" + string.charAt(0) + ":/" + string.substring(2);
        }
        if (string.length() > 1 && string.charAt(0) == '/' && string.charAt(1) == '/') {
            return "/:" + string;
        }
        return string;
    }

    protected Path schemeWalk(String string, Map map, String string2, int n) {
        if (!CauchoSystem.isWindows()) {
            return super.schemeWalk(string, map, string2, n);
        }
        if (string2.length() < n + 2) {
            return super.schemeWalk(string, map, string2, n);
        }
        char c = string2.charAt(n + 1);
        char c2 = string2.charAt(n);
        if (!(c2 != '/' && c2 != this.separatorChar || c != '/' && c != this.separatorChar)) {
            return super.schemeWalk(string, map, "/:" + string2.substring(n), 0);
        }
        return super.schemeWalk(string, map, string2, n);
    }

    protected Path fsWalk(String string, Map map, String string2) {
        return new FilePath(this.root, string, string2);
    }

    public String getScheme() {
        return "file";
    }

    public String getNativePath() {
        char c;
        if (this.separatorChar == '/' && !CauchoSystem.isWindows()) {
            return this.getFullPath();
        }
        String string = this.getFullPath();
        int n = string.length();
        CharBuffer charBuffer = CharBuffer.allocate();
        int n2 = 0;
        if (CauchoSystem.isWindows()) {
            if (n >= 3 && string.charAt(0) == '/' && string.charAt(2) == ':' && ((c = string.charAt(1)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                n2 = 1;
            } else if (n >= 3 && string.charAt(0) == '/' && string.charAt(1) == ':' && string.charAt(2) == '/') {
                charBuffer.append('\\');
                charBuffer.append('\\');
                n2 = 3;
            }
        }
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == '/') {
                charBuffer.append(this.separatorChar);
            } else {
                charBuffer.append(c);
            }
            ++n2;
        }
        return charBuffer.close();
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    public boolean isFile() {
        return this.getFile().isFile();
    }

    public long getLength() {
        return this.getFile().length();
    }

    public long getLastModified() {
        return this.getFile().lastModified();
    }

    public void setLastModified(long l) {
        try {
            this.getFile().setLastModified(l);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public boolean canRead() {
        return this.getFile().canRead();
    }

    public boolean canWrite() {
        return this.getFile().canWrite();
    }

    public String[] list() throws IOException {
        String[] stringArray = this.getFile().list();
        if (stringArray != null) {
            return stringArray;
        }
        if (!this.getFile().isDirectory()) {
            throw new IOException("not dir: " + this.getFile());
        }
        return new String[0];
    }

    public boolean mkdir() throws IOException {
        boolean bl = this.getFile().mkdir();
        if (!bl && !this.getFile().isDirectory()) {
            throw new IOException("cannot create directory");
        }
        return bl;
    }

    public boolean mkdirs() throws IOException {
        boolean bl = this.getFile().mkdirs();
        if (!bl && !this.getFile().isDirectory()) {
            throw new IOException("Cannot create directory: " + this.getFile());
        }
        return bl;
    }

    public boolean remove() {
        return this.getFile().delete();
    }

    public boolean renameTo(Path path) {
        if (!(path instanceof FilePath)) {
            return false;
        }
        FilePath filePath = (FilePath)path;
        return this.getFile().renameTo(filePath.getFile());
    }

    public StreamImpl openReadImpl() throws IOException {
        if (this.isDirectory()) {
            throw new IOException("is directory");
        }
        return new VfsStream(new FileInputStream(this.getFile()), null, this);
    }

    public StreamImpl openWriteImpl() throws IOException {
        VfsStream vfsStream = new VfsStream(null, new FileOutputStream(this.getFile()), this);
        vfsStream.setNewline(newline);
        return vfsStream;
    }

    public StreamImpl openAppendImpl() throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.getFile().toString(), true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileOutputStream = new FileOutputStream(this.getFile().toString());
        }
        VfsStream vfsStream = new VfsStream(null, fileOutputStream);
        vfsStream.setNewline(newline);
        return vfsStream;
    }

    public StreamImpl openReadWriteImpl() throws IOException {
        VfsStream vfsStream = new VfsStream(new FileInputStream(this.getFile()), new FileOutputStream(this.getFile()), this);
        vfsStream.setNewline(newline);
        return vfsStream;
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilePath)) {
            return false;
        }
        FilePath filePath = (FilePath)object;
        return this.getFile().equals(filePath.getFile());
    }

    private File getFile() {
        if (this.file != null) {
            return this.file;
        }
        this.file = CauchoSystem.isTesting() ? new File(this.getFullPath()) : new File(this.getNativePath());
        return this.file;
    }

    protected FilePath(FilesystemPath filesystemPath, String string, String string2) {
        super(filesystemPath, string, string2);
        this.separatorChar = CauchoSystem.getFileSeparatorChar();
    }

    FilePath(String string) {
        this(Pwd.PWD != null ? Pwd.PWD.root : null, string, FilesystemPath.normalizePath("/", FilePath.initialPath(string), 0, CauchoSystem.getFileSeparatorChar()));
        if (this.root == null) {
            this.root.root = this.root = new FilePath(null, "/", "/");
        }
    }
}

