/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.QDate;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RegistryNode {
    private RegistryNode root;
    boolean isModified;
    RegistryNode parent;
    private ArrayList children;
    String name;
    String value;
    private String filename;
    private int line;

    public boolean isModified() {
        return this.root.isModified;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public RegistryNode getParent() {
        return this.parent;
    }

    public RegistryNode getFirstChild() {
        if (this.children != null && this.children.size() > 0) {
            return (RegistryNode)this.children.get(0);
        }
        return null;
    }

    public void append(RegistryNode registryNode) {
        if (registryNode == null || registryNode.children == null) {
            return;
        }
        int n = 0;
        while (n < registryNode.children.size()) {
            RegistryNode registryNode2 = (RegistryNode)registryNode.children.get(n);
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(registryNode2);
            ++n;
        }
    }

    public boolean getBoolean() {
        String string = this.getValue();
        if (string == null) {
            return false;
        }
        return !string.equals("false");
    }

    public boolean getBoolean(String string, boolean bl) {
        RegistryNode registryNode = this.lookup(string);
        if (registryNode == null) {
            return bl;
        }
        return registryNode.getBoolean();
    }

    public RegistryNode lookup(String string) {
        int n = 0;
        int n2 = string.length();
        RegistryNode registryNode = this;
        while (n < n2 && string.charAt(n) == '/') {
            ++n;
        }
        while (n < n2) {
            int n3 = n;
            while (n3 < n2 && string.charAt(n3) != '/') {
                ++n3;
            }
            if (n3 > n && (registryNode = registryNode.getLink(string.substring(n, n3))) == null) {
                return null;
            }
            n = n3;
            while (n < n2 && string.charAt(n) == '/') {
                ++n;
            }
        }
        return registryNode;
    }

    private RegistryNode getLink(String string) {
        int n = this.children == null ? 0 : this.children.size();
        int n2 = 0;
        while (n2 < n) {
            RegistryNode registryNode = (RegistryNode)this.children.get(n2);
            if (registryNode.name.equals(string)) {
                return registryNode;
            }
            ++n2;
        }
        return null;
    }

    public int getInt() {
        String string = this.getValue();
        if (string == null || string.equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getInt(String string, int n) {
        RegistryNode registryNode = this.lookup(string);
        if (registryNode == null) {
            return n;
        }
        return registryNode.getInt();
    }

    public double getDouble() {
        String string = this.getValue();
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public double getDouble(String string, double d) {
        RegistryNode registryNode = this.lookup(string);
        if (registryNode == null) {
            return d;
        }
        return registryNode.getDouble();
    }

    public String getString() {
        String string = this.getValue();
        return string;
    }

    public String getString(String string, String string2) {
        RegistryNode registryNode = this.lookup(string);
        if (registryNode == null) {
            return string2;
        }
        return registryNode.getString();
    }

    public QDate getDate() {
        String string = this.getValue();
        throw new RuntimeException("no date");
    }

    public QDate getDate(String string, QDate qDate) {
        RegistryNode registryNode = this.lookup(string);
        if (registryNode == null) {
            return qDate;
        }
        return registryNode.getDate();
    }

    public long getPeriod() {
        String string = this.getValue();
        if (string == null) {
            return 0L;
        }
        long l = 0L;
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c;
            int n3 = 0;
            while (n < n2 && (c = string.charAt(n)) >= '0' && c <= '9') {
                n3 = 10 * n3 + c - 48;
                ++n;
            }
            if (n >= n2) {
                l += (long)(1000 * n3);
                continue;
            }
            switch (string.charAt(n++)) {
                default: {
                    l += (long)(1000 * n3);
                    break;
                }
                case 'm': {
                    l += (long)(60000 * n3);
                    break;
                }
                case 'H': 
                case 'h': {
                    l += (long)(3600000 * n3);
                    break;
                }
                case 'D': 
                case 'd': {
                    l += (long)(86400000 * n3);
                    break;
                }
                case 'W': 
                case 'w': {
                    l += (long)(604800000 * n3);
                    break;
                }
                case 'M': {
                    l += (long)(-1702967296 * n3);
                    break;
                }
                case 'Y': 
                case 'y': {
                    l += (long)(1314000000 * n3);
                    break;
                }
            }
        }
        return l;
    }

    public long getPeriod(String string, long l) {
        RegistryNode registryNode = this.lookup(string);
        if (registryNode == null) {
            return l;
        }
        return registryNode.getPeriod();
    }

    public Iterator iterator() {
        RegistryNode registryNode = this;
        if (registryNode == null) {
            throw null;
        }
        return registryNode.new RegistryIterator();
    }

    public Iterator select(String string) {
        RegistryNode registryNode = this;
        if (registryNode == null) {
            throw null;
        }
        return registryNode.new RegistryIterator(string);
    }

    RegistryNode add(String string, String string2, String string3, int n) {
        RegistryNode registryNode = new RegistryNode(this, string, string2, string3, n);
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(registryNode);
        registryNode.parent = this;
        return registryNode;
    }

    RegistryNode add(RegistryNode registryNode) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(registryNode);
        registryNode.parent = this;
        return registryNode;
    }

    private RegistryNode getLink(String string, String string2) {
        int n = this.children == null ? 0 : this.children.size();
        int n2 = 0;
        while (n2 < n) {
            RegistryNode registryNode = (RegistryNode)this.children.get(n2);
            if (registryNode.name.equals(string) && registryNode.value != null && registryNode.value.equals(string2)) {
                return registryNode;
            }
            ++n2;
        }
        return null;
    }

    public void print(WriteStream writeStream) throws IOException {
        this.print(writeStream, 0);
    }

    private void print(WriteStream writeStream, int n) throws IOException {
        this.printSpaces(writeStream, n);
        writeStream.print("<" + this.getName());
        if (this.getValue() != null) {
            writeStream.print(" id=\"" + this.getValue() + "\"");
        }
        int n2 = this.children == null ? 0 : this.children.size();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            RegistryNode registryNode = (RegistryNode)this.children.get(n3);
            if (registryNode.children != null && registryNode.children.size() != 0) {
                bl = true;
                break;
            }
            writeStream.print(" " + registryNode.getName() + "=\"" + registryNode.getValue() + "\"");
            ++n3;
        }
        if (!bl) {
            writeStream.println("/>");
            return;
        }
        writeStream.println(">");
        n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            RegistryNode registryNode = (RegistryNode)this.children.get(n4);
            if (n3 != 0 || registryNode.children != null && registryNode.children.size() > 0) {
                n3 = 1;
                registryNode.print(writeStream, n + 2);
            }
            ++n4;
        }
        this.printSpaces(writeStream, n);
        writeStream.println("</" + this.getName() + ">");
    }

    private void printSpaces(WriteStream writeStream, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            writeStream.print(' ');
            ++n2;
        }
    }

    public Object clone() {
        RegistryNode registryNode = new RegistryNode(this.root, this.name, this.value, this.filename, this.line);
        if (this.root == this) {
            registryNode.root = registryNode;
            registryNode.parent = this.parent;
        } else {
            registryNode.root = this.root;
            registryNode.parent = this.parent;
        }
        registryNode.isModified = false;
        if (this.children != null) {
            registryNode.children = new ArrayList();
            int n = 0;
            while (n < this.children.size()) {
                registryNode.children.add(this.children.get(n));
                ++n;
            }
        }
        return registryNode;
    }

    public String toString() {
        return "[RegistryNode " + this.name + " " + this.value + "]";
    }

    RegistryNode(RegistryNode registryNode, String string, String string2, String string3, int n) {
        if (registryNode == null) {
            this.root = null;
        }
        this.name = string;
        this.value = string2;
        this.filename = string3;
        this.line = n;
    }

    class RegistryIterator
    implements Iterator {
        int i;
        String key;

        /*
         * Unable to fully structure code
         */
        private void findNext() {
            if (this.key != null && RegistryNode.access$0(RegistryNode.this) != null) ** GOTO lbl7
            return;
lbl-1000:
            // 1 sources

            {
                var1_1 = (RegistryNode)RegistryNode.access$0(RegistryNode.this).get(this.i);
                if (var1_1.name.equals(this.key)) {
                    return;
                }
                ++this.i;
lbl7:
                // 2 sources

                ** while (this.i < RegistryNode.access$0((RegistryNode)RegistryNode.this).size())
            }
lbl8:
            // 1 sources

        }

        public boolean hasNext() {
            return RegistryNode.this.children != null && this.i < RegistryNode.this.children.size();
        }

        public Object next() {
            if (RegistryNode.this.children == null || this.i >= RegistryNode.this.children.size()) {
                return null;
            }
            Object e = RegistryNode.this.children.get(this.i);
            ++this.i;
            this.findNext();
            return e;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public RegistryIterator() {
        }

        public RegistryIterator(String string) {
            this.key = string;
            this.findNext();
        }
    }
}

