/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class IntSet {
    int[] data;
    int size;

    public void clear() {
        this.size = 0;
    }

    private void expand(int n) {
        while (n > this.data.length) {
            int[] nArray = new int[this.data.length * 2];
            int n2 = 0;
            while (n2 < this.data.length) {
                nArray[n2] = this.data[n2];
                ++n2;
            }
            this.data = nArray;
        }
    }

    public int length() {
        return this.size / 2;
    }

    public int size() {
        return this.size / 2;
    }

    public int getMin(int n) {
        return this.data[2 * n];
    }

    public int getMax(int n) {
        return this.data[2 * n + 1];
    }

    private void insert(int n, int n2, int n3) {
        this.expand(this.size + 2);
        System.arraycopy(this.data, n, this.data, n + 2, this.size - n);
        this.data[n] = n2;
        this.data[n + 1] = n3;
        this.size += 2;
    }

    private void delete(int n) {
        System.arraycopy(this.data, n + 2, this.data, n, this.size - n - 2);
        this.size -= 2;
    }

    public void union(int n, int n2) {
        int n3 = 1;
        while (n3 < this.size) {
            if (n2 < this.data[n3 - 1] - 1) {
                this.insert(n3 - 1, n, n2);
                return;
            }
            if (n <= this.data[n3] + 1) {
                if (n < this.data[n3 - 1]) {
                    this.data[n3 - 1] = n;
                }
                if (n2 > this.data[n3]) {
                    this.data[n3] = n2;
                }
                int n4 = n3 + 2;
                while (n4 < this.size && n2 > this.data[n4 - 1] + 1) {
                    if (n2 < this.data[n4 - 1]) {
                        this.data[n3] = this.data[n4 - 1];
                    }
                    this.delete(n4 - 1);
                }
                return;
            }
            n3 += 2;
        }
        this.insert(this.size, n, n2);
    }

    public void union(int n) {
        this.union(n, n);
    }

    public void union(IntSet intSet) {
        int n = 1;
        while (n < intSet.size) {
            this.union(intSet.data[n - 1], intSet.data[n]);
            n += 2;
        }
    }

    public void unionNegate(IntSet intSet, int n, int n2) {
        int n3 = 1;
        while (n3 < intSet.size) {
            this.union(n, intSet.data[n3 - 1] - 1);
            n = intSet.data[n3] + 1;
            n3 += 2;
        }
        this.union(n, n2);
    }

    public void negate(int n, int n2) {
        int n3 = n;
        if (this.size > 0 && this.data[0] == n) {
            n3 = this.data[1];
            this.delete(0);
            if (n3 == n2) {
                return;
            }
            ++n3;
        }
        int n4 = 1;
        while (n4 < this.size) {
            int n5 = this.data[n4];
            this.data[n4] = this.data[n4 - 1] - 1;
            this.data[n4 - 1] = n3;
            if (n5 == n2) {
                return;
            }
            n3 = n5 + 1;
            n4 += 2;
        }
        this.insert(this.size, n3, n2);
    }

    public void negate() {
        this.negate(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public boolean difference(IntSet intSet) {
        int n = 1;
        int n2 = 1;
        while (n < this.size && n2 < intSet.size) {
            int n3 = this.data[n - 1];
            int n4 = this.data[n];
            int n5 = intSet.data[n2 - 1];
            int n6 = intSet.data[n2];
            if (n6 < n3) {
                n2 += 2;
                continue;
            }
            if (n4 < n5) {
                n += 2;
                continue;
            }
            if (n5 <= n3 && n4 <= n6) {
                this.delete(n - 1);
                continue;
            }
            if (n3 < n5 && n6 < n4) {
                this.insert(n + 1, n6 + 1, n4);
                this.data[n] = n5 - 1;
                n += 2;
                n2 += 2;
                continue;
            }
            if (n3 < n5) {
                this.data[n] = n5 - 1;
                n += 2;
                continue;
            }
            if (n4 > n6) {
                this.data[n - 1] = n6 + 1;
                n2 += 2;
                continue;
            }
            throw new RuntimeException("Impossible case");
        }
        return this.size != 0;
    }

    public boolean intersection(IntSet intSet) {
        int n = 1;
        int n2 = 1;
        while (n < this.size && n2 < intSet.size) {
            int n3 = this.data[n - 1];
            int n4 = this.data[n];
            int n5 = intSet.data[n2 - 1];
            int n6 = intSet.data[n2];
            if (n6 < n3) {
                n2 += 2;
                continue;
            }
            if (n4 < n5) {
                this.delete(n - 1);
                continue;
            }
            if (n5 <= n3 && n4 <= n6) {
                n += 2;
                continue;
            }
            if (n3 <= n5 && n6 <= n4) {
                this.data[n - 1] = n5;
                this.data[n] = n6;
                if (n6 < n4) {
                    this.insert(n + 1, n6 + 1, n4);
                }
                n += 2;
                n2 += 2;
                continue;
            }
            if (n3 <= n5) {
                this.data[n - 1] = n5;
                n += 2;
                continue;
            }
            if (n5 < n3) {
                this.data[n] = n6;
                this.insert(n + 1, n6 + 1, n4);
                n += 2;
                continue;
            }
            throw new RuntimeException("case");
        }
        while (n < this.size) {
            this.delete(n - 1);
        }
        return this.size != 0;
    }

    public boolean contains(int n) {
        int n2 = 1;
        while (n2 < this.size) {
            if (n < this.data[n2 - 1]) {
                return false;
            }
            if (n <= this.data[n2]) {
                return true;
            }
            n2 += 2;
        }
        return false;
    }

    public boolean isSubset(IntSet intSet) {
        int n = 1;
        int n2 = 1;
        while (n < this.size && n2 < intSet.size) {
            if (this.data[n] < intSet.data[n2 - 1]) {
                n += 2;
                continue;
            }
            if (intSet.data[n2 - 1] < this.data[n - 1] || intSet.data[n2] > this.data[n]) {
                return false;
            }
            n2 += 2;
        }
        return true;
    }

    public boolean isDisjoint(IntSet intSet) {
        int n = 1;
        int n2 = 1;
        while (n < this.size && n2 < intSet.size) {
            if (this.data[n] < intSet.data[n2 - 1]) {
                n += 2;
                continue;
            }
            if (intSet.data[n2] < this.data[n - 1]) {
                n2 += 2;
                continue;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IntSet[");
        int n = 1;
        while (n < this.size) {
            if (n != 1) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.data[n - 1]);
            if (this.data[n - 1] != this.data[n]) {
                stringBuffer.append(",");
                stringBuffer.append(this.data[n]);
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        IntSet intSet = new IntSet(false);
        intSet.data = new int[this.data.length];
        intSet.size = this.size;
        System.arraycopy(this.data, 0, intSet.data, 0, this.size);
        return intSet;
    }

    private IntSet(boolean bl) {
    }

    public IntSet() {
        this.data = new int[16];
        this.size = 0;
    }
}

