/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.ExitListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Exit
implements AlarmListener {
    private static HashMap waiting = new HashMap();
    private static long cleanupTime = 120000L;
    private ArrayList cleanupThreads = new ArrayList();

    public static void addExit(ExitListener exitListener, Object object) {
        Thread thread = Thread.currentThread();
        HashMap hashMap = waiting;
        synchronized (hashMap) {
            Queue queue = (Queue)waiting.get(thread);
            if (queue != null) {
                queue.add(exitListener, object);
            }
        }
    }

    public static boolean addExit() {
        Thread thread = Thread.currentThread();
        HashMap hashMap = waiting;
        synchronized (hashMap) {
            Queue queue = (Queue)waiting.get(thread);
            if (queue == null) {
                queue = Queue.allocate(thread);
                waiting.put(thread, queue);
                boolean bl = true;
                Object var2_5 = null;
                return bl;
            }
            boolean bl = false;
            Object var2_6 = null;
            return bl;
        }
    }

    public static void exit() {
        Thread thread = Thread.currentThread();
        Exit.exit(thread);
    }

    private static void exit(Thread thread) {
        Queue queue = null;
        HashMap hashMap = waiting;
        synchronized (hashMap) {
            queue = (Queue)waiting.remove(thread);
        }
        if (queue == null) {
            return;
        }
        int n = queue.listeners.size();
        int n2 = 0;
        while (n2 < n) {
            ExitListener exitListener = (ExitListener)queue.listeners.get(n2);
            Object e = queue.objects.get(n2);
            if (exitListener != null) {
                try {
                    exitListener.handleExit(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        queue.free();
    }

    public void handleAlarm(Alarm alarm) {
        HashMap hashMap = waiting;
        synchronized (hashMap) {
            Iterator iterator = waiting.keySet().iterator();
            while (iterator.hasNext()) {
                Thread thread = (Thread)iterator.next();
                if (Thread.activeCount() != 0) continue;
                this.cleanupThreads.add(thread);
            }
        }
        int n = this.cleanupThreads.size();
        int n2 = 0;
        while (n2 < n) {
            Thread thread = (Thread)this.cleanupThreads.get(n2);
            Exit.exit(thread);
            ++n2;
        }
        this.cleanupThreads.clear();
        alarm.queue(cleanupTime);
    }

    private Exit() {
    }

    static {
        Exit exit = new Exit();
        new Alarm("exit", exit, cleanupTime);
    }

    private static class Queue {
        static Queue freeList;
        Queue next;
        Thread thread;
        ArrayList listeners = new ArrayList();
        ArrayList objects = new ArrayList();

        void add(ExitListener exitListener, Object object) {
            this.listeners.add(exitListener);
            this.objects.add(object);
        }

        static Queue allocate(Thread thread) {
            if (freeList == null) {
                return new Queue(thread);
            }
            Queue queue = freeList;
            freeList = Queue.freeList.next;
            queue.thread = thread;
            return queue;
        }

        void free() {
            this.thread = null;
            this.listeners.clear();
            this.objects.clear();
            this.next = freeList;
            freeList = this;
        }

        private Queue(Thread thread) {
            this.thread = thread;
        }
    }
}

