/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import com.caucho.util.CronListener;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class Cron {
    private static WriteStream dbg = LogStream.open("/caucho.com/util/alarm");
    private static CronThread cronThread;
    private static ArrayList waiting;
    private CronListener listener;
    private String name;

    public CronListener getListener() {
        return this.listener;
    }

    public void setListener(CronListener cronListener) {
        this.listener = cronListener;
    }

    public void queue() {
        CronThread cronThread = Cron.cronThread;
        synchronized (cronThread) {
            ((AbstractCollection)waiting).remove(this);
            waiting.add(this);
        }
    }

    public void dequeue() {
        CronThread cronThread = Cron.cronThread;
        synchronized (cronThread) {
            ((AbstractCollection)waiting).remove(this);
        }
    }

    static void setTestTime(long l) {
        cronThread.interrupt();
    }

    public String toString() {
        return "[Cron " + this.name + "]";
    }

    public Cron(CronListener cronListener, String string) {
        this.listener = cronListener;
        this.name = "cron";
        this.queue();
    }

    public Cron(CronListener cronListener) {
        this(cronListener, "cron");
    }

    static {
        waiting = new ArrayList();
        cronThread = new CronThread();
        cronThread.start();
    }

    private static class CronThread
    extends Thread {
        public void run() {
            ArrayList<Cron> arrayList = new ArrayList<Cron>();
            while (true) {
                Cron cron;
                int n;
                arrayList.clear();
                CronThread cronThread = this;
                synchronized (cronThread) {
                    n = 0;
                    while (n < waiting.size()) {
                        cron = (Cron)waiting.get(n);
                        arrayList.add(cron);
                        ++n;
                    }
                    waiting.clear();
                }
                n = 0;
                while (n < arrayList.size()) {
                    block12: {
                        cron = (Cron)arrayList.get(n);
                        if (cron.listener != null) {
                            try {
                                cron.listener.handleCron(cron);
                            }
                            catch (Throwable throwable) {
                                if (!dbg.canWrite()) break block12;
                                dbg.log(throwable);
                            }
                        }
                    }
                    ++n;
                }
                long l = Alarm.getCurrentTime();
                long l2 = 60000L - l % 60000L;
                if (l2 < 1000L || l2 > 60000L) {
                    l2 = 60000L;
                }
                try {
                    Thread.sleep(l2);
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }

        CronThread() {
            super("resin-cron");
            this.setDaemon(true);
        }
    }
}

