/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.AccessLog;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.PageCache;
import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.server.http.ServletServer;
import com.caucho.server.http.UrlMap;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;

class VirtualHost {
    static WriteStream dbg = LogStream.open("/caucho.com/http/host");
    private ServletServer server;
    private String host;
    private RegistryNode registry;
    private Path hostRoot;
    private PageCache cache;
    private UrlMap appMap;
    private HashMap apps;
    private Application defaultApplication;
    private QDate calendar = new QDate();
    private WriteStream errorLog;
    private ArrayList accessLogs;
    private LruCache invocationCache;
    private long bogusDate;

    static VirtualHost create(ServletServer servletServer, String string, RegistryNode registryNode, Path path, Path path2) throws Exception {
        String string2 = registryNode.getString("error-log", null);
        if (string2 == null && registryNode.getParent() != null) {
            string2 = registryNode.getParent().getString("error-log", null);
        }
        Path path3 = null;
        if (string2 != null) {
            path3 = servletServer.getHome().lookupNative(string2);
            path3.getParent().mkdirs();
        }
        try {
            return new VirtualHost(servletServer, string, registryNode, path, path2, path3);
        }
        catch (Exception exception) {
            if (path3 != null) {
                WriteStream writeStream = path3.openAppend();
                writeStream.log(exception);
                writeStream.close();
            }
            throw exception;
        }
    }

    void init() throws IOException {
        Iterator iterator = this.apps.values().iterator();
        while (iterator.hasNext()) {
            Application application = (Application)iterator.next();
            application.init();
        }
    }

    private void initApp(RegistryNode registryNode) throws Exception {
        String string = registryNode.getString("app-dir", null);
        String string2 = registryNode.getString("url-regexp", null);
        String string3 = registryNode.getValue();
        if (string2 == null) {
            string2 = registryNode.getString("regexp", null);
        }
        if (string2 != null) {
            this.appMap.addRegexp(string2, null, null, string, registryNode);
        } else if (string3 != null) {
            String string4 = Invocation.normalizeUri(string3);
            if (string == null) {
                string = "./" + string4;
            }
            if (string4.length() != 0) {
                string4 = string4.charAt(string4.length() - 1) == '/' ? string4 + "*" : string4 + "/*";
            }
            Path path = this.hostRoot.lookupNative(string);
            Application application = new Application(this, string4, registryNode, path, "web-app");
            this.appMap.addMap(string4, null, null, string, registryNode);
            this.apps.put(string4, application);
        } else {
            throw new ServletException(registryNode.getFilename() + ":" + registryNode.getLine() + " illegal web-app");
        }
    }

    ServletServer getServer() {
        return this.server;
    }

    String getName() {
        return this.host;
    }

    RegistryNode getRegistry() {
        return this.registry;
    }

    Iterator getApplications() {
        return this.apps.values().iterator();
    }

    Application getDefaultApplication() {
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            if (this.defaultApplication == null) {
                this.defaultApplication = (Application)this.apps.get("");
            }
            Application application = this.defaultApplication;
            Object var2_3 = null;
            return application;
        }
    }

    void logAccess(Request request, Response response) throws IOException {
        int n = 0;
        while (n < this.accessLogs.size()) {
            AccessLog accessLog = (AccessLog)this.accessLogs.get(n);
            accessLog.log(request, response);
            ++n;
        }
    }

    public void log(String string, Throwable throwable) throws IOException {
        this.log(this.errorLog, string, throwable);
        if (dbg.canWrite()) {
            this.log(dbg, string, throwable);
        }
    }

    private void log(WriteStream writeStream, String string, Throwable throwable) throws IOException {
        if (writeStream == null) {
            return;
        }
        WriteStream writeStream2 = writeStream;
        synchronized (writeStream2) {
            long l = this.bogusDate > 0L ? this.bogusDate : Alarm.getCurrentTime();
            writeStream.print("[");
            this.timestamp(writeStream, l);
            writeStream.print("] ");
            writeStream.println(string);
            if (throwable != null) {
                PrintWriter printWriter = writeStream.getPrintWriter();
                throwable.printStackTrace(printWriter);
                printWriter.flush();
            }
            writeStream.flush();
        }
    }

    private void timestamp(WriteStream writeStream, long l) throws IOException {
        this.calendar.setTime(l);
        writeStream.print(this.calendar.get(0));
        writeStream.print('/');
        long l2 = this.calendar.get(1) + 1L;
        writeStream.print(l2 / 10L);
        writeStream.print(l2 % 10L);
        writeStream.print('/');
        l2 = this.calendar.get(2) + 1L;
        writeStream.print(l2 / 10L);
        writeStream.print(l2 % 10L);
        writeStream.print(' ');
        l2 = this.calendar.get(5);
        writeStream.print(l2 / 10L);
        writeStream.print(l2 % 10L);
        writeStream.print(':');
        l2 = this.calendar.get(6);
        writeStream.print(l2 / 10L);
        writeStream.print(l2 % 10L);
        writeStream.print(':');
        l2 = this.calendar.get(7);
        writeStream.print(l2 / 10L);
        writeStream.print(l2 % 10L);
        l2 = this.calendar.get(8);
    }

    void service(AbstractRequest abstractRequest, Response response) throws IOException, ServletException {
        try {
            if (this.cache == null) {
                abstractRequest.service(this.getInvocation(abstractRequest.getPageUriBuffer()), (CauchoResponse)response);
            } else {
                this.cache.service(abstractRequest, response);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    synchronized Invocation getInvocation(CharBuffer charBuffer) throws Exception {
        Invocation invocation = (Invocation)this.invocationCache.get(charBuffer);
        if (invocation != null && !invocation.application.isModified()) {
            return invocation;
        }
        invocation = this.getInvocationInt(charBuffer.toString());
        this.invocationCache.put(charBuffer.clone(), invocation);
        return invocation;
    }

    Invocation updateInvocation(Invocation invocation) throws Exception {
        Application application = invocation.getApplication();
        if (application.isClosed()) {
            VirtualHost virtualHost = this;
            synchronized (virtualHost) {
                String string = invocation.getUri();
                invocation = this.getInvocationInt(string);
                this.invocationCache.put(new CharBuffer(string), invocation);
            }
            return invocation;
        }
        if (!application.isModified()) {
            return invocation;
        }
        application = this.restartApplication(application);
        VirtualHost virtualHost = this;
        synchronized (virtualHost) {
            String string = invocation.getUri();
            invocation = this.getInvocationInt(string);
            this.invocationCache.put(new CharBuffer(string), invocation);
        }
        return invocation;
    }

    private Invocation getInvocationInt(String string) throws Exception {
        Object object;
        Invocation invocation = new Invocation(this, string);
        String string2 = invocation.getUri();
        Application application = null;
        UrlMap urlMap = this.appMap;
        synchronized (urlMap) {
            CharBuffer charBuffer = new CharBuffer();
            object = new CharBuffer();
            RegistryNode registryNode = (RegistryNode)this.appMap.map(string2, charBuffer, null, (CharBuffer)object);
            if (registryNode == null) {
                throw new RuntimeException("internal app error `" + string2 + "'");
            }
            invocation.contextPath = charBuffer.toString();
            application = (Application)this.apps.get(invocation.contextPath);
            if (application == null) {
                application = new Application(this, invocation.contextPath, registryNode, VirtualHost.getAppDir(this.hostRoot, ((CharBuffer)object).toString()), "web-app");
                this.apps.put(invocation.contextPath, application);
                application.init();
            } else if (application.isModified()) {
                application = this.restartApplication(application);
                this.apps.put(invocation.contextPath, application);
            }
        }
        int n = invocation.contextPath.length();
        invocation.application = application;
        object = null;
        int n2 = -1;
        if (application.enableSessionUrls()) {
            n2 = string2.lastIndexOf(59);
        }
        if (n2 >= 0 && ((String)(object = string2.substring(n2))).startsWith(";jsessionid=")) {
            invocation.sessionId = string2.substring(n2 + ";jsessionid=".length());
        }
        Object var11_11 = null;
        if (n >= 0 && n2 >= 0) {
            invocation.pathInfo = string2.substring(n, n2);
            invocation.uri = string2.substring(0, n2);
        } else if (n >= 0) {
            invocation.pathInfo = string2.substring(n);
        } else if (n2 >= 0) {
            invocation.uri = string2.substring(0, n2);
            invocation.pathInfo = string2;
        } else {
            invocation.pathInfo = string2;
        }
        invocation.security = application.getSecurity(invocation.pathInfo);
        application.getServlet(invocation);
        return invocation;
    }

    static Path getAppDir(Path path, String string) {
        if (string.endsWith(".war") || string.endsWith(".jar")) {
            return new JarPath(path.lookupNative(string));
        }
        return path.lookupNative(string);
    }

    private Application restartApplication(Application application) {
        String string = application.getContextPath();
        String string2 = application.getCreateMode();
        RegistryNode registryNode = application.getRegistry();
        Path path = application.getAppDir();
        if (this.cache != null) {
            this.cache.clear();
        }
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            block7: {
                if (this.defaultApplication == application) {
                    this.defaultApplication = null;
                }
                this.apps.remove(string);
                application.close();
                try {
                    application = new Application(this, string, registryNode, path, string2);
                    this.apps.put(string, application);
                    application.init();
                }
                catch (Exception exception) {
                    if (!dbg.canWrite()) break block7;
                    dbg.log(exception);
                }
            }
        }
        return application;
    }

    void timeout(long l) {
        Object object;
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            Iterator iterator = this.apps.values().iterator();
            while (iterator.hasNext()) {
                object = (Application)iterator.next();
                ((Application)object).timeout(l);
            }
        }
        int n = 0;
        while (n < this.accessLogs.size()) {
            object = (AccessLog)this.accessLogs.get(n);
            try {
                ((AccessLog)object).flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
    }

    void cron(long l) {
        Application application;
        ArrayList<Application> arrayList = new ArrayList<Application>();
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            Iterator iterator = this.apps.values().iterator();
            while (iterator.hasNext()) {
                application = (Application)iterator.next();
                arrayList.add(application);
            }
        }
        int n = 0;
        while (n < arrayList.size()) {
            application = (Application)arrayList.get(n);
            application.cron(l);
            ++n;
        }
    }

    void close() {
        Object object;
        int n = 0;
        while (n < this.accessLogs.size()) {
            object = (AccessLog)this.accessLogs.get(n);
            try {
                ((AccessLog)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
        Iterator iterator = this.apps.values().iterator();
        while (iterator.hasNext()) {
            object = (Application)iterator.next();
            ((Application)object).close();
        }
    }

    public String toString() {
        return "[VirtualHost " + this.host + "]";
    }

    void setDate(long l) {
        this.bogusDate = l;
    }

    private VirtualHost(ServletServer servletServer, String string, RegistryNode registryNode, Path path, Path path2, Path path3) throws Exception {
        Object object;
        int n;
        if (dbg.canWrite()) {
            dbg.println("virtual-host: " + string + " " + path);
        }
        if (path3 != null) {
            this.errorLog = path3.openAppend();
        }
        this.server = servletServer;
        this.hostRoot = path;
        if (path2 != null) {
            path2.mkdirs();
            this.cache = new PageCache(this, path2);
        }
        this.registry = registryNode;
        this.bogusDate = registryNode.getInt("bogus-date", 0);
        if (string == null || string.equals("*")) {
            string = "";
        }
        if ((n = string.indexOf(58)) > 0) {
            string = string.substring(0, n);
        }
        this.host = string;
        this.invocationCache = new LruCache(1024);
        this.appMap = new UrlMap();
        this.apps = new HashMap();
        this.accessLogs = new ArrayList();
        boolean bl = false;
        Iterator iterator = registryNode.iterator();
        while (iterator.hasNext()) {
            object = (RegistryNode)iterator.next();
            if (((RegistryNode)object).getName().equals("web-app")) {
                this.initApp((RegistryNode)object);
                if (!"".equals(((RegistryNode)object).getValue()) && !"/".equals(((RegistryNode)object).getValue()) && !"/*".equals(((RegistryNode)object).getValue())) continue;
                bl = true;
                continue;
            }
            if (!((RegistryNode)object).getName().equals("access-log")) continue;
            String string2 = ((RegistryNode)object).getValue();
            String string3 = ((RegistryNode)object).getString("format", null);
            this.accessLogs.add(new AccessLog(servletServer.getHome().lookupNative(string2), string3));
        }
        if (!bl) {
            object = new Application(this, "", registryNode, path, "host");
            this.appMap.addMap("", null, null, ".", registryNode);
            this.apps.put("", object);
        }
    }
}

