/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Response;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InterruptedIOException;

class ResponseStream
extends StreamImpl {
    Response response;
    WriteStream next;
    WriteStream cache;
    boolean chunkedEncoding;
    TempBuffer head;
    TempBuffer tail;
    int chunkLength;
    int bufferSize;
    int contentLength;
    boolean allowFlush = true;
    boolean isClosed = false;
    boolean isHead = false;
    private byte[] buffer = new byte[16];

    void init(Response response, WriteStream writeStream) {
        this.response = response;
        this.next = writeStream;
        if (writeStream == null) {
            throw new NullPointerException("missing next");
        }
    }

    void start() {
        this.chunkedEncoding = false;
        this.response.headersWritten = false;
        this.chunkLength = 0;
        this.bufferSize = 8192;
        if (this.head != null) {
            this.head.clear();
        }
        this.tail = this.head;
        this.contentLength = 0;
        this.allowFlush = true;
        this.isClosed = false;
        this.isHead = false;
        this.cache = null;
    }

    TempBuffer startChaining() {
        TempBuffer tempBuffer = this.head;
        this.head = null;
        this.start();
        return tempBuffer;
    }

    void setCache(WriteStream writeStream) {
        this.cache = writeStream;
    }

    public boolean canWrite() {
        return true;
    }

    void setFlush(boolean bl) {
        this.allowFlush = bl;
    }

    void setHead() {
        this.isHead = true;
        this.bufferSize = 0;
    }

    int getContentLength() {
        return this.contentLength;
    }

    int getBufferSize() {
        return this.bufferSize;
    }

    void setBufferSize(int n) {
        int n2 = TempBuffer.SIZE;
        this.bufferSize = n2 * ((n + n2 - 1) / n2);
        if (this.bufferSize <= 0) {
            this.bufferSize = 0;
        }
    }

    boolean isCommitted() {
        return this.response.headersWritten || this.isClosed;
    }

    void clear() {
        if (this.head != null) {
            TempBuffer.freeAll(this.head.getNext());
            this.head.clear();
        }
        this.tail = this.head;
        this.allowFlush = true;
        if (this.response.headersWritten) {
            throw new IllegalStateException("can't clear response after writing headers");
        }
        this.chunkLength = 0;
        this.contentLength = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void write(byte[] var1_1, int var2_2, int var3_3, boolean var4_4) throws IOException {
        if (this.isHead || this.isClosed) {
            return;
        }
        if (this.bufferSize == 0) {
            this.writeHeaders(-1);
            this.writeChunk(var1_1, var2_2, var3_3);
            return;
        }
        if (this.chunkLength != 0 || !this.allowFlush || var3_3 < this.bufferSize - TempBuffer.SIZE && !var4_4) ** GOTO lbl26
        this.writeHeaders(-1);
        if (!this.allowFlush) ** GOTO lbl26
        this.writeChunk(var1_1, var2_2, var3_3);
        return;
lbl-1000:
        // 1 sources

        {
            if (this.head == null) {
                this.head = this.tail = TempBuffer.allocate();
            } else if (this.tail.getLength() >= TempBuffer.SIZE) {
                if (this.allowFlush && this.chunkLength + var3_3 > this.bufferSize - TempBuffer.SIZE) {
                    this.flushBuffer(false);
                } else {
                    var5_6 = TempBuffer.allocate();
                    this.tail.setNext(var5_6);
                    this.tail = var5_6;
                }
            }
            var5_5 = this.tail.write(var1_1, var2_2, var3_3);
            var2_2 += var5_5;
            var3_3 -= var5_5;
            this.chunkLength += var5_5;
lbl26:
            // 3 sources

            ** while (var3_3 > 0 && !this.isClosed)
        }
lbl27:
        // 1 sources

    }

    void finish(boolean bl, boolean bl2) throws IOException {
        if (this.next == null || this.isClosed) {
            return;
        }
        this.allowFlush = true;
        this.flushBuffer(true);
        this.isClosed = true;
        if (this.chunkedEncoding) {
            this.next.write(13);
            this.next.write(10);
            this.next.write(48);
            this.next.write(13);
            this.next.write(10);
            this.next.write(13);
            this.next.write(10);
        }
        if (bl) {
            this.next.close();
            this.next = null;
        } else if (bl2) {
            this.next.flush();
        }
    }

    /*
     * Unable to fully structure code
     */
    void flushBuffer(boolean var1_1) throws IOException {
        if (this.isClosed) {
            return;
        }
        this.writeHeaders(var1_1 != false ? this.chunkLength : -1);
        if (this.allowFlush) ** GOTO lbl11
        return;
lbl-1000:
        // 1 sources

        {
            this.writeChunk(this.head.getBuffer(), 0, this.head.getLength());
            var2_2 = this.head.getNext();
            if (var2_2 == null) break;
            TempBuffer.free(this.head);
            this.head = var2_2;
lbl11:
            // 2 sources

            ** while (this.head != null)
        }
lbl12:
        // 2 sources

        this.tail = this.head;
        if (this.head != null) {
            this.head.clear();
        }
        this.chunkLength = 0;
    }

    private void writeHeaders(int n) throws IOException {
        if (this.response.headersWritten || this.isClosed) {
            return;
        }
        this.response.headersWritten = true;
        this.chunkedEncoding = this.response.writeHeaders(this.next, n);
    }

    private void writeChunk(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        boolean bl = this.contentLength == 0;
        this.contentLength += n2;
        if (this.cache != null) {
            this.cache.write(byArray, n, n2);
        }
        if (this.next == null) {
            return;
        }
        if (this.isHead) {
            return;
        }
        Thread.currentThread();
        if (Thread.interrupted()) {
            throw new InterruptedIOException("interrupt during write");
        }
        this.response.getRequest().resetTimeout();
        if (!this.chunkedEncoding) {
            this.next.write(byArray, n, n2);
            return;
        }
        int n3 = this.buffer.length;
        int n4 = n2;
        this.buffer[--n3] = 10;
        this.buffer[--n3] = 13;
        while (n4 > 0) {
            int n5 = n4 & 0xF;
            this.buffer[--n3] = n5 <= 9 ? (byte)(48 + n5) : (byte)(97 + n5 - 10);
            n4 >>= 4;
        }
        if (!bl) {
            this.buffer[--n3] = 10;
            this.buffer[--n3] = 13;
        }
        this.next.write(this.buffer, n3, this.buffer.length - n3);
        this.next.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        if (this.allowFlush && !this.isClosed) {
            this.flushBuffer(false);
            this.next.flush();
        }
    }

    public void close() throws IOException {
    }

    ResponseStream() {
    }
}

