/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.QServletOutputStream;
import com.caucho.server.http.RequestAdapter;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

class ResponseAdapter
implements CauchoResponse {
    protected RequestAdapter request;
    protected HttpServletResponse response;
    protected WriteStream stream;
    private QServletOutputStream os;
    private boolean hasWriter;
    private boolean hasOutputStream;

    void setRequest(RequestAdapter requestAdapter) {
        this.request = requestAdapter;
    }

    public void init(HttpServletResponse httpServletResponse) {
        this.response = httpServletResponse;
        this.stream = null;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.flush();
        }
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public WriteStream getStream() throws IOException {
        if (this.stream != null) {
            return this.stream;
        }
        this.stream = this.response instanceof CauchoResponse ? ((CauchoResponse)this.response).getStream() : Vfs.openWrite(this.response.getWriter());
        return this.stream;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.stream == null) {
            this.stream = Vfs.openWrite((OutputStream)this.response.getOutputStream());
        }
        this.os.init(this.getStream());
        return this.os;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.stream == null && this.response instanceof CauchoResponse) {
            this.stream = Vfs.openWrite((OutputStream)this.response.getOutputStream());
        } else if (this.stream == null) {
            this.stream = Vfs.openWrite(this.response.getWriter());
        }
        return this.stream.getPrintWriter();
    }

    public void setStream(WriteStream writeStream) {
        this.stream = writeStream;
    }

    public void setContentLength(int n) {
        this.response.setContentLength(n);
    }

    public String encodeRedirectURL(String string) {
        return this.response.encodeRedirectURL(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.response.encodeRedirectURL(string);
    }

    public String encodeURL(String string) {
        return this.response.encodeURL(string);
    }

    public String encodeUrl(String string) {
        return this.response.encodeUrl(string);
    }

    public void sendRedirect(String string) throws IOException {
        this.response.sendRedirect(string);
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public void setContentType(String string) {
        this.response.setContentType(string);
    }

    public boolean containsHeader(String string) {
        return this.response.containsHeader(string);
    }

    public void setHeader(String string, String string2) {
        this.response.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) {
        this.response.setHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        this.response.setIntHeader(string, n);
    }

    public void addIntHeader(String string, int n) {
        this.response.setIntHeader(string, n);
    }

    public void setStatus(int n) {
        this.response.setStatus(n);
    }

    public void setStatus(int n, String string) {
        this.response.setStatus(n, string);
    }

    public void sendError(int n, String string) throws IOException {
        this.response.sendError(n, string);
    }

    public void sendError(int n) throws IOException {
        this.response.sendError(n);
    }

    public void setDateHeader(String string, long l) {
        this.response.setDateHeader(string, l);
    }

    public void addDateHeader(String string, long l) {
        this.response.setDateHeader(string, l);
    }

    public void addCookie(Cookie cookie) {
        if (this.request != null) {
            this.request.setUsesCookies();
        }
        this.response.addCookie(cookie);
    }

    public void setBufferSize(int n) {
        try {
            this.response.setBufferSize(n);
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public int getBufferSize() {
        try {
            return this.response.getBufferSize();
        }
        catch (Error error) {
            return 0;
        }
    }

    public void flushBuffer() throws IOException {
        try {
            this.response.flushBuffer();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Error error) {
            this.stream.flush();
        }
    }

    public boolean isCommitted() {
        try {
            return this.response.isCommitted();
        }
        catch (Error error) {
            return true;
        }
    }

    public void reset() {
        block3: {
            try {
                this.response.reset();
            }
            catch (IllegalStateException illegalStateException) {
                throw illegalStateException;
            }
            catch (Error error) {
                if (this.stream == null) break block3;
                this.stream.clearWrite();
            }
        }
    }

    public void setLocale(Locale locale) {
    }

    public Locale getLocale() {
        return null;
    }

    public String getFilter() {
        return null;
    }

    public String getHeader(String string) {
        return null;
    }

    public StreamImpl startChaining() {
        return null;
    }

    public boolean disableHeaders(boolean bl) {
        return false;
    }

    protected ResponseAdapter() {
        this.os = new QServletOutputStream();
    }

    protected ResponseAdapter(HttpServletResponse httpServletResponse) {
        this.response = httpServletResponse;
        this.os = new QServletOutputStream();
    }
}

