/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.Connection;
import com.caucho.server.StreamConnection;
import com.caucho.server.http.Application;
import com.caucho.server.http.QServletConfig;
import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.server.http.RunnerRequest;
import com.caucho.server.http.RunnerServer;
import com.caucho.server.http.ServletServer;
import com.caucho.util.CharBuffer;
import com.caucho.util.QDate;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import com.caucho.vfs.PipeStream;
import com.caucho.vfs.Pwd;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteServlet
extends GenericServlet {
    Path context;
    RegistryNode registry;
    RunnerServer subHttp;
    protected QDate calendar = new QDate();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig instanceof QServletConfig ? ((QServletConfig)servletConfig).getPath() : Pwd.lookup();
        String string = servletConfig.getInitParameter("registry.path");
        if (string != null) {
            try {
                this.registry = Registry.parse(this.context.lookup(string));
            }
            catch (IOException iOException) {
                throw new ServletException((Throwable)iOException);
            }
        }
        RegistryNode registryNode = this.registry.lookup("/caucho.com/http-server");
        Application application = (Application)this.getServletContext();
        ServletServer servletServer = application.getVirtualHost().getServer();
        try {
            this.subHttp = new RunnerServer(null, registryNode, servletServer.pwd);
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        if (servletServer.bogusDate > 0L) {
            this.subHttp.setDate(servletServer.bogusDate);
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        RunnerRequest runnerRequest = null;
        ((Response)servletResponse).headersWritten = true;
        runnerRequest = new RunnerRequest(this.subHttp);
        RemoteServlet remoteServlet = this;
        if (remoteServlet == null) {
            throw null;
        }
        TestServlet testServlet = remoteServlet.new TestServlet();
        Object[] objectArray = PipeStream.create();
        ReadStream readStream = (ReadStream)objectArray[0];
        WriteStream writeStream = (WriteStream)objectArray[1];
        objectArray = PipeStream.create();
        ReadStream readStream2 = (ReadStream)objectArray[0];
        WriteStream writeStream2 = (WriteStream)objectArray[1];
        StreamConnection streamConnection = new StreamConnection(readStream, writeStream2);
        readStream.setSibling(writeStream2);
        readStream2.setSibling(writeStream);
        try {
            testServlet.start(this.registry, runnerRequest, streamConnection);
            this.handleRequest((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, readStream2, writeStream);
        }
        finally {
            Object var12_11 = null;
            try {
                readStream2.close();
                writeStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReadStream readStream, WriteStream writeStream) throws ServletException, IOException {
        int n;
        int n2;
        Object object;
        Object object2;
        this.writeRequestString(writeStream, 102, httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort());
        this.writeRequestString(writeStream, 103, String.valueOf(httpServletRequest.getServerPort()));
        this.writeRequestString(writeStream, 104, httpServletRequest.getRemoteHost());
        this.writeRequestString(writeStream, 105, httpServletRequest.getRemoteAddr());
        this.writeRequestString(writeStream, 100, httpServletRequest.getMethod());
        this.writeRequestString(writeStream, 111, httpServletRequest.getRequestURI());
        this.writeRequestString(writeStream, 101, httpServletRequest.getQueryString());
        this.writeRequestString(writeStream, 99, httpServletRequest.getProtocol());
        this.writeRequestString(writeStream, 115, "0");
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = httpServletRequest.getHeader((String)object2);
            this.writeRequestString(writeStream, 72, (String)object2);
            this.writeRequestString(writeStream, 86, (String)object);
        }
        object2 = httpServletRequest.getInputStream();
        object = TempBuffer.allocate();
        byte[] byArray = ((TempBuffer)object).getBuffer();
        int n3 = 0;
        boolean bl = true;
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        PrintWriter printWriter = httpServletResponse.getWriter();
        CharBuffer charBuffer = new CharBuffer();
        CharBuffer charBuffer2 = new CharBuffer();
        boolean bl2 = !httpServletRequest.getProtocol().equals("HTTP/0.9");
        while ((n3 = ((InputStream)object2).read(byArray, 0, byArray.length)) > 0) {
            block16: {
                if (!bl) {
                    while (true) {
                        n2 = readStream.read();
                        n = (readStream.read() << 16) + (readStream.read() << 8) + readStream.read();
                        if (n2 == 65) {
                            if (n > 0) {
                                readStream.skip(n);
                            }
                            break block16;
                        }
                        if (n2 == 83 && bl2) {
                            readStream.writeToStream((OutputStream)servletOutputStream, n);
                            printWriter.print("\r\nServer: Resin/1.1\r\n");
                            continue;
                        }
                        if (n2 == 71) {
                            if (!bl2) continue;
                            this.calendar.calculate(((Request)httpServletRequest).getDate(), false);
                            printWriter.print("Date: ");
                            printWriter.print(this.calendar.toString());
                            printWriter.print("\r\n\r\n");
                            continue;
                        }
                        if (n2 == 72 && bl2) {
                            charBuffer.clear();
                            readStream.readAll(charBuffer, n);
                            n2 = readStream.read();
                            n = (readStream.read() << 16) + (readStream.read() << 8) + readStream.read();
                            charBuffer2.clear();
                            readStream.readAll(charBuffer2, n);
                            printWriter.print(charBuffer + ": " + charBuffer2 + "\r\n");
                            continue;
                        }
                        if (n2 == 68) {
                            readStream.writeToStream((OutputStream)servletOutputStream, n);
                            continue;
                        }
                        if (n2 == 90 || n2 == 88 || n2 == -1) break;
                    }
                    TempBuffer.free((TempBuffer)object);
                    return;
                }
            }
            this.writeRequestData(writeStream, 68, byArray, n3);
            bl = false;
        }
        TempBuffer.free((TempBuffer)object);
        this.writeRequestData(writeStream, 90);
        while (true) {
            n2 = readStream.read();
            n = (readStream.read() << 16) + (readStream.read() << 8) + readStream.read();
            if (n2 == 68) {
                readStream.writeToStream((OutputStream)servletOutputStream, n);
                continue;
            }
            if (n2 == 83 && bl2) {
                readStream.writeToStream((OutputStream)servletOutputStream, n);
                printWriter.print("\r\nServer: Resin/1.1\r\n");
                continue;
            }
            if (n2 == 71) {
                if (!bl2) continue;
                this.calendar.calculate(((Request)httpServletRequest).getDate(), false);
                printWriter.print("Date: ");
                printWriter.print(this.calendar.toString());
                printWriter.print("\r\n\r\n");
                continue;
            }
            if (n2 == 72 && bl2) {
                charBuffer.clear();
                readStream.readAll(charBuffer, n);
                n2 = readStream.read();
                n = (readStream.read() << 16) + (readStream.read() << 8) + readStream.read();
                charBuffer2.clear();
                readStream.readAll(charBuffer2, n);
                printWriter.print(charBuffer + ": " + charBuffer2 + "\r\n");
                continue;
            }
            if (n2 == 90 || n2 == 88 || n2 < 0) {
                return;
            }
            readStream.skip(n);
        }
    }

    private void writeRequestString(WriteStream writeStream, int n, String string) throws IOException {
        if (string == null) {
            string = "";
        }
        int n2 = string.length();
        writeStream.write(n);
        writeStream.write(n2 >> 16);
        writeStream.write(n2 >> 8);
        writeStream.write(n2);
        writeStream.print(string);
    }

    private void writeRequestData(WriteStream writeStream, int n) throws IOException {
        writeStream.write(n);
        writeStream.write(0);
        writeStream.write(0);
        writeStream.write(0);
    }

    private void writeRequestData(WriteStream writeStream, int n, byte[] byArray, int n2) throws IOException {
        writeStream.write(n);
        writeStream.write(n2 >> 16);
        writeStream.write(n2 >> 8);
        writeStream.write(n2);
        writeStream.write(byArray, 0, n2);
    }

    class TestServlet
    implements Runnable {
        RunnerRequest conn;
        Connection rconn;
        RegistryNode registry;
        Thread thread;

        /*
         * Loose catch block
         */
        public void run() {
            block15: {
                if (this.registry != null) {
                    Registry.setRegistry(this.registry);
                }
                this.conn.handleConnection(this.rconn);
                Object var2_1 = null;
                try {
                    this.rconn.getReadStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.rconn.getWriteStream().close();
                }
                catch (Exception exception) {}
                break block15;
                {
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var2_2 = null;
                        try {
                            this.rconn.getReadStream().close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        try {
                            this.rconn.getWriteStream().close();
                        }
                        catch (Exception exception2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    try {
                        this.rconn.getReadStream().close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.rconn.getWriteStream().close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        public void start(RegistryNode registryNode, RunnerRequest runnerRequest, Connection connection) {
            this.registry = registryNode;
            this.conn = runnerRequest;
            this.rconn = connection;
            this.thread = new Thread(this);
            this.thread.start();
        }

        void stop() {
            this.thread.interrupt();
        }

        TestServlet() {
        }
    }
}

