/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.Connection;
import com.caucho.server.http.Application;
import com.caucho.server.http.BadRequestException;
import com.caucho.server.http.BrowserConfig;
import com.caucho.server.http.HttpResponse;
import com.caucho.server.http.Request;
import com.caucho.server.http.ServletServer;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

class HttpRequest
extends Request {
    static WriteStream dbg = LogStream.open("/caucho.com/http/connection");
    private CharBuffer method;
    private CharBuffer scheme;
    private CharBuffer host;
    private CharBuffer uri;
    private CharBuffer queryString;
    private CharBuffer protocol;
    private CharBuffer[] headerKeys;
    private CharBuffer[] headerValues;
    private int headerSize;
    private int headerCapacity;
    private CharBuffer cb;
    private char[] charBuf;
    private String cacheQuery;

    public void handleConnection(Connection connection) throws IOException {
        this.setConnection(connection);
        ReadStream readStream = connection.getReadStream();
        readStream.setDisableClose(true);
        this.rawStream = readStream;
        WriteStream writeStream = connection.getWriteStream();
        writeStream.setDisableClose(true);
        this.response.init(writeStream);
        if (!this.handleRequest(true)) {
            return;
        }
        while (!connection.isInterrupted() && this.handleRequest(false)) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleRequest(boolean bl) throws IOException {
        block16: {
            boolean bl2;
            block15: {
                try {
                    try {
                        CharBuffer charBuffer;
                        this.start(this.rawStream);
                        if (!bl) {
                            this.conn.setIdle();
                        }
                        if (!this.readRequest(this.rawStream)) {
                            bl2 = false;
                            Object var3_5 = null;
                            break block15;
                        }
                        if (dbg.canWrite()) {
                            dbg.log("[" + this.conn.getId() + "] " + this.method + " " + this.uri + "?" + this.queryString + " " + this.protocol);
                        }
                        this.parseHeaders(this.rawStream);
                        if (this.getVersion() >= 257) {
                            charBuffer = this.getHeaderBuffer("User-Agent");
                            BrowserConfig browserConfig = null;
                            Application application = this.getApplication();
                            if (charBuffer != null && application != null) {
                                browserConfig = application.getBrowser(charBuffer);
                            }
                            if (browserConfig != null && browserConfig.isForce10()) {
                                this.protocol.clear();
                                this.protocol.append("HTTP/1.0");
                                this.version = 256;
                            }
                        }
                        if ((charBuffer = this.getHost()) == null && this.getVersion() >= 257) {
                            this.response.closeConnection();
                            this.response.sendError(400, "HTTP/1.1 requires host");
                            break block16;
                        } else {
                            this.dispatch(charBuffer, this.uri);
                        }
                        break block16;
                    }
                    catch (BadRequestException badRequestException) {
                        if (dbg.canWrite()) {
                            dbg.log(badRequestException);
                        }
                        this.response.sendError(400);
                        boolean bl3 = false;
                        Object var3_7 = null;
                        this.finish();
                        return bl3;
                    }
                    catch (SocketException socketException) {
                        boolean bl4 = false;
                        Object var3_8 = null;
                        this.finish();
                        return bl4;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_9 = null;
                    this.finish();
                    throw throwable;
                }
            }
            this.finish();
            return bl2;
        }
        Object var3_6 = null;
        this.finish();
        if (dbg.canWrite()) {
            dbg.log("[" + this.conn.getId() + "] " + (this.response.allowKeepalive() ? "keepalive" : "done"));
        }
        return this.response.allowKeepalive();
    }

    protected void start(ReadStream readStream) throws IOException {
        super.start(readStream);
        this.method.clear();
        this.protocol.clear();
        this.uri.clear();
        this.queryString.clear();
        this.cacheQuery = null;
        this.host.clear();
        this.headerSize = 0;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readRequest(ReadStream var1_1) throws IOException {
        var2_2 = false;
        var3_3 = 0;
        var4_4 = false;
        var3_3 = var1_1.read();
        this.conn.setActive();
        this.conn.setAccessTime(this.getDate());
        while (var3_3 >= 0 && this.isWhitespace(var3_3)) {
            var3_3 = var1_1.read();
        }
        while (var3_3 >= 0 && var3_3 != 32 && var3_3 != 9) {
            if (var3_3 >= 97 && var3_3 <= 122) {
                this.method.append((char)(var3_3 + 65 - 97));
            } else {
                this.method.append((char)var3_3);
            }
            var3_3 = var1_1.read();
        }
        if (var3_3 >= 0 && this.method.length() != 0) ** GOTO lbl22
        return false;
lbl-1000:
        // 1 sources

        {
            var3_3 = var1_1.read();
lbl22:
            // 2 sources

            ** while (var3_3 == 32 || var3_3 == 9)
        }
lbl23:
        // 1 sources

        var3_3 = this.readUri(var1_1, var3_3);
        while (var3_3 == 32 || var3_3 == 9) {
            var3_3 = var1_1.read();
        }
        while (var3_3 >= 0 && !this.isWhitespace(var3_3)) {
            if (var3_3 >= 97 && var3_3 <= 122) {
                this.protocol.append((char)(var3_3 + 65 - 97));
            } else {
                this.protocol.append((char)var3_3);
            }
            var3_3 = var1_1.read();
        }
        if (this.protocol.length() == 0) {
            this.protocol.append("HTTP/0.9");
        }
        while (var3_3 >= 0 && var3_3 != 10 && var3_3 != 13) {
            var3_3 = var1_1.read();
        }
        if (var3_3 == 13 && (var3_3 = var1_1.read()) != 10) {
            throw new BadRequestException("cr must have lf");
        }
        return true;
    }

    private int readUri(ReadStream readStream, int n) throws IOException {
        while (n != 47) {
            switch (n) {
                case -1: {
                    throw new EOFException();
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.response.closeConnection();
                    throw new BadRequestException("bad url");
                }
                case 37: {
                    this.uri.append(this.readUrlEscape(readStream));
                    break;
                }
            }
            n = readStream.read();
        }
        int n2 = readStream.read();
        if (n2 == 47) {
            n = this.readHost(readStream);
        } else {
            this.uri.append((char)n);
            n = n2;
        }
        while (true) {
            switch (n) {
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    return n;
                }
                case 63: {
                    return this.readQuery(readStream);
                }
            }
            this.uri.append((char)n);
            n = readStream.read();
        }
    }

    private int readHost(ReadStream readStream) throws IOException {
        int n;
        while ((n = readStream.read()) >= 0) {
            switch (n) {
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    throw new BadRequestException("bad url");
                }
                case 58: {
                    return this.readPort(readStream);
                }
                case 47: {
                    return n;
                }
                case 37: {
                    n = this.readUrlEscape(readStream);
                    if (n >= 65 && n <= 90) {
                        this.host.append((char)(n + 97 - 65));
                        break;
                    }
                    this.host.append((char)n);
                    break;
                }
                default: {
                    if (n >= 65 && n <= 90) {
                        this.host.append((char)(n + 97 - 65));
                        break;
                    }
                    this.host.append((char)n);
                    break;
                }
            }
        }
        return n;
    }

    private int readPort(ReadStream readStream) throws IOException {
        int n;
        this.host.append(':');
        while ((n = readStream.read()) >= 0) {
            switch (n) {
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    throw new BadRequestException("bad url");
                }
                case 47: {
                    return n;
                }
            }
            if (n >= 48 && n <= 57) {
                this.host.append((char)n);
                continue;
            }
            throw new BadRequestException("bad url");
        }
        return n;
    }

    private int readQuery(ReadStream readStream) throws IOException {
        int n;
        while ((n = readStream.read()) >= 0) {
            switch (n) {
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    return n;
                }
            }
            this.queryString.append((char)n);
        }
        return n;
    }

    private char readUrlEscape(ReadStream readStream) throws IOException {
        int n = readStream.read();
        if (n == 117) {
            int n2 = this.toHex(n);
            int n3 = this.toHex(readStream.read());
            int n4 = this.toHex(readStream.read());
            int n5 = this.toHex(readStream.read());
            if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
                throw new BadRequestException("bad uri");
            }
            return (char)((n2 << 12) + (n3 << 8) + (n4 << 4) + n5);
        }
        int n6 = this.toHex(n);
        int n7 = this.toHex(readStream.read());
        if (n6 < 0 || n7 < 0) {
            throw new BadRequestException("bad uri");
        }
        return (char)((n6 << 4) + n7);
    }

    private int toHex(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 97 && n <= 102) {
            return n - 97 + 10;
        }
        if (n >= 65 && n <= 70) {
            return n - 65 + 10;
        }
        return -1;
    }

    private void parseHeaders(ReadStream readStream) throws IOException {
        int n = this.getVersion();
        if (n < 257) {
            this.response.closeConnection();
        }
        if (n >= 256) {
            while (true) {
                CharBuffer charBuffer = this.headerKeys[this.headerSize];
                charBuffer.clear();
                readStream.readLine(charBuffer);
                if (charBuffer.length() == 0) {
                    return;
                }
                char[] cArray = charBuffer.getBuffer();
                int n2 = charBuffer.getLength();
                int n3 = 0;
                int n4 = 0;
                n3 = 0;
                while (n3 < n2) {
                    n4 = cArray[n3];
                    if (n4 == 32 || n4 == 58) break;
                    ++n3;
                }
                int n5 = n3;
                while (n5 < n2) {
                    n4 = cArray[n5];
                    if (n4 != 32 && n4 != 58) break;
                    ++n5;
                }
                CharBuffer charBuffer2 = this.headerValues[this.headerSize];
                char[] cArray2 = charBuffer2.getBuffer();
                int n6 = 0;
                int n7 = charBuffer2.getCapacity();
                int n8 = 0;
                int n9 = n5;
                while (n9 < n2) {
                    n4 = cArray[n9];
                    if (n4 == 9) {
                        n4 = 32;
                    } else if (n4 != 32) {
                        n8 = n6 + 1;
                    }
                    if (n6 >= n7) {
                        charBuffer2.setLength(n6 + 1);
                        n7 = charBuffer2.getCapacity();
                        cArray2 = charBuffer2.getBuffer();
                    }
                    cArray2[n6++] = n4;
                    ++n9;
                }
                charBuffer.setLength(n3);
                charBuffer2.setLength(n8);
                ++this.headerSize;
                if (!dbg.canWrite()) continue;
                dbg.println(charBuffer + ": " + charBuffer2);
            }
        }
    }

    private void resizeHeaders() {
        int n = this.headerCapacity * 2;
        CharBuffer[] charBufferArray = new CharBuffer[n];
        CharBuffer[] charBufferArray2 = new CharBuffer[n];
        int n2 = 0;
        while (n2 < this.headerCapacity) {
            charBufferArray[n2] = this.headerKeys[n2];
            charBufferArray2[n2] = this.headerValues[n2];
            ++n2;
        }
        n2 = this.headerCapacity;
        while (n2 < n) {
            charBufferArray[n2] = new CharBuffer();
            charBufferArray2[n2] = new CharBuffer();
            ++n2;
        }
        this.headerKeys = charBufferArray;
        this.headerValues = charBufferArray2;
        this.headerCapacity = n;
    }

    private boolean isWhitespace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13;
    }

    public String getScheme() {
        return this.scheme.toString();
    }

    public CharBuffer getMethodBuffer() {
        return this.method;
    }

    CharBuffer getHost() {
        if (this.host.length() != 0) {
            return this.host;
        }
        CharBuffer charBuffer = this.getHeaderBuffer("host");
        if (charBuffer == null) {
            return null;
        }
        this.cb.clear();
        this.cb.append(charBuffer);
        this.cb.toLowerCase();
        return this.cb;
    }

    public CharBuffer getPageUriBuffer() {
        return this.uri;
    }

    public CharBuffer getPageQueryBuffer() {
        return this.queryString;
    }

    public String getQueryString() {
        if (this.queryString.length() == 0) {
            return null;
        }
        return this.queryString.toString();
    }

    public CharBuffer getProtocolBuffer() {
        return this.protocol;
    }

    public void setHeader(String string, String string2) {
        this.headerKeys[this.headerSize].clear();
        this.headerKeys[this.headerSize].append(string);
        this.headerValues[this.headerSize].clear();
        this.headerValues[this.headerSize].append(string2);
        ++this.headerSize;
    }

    public CharBuffer getHeaderBuffer(String string) {
        this.cb.clear();
        this.cb.append(string);
        int n = this.headerSize;
        int n2 = 0;
        while (n2 < n) {
            CharBuffer charBuffer = this.headerKeys[n2];
            if (charBuffer.equalsIgnoreCase(this.cb)) {
                return this.headerValues[n2];
            }
            ++n2;
        }
        return null;
    }

    public void getHeaderBuffers(ArrayList arrayList, String string) {
        this.cb.clear();
        this.cb.append(string);
        int n = this.headerSize;
        int n2 = 0;
        while (n2 < n) {
            CharBuffer charBuffer = this.headerKeys[n2];
            if (charBuffer.equalsIgnoreCase(this.cb)) {
                arrayList.add(this.headerValues[n2]);
            }
            ++n2;
        }
    }

    public Enumeration getHeaders(String string) {
        this.cb.clear();
        this.cb.append(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.headerSize;
        int n2 = 0;
        while (n2 < n) {
            CharBuffer charBuffer = this.headerKeys[n2];
            if (charBuffer.equalsIgnoreCase(this.cb)) {
                CharBuffer charBuffer2 = this.headerValues[n2];
                String string2 = charBuffer2.toString();
                arrayList.add(string2);
            }
            ++n2;
        }
        return Collections.enumeration(arrayList);
    }

    public Enumeration getHeaderNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.headerSize) {
            String string = this.headerKeys[n].toString();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                String string2 = (String)arrayList.get(n2);
                if (string.equals(string2)) break;
                ++n2;
            }
            if (n2 == arrayList.size()) {
                arrayList.add(n2, string);
            }
            ++n;
        }
        return Collections.enumeration(arrayList);
    }

    public String getServerName() {
        CharBuffer charBuffer = this.getHost();
        if (charBuffer == null) {
            InetAddress inetAddress = this.conn.getRemoteAddress();
            return inetAddress.getHostName();
        }
        int n = charBuffer.indexOf(':');
        if (n >= 0) {
            return charBuffer.substring(0, n);
        }
        return charBuffer.toString();
    }

    public int getServerPort() {
        CharBuffer charBuffer = this.getHost();
        if (charBuffer == null) {
            return this.conn.getLocalPort();
        }
        int n = charBuffer.indexOf(':');
        if (n >= 0) {
            return Integer.parseInt(charBuffer.substring(n + 1));
        }
        return this.conn.getLocalPort();
    }

    public String getRemoteAddr() {
        InetAddress inetAddress = this.conn.getRemoteAddress();
        return inetAddress.getHostAddress();
    }

    public String getRemoteHost() {
        InetAddress inetAddress = this.conn.getRemoteAddress();
        return inetAddress.getHostName();
    }

    void setSecure(boolean bl) {
        this.bogusSecure = bl;
    }

    HttpRequest(ServletServer servletServer) {
        super(servletServer);
        this.response = new HttpResponse(this);
        this.charBuf = new char[1024];
        this.uri = new CharBuffer();
        this.cb = new CharBuffer();
        this.method = new CharBuffer();
        this.host = new CharBuffer();
        this.protocol = new CharBuffer();
        this.scheme = new CharBuffer("http");
        this.queryString = new CharBuffer();
        this.headerCapacity = 32;
        this.headerSize = 0;
        this.headerKeys = new CharBuffer[this.headerCapacity];
        this.headerValues = new CharBuffer[this.headerCapacity];
        int n = 0;
        while (n < this.headerCapacity) {
            this.headerKeys[n] = new CharBuffer();
            this.headerValues[n] = new CharBuffer();
            ++n;
        }
    }
}

