/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.java.CompilingClassLoader;
import com.caucho.regexp.IllegalRegexpException;
import com.caucho.server.http.Authenticator;
import com.caucho.server.http.BrowserConfig;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.NullAuthenticator;
import com.caucho.server.http.QNamedDispatcher;
import com.caucho.server.http.QRequestDispatcher;
import com.caucho.server.http.QServletConfig;
import com.caucho.server.http.QSession;
import com.caucho.server.http.SecurityConstraint;
import com.caucho.server.http.ServletAlarm;
import com.caucho.server.http.Statistics;
import com.caucho.server.http.UrlMap;
import com.caucho.server.http.VirtualHost;
import com.caucho.sql.DBPool;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.DirectoryClassLoader;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.ExitListener;
import com.caucho.util.LruCache;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.util.SimpleClassLoader;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;

class Application
implements CauchoApplication {
    static WriteStream dbg = LogStream.open("/caucho.com/http/application");
    static HashMap defaultMimeTypes = new HashMap();
    private static HashMap webAppElements;
    private static HashMap loginConfigElements;
    private VirtualHost host;
    private String contextPath;
    private Path config;
    private long configLastModified;
    RegistryNode origRegistry;
    RegistryNode registry;
    private UrlMap dispatchMap;
    private QServletConfig defaultServlet;
    private UrlMap realPathMap;
    private UrlMap cacheMap;
    private Hashtable servlets;
    private HashMap mimeTypes;
    private HashMap mimeFilters;
    private HashMap taglibMap;
    private Path appDir;
    private ClassLoader parentLoader;
    private DynamicClassLoader classLoader;
    private long classUpdateInterval;
    private long lastClassUpdate;
    private int classUpdateCount;
    private HashMap initParams;
    private HashMap attributes;
    private Hashtable instances;
    private LruCache sessions;
    private Iterator sessionIter;
    private int sessionCount;
    private boolean enableSessionCookies;
    private boolean enableSessionUrls;
    private long sessionTimeout;
    private String charEncoding;
    private LruCache realPathCache;
    private LruCache mimeTypeCache;
    private HashMap errorPages;
    private UrlMap securityMap;
    private String loginAuthMethod;
    private String loginRealmName;
    private String formLoginPage;
    private String formErrorPage;
    private Authenticator authenticator;
    private ArrayList cronList;
    private ArrayList listeners;
    private ArrayList dbPools;
    private UrlMap browserMap;
    private Hashtable browserCache;
    Statistics stats;
    private boolean isClosed;
    private String createMode;
    private boolean hasInit;

    private void preServletConfigure(String string) throws IOException, ServletException {
        try {
            Class.forName("com.caucho.sql.DBPool");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Iterator iterator = this.registry.iterator();
        while (iterator.hasNext()) {
            RegistryNode registryNode = (RegistryNode)iterator.next();
            if (registryNode.getName().equals("db-pool")) {
                DBPool dBPool;
                String string2 = registryNode.getValue();
                if (string2 == null) {
                    throw Application.error(registryNode, "db-pool needs an id");
                }
                String string3 = registryNode.getString("driver", null);
                if (string3 == null) {
                    throw Application.error(registryNode, "db-pool needs a `driver'");
                }
                String string4 = registryNode.getString("url", null);
                if (string4 == null) {
                    throw Application.error(registryNode, "db-pool needs a `url'");
                }
                String string5 = registryNode.getString("user", null);
                String string6 = registryNode.getString("password", null);
                int n = registryNode.getInt("max-connections", 10);
                try {
                    dBPool = new DBPool(string2, string4, string5, string6, string3, this.getClassLoader(), n);
                }
                catch (Exception exception) {
                    throw Application.error(registryNode, "db-pool `" + string2 + "'" + exception);
                }
                this.setAttribute(string2, dBPool);
                if (this.dbPools == null) {
                    this.dbPools = new ArrayList();
                }
                this.dbPools.add(dBPool);
                continue;
            }
            if (!"web-app".equals(string) || webAppElements.get(registryNode.getName()) != null) continue;
            throw Application.error(registryNode, "unknown element `" + registryNode.getName() + "' in " + string);
        }
    }

    private void configureServlets() throws IOException, ServletException {
        this.servlets = new Hashtable();
        Iterator iterator = this.registry.iterator();
        while (iterator.hasNext()) {
            RegistryNode registryNode = (RegistryNode)iterator.next();
            if (registryNode.getName().equals("servlet")) {
                String string = registryNode.getString("servlet-name", null);
                if (string == null) {
                    throw Application.error(registryNode, "servlet expects `servlet-name' attribute");
                }
                QServletConfig qServletConfig = new QServletConfig(this, string, null, registryNode);
                this.servlets.put(string, qServletConfig);
                continue;
            }
            if (!registryNode.getName().equals("context-param")) continue;
            this.fillParam(registryNode, this.initParams);
        }
    }

    private void postServletConfigure(String string) throws IOException, ServletException {
        this.dispatchMap = new UrlMap(true);
        this.realPathMap = new UrlMap(true);
        this.cacheMap = null;
        this.mimeTypes = new HashMap();
        this.mimeFilters = new HashMap();
        this.taglibMap = new HashMap();
        this.errorPages = new HashMap();
        try {
            this.dispatchMap.addMap("*.jsp", this.createServlet("com.caucho.jsp.JspServlet"));
            this.dispatchMap.addMap("*.xtp", this.createServlet("com.caucho.jsp.XtpServlet"));
        }
        catch (IllegalRegexpException illegalRegexpException) {
            // empty catch block
        }
        this.mimeFilters.put("x-application/xsl", "com.caucho.jsp.XslFilter");
        this.defaultServlet = this.addServlet("com.caucho.server.http.FileServlet", null);
        Iterator iterator = this.registry.iterator();
        while (iterator.hasNext()) {
            RegistryNode registryNode = (RegistryNode)iterator.next();
            try {
                this.webAppEntryConfigure(registryNode, string);
            }
            catch (IllegalRegexpException illegalRegexpException) {
                throw Application.error(registryNode, illegalRegexpException.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void webAppEntryConfigure(RegistryNode registryNode, String string) throws IOException, ServletException, IllegalRegexpException {
        if (registryNode.getName().equals("servlet-mapping")) {
            String string2 = registryNode.getString("url-pattern", null);
            String string3 = registryNode.getString("url-regexp", null);
            String string4 = registryNode.getString("path-info", null);
            String string5 = registryNode.getString("servlet-name", null);
            if (string5 == null) {
                throw Application.error(registryNode, "servlet-mapping expects `servlet-name'");
            }
            QServletConfig qServletConfig = null;
            if (string3 == null || string5.indexOf(36) < 0) {
                qServletConfig = this.createServlet(string5, registryNode);
            }
            if (string2 != null) {
                this.dispatchMap.addMap(string2, null, string4, string5, qServletConfig);
            } else {
                if (string3 == null) throw Application.error(registryNode, "servlet-mapping expects `url-pattern' or `url-regexp'");
                this.dispatchMap.addRegexp(string3, null, string4, string5, qServletConfig);
            }
            if (dbg.canWrite() && string2 != null) {
                dbg.log("servlet-mapping: " + string2 + " " + string5);
                return;
            } else {
                if (!dbg.canWrite()) return;
                dbg.log("servlet-mapping: " + string3 + " " + string5);
            }
            return;
        } else if (registryNode.getName().equals("path-mapping")) {
            String string6 = registryNode.getString("url-pattern", null);
            String string7 = registryNode.getString("url-regexp", null);
            String string8 = registryNode.getString("real-path", null);
            if (string6 == null && string7 == null) {
                throw Application.error(registryNode, "path-mapping expects `url-pattern' or `url-regexp'");
            }
            if (string8 == null) {
                throw Application.error(registryNode, "path-mapping expects `real-path'");
            }
            try {
                if (string6 != null) {
                    this.realPathMap.addMap(string6, null, string8, null, "dummy");
                    return;
                }
                this.realPathMap.addRegexp(string7, null, string8, null, "dummy");
                return;
            }
            catch (IllegalRegexpException illegalRegexpException) {
                throw Application.error(registryNode, illegalRegexpException.toString());
            }
        } else if (registryNode.getName().equals("mime-mapping")) {
            String string9 = registryNode.getString("extension", null);
            String string10 = registryNode.getString("mime-type", null);
            if (string9 == null) {
                throw Application.error(registryNode, "mime-mapping expects `extension'");
            }
            if (string10 == null) {
                throw Application.error(registryNode, "mime-mapping expects `mime-type'");
            }
            this.mimeTypes.put(string9, string10);
            return;
        } else if (registryNode.getName().equals("filter-mapping")) {
            String string11 = registryNode.getString("mime-type", null);
            if (string11 == null) {
                throw Application.error(registryNode, "filter-mapping expects `mime-type'");
            }
            String string12 = registryNode.getString("servlet-name", null);
            if (string12 == null) {
                throw Application.error(registryNode, "filter-mapping expects `servlet-name'");
            }
            if (dbg.canWrite()) {
                dbg.log("filter-mapping: " + string11 + " " + string12);
            }
            this.mimeFilters.put(string11, string12);
            return;
        } else if (registryNode.getName().equals("cache-mapping")) {
            String string13 = registryNode.getString("url-pattern", null);
            String string14 = registryNode.getString("url-regexp", null);
            long l = registryNode.getPeriod("expires", -1L);
            if (this.cacheMap == null) {
                this.cacheMap = new UrlMap(true);
            }
            if (string13 != null) {
                this.cacheMap.addMap(string13, null, null, null, new Long(l));
                return;
            } else {
                if (string14 == null) throw Application.error(registryNode, "cache-mapping expects `url-pattern' or `url-regexp'");
                this.cacheMap.addRegexp(string13, null, null, null, new Long(l));
            }
            return;
        } else {
            if (registryNode.getName().equals("taglib")) {
                String string15 = registryNode.getString("taglib-uri", null);
                String string16 = registryNode.getString("taglib-location", null);
                RegistryNode registryNode2 = registryNode.lookup("tag");
                if (string15 == null) {
                    throw Application.error(registryNode, "taglib expects `taglib-uri'");
                }
                if (string16 != null || registryNode2 != null) return;
                throw Application.error(registryNode, "taglib expects `taglib-location' or `tag'");
            }
            if (registryNode.getName().equals("error-page")) {
                String string17 = registryNode.getString("location", null);
                String string18 = registryNode.getString("error-code", null);
                String string19 = registryNode.getString("exception-type", null);
                if (string17 == null) {
                    throw Application.error(registryNode, "error-page expects `location'");
                }
                if (string19 != null) {
                    this.errorPages.put(string19, string17);
                    return;
                } else if (string18 != null) {
                    this.errorPages.put(string18, string17);
                    return;
                } else {
                    this.errorPages.put("0", string17);
                }
                return;
            } else if (registryNode.getName().equals("security-constraint")) {
                this.initSecurityConstraint(registryNode);
                return;
            } else if (registryNode.getName().equals("login-config")) {
                this.initLoginConfig(registryNode);
                return;
            } else {
                if ("web-app".equals(string) && webAppElements.get(registryNode.getName()) == null) {
                    throw Application.error(registryNode, "unknown element `" + registryNode.getName() + "' in " + string);
                }
                if (!registryNode.getName().equals("browser-mapping")) return;
                String string20 = registryNode.getString("regexp", null);
                boolean bl = registryNode.getBoolean("force10", false);
                if (string20 == null) {
                    throw Application.error(registryNode, "browser-mapping expects `regexp'");
                }
                this.addBrowserMapping(string20, bl);
            }
        }
    }

    private void addBrowserMapping(String string, boolean bl) throws IllegalRegexpException {
        if (this.browserMap == null) {
            this.browserMap = new UrlMap();
            this.browserCache = new Hashtable();
        }
        BrowserConfig browserConfig = new BrowserConfig(bl);
        this.browserMap.addRegexp(string, "", null, null, browserConfig);
    }

    private void initSecurityConstraint(RegistryNode registryNode) throws IOException, ServletException {
        Object object;
        RegistryNode registryNode2;
        if (this.securityMap == null) {
            this.securityMap = new UrlMap(true);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = registryNode.getString("role-name", null);
        String string2 = registryNode.getString("transport-guarantee", null);
        if (string2 == null) {
            string2 = registryNode.getString("user-data-constraint/transport-guarantee", null);
        }
        if (string != null) {
            arrayList.add(string);
        }
        Iterator iterator = (registryNode2 = registryNode.lookup("auth-constraint")) != null ? registryNode2.select("role-name") : null;
        while (iterator != null && iterator.hasNext()) {
            object = (RegistryNode)iterator.next();
            arrayList.add(((RegistryNode)object).getValue());
        }
        String string3 = registryNode.getString("method", null);
        String string4 = registryNode.getString("url-pattern", null);
        String string5 = registryNode.getString("url-regexp", null);
        try {
            object = new SecurityConstraint(arrayList, string2);
            if (string3 != null) {
                ((SecurityConstraint)object).addMethod(string3);
            }
            if (string4 != null) {
                this.securityMap.addMap(string4, null, null, null, object);
            } else if (string5 != null) {
                this.securityMap.addRegexp(string5, null, null, null, object);
            } else if (string3 != null) {
                this.securityMap.addRegexp("", null, null, null, object);
            }
            iterator = registryNode.select("web-resource-collection");
            while (iterator.hasNext()) {
                boolean bl = false;
                registryNode2 = (RegistryNode)iterator.next();
                object = new SecurityConstraint(arrayList, string2);
                Iterator iterator2 = registryNode2.select("method");
                while (iterator2.hasNext()) {
                    RegistryNode registryNode3 = (RegistryNode)iterator2.next();
                    ((SecurityConstraint)object).addMethod(registryNode3.getValue());
                    bl = true;
                }
                boolean bl2 = false;
                iterator2 = registryNode2.iterator();
                while (iterator2.hasNext()) {
                    String string6;
                    RegistryNode registryNode4 = (RegistryNode)iterator2.next();
                    if (registryNode4.getName().equals("url-pattern")) {
                        string6 = registryNode4.getValue();
                        this.securityMap.addMap(string6, null, null, null, object);
                        bl2 = true;
                        continue;
                    }
                    if (!registryNode4.getName().equals("url-regexp")) continue;
                    string6 = registryNode4.getValue();
                    this.securityMap.addRegexp(string6, null, null, null, object);
                    bl2 = true;
                }
                if (!bl || bl2) continue;
                this.securityMap.addRegexp("", null, null, null, object);
            }
        }
        catch (Exception exception) {
            throw Application.error(registryNode, exception);
        }
        if (this.securityMap.size() == 0) {
            throw Application.error(registryNode, "security-constraint expects a `web-resource-collection'");
        }
    }

    private void initLoginConfig(RegistryNode registryNode) throws IOException, ServletException {
        String string;
        this.validateNodeChildren(registryNode, loginConfigElements);
        this.loginAuthMethod = registryNode.getString("auth-method", null);
        this.loginRealmName = registryNode.getString("realm-name", null);
        this.formLoginPage = registryNode.getString("form-login-config/form-login-page", null);
        this.formErrorPage = registryNode.getString("form-login-config/form-error-page", null);
        if (this.loginAuthMethod == null) {
            throw Application.error(registryNode, "login-config expects `auth-method'");
        }
        this.loginAuthMethod = this.loginAuthMethod.toLowerCase();
        if (this.loginAuthMethod.equals("form")) {
            if (this.formLoginPage == null) {
                throw Application.error(registryNode, "form login expects `form-login-page'");
            }
            if (this.formErrorPage == null) {
                throw Application.error(registryNode, "form login expects `form-error-page'");
            }
        }
        if ((string = registryNode.getString("authenticator", null)) == null) {
            return;
        }
        try {
            this.authenticator = (Authenticator)Beans.instantiate(this.getClassLoader(), string);
        }
        catch (Exception exception) {
            throw Application.error(registryNode, "authenticator load: " + exception);
        }
        try {
            this.authenticator.init(this, registryNode.lookup("authenticator"));
        }
        catch (Exception exception) {
            throw Application.error(registryNode, "authenticator init: " + exception);
        }
    }

    private void validateNodeChildren(RegistryNode registryNode, HashMap hashMap) throws ServletException {
        Iterator iterator = registryNode.iterator();
        while (iterator.hasNext()) {
            RegistryNode registryNode2 = (RegistryNode)iterator.next();
            if (hashMap.get(registryNode2.getName()) != null) continue;
            throw Application.error(registryNode2, "unexpected tag `" + registryNode2.getName() + "' in `" + registryNode.getName() + "'");
        }
    }

    private QServletConfig createServlet(String string) throws ServletException {
        return this.createServlet(string, null);
    }

    private QServletConfig createServlet(String string, RegistryNode registryNode) throws ServletException {
        QServletConfig qServletConfig = (QServletConfig)this.servlets.get(string);
        if (qServletConfig == null) {
            qServletConfig = new QServletConfig(this, string, null, registryNode);
            this.servlets.put(string, qServletConfig);
        }
        return qServletConfig;
    }

    private void fillParam(RegistryNode registryNode, HashMap hashMap) {
        Iterator iterator = registryNode.iterator();
        while (iterator.hasNext()) {
            RegistryNode registryNode2 = (RegistryNode)iterator.next();
            if (registryNode2.getName().equals("param-name")) {
                String string = registryNode2.getValue();
                String string2 = registryNode.getString("param-value", null);
                hashMap.put(string, string2 == null ? "" : string2);
                continue;
            }
            if (registryNode2.getName().equals("param-value")) continue;
            hashMap.put(registryNode2.getName(), registryNode2.getValue());
        }
    }

    static ServletException error(RegistryNode registryNode, String string) {
        return new ServletException(registryNode.getFilename() + ":" + registryNode.getLine() + ": " + string);
    }

    static ServletException error(RegistryNode registryNode, Exception exception) {
        if (exception instanceof ServletException) {
            return (ServletException)((Object)exception);
        }
        return new ServletException((Throwable)exception);
    }

    void init() throws IOException {
        if (this.hasInit) {
            return;
        }
        this.hasInit = true;
        this.initServlets();
    }

    private void initServlets() throws IOException {
        Enumeration enumeration = this.servlets.elements();
        while (enumeration.hasMoreElements()) {
            QServletConfig qServletConfig = (QServletConfig)enumeration.nextElement();
            if (!qServletConfig.loadOnStartup()) continue;
            try {
                Servlet servlet = this.loadServlet(qServletConfig);
                if (!qServletConfig.isCron()) continue;
                this.cronList.add(new ServletAlarm(qServletConfig, servlet));
            }
            catch (Exception exception) {
                this.log("Can't load servlet `" + qServletConfig.getServletName() + "'", exception);
            }
        }
    }

    String getCreateMode() {
        return this.createMode;
    }

    VirtualHost getVirtualHost() {
        return this.host;
    }

    public String getServerInfo() {
        return "Resin/1.1";
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 2;
    }

    public ServletContext getContext(String string) {
        try {
            CharBuffer charBuffer = CharBuffer.allocate();
            charBuffer.append(string);
            Invocation invocation = this.host.getInvocation(charBuffer);
            charBuffer.free();
            return invocation.application;
        }
        catch (Exception exception) {
            if (dbg.canWrite()) {
                dbg.log(exception);
            }
            return null;
        }
    }

    public String getRealPath(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        string2 = (String)this.realPathCache.get(string);
        if (string2 == null) {
            Invocation invocation;
            Object object;
            try {
                object = CharBuffer.allocate();
                ((CharBuffer)object).append(this.contextPath);
                ((CharBuffer)object).append('/');
                ((CharBuffer)object).append(string);
                invocation = this.host.getInvocation((CharBuffer)object);
                ((CharBuffer)object).free();
            }
            catch (Exception exception) {
                if (dbg.canWrite()) {
                    dbg.log(exception);
                }
                return null;
            }
            object = invocation.getApplication();
            Path path = ((Application)object).appDir;
            String string3 = invocation.getUri();
            String string4 = invocation.getContextPath();
            String string5 = string3.substring(string4.length());
            CharBuffer charBuffer = new CharBuffer();
            string2 = this.realPathMap.map(string5, null, charBuffer, null) != null ? path.lookupNative(charBuffer.toString()).getNativePath() : path.lookup("./" + string5).getNativePath();
            this.realPathCache.put(string, string2);
        }
        if (dbg.canWrite()) {
            dbg.log("realPath: " + string + " -> " + string2);
        }
        return string2;
    }

    public String getMimeType(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        string2 = (String)this.mimeTypeCache.get(string);
        if (string2 == null) {
            Invocation invocation;
            Object object;
            try {
                object = CharBuffer.allocate();
                ((CharBuffer)object).append(this.contextPath);
                ((CharBuffer)object).append('/');
                ((CharBuffer)object).append(string);
                invocation = this.host.getInvocation((CharBuffer)object);
                ((CharBuffer)object).free();
            }
            catch (Exception exception) {
                if (dbg.canWrite()) {
                    dbg.log(exception);
                }
                return null;
            }
            object = invocation.getPathInfo();
            if (object == null) {
                object = invocation.getServletPath();
            }
            if (object == null) {
                return null;
            }
            Application application = invocation.getApplication();
            int n = ((String)object).lastIndexOf(46);
            if (n < 0) {
                return null;
            }
            String string3 = ((String)object).substring(n);
            string2 = (String)application.mimeTypes.get(string3);
            if (string2 == null) {
                string2 = (String)defaultMimeTypes.get(string3);
            }
            this.mimeTypeCache.put(string, string2);
        }
        return string2;
    }

    long getCacheTime(String string) {
        if (this.cacheMap == null) {
            return 0L;
        }
        Long l = (Long)this.cacheMap.map(string, null, null, null);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    String getErrorPage(Throwable throwable) {
        Class<?> clazz = throwable.getClass();
        while (clazz != null) {
            String string = (String)this.errorPages.get(clazz.getName());
            if (string != null) {
                return string;
            }
            clazz = clazz.getSuperclass();
        }
        return (String)this.errorPages.get("0");
    }

    SecurityConstraint getSecurity(String string) {
        if (this.securityMap == null || this.securityMap.size() == 0) {
            return null;
        }
        return (SecurityConstraint)this.securityMap.map(string, null, null, null);
    }

    String getErrorPage(int n) {
        String string = (String)this.errorPages.get(String.valueOf(n));
        if (string == null) {
            string = (String)this.errorPages.get("0");
        }
        return string;
    }

    String getLoginMethod() {
        return this.loginAuthMethod;
    }

    String getLoginRealm() {
        return this.loginRealmName;
    }

    String getLoginForm() {
        return this.formLoginPage;
    }

    String getLoginError() {
        return this.formErrorPage;
    }

    Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public URL getResource(String string) {
        String string2 = this.getRealPath(string);
        try {
            return new URL("file", null, string2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public InputStream getResourceAsStream(String string) {
        Path path = this.appDir.lookupNative(this.getRealPath(string));
        try {
            return path.openRead();
        }
        catch (IOException iOException) {
            if (dbg.canWrite()) {
                dbg.log(iOException);
            }
            return this.getClassLoader().getResourceAsStream(string);
        }
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string.length() == 0 || string.charAt(0) != '/') {
            throw new IllegalArgumentException("path must be absolute: `" + string + "'");
        }
        String string2 = null;
        CharBuffer charBuffer = CharBuffer.allocate();
        charBuffer.append(this.getContextPath());
        int n = string.indexOf(63);
        if (n >= 0) {
            charBuffer.append(string, 0, n);
            string2 = string.substring(n + 1);
        } else {
            charBuffer.append(string);
        }
        RequestDispatcher requestDispatcher = this.getRequestDispatcher(charBuffer, string2);
        charBuffer.free();
        return requestDispatcher;
    }

    RequestDispatcher getRequestDispatcher(CharBuffer charBuffer, String string) {
        Invocation invocation;
        try {
            invocation = this.host.getInvocation(charBuffer);
        }
        catch (Exception exception) {
            if (dbg.canWrite()) {
                dbg.log(exception);
            }
            return null;
        }
        return new QRequestDispatcher(invocation, string);
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        int n = string.indexOf(63);
        String string2 = null;
        if (n >= 0) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        try {
            QServletConfig qServletConfig = this.addServlet(string, null);
            return new QNamedDispatcher(qServletConfig, string2);
        }
        catch (ServletException servletException) {
            if (dbg.canWrite()) {
                dbg.log(servletException);
            }
            return null;
        }
    }

    QServletConfig addServlet(String string, String string2) throws ServletException {
        QServletConfig qServletConfig = (QServletConfig)this.servlets.get(string);
        if (qServletConfig != null) {
            return qServletConfig;
        }
        qServletConfig = new QServletConfig(this, string, string2, null);
        this.servlets.put(string, qServletConfig);
        return qServletConfig;
    }

    void getServlet(Invocation invocation) throws ServletException {
        CharBuffer charBuffer;
        CharBuffer charBuffer2;
        String string = invocation.pathInfo;
        if (string.endsWith("/j_security_check") && "form".equals(this.getLoginMethod())) {
            QServletConfig qServletConfig;
            invocation.servletConfig = qServletConfig = this.addServlet("j_security_check", "com.caucho.server.http.FormLoginServlet");
            return;
        }
        CharBuffer charBuffer3 = CharBuffer.allocate();
        QServletConfig qServletConfig = (QServletConfig)this.dispatchMap.map(string, charBuffer3, charBuffer2 = CharBuffer.allocate(), charBuffer = CharBuffer.allocate());
        if (qServletConfig == null && charBuffer.length() > 0) {
            qServletConfig = this.createServlet(charBuffer.toString());
            invocation.servletPath = charBuffer3.toString();
            invocation.pathInfo = charBuffer2.length() > 0 ? charBuffer2.toString() : null;
        } else if (qServletConfig == null) {
            qServletConfig = this.defaultServlet;
            invocation.servletPath = null;
            invocation.pathInfo = string;
        } else if (charBuffer2.length() > 0) {
            invocation.servletPath = charBuffer3.toString();
            invocation.pathInfo = charBuffer2.toString();
        } else {
            invocation.servletPath = charBuffer3.toString();
            invocation.pathInfo = null;
        }
        charBuffer3.free();
        charBuffer2.free();
        charBuffer.free();
        if (qServletConfig.getServletName().equals("invoker") && invocation.pathInfo != null) {
            string = invocation.pathInfo;
            int n = string.indexOf(47, 1);
            if (n < 0) {
                n = string.length();
            }
            String string2 = string.substring(1, n);
            qServletConfig = this.addServlet(string2, null);
            invocation.servletPath = invocation.servletPath + string.substring(0, n);
            invocation.pathInfo = n < string.length() ? string.substring(n) : null;
        }
        invocation.servletConfig = qServletConfig;
    }

    boolean isModified() {
        long l = Alarm.getCurrentTime();
        if (this.classLoader == null) {
            return true;
        }
        if (this.lastClassUpdate + this.classUpdateInterval > l) {
            return false;
        }
        if (this.config != null && this.config.getLastModified() > this.configLastModified) {
            return true;
        }
        if (this.classLoader.isModified()) {
            return true;
        }
        this.lastClassUpdate = l;
        return false;
    }

    Servlet updateServlet(QServletConfig qServletConfig, Servlet servlet, int n) throws ServletException, IOException, ClassNotFoundException {
        Hashtable hashtable = this.instances;
        synchronized (hashtable) {
            if (servlet != null && n == this.classUpdateCount) {
                Servlet servlet2 = servlet;
                Object var5_7 = null;
                return servlet2;
            }
            Servlet servlet3 = (Servlet)this.instances.get(qServletConfig.getServletName());
            Object var5_8 = null;
            return servlet3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Servlet loadServlet(QServletConfig qServletConfig) throws ServletException, IOException, ClassNotFoundException {
        Hashtable hashtable = this.instances;
        synchronized (hashtable) {
            Servlet servlet = (Servlet)this.instances.get(qServletConfig.getServletName());
            if (servlet != null) {
                return servlet;
            }
            String string = qServletConfig.getClassName();
            if (string == null) {
                return null;
            }
            if (!qServletConfig.isAvailable(Alarm.getCurrentTime())) {
                throw new UnavailableException("still unavailable");
            }
            ClassLoader classLoader = CauchoSystem.getContextClassLoader();
            try {
                try {
                    CauchoSystem.setContextClassLoader(this.getClassLoader());
                    servlet = (Servlet)Beans.instantiate(this.getClassLoader(), string);
                    servlet.init((ServletConfig)qServletConfig);
                }
                catch (UnavailableException unavailableException) {
                    if (unavailableException.isPermanent()) {
                        qServletConfig.setAvailable(Long.MAX_VALUE);
                        throw unavailableException;
                    } else {
                        qServletConfig.setAvailable(Alarm.getCurrentTime() + 1000L * (long)unavailableException.getUnavailableSeconds());
                    }
                    throw unavailableException;
                }
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                CauchoSystem.setContextClassLoader(classLoader);
                throw throwable;
            }
            CauchoSystem.setContextClassLoader(classLoader);
            this.instances.put(qServletConfig.getServletName(), servlet);
            return servlet;
        }
    }

    public void log(String string) {
        this.log(string, null);
    }

    public void log(Exception exception, String string) {
        this.log(string, exception);
    }

    public void log(String string, Throwable throwable) {
        block2: {
            try {
                this.host.log(string, throwable);
            }
            catch (Exception exception) {
                if (!dbg.canWrite()) break block2;
                dbg.log(exception);
            }
        }
    }

    public Object getAttribute(String string) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Object v = this.attributes.get(string);
            Object var3_4 = null;
            return v;
        }
    }

    public Enumeration getAttributeNames() {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Enumeration enumeration = Collections.enumeration(this.attributes.keySet());
            Object var2_3 = null;
            return enumeration;
        }
    }

    public void setAttribute(String string, Object object) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.put(string, object);
        }
    }

    public void removeAttribute(String string) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.remove(string);
        }
    }

    QSession getSession(String string) {
        return (QSession)this.sessions.get(string);
    }

    void addSession(QSession qSession) {
        this.sessions.put(qSession.getId(), qSession);
    }

    void removeSession(QSession qSession) {
        this.sessions.remove(qSession.getId());
    }

    public Servlet getServlet(String string) {
        return null;
    }

    public Enumeration getServlets() {
        return new NullEnum();
    }

    public Enumeration getServletNames() {
        return new NullEnum();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getInitParameter(String string) {
        return (String)this.initParams.get(string);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this.initParams.keySet());
    }

    public Path getAppDir() {
        return this.appDir;
    }

    public RegistryNode getRegistry() {
        return this.registry;
    }

    public String getHost() {
        return this.host.getName();
    }

    long getSessionTimeout() {
        return this.sessionTimeout;
    }

    boolean enableSessionCookies() {
        return this.enableSessionCookies;
    }

    boolean enableSessionUrls() {
        return this.enableSessionUrls;
    }

    public String getFilter(String string) {
        return (String)this.mimeFilters.get(string);
    }

    public DynamicClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void setClassLoader() throws IOException {
        ++this.classUpdateCount;
        this.configureClassLoaders();
        this.instances.clear();
        this.attributes = new HashMap();
        this.sessions.clear();
    }

    private void configureClassLoaders() throws IOException {
        Object object;
        Object object2;
        boolean bl = false;
        ArrayList<RegistryNode> arrayList = new ArrayList<RegistryNode>();
        Iterator iterator = this.registry.select("classpath");
        while (iterator.hasNext()) {
            object2 = (RegistryNode)iterator.next();
            object = ((RegistryNode)object2).getString();
            if (object == null) continue;
            arrayList.add(0, (RegistryNode)object2);
            if (!((String)object).equals("WEB-INF/classes")) continue;
            bl = true;
        }
        this.classLoader = DirectoryClassLoader.create(this.parentLoader, this.appDir.lookup("WEB-INF/lib"));
        object2 = null;
        iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            object = (RegistryNode)iterator.next();
            String string = ((RegistryNode)object).getString();
            if (string == null) continue;
            Path path = this.appDir.lookupNative(string);
            if (!path.isDirectory() && (string.endsWith(".jar") || string.endsWith(".zip"))) {
                if (dbg.canWrite()) {
                    dbg.log("jar class loader: " + path);
                }
                object2 = SimpleClassLoader.create(this.parentLoader, new JarPath(path), null);
                ((DynamicClassLoader)object2).setNext(this.classLoader);
                this.classLoader = object2;
                continue;
            }
            String string2 = ((RegistryNode)object).getString("source", string);
            boolean bl2 = ((RegistryNode)object).getBoolean("compile", true);
            if (!bl2) {
                object2 = SimpleClassLoader.create(this.parentLoader, path, null);
                ((DynamicClassLoader)object2).setNext(this.classLoader);
                this.classLoader = object2;
                continue;
            }
            Path path2 = this.appDir.lookupNative(string2);
            String string3 = ((RegistryNode)object).getString("encoding", this.charEncoding);
            String string4 = ((RegistryNode)object).getString("args", null);
            if (dbg.canWrite()) {
                dbg.log("compiling class loader: " + path + " source=" + path2);
            }
            object2 = CompilingClassLoader.create(this.parentLoader, path, path2, string4, string3);
            ((DynamicClassLoader)object2).setNext(this.classLoader);
            this.classLoader = object2;
        }
        if (!bl) {
            object = this.appDir.lookupNative("WEB-INF/classes");
            if (dbg.canWrite()) {
                dbg.log("compiling class loader: " + object + " source=" + object);
            }
            object2 = CompilingClassLoader.create(this.parentLoader, (Path)object, (Path)object, this.charEncoding);
            ((DynamicClassLoader)object2).setNext(this.classLoader);
            this.classLoader = object2;
        }
    }

    int getClassUpdateCount() {
        return this.classUpdateCount;
    }

    public void addListener(ExitListener exitListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(exitListener);
    }

    void timeout(long l) {
        int n = 0;
        LruCache lruCache = this.sessions;
        synchronized (lruCache) {
            this.sessionIter = this.sessions.values(this.sessionIter);
            while (this.sessionIter.hasNext()) {
                QSession qSession = (QSession)this.sessionIter.next();
                if (qSession.accessTime + qSession.maxInactiveInterval < l) {
                    qSession.invalidate();
                    continue;
                }
                ++n;
            }
        }
        this.stats.setLiveSessions(n);
    }

    void cron(long l) {
        int n = 0;
        while (n < this.cronList.size()) {
            block3: {
                ServletAlarm servletAlarm = (ServletAlarm)this.cronList.get(n);
                try {
                    servletAlarm.timeout(l);
                }
                catch (Exception exception) {
                    if (!dbg.canWrite()) break block3;
                    dbg.log(exception);
                }
            }
            ++n;
        }
    }

    boolean isClosed() {
        return this.isClosed;
    }

    void close() {
        Object object;
        Object object2;
        Object object3 = this.instances;
        synchronized (object3) {
            this.isClosed = true;
            object2 = this.instances.elements();
            while (object2.hasMoreElements()) {
                object = (Servlet)object2.nextElement();
                object.destroy();
            }
            this.instances.clear();
            if (this.listeners != null) {
                int n = 0;
                while (n < this.listeners.size()) {
                    ExitListener exitListener = (ExitListener)this.listeners.get(n);
                    exitListener.handleExit(this);
                    ++n;
                }
                this.listeners = null;
            }
        }
        object3 = this.sessions;
        synchronized (object3) {
            this.sessionIter = this.sessions.values(this.sessionIter);
            while (this.sessionIter.hasNext()) {
                object2 = (QSession)this.sessionIter.next();
                ((QSession)object2).invalidate();
            }
        }
        int n = 0;
        while (this.dbPools != null && n < this.dbPools.size()) {
            object = (DBPool)this.dbPools.get(n);
            ((DBPool)object).close();
            ++n;
        }
        if (dbg.canWrite()) {
            dbg.log("close: " + this);
        }
    }

    String getCharEncoding() {
        return this.charEncoding;
    }

    BrowserConfig getBrowser(CharBuffer charBuffer) {
        if (this.browserMap == null) {
            return null;
        }
        Hashtable hashtable = this.browserCache;
        synchronized (hashtable) {
            BrowserConfig browserConfig = (BrowserConfig)this.browserCache.get(charBuffer);
            if (browserConfig != null) {
                BrowserConfig browserConfig2 = browserConfig;
                Object var3_6 = null;
                return browserConfig2;
            }
            browserConfig = (BrowserConfig)this.browserMap.map(charBuffer.toString(), null, null, null);
            if (browserConfig == null) {
                browserConfig = new BrowserConfig();
            }
            this.browserCache.put(charBuffer.clone(), browserConfig);
            BrowserConfig browserConfig3 = browserConfig;
            Object var3_7 = null;
            return browserConfig3;
        }
    }

    String getMedia(CauchoRequest cauchoRequest) {
        return null;
    }

    public String toString() {
        return "[Application " + this.host.getName() + ":" + this.getContextPath() + "]";
    }

    Application(VirtualHost virtualHost, String string, RegistryNode registryNode, Path path, String string2) throws Exception {
        Path path2;
        this.createMode = string2;
        this.host = virtualHost;
        this.contextPath = string.intern();
        this.appDir = path;
        this.origRegistry = registryNode;
        if (dbg.canWrite()) {
            dbg.log("init: " + this);
        }
        if ((path2 = path.lookup("WEB-INF/web.xml")).canRead()) {
            path2.setUserPath(path2.getNativePath());
            RegistryNode registryNode2 = Registry.parse(path2);
            registryNode = (RegistryNode)registryNode.clone();
            registryNode.append(registryNode2.lookup("web-app"));
            this.config = path2;
            this.configLastModified = path2.getLastModified();
        }
        this.registry = registryNode;
        this.attributes = new HashMap();
        this.initParams = new HashMap();
        this.instances = new Hashtable();
        int n = registryNode.getInt("session-config/session-max", 4096);
        this.sessions = new LruCache(n);
        this.sessionIter = this.sessions.values();
        this.sessionTimeout = 60000 * registryNode.getInt("session-config/session-timeout", 30);
        if (this.sessionTimeout < 5000L) {
            this.sessionTimeout = 5000L;
        }
        this.enableSessionCookies = registryNode.getBoolean("session-config/enable-cookies", true);
        this.enableSessionUrls = registryNode.getBoolean("session-config/enable-url-rewriting", true);
        this.charEncoding = registryNode.getString("character-encoding", null);
        this.parentLoader = CauchoSystem.getContextClassLoader();
        if (this.parentLoader == null) {
            this.parentLoader = CauchoSystem.getStaticClassLoader();
        }
        if (this.parentLoader == null) {
            this.parentLoader = this.getClass().getClassLoader();
        }
        this.setClassLoader();
        this.classUpdateInterval = 1000 * registryNode.getInt("class-update-interval", 2);
        if (this.classUpdateInterval < 0L) {
            this.classUpdateInterval = 0L;
        }
        this.preServletConfigure(string2);
        this.configureServlets();
        this.postServletConfigure(string2);
        this.addBrowserMapping("MSIE 4\\.0b2", true);
        this.addBrowserMapping("RealPlayer 4\\.0", true);
        this.addBrowserMapping("Java/1\\.0", true);
        this.addBrowserMapping("JDK/1\\.0", true);
        this.realPathCache = new LruCache(256);
        this.mimeTypeCache = new LruCache(256);
        this.cronList = new ArrayList();
        if (this.authenticator == null) {
            this.authenticator = new NullAuthenticator();
        }
        String string3 = registryNode.getString("temp-dir", "WEB-INF/tmp");
        this.attributes.put("javax.servlet.context.tempdir", new File(path.lookup(string3).getNativePath()));
        this.stats = new Statistics(this.getVirtualHost().getServer());
        this.attributes.put("caucho.statistics", this.stats);
        this.attributes.put("caucho.class-loader", this.getClassLoader());
    }

    static {
        defaultMimeTypes.put(".aif", "audio/x-aiff");
        defaultMimeTypes.put(".aiff", "audio/x-aiff");
        defaultMimeTypes.put(".aifc", "audio/x-aiff");
        defaultMimeTypes.put(".ai", "application/postscript");
        defaultMimeTypes.put(".au", "audio/basic");
        defaultMimeTypes.put(".asc", "text/plain");
        defaultMimeTypes.put(".avi", "video/x-msvideo");
        defaultMimeTypes.put(".bin", "application/octet-stream");
        defaultMimeTypes.put(".bcpio", "application/x-bcpio");
        defaultMimeTypes.put(".bmp", "image/bmp");
        defaultMimeTypes.put(".class", "application/octet-stream");
        defaultMimeTypes.put(".cpt", "application/mac-compactpro");
        defaultMimeTypes.put(".css", "text/css");
        defaultMimeTypes.put(".cpio", "application/x-cpio");
        defaultMimeTypes.put(".csh", "application/x-csh");
        defaultMimeTypes.put(".cdf", "application/x-netcdf");
        defaultMimeTypes.put(".dms", "application/octet-stream");
        defaultMimeTypes.put(".doc", "application/msword");
        defaultMimeTypes.put(".dcr", "application/x-director");
        defaultMimeTypes.put(".dir", "application/x-director");
        defaultMimeTypes.put(".dxr", "application/x-director");
        defaultMimeTypes.put(".dvi", "application/x-dvi");
        defaultMimeTypes.put(".exe", "application/octet-stream");
        defaultMimeTypes.put(".eps", "application/postscript");
        defaultMimeTypes.put(".etx", "text/x-setext");
        defaultMimeTypes.put(".gtar", "application/x-gtar");
        defaultMimeTypes.put(".gif", "image/gif");
        defaultMimeTypes.put(".gz", "application/octet-stream");
        defaultMimeTypes.put(".hqx", "application/mac-binhex40");
        defaultMimeTypes.put(".html", "text/html");
        defaultMimeTypes.put(".htm", "text/html");
        defaultMimeTypes.put(".hdf", "application/x-hdf");
        defaultMimeTypes.put(".ief", "image/ief");
        defaultMimeTypes.put(".ice", "x-conference/x-cooltalk");
        defaultMimeTypes.put(".js", "application/x-javascript");
        defaultMimeTypes.put(".jpeg", "image/jpeg");
        defaultMimeTypes.put(".jpg", "image/jpeg");
        defaultMimeTypes.put(".jpe", "image/jpeg");
        defaultMimeTypes.put(".kar", "audio/midi");
        defaultMimeTypes.put(".latex", "application/x-latex");
        defaultMimeTypes.put(".lha", "application/octet-stream");
        defaultMimeTypes.put(".lhz", "application/octet-stream");
        defaultMimeTypes.put(".mid", "audio/midi");
        defaultMimeTypes.put(".mpeg", "video/mpeg");
        defaultMimeTypes.put(".mpg", "video/mpeg");
        defaultMimeTypes.put(".mpe", "video/mpeg");
        defaultMimeTypes.put(".mov", "video/quicktime");
        defaultMimeTypes.put(".movie", "video/x-sgi-movie");
        defaultMimeTypes.put(".mpga", "audio/mpeg");
        defaultMimeTypes.put(".mp2", "audio/mpeg");
        defaultMimeTypes.put(".mp3", "audio/mpeg");
        defaultMimeTypes.put(".man", "application/x-troff-man");
        defaultMimeTypes.put(".me", "application/x-troff-me");
        defaultMimeTypes.put(".ms", "application/x-troff-ms");
        defaultMimeTypes.put(".nc", "application/x-netcdf");
        defaultMimeTypes.put(".oda", "application/oda");
        defaultMimeTypes.put(".pdf", "application/pdf");
        defaultMimeTypes.put(".ps", "application/postscript");
        defaultMimeTypes.put(".ppt", "application/vnd.ms-powerpoint");
        defaultMimeTypes.put(".png", "image/png");
        defaultMimeTypes.put(".pgn", "application/x-chess-pgn");
        defaultMimeTypes.put(".pnm", "image/x-portable-anymap");
        defaultMimeTypes.put(".pbm", "image/x-portable-bitmap");
        defaultMimeTypes.put(".pgm", "image/x-portable-graymap");
        defaultMimeTypes.put(".ppm", "image/x-portable-pixmap");
        defaultMimeTypes.put(".qt", "video/quicktime");
        defaultMimeTypes.put(".rtf", "application/rtf");
        defaultMimeTypes.put(".ram", "audio/x-pn-realaudio");
        defaultMimeTypes.put(".rm", "audio/x-pn-realaudio");
        defaultMimeTypes.put(".rpm", "audio/x-pn-realaudio-plugin");
        defaultMimeTypes.put(".ra", "audio/x-realaudio");
        defaultMimeTypes.put(".ras", "image/x-cmu-raster");
        defaultMimeTypes.put(".rgb", "image/x-rgb");
        defaultMimeTypes.put(".rtx", "text/richtext");
        defaultMimeTypes.put(".rtf", "text/rtf");
        defaultMimeTypes.put(".smi", "application/smil");
        defaultMimeTypes.put(".smil", "application/smil");
        defaultMimeTypes.put(".skp", "application/x-koan");
        defaultMimeTypes.put(".skd", "application/x-koan");
        defaultMimeTypes.put(".skt", "application/x-koan");
        defaultMimeTypes.put(".skm", "application/x-koan");
        defaultMimeTypes.put(".src", "application/x-wais-source");
        defaultMimeTypes.put(".sh", "application/x-sh");
        defaultMimeTypes.put(".shar", "application/x-shar");
        defaultMimeTypes.put(".swf", "application/x-shockwave-flash");
        defaultMimeTypes.put(".sit", "application/x-stuffit");
        defaultMimeTypes.put(".spl", "application/x-futuresplash");
        defaultMimeTypes.put(".sv4cpio", "application/x-sv4cpio");
        defaultMimeTypes.put(".sv4crc", "application/x-sv4crc");
        defaultMimeTypes.put(".snd", "audio/basic");
        defaultMimeTypes.put(".sgml", "text/sgml");
        defaultMimeTypes.put(".sgm", "text/sgml");
        defaultMimeTypes.put(".tgz", "application/octet-stream");
        defaultMimeTypes.put(".tar", "application/x-tar");
        defaultMimeTypes.put(".tcl", "application/x-tcl");
        defaultMimeTypes.put(".tex", "application/x-tex");
        defaultMimeTypes.put(".texinfo", "application/x-texinfo");
        defaultMimeTypes.put(".texi", "application/x-texinfo");
        defaultMimeTypes.put(".t", "application/x-troff");
        defaultMimeTypes.put(".tr", "application/x-troff");
        defaultMimeTypes.put(".roff", "application/x-troff");
        defaultMimeTypes.put(".tiff", "image/tiff");
        defaultMimeTypes.put(".tif", "image/tiff");
        defaultMimeTypes.put(".txt", "text/plain");
        defaultMimeTypes.put(".tsv", "text/tab-separated-values");
        defaultMimeTypes.put(".ustar", "application/x-ustar");
        defaultMimeTypes.put(".vcd", "application/x-cdlink");
        defaultMimeTypes.put(".vrml", "model/vrml");
        defaultMimeTypes.put(".wav", "audio/x-wav");
        defaultMimeTypes.put(".wrl", "model/vrml");
        defaultMimeTypes.put(".xls", "application/vnd.ms-excel");
        defaultMimeTypes.put(".xbm", "image/x-xbitmap");
        defaultMimeTypes.put(".xpm", "image/x-xpixmax");
        defaultMimeTypes.put(".xwd", "image/x-xwindowdump");
        defaultMimeTypes.put(".xml", "text/xml");
        defaultMimeTypes.put(".zip", "application/zip");
        defaultMimeTypes.put(".z", "application/octet-stream");
        webAppElements = new HashMap();
        webAppElements.put("context-param", "context-param");
        webAppElements.put("servlet", "servlet");
        webAppElements.put("servlet-mapping", "servlet-mapping");
        webAppElements.put("filter-mapping", "filter-mapping");
        webAppElements.put("path-mapping", "path-mapping");
        webAppElements.put("mime-mapping", "mime-mapping");
        webAppElements.put("cache-mapping", "cache-mapping");
        webAppElements.put("session-config", "session-config");
        webAppElements.put("character-encoding", "character-encoding");
        webAppElements.put("class-update-interval", "class-update-interval");
        webAppElements.put("taglib", "taglib");
        webAppElements.put("url-regexp", "url-regexp");
        webAppElements.put("app-dir", "app-dir");
        webAppElements.put("error-page", "error-page");
        webAppElements.put("classpath", "classpath");
        webAppElements.put("security-constraint", "security-constraint");
        webAppElements.put("welcome-file-list", "welcome-file-list");
        webAppElements.put("icon", "icon");
        webAppElements.put("display-name", "display-name");
        webAppElements.put("discription", "discription");
        webAppElements.put("distributable", "distributable");
        webAppElements.put("resource-ref", "resource-ref");
        webAppElements.put("login-config", "login-config");
        webAppElements.put("security-role", "security-role");
        webAppElements.put("env-entry", "env-entry");
        webAppElements.put("ejb-ref", "ejb-ref");
        webAppElements.put("db-pool", "db-pool");
        webAppElements.put("browser-mapping", "browser-mapping");
        webAppElements.put("temp-dir", "temp-dir");
        webAppElements.put("jsp", "jsp");
        loginConfigElements = new HashMap();
        loginConfigElements.put("auth-method", "auth-method");
        loginConfigElements.put("realm-name", "realm-name");
        loginConfigElements.put("form-login-config", "form-login-config");
        loginConfigElements.put("authenticator", "authenticator");
    }

    static class NullEnum
    implements Enumeration {
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }

        NullEnum() {
        }
    }

    class AppAlarm {
        int start;
        int stop;
        int period;
        Invocation invocation;
        String queryString;

        AppAlarm(Invocation invocation, String string, int n, int n2, int n3) {
            this.invocation = invocation;
            this.queryString = string;
            this.start = n;
            this.stop = n2;
            this.period = n3;
        }
    }
}

