/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;

class AccessLog {
    private static FreeList freeBuffers = new FreeList(16);
    private QDate calendar;
    private Path path;
    private WriteStream os;
    private String format;
    private ArrayList segments;
    private long lastTime;
    private CharBuffer timeBuffer = new CharBuffer();

    private ArrayList parseFormat(String string) {
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        CharBuffer charBuffer = new CharBuffer();
        int n = 0;
        while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) != '%' || n >= string.length()) {
                charBuffer.append(c);
                continue;
            }
            String string2 = null;
            if ((c = string.charAt(n++)) == '>') {
                c = string.charAt(n++);
            } else if (c == '{') {
                if (charBuffer.length() > 0) {
                    arrayList.add(new Segment(this, 0, charBuffer.toString()));
                }
                charBuffer.clear();
                while (n < string.length() && string.charAt(n++) != '}') {
                    charBuffer.append(string.charAt(n - 1));
                }
                string2 = charBuffer.toString();
                charBuffer.clear();
                c = string.charAt(n++);
            }
            switch (c) {
                case 'b': 
                case 'h': 
                case 'i': 
                case 'l': 
                case 'o': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': {
                    if (charBuffer.length() > 0) {
                        arrayList.add(new Segment(this, 0, charBuffer.toString()));
                    }
                    charBuffer.clear();
                    arrayList.add(new Segment(this, c, string2));
                    break;
                }
                default: {
                    charBuffer.append('%');
                    --n;
                    break;
                }
            }
        }
        if (charBuffer.length() > 0) {
            arrayList.add(new Segment(this, 0, charBuffer.toString()));
        }
        return arrayList;
    }

    void log(Request request, Response response) throws IOException {
        CharBuffer charBuffer = (CharBuffer)freeBuffers.allocate();
        if (charBuffer == null) {
            charBuffer = new CharBuffer();
        } else {
            charBuffer.clear();
        }
        int n = 0;
        while (n < this.segments.size()) {
            Segment segment = (Segment)this.segments.get(n);
            segment.apply(charBuffer, request, response);
            ++n;
        }
        WriteStream writeStream = this.os;
        synchronized (writeStream) {
            this.os.println(charBuffer.getBuffer(), 0, charBuffer.getLength());
        }
        freeBuffers.free(charBuffer);
    }

    void flush() throws IOException {
        WriteStream writeStream = this.os;
        synchronized (writeStream) {
            this.os.flush();
        }
    }

    void close() throws IOException {
        WriteStream writeStream = this.os;
        synchronized (writeStream) {
            this.os.close();
        }
    }

    synchronized void printTime(CharBuffer charBuffer, long l) throws IOException {
        if (l / 1000L == this.lastTime / 1000L) {
            charBuffer.append(this.timeBuffer);
            return;
        }
        this.timeBuffer.clear();
        this.lastTime = l;
        this.calendar.calculate(l, true);
        long l2 = this.calendar.get(2) + 1L;
        int n = (int)this.calendar.get(1) + 1;
        long l3 = this.calendar.get(0);
        long l4 = this.calendar.get(5);
        long l5 = this.calendar.get(6);
        long l6 = this.calendar.get(7);
        long l7 = this.calendar.get(10);
        this.timeBuffer.append('[');
        this.timeBuffer.append(l2 / 10L);
        this.timeBuffer.append(l2 % 10L);
        this.timeBuffer.append('/');
        switch (n) {
            case 1: {
                this.timeBuffer.append("Jan");
                break;
            }
            case 2: {
                this.timeBuffer.append("Feb");
                break;
            }
            case 3: {
                this.timeBuffer.append("Mar");
                break;
            }
            case 4: {
                this.timeBuffer.append("Apr");
                break;
            }
            case 5: {
                this.timeBuffer.append("May");
                break;
            }
            case 6: {
                this.timeBuffer.append("Jun");
                break;
            }
            case 7: {
                this.timeBuffer.append("Jul");
                break;
            }
            case 8: {
                this.timeBuffer.append("Aug");
                break;
            }
            case 9: {
                this.timeBuffer.append("Sep");
                break;
            }
            case 10: {
                this.timeBuffer.append("Oct");
                break;
            }
            case 11: {
                this.timeBuffer.append("Nov");
                break;
            }
            case 12: {
                this.timeBuffer.append("Dec");
                break;
            }
        }
        this.timeBuffer.append('/');
        this.timeBuffer.append(l3);
        this.timeBuffer.append(':');
        this.timeBuffer.append(l4 / 10L);
        this.timeBuffer.append(l4 % 10L);
        this.timeBuffer.append(':');
        this.timeBuffer.append(l5 / 10L);
        this.timeBuffer.append(l5 % 10L);
        this.timeBuffer.append(':');
        this.timeBuffer.append(l6 / 10L);
        this.timeBuffer.append(l6 % 10L);
        this.timeBuffer.append(' ');
        if (l7 < 0L) {
            this.timeBuffer.append('-');
            l7 = -l7;
        }
        this.timeBuffer.append(l7 / 36000L % 10L);
        this.timeBuffer.append(l7 / 3600L % 10L);
        this.timeBuffer.append(l7 / 600L % 6L);
        this.timeBuffer.append(l7 / 60L % 10L);
        this.timeBuffer.append(']');
        charBuffer.append(this.timeBuffer);
    }

    AccessLog(Path path, String string) throws IOException {
        this.path = path;
        this.format = string;
        path.getParent().mkdirs();
        this.os = path.openAppend();
        this.calendar = new QDate();
        if (string == null) {
            string = "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        this.segments = this.parseFormat(string);
    }

    static class Segment {
        static final int TEXT = 0;
        int code;
        String string;
        char[] data;
        AccessLog log;

        void apply(CharBuffer charBuffer, Request request, Response response) throws IOException {
            String string = null;
            CharBuffer charBuffer2 = null;
            switch (this.code) {
                case 0: {
                    charBuffer.append(this.data);
                    break;
                }
                case 98: {
                    charBuffer.append(response.getContentLength());
                    break;
                }
                case 104: {
                    charBuffer.append(request.getRemoteAddr());
                    break;
                }
                case 105: {
                    charBuffer2 = request.getHeaderBuffer(this.string);
                    if (charBuffer2 == null) {
                        charBuffer.append('-');
                        break;
                    }
                    charBuffer.append(charBuffer2);
                    break;
                }
                case 108: {
                    charBuffer.append("-");
                    break;
                }
                case 111: {
                    string = response.getHeader(this.string);
                    if (string == null) {
                        charBuffer.append('-');
                        break;
                    }
                    charBuffer.append(string);
                    break;
                }
                case 114: {
                    charBuffer.append(request.getMethodBuffer());
                    charBuffer.append(' ');
                    charBuffer.append(request.getPageUriBuffer());
                    if (request.getPageQueryBuffer().length() > 0) {
                        charBuffer.append('?');
                        charBuffer.append(request.getPageQueryBuffer());
                    }
                    charBuffer.append(' ');
                    charBuffer.append(request.getProtocolBuffer());
                    break;
                }
                case 115: {
                    charBuffer.append(response.getStatusCode());
                    break;
                }
                case 116: {
                    this.log.printTime(charBuffer, request.getDate());
                    break;
                }
                case 117: {
                    string = request.getRemoteUser();
                    charBuffer.append(string == null ? "-" : string);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
        }

        Segment(AccessLog accessLog, int n, String string) {
            this.log = accessLog;
            this.code = n;
            this.string = string;
            if (string != null) {
                this.data = string.toCharArray();
            }
        }
    }
}

