/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.regexp;

import com.caucho.util.IntSet;

class RegexpSet {
    static final int BITSET_CHARS = 128;
    static final int BITSET_WIDTH = 16;
    static RegexpSet SPACE = null;
    static RegexpSet WORD = null;
    static RegexpSet DIGIT = null;
    static RegexpSet DOT = null;
    int[] bitset = new int[16];
    IntSet range;

    void mergeOr(RegexpSet regexpSet) {
        int n = 0;
        while (n < 16) {
            int n2 = n;
            this.bitset[n2] = this.bitset[n2] | regexpSet.bitset[n];
            ++n;
        }
        this.range.union(regexpSet.range);
    }

    void mergeOrInv(RegexpSet regexpSet) {
        int n = 0;
        while (n < 16) {
            int n2 = n;
            this.bitset[n2] = this.bitset[n2] | ~regexpSet.bitset[n];
            ++n;
        }
        this.range.unionNegate(regexpSet.range, 0, 65535);
    }

    void setRange(int n, int n2) {
        if (n > n2 || n < 0 || n2 > 65535) {
            throw new RuntimeException("Range out of range");
        }
        if (n < 128) {
            int n3 = n;
            while (n3 < Math.min(n2 + 1, 128)) {
                int n4 = n3 >> 3;
                this.bitset[n4] = this.bitset[n4] | 1 << (n3 & 7);
                ++n3;
            }
            if (n2 < 128) {
                return;
            }
            n = 128;
        }
        this.range.union(n, n2);
    }

    boolean mergeOverlap(RegexpSet regexpSet) {
        boolean bl = true;
        int n = 0;
        while (n < 16) {
            int n2 = n;
            this.bitset[n2] = this.bitset[n2] & regexpSet.bitset[n];
            if (this.bitset[n2] != 0) {
                bl = false;
            }
            ++n;
        }
        if (this.range.intersection(regexpSet.range)) {
            bl = false;
        }
        return bl;
    }

    void difference(RegexpSet regexpSet) {
        int n = 0;
        while (n < 16) {
            int n2 = n;
            this.bitset[n2] = this.bitset[n2] & ~regexpSet.bitset[n];
            ++n;
        }
        this.range.difference(regexpSet.range);
    }

    boolean match(int n) {
        if (n < 0) {
            return false;
        }
        if (n < 128) {
            return (this.bitset[n >> 3] & 1 << (n & 7)) != 0;
        }
        return this.range.contains(n);
    }

    RegexpSet() {
        this.range = new IntSet();
    }

    RegexpSet(RegexpSet regexpSet) {
        int n = 0;
        while (n < 16) {
            this.bitset[n] = regexpSet.bitset[n];
            ++n;
        }
        this.range = (IntSet)regexpSet.range.clone();
    }

    static {
        SPACE = new RegexpSet();
        SPACE.setRange(32, 32);
        SPACE.setRange(9, 13);
        DOT = new RegexpSet();
        DOT.setRange(10, 10);
        DIGIT = new RegexpSet();
        DIGIT.setRange(48, 57);
        WORD = new RegexpSet();
        WORD.setRange(97, 122);
        WORD.setRange(65, 90);
        WORD.setRange(48, 57);
        WORD.setRange(95, 95);
    }
}

