/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.regexp;

import com.caucho.regexp.IllegalRegexpException;
import com.caucho.regexp.Node;
import com.caucho.regexp.PeekStream;
import com.caucho.regexp.RegexpSet;
import com.caucho.util.CharBuffer;

class Regcomp {
    static final int MULTILINE = 1;
    static final int SINGLE_LINE = 2;
    static final int IGNORE_CASE = 4;
    static final int IGNORE_WS = 8;
    static final int GLOBAL = 16;
    int nGroup;
    int maxGroup;
    int nLoop;
    int flags;

    Node parse(PeekStream peekStream) throws IllegalRegexpException {
        this.nGroup = 0;
        Node node = this.parseRec(peekStream);
        if (this.nGroup > this.maxGroup) {
            this.maxGroup = this.nGroup;
        }
        return node;
    }

    private Node parseRec(PeekStream peekStream) throws IllegalRegexpException {
        int n;
        Node node = null;
        Node node2 = null;
        block28: while ((n = peekStream.read()) >= 0) {
            switch (n) {
                case 42: {
                    Node node3;
                    if (node2 == null) {
                        throw new IllegalRegexpException("`*' must follow content expression");
                    }
                    if (node2.code == 8) {
                        throw new IllegalRegexpException("nested *?+");
                    }
                    if (peekStream.peek() == 63) {
                        peekStream.read();
                        node3 = new Node(10, this.nLoop++, 0, Integer.MAX_VALUE);
                    } else {
                        node3 = new Node(8, this.nLoop++, 0, Integer.MAX_VALUE);
                    }
                    node3.branch = node2;
                    node2 = node3;
                    break;
                }
                case 43: {
                    Node node3;
                    if (node2 == null) {
                        throw new IllegalRegexpException("`+' must follow content expression");
                    }
                    if (node2.code == 8) {
                        throw new IllegalRegexpException("nested *?+");
                    }
                    if (peekStream.peek() == 63) {
                        peekStream.read();
                        node3 = new Node(10, this.nLoop++, 1, Integer.MAX_VALUE);
                    } else {
                        node3 = new Node(8, this.nLoop++, 1, Integer.MAX_VALUE);
                    }
                    node3.branch = node2;
                    node2 = node3;
                    break;
                }
                case 63: {
                    Node node3;
                    if (node2 == null) {
                        throw new IllegalRegexpException("`?' must follow content expression");
                    }
                    if (node2.code == 8) {
                        throw new IllegalRegexpException("nested *?+");
                    }
                    if (peekStream.peek() == 63) {
                        peekStream.read();
                        node3 = new Node(10, this.nLoop++, 0, 1);
                    } else {
                        node3 = new Node(8, this.nLoop++, 0, 1);
                    }
                    node3.branch = node2;
                    node2 = node3;
                    break;
                }
                case 123: {
                    if (node2 == null) {
                        throw new IllegalRegexpException("`{' must follow content expression");
                    }
                    if (node2.code == 8) {
                        throw new IllegalRegexpException("nested *?+");
                    }
                    Node node3 = new Node(8);
                    ++this.nLoop;
                    node3.index = node3.index;
                    node3.branch = node2;
                    this.parseBrace(peekStream, node3);
                    n = peekStream.read();
                    if (n != 125) {
                        throw new IllegalRegexpException("expected `}' at " + this.badChar(n));
                    }
                    if (peekStream.peek() == 63) {
                        peekStream.read();
                        node3.code = 10;
                    }
                    node2 = node3;
                    break;
                }
                case 124: {
                    node = new Node(13, Node.concat(node, node2));
                    node2 = null;
                    break;
                }
                case 40: {
                    Node node3;
                    node = Node.concat(node, node2);
                    if (peekStream.peek() == 63) {
                        peekStream.read();
                        n = peekStream.read();
                        switch (n) {
                            case 35: {
                                while ((n = peekStream.read()) >= 0 && n != 41) {
                                }
                                peekStream.ungetc(n);
                                node2 = null;
                                break;
                            }
                            case 58: {
                                node2 = this.parseRec(peekStream);
                                node2 = Node.replaceTail(node2, new Node(1));
                                break;
                            }
                            case 61: {
                                node2 = new Node(15, this.parseRec(peekStream));
                                break;
                            }
                            case 33: {
                                node2 = new Node(16, this.parseRec(peekStream));
                                break;
                            }
                            case 103: 
                            case 105: 
                            case 109: 
                            case 115: 
                            case 120: {
                                do {
                                    switch (n) {
                                        case 109: {
                                            this.flags |= 1;
                                            break;
                                        }
                                        case 105: {
                                            this.flags |= 4;
                                            break;
                                        }
                                        case 115: {
                                            this.flags |= 2;
                                            break;
                                        }
                                        case 120: {
                                            this.flags |= 8;
                                            break;
                                        }
                                        case 103: {
                                            this.flags |= 0x10;
                                            break;
                                        }
                                        default: {
                                            throw new IllegalRegexpException("expected one of `misxg' at " + this.badChar(n));
                                        }
                                    }
                                } while ((n = peekStream.read()) >= 0 && n != 41);
                                peekStream.ungetc(n);
                                node2 = null;
                                break;
                            }
                            default: {
                                throw new IllegalRegexpException("expected `(?' code at " + this.badChar(n));
                            }
                        }
                    } else {
                        int n2 = ++this.nGroup;
                        node2 = new Node(5, n2);
                        node2.rest = this.parseRec(peekStream);
                        node3 = new Node(6, n2);
                        node2 = Node.replaceTail(node2, node3);
                    }
                    n = peekStream.read();
                    if (n == 41) continue block28;
                    throw new IllegalRegexpException("expected `)' at " + this.badChar(n));
                }
                case 41: {
                    peekStream.ungetc(n);
                    return Node.concat(node, node2);
                }
                case 91: {
                    node = Node.concat(node, node2);
                    node2 = this.parseSet(peekStream);
                    n = peekStream.read();
                    if (n == 93) continue block28;
                    throw new IllegalRegexpException("expected `]' at " + this.badChar(n));
                }
                case 46: {
                    node = Node.concat(node, node2);
                    if ((this.flags & 2) == 0) {
                        node2 = new Node(4, RegexpSet.DOT);
                        break;
                    }
                    node2 = new Node(4, new RegexpSet());
                    break;
                }
                case 92: {
                    Node node4 = this.parseSlash(peekStream, node2);
                    if (node4 != node2) {
                        node = Node.concat(node, node2);
                    }
                    node2 = node4;
                    break;
                }
                case 94: {
                    node = Node.concat(node, node2);
                    if ((this.flags & 1) != 0) {
                        node2 = new Node(19);
                        break;
                    }
                    node2 = new Node(21);
                    break;
                }
                case 36: {
                    node = Node.concat(node, node2);
                    if ((this.flags & 1) != 0) {
                        node2 = new Node(20);
                        break;
                    }
                    node2 = new Node(22);
                    break;
                }
                default: {
                    Node node5 = this.parseString(n, peekStream, node2);
                    if (node5 == node2) continue block28;
                    node = Node.concat(node, node2);
                    node2 = node5;
                    break;
                }
            }
        }
        return Node.concat(node, node2);
    }

    private void parseBrace(PeekStream peekStream, Node node) {
        int n;
        node.min = 0;
        while ((n = peekStream.read()) >= 48 && n <= 57) {
            node.min = 10 * node.min + n - 48;
        }
        if (n != 44) {
            node.max = node.min;
            peekStream.ungetc(n);
            return;
        }
        node.max = Integer.MAX_VALUE;
        while ((n = peekStream.read()) >= 48 && n <= 57) {
            node.max = node.max == Integer.MAX_VALUE ? 0 : node.max;
            node.max = 10 * node.max + n - 48;
        }
        peekStream.ungetc(n);
    }

    private String hex(int n) {
        CharBuffer charBuffer = new CharBuffer();
        int n2 = 3;
        while (n2 >= 0) {
            int n3 = n >> 4 * n2 & 0xF;
            if (n3 < 10) {
                charBuffer.append((char)(n3 + 48));
            } else {
                charBuffer.append((char)(n3 - 10 + 97));
            }
            --n2;
        }
        return charBuffer.toString();
    }

    private String badChar(int n) {
        if (n >= 32 && n <= 127) {
            return "`" + (char)n + "'";
        }
        if ((n & 0xFFFF) == 65535) {
            return "end of expression";
        }
        return "`" + (char)n + "' (\\u" + this.hex(n) + ")";
    }

    private Node parseSet(PeekStream peekStream) throws IllegalRegexpException {
        int n;
        RegexpSet regexpSet;
        Node node;
        if (peekStream.peek() == 94) {
            peekStream.read();
            node = new Node(4);
        } else {
            node = new Node(3);
        }
        node.set = regexpSet = new RegexpSet();
        int n2 = -1;
        int n3 = -1;
        while ((n = peekStream.read()) != 93 && n >= 0) {
            boolean bl;
            boolean bl2 = true;
            boolean bl3 = bl = n == 45;
            if (n == 92) {
                bl2 = false;
                n = peekStream.read();
                switch (n) {
                    case 115: {
                        regexpSet.mergeOr(RegexpSet.SPACE);
                        break;
                    }
                    case 83: {
                        regexpSet.mergeOrInv(RegexpSet.SPACE);
                        break;
                    }
                    case 100: {
                        regexpSet.mergeOr(RegexpSet.DIGIT);
                        break;
                    }
                    case 68: {
                        regexpSet.mergeOrInv(RegexpSet.DIGIT);
                        break;
                    }
                    case 119: {
                        regexpSet.mergeOr(RegexpSet.WORD);
                        break;
                    }
                    case 87: {
                        regexpSet.mergeOrInv(RegexpSet.WORD);
                        break;
                    }
                    case 98: {
                        n = 8;
                        bl2 = true;
                        break;
                    }
                    default: {
                        bl2 = true;
                    }
                }
            }
            if (bl && n2 != -1 && n3 == -1) {
                n3 = n2;
                continue;
            }
            if (bl2 && n3 != -1) {
                if (n3 > n) {
                    throw new IllegalRegexpException("expected increasing range at " + this.badChar(n));
                }
                regexpSet.setRange(n3, n);
                n2 = -1;
                n3 = -1;
                continue;
            }
            if (n3 != -1) {
                regexpSet.setRange(n3, n3);
                regexpSet.setRange(45, 45);
                n2 = -1;
                n3 = -1;
                continue;
            }
            if (n2 != -1) {
                regexpSet.setRange(n2, n2);
                if (!bl2) continue;
                n2 = n;
                continue;
            }
            if (!bl2) continue;
            n2 = n;
        }
        if (n3 != -1) {
            regexpSet.setRange(n3, n3);
            regexpSet.setRange(45, 45);
        } else if (n2 != -1) {
            regexpSet.setRange(n2, n2);
        }
        if (n == 93) {
            peekStream.ungetc(n);
        }
        return node;
    }

    private Node parseString(int n, PeekStream peekStream, Node node) throws IllegalRegexpException {
        if ((this.flags & 8) != 0 && RegexpSet.SPACE.match(n)) {
            return node;
        }
        int n2 = peekStream.read();
        if (node == null || node.code != 2 || n2 == 42 || n2 == 63 || n2 == 123 || n2 == 43) {
            node = new Node(new CharBuffer());
        }
        node.string.append((char)n);
        if (n2 != -1) {
            peekStream.ungetc(n2);
        }
        return node;
    }

    private Node parseSlash(PeekStream peekStream, Node node) throws IllegalRegexpException {
        int n = peekStream.read();
        switch (n) {
            case 115: {
                return new Node(3, new RegexpSet(RegexpSet.SPACE));
            }
            case 83: {
                return new Node(4, new RegexpSet(RegexpSet.SPACE));
            }
            case 100: {
                return new Node(3, new RegexpSet(RegexpSet.DIGIT));
            }
            case 68: {
                return new Node(4, new RegexpSet(RegexpSet.DIGIT));
            }
            case 119: {
                return new Node(3, new RegexpSet(RegexpSet.WORD));
            }
            case 87: {
                return new Node(4, new RegexpSet(RegexpSet.WORD));
            }
            case 98: {
                return new Node(17);
            }
            case 66: {
                return new Node(18);
            }
            case 65: {
                return new Node(21);
            }
            case 90: {
                return new Node(22);
            }
            case 71: {
                return new Node(23);
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int n2 = n - 48;
                int n3 = n - 48;
                boolean bl = n >= 56;
                while ((n = peekStream.read()) >= 48 && n <= 57) {
                    n2 = 10 * n2 + n - 48;
                    n3 = 8 * n3 + n - 48;
                    if (n < 56) continue;
                    bl = true;
                }
                if (n != -1) {
                    peekStream.ungetc(n);
                }
                if (n2 <= this.nGroup) {
                    return new Node(7, n2);
                }
                if (bl) {
                    throw new IllegalRegexpException("expected octal digit at " + this.badChar(n));
                }
                return this.parseString(n3, peekStream, node);
            }
        }
        return this.parseString(n, peekStream, node);
    }

    Regcomp(int n) {
        this.flags = n;
    }
}

