/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.regexp;

import com.caucho.regexp.Node;
import com.caucho.regexp.RegexpSet;
import com.caucho.util.CharBuffer;

class RegOptim {
    static void ignoreCase(Node node) {
        while (node != null) {
            switch (node.code) {
                case 3: {
                    node.code = 25;
                    break;
                }
                case 4: {
                    node.code = 26;
                    break;
                }
                case 2: {
                    node.code = 24;
                    break;
                }
                case 7: {
                    node.code = 27;
                    break;
                }
            }
            RegOptim.ignoreCase(node.branch);
            node = node.rest;
        }
    }

    static int minLength(Node node) {
        if (node == null) {
            return 0;
        }
        switch (node.code) {
            case 3: 
            case 4: 
            case 25: 
            case 26: {
                return 1 + RegOptim.minLength(node.rest);
            }
            case 2: 
            case 24: {
                return node.string.length() + RegOptim.minLength(node.rest);
            }
            case 13: 
            case 14: {
                return Math.min(RegOptim.minLength(node.branch), RegOptim.minLength(node.rest));
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                return node.min * RegOptim.minLength(node.branch) + RegOptim.minLength(node.rest);
            }
        }
        return RegOptim.minLength(node.rest);
    }

    static CharBuffer prefix(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.code) {
            case 5: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return RegOptim.prefix(node.rest);
            }
            case 15: {
                return RegOptim.prefix(node.branch);
            }
            case 2: 
            case 24: {
                return node.string;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                if (node.min > 0) {
                    return RegOptim.prefix(node.branch);
                }
                return null;
            }
        }
        return null;
    }

    private static CharBuffer findMust(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.code) {
            case 2: {
                CharBuffer charBuffer = RegOptim.findMust(node.rest);
                return charBuffer != null ? charBuffer : node.string;
            }
            case 13: 
            case 14: {
                CharBuffer charBuffer = RegOptim.findMust(node.branch);
                CharBuffer charBuffer2 = RegOptim.findMust(node.rest);
                if (charBuffer != null && charBuffer2 != null && charBuffer.equals(charBuffer2)) {
                    return charBuffer;
                }
                return null;
            }
            case 8: 
            case 10: 
            case 11: {
                CharBuffer charBuffer = RegOptim.findMust(node.rest);
                if (charBuffer != null) {
                    return charBuffer;
                }
                if (node.min > 0) {
                    return RegOptim.findMust(node.branch);
                }
                return null;
            }
            case 15: {
                CharBuffer charBuffer = RegOptim.findMust(node.rest);
                if (charBuffer != null) {
                    return charBuffer;
                }
                return RegOptim.findMust(node.branch);
            }
        }
        return RegOptim.findMust(node.rest);
    }

    private static Node linkLoops(Node node, Node node2, boolean bl) {
        if (node == null && node2 != null && bl) {
            if (node2.min > 0) {
                node2.min = 1;
            }
            return node2;
        }
        if (node == null) {
            return node2;
        }
        switch (node.code) {
            case 0: 
            case 1: {
                return RegOptim.linkLoops(node.rest, node2, bl);
            }
            case 13: 
            case 14: {
                if (node.mark) {
                    return node;
                }
                node.mark = true;
                node.branch = RegOptim.linkLoops(node.branch, node2, bl);
                node.rest = RegOptim.linkLoops(node.rest, node2, bl);
                return node;
            }
            case 8: 
            case 10: 
            case 11: {
                if (node.mark) {
                    if (bl && node.min > 0) {
                        node.min = 1;
                    }
                    return node;
                }
                node.mark = true;
                node.branch = RegOptim.linkLoops(node.branch, node, true);
                node.rest = RegOptim.linkLoops(node.rest, node2, bl);
                Node node3 = new Node(9);
                node3.rest = node;
                return node3;
            }
            case 2: 
            case 3: 
            case 4: 
            case 24: 
            case 25: 
            case 26: {
                node.rest = RegOptim.linkLoops(node.rest, node2, false);
                return node;
            }
        }
        node.rest = RegOptim.linkLoops(node.rest, node2, bl);
        return node;
    }

    static Node linkLoops(Node node) {
        return RegOptim.linkLoops(node, null, true);
    }

    static void eliminateBacktrack(Node node, Node node2) {
        if (node == null) {
            return;
        }
        switch (node.code) {
            case 10: {
                RegOptim.eliminateBacktrack(node.branch, node.rest);
                RegOptim.eliminateBacktrack(node.rest, node2);
                if (RegOptim.firstset(node.branch, null) && node.min > 0) {
                    node.min = 1;
                }
                return;
            }
            case 8: {
                RegOptim.eliminateBacktrack(node.branch, node.rest);
                RegOptim.eliminateBacktrack(node.rest, node2);
                RegexpSet regexpSet = new RegexpSet();
                if (RegOptim.firstset(node.branch, regexpSet) && node.min > 0) {
                    node.min = 0;
                }
                RegexpSet regexpSet2 = new RegexpSet();
                boolean bl = false;
                if (RegOptim.firstset(node.rest, regexpSet2)) {
                    bl = true;
                    RegOptim.firstset(node2, regexpSet2);
                }
                if (!bl) {
                    if (regexpSet2.mergeOverlap(regexpSet)) {
                        node.code = 11;
                        node.set = regexpSet;
                    } else {
                        regexpSet.difference(regexpSet2);
                        node.set = regexpSet;
                    }
                }
                return;
            }
            case 13: 
            case 14: {
                RegexpSet regexpSet;
                RegOptim.eliminateBacktrack(node.branch, node2);
                RegOptim.eliminateBacktrack(node.rest, node2);
                boolean bl = false;
                RegexpSet regexpSet3 = new RegexpSet();
                if (RegOptim.firstset(node.branch, regexpSet3)) {
                    bl = RegOptim.firstset(node2, regexpSet3);
                }
                if (RegOptim.firstset(node.rest, regexpSet = new RegexpSet())) {
                    RegOptim.firstset(node2, regexpSet);
                }
                if (!bl && regexpSet.mergeOverlap(regexpSet3)) {
                    node.code = 14;
                    node.set = regexpSet3;
                }
                return;
            }
            case 15: 
            case 16: {
                RegOptim.eliminateBacktrack(node.branch, node2);
                RegOptim.eliminateBacktrack(node.rest, node2);
                return;
            }
        }
        RegOptim.eliminateBacktrack(node.rest, node2);
    }

    private static boolean firstset(Node node, RegexpSet regexpSet) {
        if (node == null) {
            return true;
        }
        switch (node.code) {
            case 2: {
                char c = node.string.charAt(0);
                if (regexpSet != null) {
                    regexpSet.setRange(c, c);
                }
                return false;
            }
            case 3: {
                if (regexpSet != null) {
                    regexpSet.mergeOr(node.set);
                }
                return false;
            }
            case 4: {
                if (regexpSet != null) {
                    regexpSet.mergeOrInv(node.set);
                }
                return false;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                if (RegOptim.firstset(node.branch, regexpSet)) {
                    if (node.min > 0) {
                        node.min = 1;
                    }
                    return RegOptim.firstset(node.rest, regexpSet);
                }
                if (node.min == 0) {
                    boolean bl = RegOptim.firstset(node.rest, regexpSet);
                    return bl;
                }
                return false;
            }
            case 13: 
            case 14: {
                if (RegOptim.firstset(node.branch, regexpSet)) {
                    RegOptim.firstset(node.rest, regexpSet);
                    return true;
                }
                return RegOptim.firstset(node.rest, regexpSet);
            }
            case 15: {
                RegexpSet regexpSet2 = new RegexpSet();
                boolean bl = RegOptim.firstset(node.rest, regexpSet);
                if (regexpSet != null && RegOptim.firstset(node.branch, regexpSet2)) {
                    regexpSet.mergeOr(regexpSet2);
                } else {
                    regexpSet.mergeOverlap(regexpSet2);
                }
                return bl;
            }
        }
        return RegOptim.firstset(node.rest, regexpSet);
    }

    static Node appendLexemeValue(Node node, int n) {
        if (node == null || node.code == 0 || node.code == 28) {
            node = new Node(28, n);
            node.rest = null;
            return node;
        }
        node.rest = RegOptim.appendLexemeValue(node.rest, n);
        if (node.code == 13) {
            node.branch = RegOptim.appendLexemeValue(node.branch, n);
        }
        return node;
    }

    static Node appendLexeme(Node node, Node node2, int n) {
        node2 = RegOptim.appendLexemeValue(node2, n);
        if (node == null) {
            return node2;
        }
        node = new Node(13, node);
        node.rest = node2;
        return node;
    }

    RegOptim() {
    }
}

