/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.CompileClassNotFound;
import com.caucho.java.JavaCompiler;
import com.caucho.regexp.Regexp;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.DynamicClassLoader;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;

public class CompilingClassLoader
extends DynamicClassLoader {
    private static WriteStream dbg = LogStream.open("/caucho.com/java/loader");
    private Path sourceDir;
    private Path classDir;
    private ArrayList args;
    private String encoding;

    public static CompilingClassLoader create(ClassLoader classLoader, Path path, Path path2, String string, String string2) {
        CompilingClassLoader compilingClassLoader;
        block8: {
            block7: {
                try {
                    compilingClassLoader = new CompilingClassLoader(classLoader);
                }
                catch (Error error) {
                    compilingClassLoader = new CompilingClassLoader();
                    compilingClassLoader.setParent(classLoader);
                }
                compilingClassLoader.sourceDir = path2;
                compilingClassLoader.classDir = path;
                try {
                    path.mkdirs();
                }
                catch (IOException iOException) {
                    if (!dbg.canWrite()) break block7;
                    dbg.log(iOException);
                }
            }
            compilingClassLoader.encoding = string2;
            try {
                if (string != null) {
                    compilingClassLoader.args = new Regexp("[\\s,]+").split(string);
                }
            }
            catch (Exception exception) {
                if (!dbg.canWrite()) break block8;
                dbg.log(exception);
            }
        }
        return compilingClassLoader;
    }

    public static CompilingClassLoader create(ClassLoader classLoader, Path path, Path path2, String string) {
        return CompilingClassLoader.create(classLoader, path, path2, null, string);
    }

    public synchronized void makeAll() throws Exception {
        super.makeAll();
        this.makeAll("", this.sourceDir, this.classDir);
    }

    private void makeAll(String string, Path path, Path path2) throws Exception {
        String[] stringArray;
        try {
            stringArray = path.list();
        }
        catch (IOException iOException) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            Path path3 = path.lookup(stringArray[n]);
            if (path3.isDirectory()) {
                this.makeAll(string + stringArray[n] + "/", path3, path2.lookup(stringArray[n]));
            } else if (stringArray[n].endsWith(".java")) {
                String string2 = stringArray[n].substring(0, stringArray[n].length() - 5);
                Path path4 = path2.lookup(string2 + ".class");
                if (path3.getLastModified() > path4.getLastModified()) {
                    this.compileClass(path3, path4);
                }
            }
            ++n;
        }
    }

    public DynamicClassLoader.Entry getClassEntry(String string) throws ClassNotFoundException {
        long l;
        Path path = this.classDir.lookup(string.replace('.', '/') + ".class");
        Path path2 = this.sourceDir.lookup(string.replace('.', '/') + ".java");
        if (path2.getLastModified() > path.getLastModified()) {
            this.compileClass(path2, path);
        }
        if ((l = path.getLength()) > 0L) {
            return new DynamicClassLoader.Entry(path2, path);
        }
        return super.getClassEntry(string);
    }

    private void compileClass(Path path, Path path2) throws ClassNotFoundException {
        try {
            super.makeAll();
            if (dbg.canWrite()) {
                dbg.log("compiling " + path);
            }
            JavaCompiler javaCompiler = new JavaCompiler(this, this.getClassPath(), this.sourceDir.getNativePath(), this.classDir);
            javaCompiler.setEncoding(this.encoding);
            javaCompiler.setArgs(this.args);
            String string = this.sourceDir.getPath();
            String string2 = path.getPath();
            String string3 = string2.startsWith(string) ? string2.substring(string.length() + 1) : path.getPath();
            if (path.canRead() && path2.exists()) {
                path2.remove();
            }
            javaCompiler.compile(string3, null);
        }
        catch (Exception exception) {
            throw new CompileClassNotFound(exception);
        }
    }

    protected Path getPath(String string) {
        Path path = this.classDir.lookup(string);
        if (path != null && path.exists()) {
            return path;
        }
        path = this.sourceDir.lookup("./" + string);
        if (path != null && path.exists()) {
            return path;
        }
        return null;
    }

    protected String fillClassPath() {
        CharBuffer charBuffer = new CharBuffer();
        if (this.classDir.isDirectory()) {
            charBuffer.append(this.classDir.getNativePath());
            charBuffer.append(CauchoSystem.getPathSeparatorChar());
        }
        charBuffer.append(super.fillClassPath());
        return charBuffer.toString();
    }

    protected CompilingClassLoader() {
    }

    protected CompilingClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }
}

