/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.eswrap.java.sql;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.Global;
import com.caucho.util.NullIterator;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;

public class ResultSetEcmaWrap {
    private static WriteStream dbg = LogStream.open("/caucho.com/sql");

    public static String getString(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getString(eSBase2.toString());
        }
        return resultSet.getString((int)eSBase2.toNum());
    }

    public static boolean getBoolean(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getBoolean(eSBase2.toString());
        }
        return resultSet.getBoolean((int)eSBase2.toNum());
    }

    public static byte getByte(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getByte(eSBase2.toString());
        }
        return resultSet.getByte((int)eSBase2.toNum());
    }

    public static short getShort(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getShort(eSBase2.toString());
        }
        return resultSet.getShort((int)eSBase2.toNum());
    }

    public static int getInt(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getInt(eSBase2.toString());
        }
        return resultSet.getInt((int)eSBase2.toNum());
    }

    public static long getLong(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getLong(eSBase2.toString());
        }
        return resultSet.getLong((int)eSBase2.toNum());
    }

    public static float getFloat(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getFloat(eSBase2.toString());
        }
        return resultSet.getFloat((int)eSBase2.toNum());
    }

    public static double getDouble(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getDouble(eSBase2.toString());
        }
        return resultSet.getDouble((int)eSBase2.toNum());
    }

    public static BigDecimal getBigDecimal(ResultSet resultSet, ESBase eSBase, int n) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getBigDecimal(eSBase2.toString(), n);
        }
        return resultSet.getBigDecimal((int)eSBase2.toNum(), n);
    }

    public static byte[] getBytes(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getBytes(eSBase2.toString());
        }
        return resultSet.getBytes((int)eSBase2.toNum());
    }

    public static ESBase getDate(ResultSet resultSet, Call call, int n) throws Exception {
        ESBase eSBase = call.getArg(0, n);
        ESBase eSBase2 = eSBase.toPrimitive();
        java.sql.Date date = eSBase2.isString() ? resultSet.getDate(eSBase2.toString()) : resultSet.getDate((int)eSBase2.toNum());
        return call.createDate(date.getTime());
    }

    public static ESBase getTime(ResultSet resultSet, Call call, int n) throws Exception {
        ESBase eSBase = call.getArg(0, n);
        ESBase eSBase2 = eSBase.toPrimitive();
        Time time = eSBase2.isString() ? resultSet.getTime(eSBase2.toString()) : resultSet.getTime((int)eSBase2.toNum());
        return call.createDate(time.getTime());
    }

    public static ESBase getTimestamp(ResultSet resultSet, Call call, int n) throws Exception {
        ESBase eSBase = call.getArg(0, n);
        ESBase eSBase2 = eSBase.toPrimitive();
        Timestamp timestamp = eSBase2.isString() ? resultSet.getTimestamp(eSBase2.toString()) : resultSet.getTimestamp((int)eSBase2.toNum());
        return call.createDate(((Date)timestamp).getTime());
    }

    public static InputStream getAsciiStream(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getAsciiStream(eSBase2.toString());
        }
        return resultSet.getAsciiStream((int)eSBase2.toNum());
    }

    public static InputStream getUnicodeStream(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getUnicodeStream(eSBase2.toString());
        }
        return resultSet.getUnicodeStream((int)eSBase2.toNum());
    }

    public static InputStream getBinaryStream(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getBinaryStream(eSBase2.toString());
        }
        return resultSet.getBinaryStream((int)eSBase2.toNum());
    }

    public static Object getObject(ResultSet resultSet, ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive();
        if (eSBase2.isString()) {
            return resultSet.getObject(eSBase2.toString());
        }
        return resultSet.getObject((int)eSBase2.toNum());
    }

    public static String getByname(ResultSet resultSet, String string) throws SQLException {
        return resultSet.getString(string);
    }

    private static Object get(ResultSet resultSet, Call call, int n, ResultSetMetaData resultSetMetaData) throws Exception {
        switch (resultSetMetaData.getColumnType(n)) {
            case -7: {
                return new Boolean(resultSet.getInt(n) == 1);
            }
            case -6: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new Double(resultSet.getDouble(n));
            }
            case 1: 
            case 12: {
                return resultSet.getString(n);
            }
            case 0: {
                return null;
            }
            case -5: 
            case 2: 
            case 3: {
                return resultSet.getString(n);
            }
            case -1: {
                return resultSet.getAsciiStream(n);
            }
            case 91: {
                return call.createDate(resultSet.getDate(n).getTime());
            }
            case 92: {
                return call.createDate(resultSet.getTime(n).getTime());
            }
            case 93: {
                return call.createDate(((Date)resultSet.getTimestamp(n)).getTime());
            }
            case -3: 
            case -2: {
                return resultSet.getBytes(n);
            }
            case -4: {
                return resultSet.getBinaryStream(n);
            }
        }
        return resultSet.getString(n);
    }

    public static Object get(ResultSet resultSet, Call call, int n) throws Exception {
        ESBase eSBase = call.getArg(0, n).toPrimitive();
        int n2 = eSBase.isString() ? resultSet.findColumn(eSBase.toString()) : (int)eSBase.toNum();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        return ResultSetEcmaWrap.get(resultSet, call, n2, resultSetMetaData);
    }

    public static Object toObject(ResultSet resultSet, Call call, int n) throws Exception {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Global global = Global.getGlobalProto();
        ESBase eSBase = n > 0 ? call.getArg(0, n) : global.createObject();
        int n2 = resultSetMetaData.getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            String string = resultSetMetaData.getColumnName(n3 + 1);
            Object object = ResultSetEcmaWrap.get(resultSet, call, n3 + 1, resultSetMetaData);
            eSBase.setProperty(string, Global.wrap(object));
            ++n3;
        }
        return eSBase;
    }

    public static Iterator keys(ResultSet resultSet) {
        try {
            return new ResultSetIterator(resultSet);
        }
        catch (Exception exception) {
            return NullIterator.create();
        }
    }

    private ResultSetEcmaWrap() {
    }

    static class ResultSetIterator
    implements Iterator {
        ResultSet rs;
        ResultSetMetaData md;
        int nColumns;
        int i;

        public boolean hasNext() {
            return this.i < this.nColumns;
        }

        public Object next() {
            try {
                return this.md.getColumnName(++this.i);
            }
            catch (SQLException sQLException) {
                return null;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        ResultSetIterator(ResultSet resultSet) throws SQLException {
            this.rs = resultSet;
            this.md = resultSet.getMetaData();
            this.nColumns = this.md.getColumnCount();
        }
    }
}

