/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.wrapper;

import com.caucho.es.ESArrayWrapper;
import com.caucho.es.ESBase;
import com.caucho.es.ESBeanWrapper;
import com.caucho.es.ESJavaWrapper;
import com.caucho.es.Global;
import com.caucho.es.wrapper.ESBeanInfo;
import com.caucho.es.wrapper.ESIndexedPropertyDescriptor;
import com.caucho.es.wrapper.ESIntrospector;
import com.caucho.es.wrapper.ESMethodDescriptor;
import com.caucho.es.wrapper.ESPropertyDescriptor;
import com.caucho.es.wrapper.NamedPropertyDescriptor;
import com.caucho.java.JavaCompiler;
import com.caucho.util.CauchoSystem;
import com.caucho.util.IntMap;
import com.caucho.util.SimpleClassLoader;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Wrapper {
    private static Integer LOCK = new Integer(0);
    private static WriteStream dbg = LogStream.open("/caucho.com/es/wrapper");
    static HashMap classNames = new HashMap();
    static IntMap classTypes;
    static final int T_V = 0;
    static final int T_Z = 1;
    static final int T_B = 2;
    static final int T_S = 3;
    static final int T_C = 4;
    static final int T_I = 5;
    static final int T_L = 6;
    static final int T_F = 7;
    static final int T_D = 8;
    static final int T_STRING = 9;
    private String name;
    private Class cl;
    private boolean isPublic;
    private Path dest;
    private WriteStream os;
    private ClassLoader loader;
    private JavaCompiler compiler;
    private ESBeanInfo beanInfo;
    private IntMap hasDispatch;
    private IntMap staticHasDispatch;
    private IntMap setDispatch;
    private IntMap staticSetDispatch;
    private IntMap methodDispatch;
    private IntMap staticMethodDispatch;
    private HashMap namedProperties;
    private int depth;
    private boolean isNewline;
    private Class esBase;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ESBase[] bean(Global global, Class clazz) {
        Wrapper wrapper = null;
        try {
            if (clazz.isArray()) {
                ESJavaWrapper eSJavaWrapper = ESArrayWrapper.wrapper(global, clazz);
                return new ESBase[]{eSJavaWrapper.getProperty("CONSTRUCTOR"), eSJavaWrapper};
            }
            Integer n = LOCK;
            synchronized (n) {
                wrapper = new Wrapper(global, clazz);
                ESBeanWrapper eSBeanWrapper = wrapper.wrap();
                eSBeanWrapper.n = 0;
                return new ESBase[]{eSBeanWrapper.wrapStatic(), eSBeanWrapper};
            }
        }
        catch (Exception exception) {
            if (!dbg.canWrite()) return null;
            dbg.log(exception);
            return null;
        }
    }

    private ESBeanWrapper wrap() throws Exception {
        ESBeanWrapper eSBeanWrapper;
        this.dest.getParent().mkdirs();
        Path path = CauchoSystem.getWorkPath();
        Path path2 = path.lookup(this.name.replace('.', '/') + ".class");
        SimpleClassLoader simpleClassLoader = SimpleClassLoader.create(this.loader, CauchoSystem.getWorkPath(), this.name);
        long l = path2.getLastModified();
        if (l != 0L && l >= this.getSourceLastModified(this.cl)) {
            try {
                eSBeanWrapper = (ESBeanWrapper)simpleClassLoader.loadClass(this.name).newInstance();
                if (eSBeanWrapper.getVersionId() == CauchoSystem.getVersionId()) {
                    return eSBeanWrapper;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        path2.remove();
        this.os = this.dest.openWrite();
        this.beanInfo = ESIntrospector.getBeanInfo(this.cl);
        try {
            this.printHeader();
            this.printConstructors();
            this.printHasProperty();
            this.printSetProperty();
            this.printKeys();
            this.printDeletes();
            this.printMethods();
            this.printInit();
            this.printFooter();
        }
        finally {
            Object var8_8 = null;
            this.os.close();
        }
        this.compiler.compile(this.name.replace('.', '/') + ".java", null);
        eSBeanWrapper = (ESBeanWrapper)simpleClassLoader.loadClass(this.name).newInstance();
        return eSBeanWrapper;
    }

    private long getSourceLastModified(Class clazz) {
        String string;
        long l = 0L;
        URL uRL = null;
        String string2 = clazz.getName().replace('.', '/') + ".class";
        if (this.loader != null) {
            uRL = this.loader.getResource(string2);
        }
        String string3 = string = uRL != null ? uRL.toExternalForm() : null;
        if (uRL == null || string.startsWith("systemresource:") || string.startsWith("jar:")) {
            return this.getClassPathLastModified(clazz);
        }
        Path path = Vfs.lookup(string);
        if (path != null && path.canRead()) {
            return path.getLastModified();
        }
        return 0L;
    }

    private long getClassPathLastModified(Class clazz) {
        Path path;
        String string;
        int n;
        String string2 = clazz.getName().replace('.', '/') + ".class";
        String string3 = System.getProperty("java.class.path");
        char c = CauchoSystem.getPathSeparatorChar();
        int n2 = 0;
        while ((n = string3.indexOf(c, n2)) >= 0) {
            string = string3.substring(n2, n);
            path = Vfs.lookupNative(string);
            if (string.endsWith(".jar") || string.endsWith(".zip")) {
                path = new JarPath(path);
            }
            if (path != null && path.lookup(string2).canRead()) {
                return path.lookup(string2).getLastModified();
            }
            n2 = n + 1;
        }
        string = string3.substring(n2);
        path = Vfs.lookupNative(string);
        if (string.endsWith(".jar") || string.endsWith(".zip")) {
            path = new JarPath(path);
        }
        if (path != null && path.lookup(string2).canRead()) {
            return path.lookup(string2).getLastModified();
        }
        return 0L;
    }

    private void printHeader() throws IOException {
        int n = this.name.lastIndexOf(46);
        String string = this.name.substring(0, n);
        String string2 = this.name.substring(n + 1);
        this.println("package " + string + ";");
        this.println("import com.caucho.es.*;");
        Iterator iterator = ((AbstractList)this.beanInfo.getNonPkgClasses()).iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            this.println("import " + string3 + ";");
        }
        this.println();
        this.println("public class " + string2 + " extends ESBeanWrapper {");
        this.pushDepth();
        if (this.isPublic) {
            this.println("private " + this.cl.getName() + " _value;");
        }
        this.println();
        this.println("public int getVersionId() { return " + CauchoSystem.getVersionId() + "; }");
        this.println();
        this.println("protected ESBeanWrapper dup()");
        this.println("{");
        this.println("  return new " + string2 + "();");
        this.println("}");
        this.println();
        this.println("public ESBeanWrapper wrap(Object value)");
        this.println("{");
        this.pushDepth();
        this.println("if (value == null) throw new NullPointerException();");
        this.println(this.name + " child = new " + this.name + "();");
        this.println("child.value = value;");
        if (this.isPublic) {
            this.println("child._value = (" + this.cl.getName() + ") value;");
        }
        this.println("child.hasDispatch = instanceHasDispatch;");
        this.println("child.setDispatch = instanceSetDispatch;");
        this.println("child.methodDispatch = instanceMethodDispatch;");
        this.println("child.n = -1;");
        this.println("return child;");
        this.popDepth();
        this.println("}");
        this.println();
        this.println("public ESBeanWrapper wrapStatic()");
        this.println("{");
        this.pushDepth();
        this.println(this.name + " child = new " + this.name + "();");
        this.println("child.hasDispatch = staticHasDispatch;");
        this.println("child.setDispatch = staticSetDispatch;");
        this.println("child.methodDispatch = staticMethodDispatch;");
        this.println("child.n = -2;");
        this.println("child.name = \"" + this.cl.getName() + "\";");
        this.println("return child;");
        this.popDepth();
        this.println("}");
    }

    private void printConstructors() throws IOException {
        this.println();
        this.println("public ESBase construct(Call call, int length)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("if (n != -2)");
        this.println("  throw new ESException(\"can't create `" + this.cl.getName() + "'\");");
        this.println();
        ArrayList arrayList = this.beanInfo.getConstructors();
        if (arrayList == null || arrayList.size() == 0) {
            this.println("  throw new ESException(\"can't create `" + this.cl.getName() + "'\");");
        } else {
            Constructor constructor = null;
            int n = 0;
            while (n < arrayList.size()) {
                if (arrayList.get(n) instanceof Constructor) {
                    constructor = (Constructor)arrayList.get(n);
                }
                ++n;
            }
            n = 0;
            while (n < arrayList.size()) {
                Object e = arrayList.get(n);
                if (e instanceof Constructor) {
                    Constructor constructor2 = (Constructor)e;
                    if (constructor2 != constructor) {
                        this.println("if (length <= " + n + ")");
                        this.print("  ");
                    }
                    this.print("return wrap(new " + this.cl.getName() + "(");
                    Class<?>[] classArray = constructor2.getParameterTypes();
                    int n2 = 0;
                    while (n2 < classArray.length) {
                        if (n2 > 0) {
                            this.print(", ");
                        }
                        this.printArgToJava(classArray[n2], n2);
                        ++n2;
                    }
                    this.println("));");
                }
                ++n;
            }
            if (constructor == null) {
                this.println("throw new ESException(\"can't create `" + this.cl.getName() + "'\");");
            }
        }
        this.popDepth();
        this.println("}");
    }

    private void printHasProperty() throws IOException {
        this.println();
        this.println("public ESBase hasProperty(ESString name)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("ESBase temp;");
        this.println("switch (hasDispatch.get(name)) {");
        PropertyDescriptor[] propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
        int n = 1;
        int n2 = 0;
        while (n2 < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n2] instanceof NamedPropertyDescriptor) {
                n = this.doHasNamedProperty(n, (NamedPropertyDescriptor)propertyDescriptorArray[n2]);
            } else if (propertyDescriptorArray[n2] instanceof ESIndexedPropertyDescriptor) {
                n = this.doHasIndexProperty(n, (ESIndexedPropertyDescriptor)propertyDescriptorArray[n2]);
            } else if (propertyDescriptorArray[n2] instanceof ESPropertyDescriptor) {
                n = this.doHasProperty(n, (ESPropertyDescriptor)propertyDescriptorArray[n2]);
            } else {
                throw new RuntimeException();
            }
            ++n2;
        }
        this.println("default:");
        this.println("  return ESBase.esEmpty;");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private int doHasIndexProperty(int n, ESIndexedPropertyDescriptor eSIndexedPropertyDescriptor) throws IOException {
        Class<?> clazz;
        Method method;
        Named named = new Named(eSIndexedPropertyDescriptor.getName(), this.namedProperties.size());
        int n2 = named.n;
        this.namedProperties.put(eSIndexedPropertyDescriptor.getName(), named);
        this.hasDispatch.put(eSIndexedPropertyDescriptor.getName(), n);
        this.println("case " + n + ":");
        this.pushDepth();
        this.println("if (name" + n2 + " == null) {");
        this.println("  name" + n2 + " = new " + this.name + "();");
        this.println("  name" + n2 + ".value = value;");
        if (this.isPublic) {
            this.println("  name" + n2 + "._value = _value;");
        }
        this.println("  name" + n2 + ".hasDispatch = has" + n2 + ";");
        this.println("  name" + n2 + ".setDispatch = set" + n2 + ";");
        this.println("  name" + n2 + ".delId = " + n2 + ";");
        this.println("}");
        this.println("return name" + n2 + ";");
        this.popDepth();
        ++n;
        ESMethodDescriptor eSMethodDescriptor = eSIndexedPropertyDescriptor.getESReadMethod();
        if (eSMethodDescriptor == null) {
            return n;
        }
        this.println("case " + n + ":");
        this.pushDepth();
        named.get = n;
        ESMethodDescriptor eSMethodDescriptor2 = eSIndexedPropertyDescriptor.getESSizeMethod();
        if (eSMethodDescriptor2 != null) {
            this.println("if (name.equals(LENGTH)) {");
            this.pushDepth();
            method = eSMethodDescriptor2.getMethod();
            clazz = method.getReturnType();
            this.print("return ");
            this.startJavaToES(clazz);
            this.startProp(eSMethodDescriptor2);
            this.print(")");
            this.endJavaToES(clazz);
            this.println(";");
            this.popDepth();
            this.println("} else {");
            this.pushDepth();
        }
        method = eSMethodDescriptor.getMethod();
        clazz = method.getReturnType();
        this.print("return ");
        this.startJavaToES(clazz);
        int n3 = this.startProp(eSMethodDescriptor);
        if (n3 > 0) {
            this.print(", ");
        }
        this.print("name.toInt32())");
        this.endJavaToES(clazz);
        this.println(";");
        if (eSMethodDescriptor2 != null) {
            this.popDepth();
            this.println("}");
        }
        this.popDepth();
        return n + 1;
    }

    private int doHasNamedProperty(int n, NamedPropertyDescriptor namedPropertyDescriptor) throws IOException {
        Named named = new Named(namedPropertyDescriptor.getName(), this.namedProperties.size());
        int n2 = named.n;
        this.namedProperties.put(namedPropertyDescriptor.getName(), named);
        this.hasDispatch.put(namedPropertyDescriptor.getName(), n);
        this.println("case " + n + ":");
        this.pushDepth();
        this.println("if (name" + n2 + " == null) {");
        this.println("  name" + n2 + " = new " + this.name + "();");
        this.println("  name" + n2 + ".value = value;");
        if (this.isPublic) {
            this.println("  name" + n2 + "._value = _value;");
        }
        this.println("  name" + n2 + ".hasDispatch = has" + n2 + ";");
        this.println("  name" + n2 + ".setDispatch = set" + n2 + ";");
        this.println("  name" + n2 + ".delId = " + n2 + ";");
        this.println("}");
        this.println("return name" + n2 + ";");
        this.popDepth();
        ++n;
        ESMethodDescriptor eSMethodDescriptor = namedPropertyDescriptor.getNamedReadMethod();
        if (eSMethodDescriptor == null) {
            return n;
        }
        this.println("case " + n + ":");
        this.pushDepth();
        named.get = n;
        Method method = eSMethodDescriptor.getMethod();
        if (Modifier.isStatic(method.getModifiers()) && !eSMethodDescriptor.isStaticVirtual()) {
            this.staticHasDispatch.put(namedPropertyDescriptor.getName(), n - 1);
        }
        Class<?> clazz = method.getReturnType();
        this.print("return ");
        this.startJavaToES(clazz);
        int n3 = this.startProp(eSMethodDescriptor);
        if (n3 > 0) {
            this.print(", ");
        }
        this.print("name.toJavaString())");
        this.endJavaToES(clazz);
        this.println(";");
        this.popDepth();
        this.popDepth();
        return n + 1;
    }

    private int doHasProperty(int n, ESPropertyDescriptor eSPropertyDescriptor) throws IOException {
        Field field = eSPropertyDescriptor.getESField();
        ESMethodDescriptor eSMethodDescriptor = eSPropertyDescriptor.getESReadMethod();
        if (field != null && !Modifier.isPublic(field.getModifiers())) {
            field = null;
        }
        if (eSMethodDescriptor == null && field == null) {
            return n;
        }
        this.hasDispatch.put(eSPropertyDescriptor.getName(), n);
        this.println("case " + n + ":");
        this.pushDepth();
        if (field != null) {
            Class<?> clazz = field.getType();
            this.print("return ");
            this.startJavaToES(clazz);
            if (this.isPublic && field.getDeclaringClass().getName().equals(this.cl.getName())) {
                this.print("_value.");
            } else {
                this.print("((" + field.getDeclaringClass().getName() + ") value).");
            }
            this.print(field.getName());
            this.endJavaToES(clazz);
            this.println(";");
            this.popDepth();
            return n + 1;
        }
        Method method = eSMethodDescriptor.getMethod();
        if (Modifier.isStatic(method.getModifiers()) && !eSMethodDescriptor.isStaticVirtual()) {
            this.staticHasDispatch.put(eSPropertyDescriptor.getName(), n);
        }
        this.print("return ");
        Class<?> clazz = method.getReturnType();
        this.startJavaToES(clazz);
        int n2 = this.startProp(eSMethodDescriptor);
        this.print(")");
        this.endJavaToES(clazz);
        this.println(";");
        this.popDepth();
        return n + 1;
    }

    private void printSetProperty() throws IOException {
        this.println();
        this.println("public void setProperty(ESString name, ESBase newValue)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("ESBase temp;");
        this.println("switch (setDispatch.get(name)) {");
        PropertyDescriptor[] propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
        int n = 0;
        int n2 = 0;
        while (n2 < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n2] instanceof NamedPropertyDescriptor) {
                n = this.doSetNamedProperty(n, (NamedPropertyDescriptor)propertyDescriptorArray[n2]);
            } else if (propertyDescriptorArray[n2] instanceof ESIndexedPropertyDescriptor) {
                n = this.doSetIndexProperty(n, (ESIndexedPropertyDescriptor)propertyDescriptorArray[n2]);
            } else if (propertyDescriptorArray[n2] instanceof ESPropertyDescriptor) {
                n = this.doSetProperty(n, (ESPropertyDescriptor)propertyDescriptorArray[n2]);
            } else {
                throw new RuntimeException();
            }
            ++n2;
        }
        this.println("default:");
        this.println("  return;");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private int doSetNamedProperty(int n, NamedPropertyDescriptor namedPropertyDescriptor) throws IOException {
        Named named = (Named)this.namedProperties.get(namedPropertyDescriptor.getName());
        if (named == null) {
            return n;
        }
        int n2 = named.n;
        ESMethodDescriptor eSMethodDescriptor = namedPropertyDescriptor.getNamedWriteMethod();
        if (eSMethodDescriptor == null) {
            return n;
        }
        this.println("case " + n + ":");
        this.pushDepth();
        named.set = n;
        int n3 = this.startProp(eSMethodDescriptor);
        Method method = eSMethodDescriptor.getMethod();
        Class<?>[] classArray = method.getParameterTypes();
        if (n3 != 0) {
            this.print(", ");
        }
        this.print("name.toJavaString(), ");
        this.printValueToJava(classArray[n3 + 1], "newValue");
        this.println(");");
        this.println("return;");
        this.popDepth();
        return n + 1;
    }

    private int doSetIndexProperty(int n, ESIndexedPropertyDescriptor eSIndexedPropertyDescriptor) throws IOException {
        Named named = (Named)this.namedProperties.get(eSIndexedPropertyDescriptor.getName());
        if (named == null) {
            return n;
        }
        int n2 = named.n;
        ESMethodDescriptor eSMethodDescriptor = eSIndexedPropertyDescriptor.getESWriteMethod();
        if (eSMethodDescriptor == null) {
            return n;
        }
        this.println("case " + n + ":");
        this.pushDepth();
        named.set = n;
        int n3 = this.startProp(eSMethodDescriptor);
        Method method = eSMethodDescriptor.getMethod();
        Class<?>[] classArray = method.getParameterTypes();
        if (n3 != 0) {
            this.print(", ");
        }
        this.print("name.toInt32(), ");
        this.printValueToJava(classArray[n3 + 1], "newValue");
        this.println(");");
        this.println("return;");
        this.popDepth();
        return n + 1;
    }

    private int doSetProperty(int n, ESPropertyDescriptor eSPropertyDescriptor) throws IOException {
        ESMethodDescriptor eSMethodDescriptor = eSPropertyDescriptor.getESWriteMethod();
        Field field = eSPropertyDescriptor.getESField();
        if (field != null && Modifier.isFinal(field.getModifiers())) {
            field = null;
        }
        if (eSMethodDescriptor == null && field == null) {
            return n;
        }
        this.println("case " + n + ":");
        this.pushDepth();
        this.setDispatch.put(eSPropertyDescriptor.getName(), n);
        if (field != null) {
            Class<?> clazz = field.getType();
            if (this.isPublic) {
                this.print("_value.");
            } else {
                this.print("((" + field.getDeclaringClass().getName() + ") value).");
            }
            this.print(field.getName());
            this.print(" = ");
            this.printValueToJava(clazz, "newValue");
            this.println(";");
            this.println("return;");
            this.popDepth();
            return n + 1;
        }
        Method method = eSMethodDescriptor.getMethod();
        if (Modifier.isStatic(method.getModifiers()) && !eSMethodDescriptor.isStaticVirtual()) {
            this.staticSetDispatch.put(eSPropertyDescriptor.getName(), n);
        }
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = this.startProp(eSMethodDescriptor);
        if (n2 != 0) {
            this.print(", ");
        }
        this.printValueToJava(classArray[n2], "newValue");
        this.println(");");
        this.println("return;");
        this.popDepth();
        return n + 1;
    }

    private void printKeys() throws IOException {
        this.println();
        this.println("public java.util.Iterator keys()");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("switch (delId) {");
        ESMethodDescriptor eSMethodDescriptor = this.beanInfo.iterator;
        if (eSMethodDescriptor != null) {
            this.println("case -1:");
            this.print("  return Call.toESIterator(");
            this.startProp(eSMethodDescriptor);
            this.println("));");
        }
        PropertyDescriptor[] propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n] instanceof NamedPropertyDescriptor) {
                this.printNamedKey((NamedPropertyDescriptor)propertyDescriptorArray[n]);
            }
            ++n;
        }
        this.println("default:");
        this.println("  return super.keys();");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void printNamedKey(NamedPropertyDescriptor namedPropertyDescriptor) throws IOException {
        ESMethodDescriptor eSMethodDescriptor = namedPropertyDescriptor.getNamedIteratorMethod();
        if (eSMethodDescriptor == null) {
            return;
        }
        Named named = (Named)this.namedProperties.get(namedPropertyDescriptor.getName());
        this.println("case " + named.n + ":");
        this.pushDepth();
        this.print("return Call.toESIterator(");
        int n = this.startProp(eSMethodDescriptor);
        this.println("));");
        this.popDepth();
    }

    private void printDeletes() throws IOException {
        this.println();
        this.println("public ESBase delete(ESString key)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("switch (delId) {");
        PropertyDescriptor[] propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n] instanceof NamedPropertyDescriptor) {
                this.printNamedDelete((NamedPropertyDescriptor)propertyDescriptorArray[n]);
            }
            ++n;
        }
        this.println("default:");
        this.println("  return ESBoolean.FALSE;");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void printNamedDelete(NamedPropertyDescriptor namedPropertyDescriptor) throws IOException {
        ESMethodDescriptor eSMethodDescriptor = namedPropertyDescriptor.getNamedRemoveMethod();
        if (eSMethodDescriptor == null) {
            return;
        }
        Named named = (Named)this.namedProperties.get(namedPropertyDescriptor.getName());
        this.println("case " + named.n + ":");
        this.pushDepth();
        int n = this.startProp(eSMethodDescriptor);
        if (n > 0) {
            this.print(", ");
        }
        this.println("key.toJavaString());");
        this.println("return ESBoolean.TRUE;");
        this.popDepth();
    }

    private void printMethods() throws IOException {
        String string;
        Map.Entry entry;
        this.println();
        this.println("public ESBase call(Call call, int length, int n)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("ESBase temp;");
        this.println("switch (n) {");
        ArrayList arrayList = (ArrayList)this.beanInfo.methodMap.get("call");
        if (arrayList != null) {
            this.printMethod(-1, "call", arrayList, null);
        }
        if ((arrayList = (ArrayList)this.beanInfo.staticMethodMap.get("call")) != null) {
            this.printMethod(-2, "call", arrayList, null);
        } else {
            this.println("case -2:");
            this.println("  return construct(call, length);");
        }
        Iterator iterator = this.beanInfo.methodMap.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            entry = iterator.next();
            arrayList = (ArrayList)entry.getValue();
            string = (String)entry.getKey();
            n = this.printMethod(n, string, arrayList, this.methodDispatch);
        }
        iterator = this.beanInfo.staticMethodMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            arrayList = (ArrayList)entry.getValue();
            string = (String)entry.getKey();
            n = this.printMethod(n, string, arrayList, this.staticMethodDispatch);
        }
        this.println("}");
        this.println("return ESBase.esUndefined;");
        this.popDepth();
        this.println("}");
    }

    private int printMethod(int n, String string, ArrayList arrayList, IntMap intMap) throws IOException {
        int n2;
        ESMethodDescriptor eSMethodDescriptor;
        Object object;
        ESMethodDescriptor eSMethodDescriptor2 = null;
        int n3 = 0;
        while (n3 < arrayList.size()) {
            if (arrayList.get(n3) instanceof ESMethodDescriptor) {
                eSMethodDescriptor2 = (ESMethodDescriptor)arrayList.get(n3);
            }
            ++n3;
        }
        if (eSMethodDescriptor2 == null) {
            return n;
        }
        this.println("case " + n + ":");
        this.pushDepth();
        if (intMap != null) {
            intMap.put(string, n++);
        }
        if (arrayList.size() > 2 && arrayList.get(2) instanceof ESMethodDescriptor && ((Class)(object = (eSMethodDescriptor = (ESMethodDescriptor)arrayList.get(2)).getMethod().getParameterTypes())[n2 = ((E)object).length - 2]).getName().equals("com.caucho.es.Call") && ((Class)object[n2 + 1]).getName().equals("int")) {
            this.printMethod(eSMethodDescriptor, intMap == null);
            this.popDepth();
            return n;
        }
        int n4 = 0;
        while (n4 < arrayList.size()) {
            object = arrayList.get(n4);
            if (object instanceof ESMethodDescriptor) {
                ESMethodDescriptor eSMethodDescriptor3 = (ESMethodDescriptor)object;
                if (eSMethodDescriptor3 != eSMethodDescriptor2) {
                    this.println("if (length <= " + n4 + ") {");
                    this.pushDepth();
                }
                this.printMethod(eSMethodDescriptor3, intMap == null);
                if (eSMethodDescriptor3 != eSMethodDescriptor2) {
                    this.popDepth();
                    this.println("}");
                }
            }
            ++n4;
        }
        this.popDepth();
        return n;
    }

    private void printMethod(ESMethodDescriptor eSMethodDescriptor, boolean bl) throws IOException {
        int n;
        Class<?>[] classArray;
        Method method = eSMethodDescriptor.getMethod();
        Class<?> clazz = method.getReturnType();
        if (!clazz.getName().equals("void")) {
            this.print("return ");
            this.startJavaToES(clazz);
        }
        if ((classArray = method.getParameterTypes()).length - (n = bl ? this.startProp(eSMethodDescriptor) : this.startCall(eSMethodDescriptor)) == 2 && classArray[n].getName().equals("com.caucho.es.Call") && classArray[n + 1].getName().equals("int")) {
            if (n > 0) {
                this.print(", ");
            }
            this.print("call, length");
        } else {
            int n2 = 0;
            while (n2 + n < classArray.length) {
                if (n2 + n > 0) {
                    this.print(", ");
                }
                this.printArgToJava(classArray[n2 + n], n2);
                ++n2;
            }
        }
        if (clazz.getName().equals("void")) {
            this.println(");");
            this.println("return ESBase.esUndefined;");
        } else {
            this.print(")");
            this.endJavaToES(clazz);
            this.println(";");
        }
    }

    private int startProp(ESMethodDescriptor eSMethodDescriptor) throws IOException {
        Method method = eSMethodDescriptor.getMethod();
        int n = 0;
        if (eSMethodDescriptor.isStaticVirtual()) {
            this.print(eSMethodDescriptor.getMethodClassName());
            this.print(".");
            this.print(eSMethodDescriptor.getMethod().getName());
            if (this.isPublic) {
                this.print("(_value");
            } else {
                this.print("((" + eSMethodDescriptor.getObjectClassName() + ") value");
            }
            n = 1;
        } else if (Modifier.isStatic(method.getModifiers())) {
            this.print(eSMethodDescriptor.getMethodClassName());
            this.print(".");
            this.print(eSMethodDescriptor.getMethod().getName());
            this.print("(");
        } else {
            if (this.isPublic) {
                this.print("_value.");
            } else {
                this.print("((" + eSMethodDescriptor.getObjectClassName() + ") value).");
            }
            this.print(eSMethodDescriptor.getMethod().getName());
            this.print("(");
        }
        return n;
    }

    private int startCall(ESMethodDescriptor eSMethodDescriptor) throws IOException {
        Method method = eSMethodDescriptor.getMethod();
        int n = 0;
        if (eSMethodDescriptor.isStaticVirtual()) {
            this.print(eSMethodDescriptor.getMethodClassName());
            this.print(".");
            this.print(eSMethodDescriptor.getMethod().getName());
            this.print("((" + eSMethodDescriptor.getObjectClassName() + ") call.getThisWrapper()");
            n = 1;
        } else if (Modifier.isStatic(method.getModifiers())) {
            this.print(eSMethodDescriptor.getMethodClassName());
            this.print(".");
            this.print(eSMethodDescriptor.getMethod().getName());
            this.print("(");
        } else {
            this.print("((" + eSMethodDescriptor.getObjectClassName() + ") call.getThisWrapper()).");
            this.print(eSMethodDescriptor.getMethod().getName());
            this.print("(");
        }
        return n;
    }

    private void startJavaToES(Class clazz) throws IOException {
        String string = clazz.getName();
        switch (classTypes.get(string)) {
            case 0: {
                break;
            }
            case 1: {
                this.print("ESBoolean.create(");
                break;
            }
            case 4: {
                this.print("ESString.createFromCharCode(");
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.print("ESNumber.create(");
                break;
            }
            case 9: {
                this.print("ESString.toStr(");
                break;
            }
            default: {
                if (this.esBase.isAssignableFrom(clazz)) {
                    this.print("((temp = ");
                    break;
                }
                this.print("Global.wrap(");
                break;
            }
        }
    }

    private void endJavaToES(Class clazz) throws IOException {
        String string = clazz.getName();
        switch (classTypes.get(string)) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.print(")");
                break;
            }
            default: {
                if (this.esBase.isAssignableFrom(clazz)) {
                    this.print(") == null ? ESBase.esNull : temp)");
                    break;
                }
                this.print(")");
                break;
            }
        }
    }

    private void printValueToJava(Class clazz, String string) throws IOException {
        String string2 = clazz.getName();
        switch (classTypes.get(string2)) {
            case 0: {
                throw new RuntimeException();
            }
            case 1: {
                this.print(string + ".toBoolean()");
                break;
            }
            case 4: {
                this.print("(char) " + string + ".toStr().carefulCharAt(0)");
                break;
            }
            case 2: {
                this.print("(byte) " + string + ".toInt32()");
                break;
            }
            case 3: {
                this.print("(short) " + string + ".toInt32()");
                break;
            }
            case 5: {
                this.print(string + ".toInt32()");
                break;
            }
            case 6: {
                this.print("(long)" + string + ".toNum()");
                break;
            }
            case 7: {
                this.print("(float)" + string + ".toNum()");
                break;
            }
            case 8: {
                this.print(string + ".toNum()");
                break;
            }
            case 9: {
                this.print("(" + string + ").toJavaString()");
                break;
            }
            default: {
                if (clazz.isAssignableFrom(this.esBase)) {
                    this.print(string);
                    break;
                }
                if (this.esBase.isAssignableFrom(clazz)) {
                    this.print("(");
                    this.printClassType(clazz);
                    this.print(") " + string);
                    break;
                }
                this.print("(");
                this.printClassType(clazz);
                this.print(") " + string + ".toJavaObject()");
                break;
            }
        }
    }

    private void printArgToJava(Class clazz, int n) throws IOException {
        String string = clazz.getName();
        switch (classTypes.get(string)) {
            case 0: {
                throw new RuntimeException();
            }
            case 1: {
                this.print("call.getArg(" + n + ", length).toBoolean()");
                break;
            }
            case 4: {
                this.print("(char) call.getArg(" + n + ", length).toStr().carefulCharAt(0)");
                break;
            }
            case 2: {
                this.print("(byte) call.getArgInt32(" + n + ", length)");
                break;
            }
            case 3: {
                this.print("(short) call.getArgInt32(" + n + ", length)");
                break;
            }
            case 5: {
                this.print("call.getArgInt32(" + n + ", length)");
                break;
            }
            case 6: {
                this.print("(long) call.getArgNum(" + n + ", length)");
                break;
            }
            case 7: {
                this.print("(float)call.getArgNum(" + n + ", length)");
                break;
            }
            case 8: {
                this.print("call.getArgNum(" + n + ", length)");
                break;
            }
            case 9: {
                this.print("call.getArgString(" + n + ", length)");
                break;
            }
            default: {
                if (clazz.isAssignableFrom(this.esBase) && !clazz.getName().equals("java.lang.Object")) {
                    this.print("call.getArg(" + n + ", length)");
                    break;
                }
                if (this.esBase.isAssignableFrom(clazz)) {
                    this.print("(");
                    this.printClassType(clazz);
                    this.print(") ");
                    this.print("call.getArg(" + n + ", length)");
                    break;
                }
                this.print("(");
                this.printClassType(clazz);
                this.print(") call.getArgObject(" + n + ", length)");
                break;
            }
        }
    }

    private void printClassType(Class clazz) throws IOException {
        if (clazz.isArray()) {
            this.printClassType(clazz.getComponentType());
            this.print("[]");
        } else {
            this.print(clazz.getName());
        }
    }

    private void printInit() throws IOException {
        Object object;
        this.println("private int delId = -1;");
        this.println();
        this.println("private static com.caucho.util.IntMap instanceHasDispatch;");
        this.println("private static com.caucho.util.IntMap instanceSetDispatch;");
        this.println("private static com.caucho.util.IntMap instanceMethodDispatch;");
        this.println("private static com.caucho.util.IntMap staticMethodDispatch;");
        this.println("private static com.caucho.util.IntMap staticHasDispatch;");
        this.println("private static com.caucho.util.IntMap staticSetDispatch;");
        Iterator iterator = this.namedProperties.values().iterator();
        while (iterator.hasNext()) {
            object = (Named)iterator.next();
            this.println(this.name + " name" + ((Named)object).n + ";");
            this.print("private static ConstIntMap has" + ((Named)object).n);
            this.println(" = new ConstIntMap(" + ((Named)object).get + ");");
            this.print("private static ConstIntMap set" + ((Named)object).n);
            this.println(" = new ConstIntMap(" + ((Named)object).set + ");");
        }
        this.println();
        this.println("static { _init(); }");
        this.println();
        this.println("private static void _init()");
        this.println("{");
        this.pushDepth();
        this.println("instanceHasDispatch = new com.caucho.util.IntMap();");
        iterator = this.hasDispatch.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.println("instanceHasDispatch.put(ESId.intern(\"" + (String)object + "\"), " + this.hasDispatch.get(object) + ");");
        }
        this.println();
        this.println("staticHasDispatch = new com.caucho.util.IntMap();");
        iterator = this.staticHasDispatch.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.println("staticHasDispatch.put(ESId.intern(\"" + (String)object + "\"), " + this.staticHasDispatch.get(object) + ");");
        }
        this.println();
        this.println("instanceSetDispatch = new com.caucho.util.IntMap();");
        iterator = this.setDispatch.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.println("instanceSetDispatch.put(ESId.intern(\"" + (String)object + "\"), " + this.setDispatch.get(object) + ");");
        }
        this.println();
        this.println("staticSetDispatch = new com.caucho.util.IntMap();");
        iterator = this.staticSetDispatch.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.println("staticSetDispatch.put(ESId.intern(\"" + (String)object + "\"), " + this.staticSetDispatch.get(object) + ");");
        }
        this.println();
        this.println("instanceMethodDispatch = new com.caucho.util.IntMap();");
        iterator = this.methodDispatch.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.println("instanceMethodDispatch.put(ESId.intern(\"" + (String)object + "\"), " + this.methodDispatch.get(object) + ");");
        }
        this.println();
        this.println("staticMethodDispatch = new com.caucho.util.IntMap();");
        iterator = this.staticMethodDispatch.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.println("staticMethodDispatch.put(ESId.intern(\"" + (String)object + "\"), " + this.staticMethodDispatch.get(object) + ");");
        }
        this.popDepth();
        this.println("}");
    }

    private void printFooter() throws IOException {
        this.popDepth();
        this.println("}");
    }

    private void pushDepth() {
        this.depth += 2;
    }

    private void popDepth() {
        this.depth -= 2;
    }

    private void print(String string) throws IOException {
        if (this.isNewline) {
            this.printDepth();
        }
        this.os.print(string);
    }

    private void println(String string) throws IOException {
        if (this.isNewline) {
            this.printDepth();
        }
        this.os.println(string);
        this.isNewline = true;
    }

    private void println() throws IOException {
        if (this.isNewline) {
            this.printDepth();
        }
        this.os.println();
        this.isNewline = true;
    }

    private void printDepth() throws IOException {
        int n = 0;
        while (n < this.depth) {
            this.os.print(' ');
            ++n;
        }
        this.isNewline = false;
    }

    private Wrapper(Global global, Class clazz) {
        this.name = "_jsbean." + clazz.getName() + "_es";
        this.cl = clazz;
        this.isPublic = Modifier.isPublic(clazz.getModifiers());
        this.loader = clazz.getClassLoader();
        this.compiler = new JavaCompiler(this.loader);
        Path path = CauchoSystem.getWorkPath();
        this.dest = path.lookup(this.name.replace('.', '/') + ".java");
        this.hasDispatch = new IntMap();
        this.staticHasDispatch = new IntMap();
        this.setDispatch = new IntMap();
        this.staticSetDispatch = new IntMap();
        this.methodDispatch = new IntMap();
        this.staticMethodDispatch = new IntMap();
        this.namedProperties = new HashMap();
        try {
            this.esBase = Class.forName("com.caucho.es.ESBase");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        classNames.put("void", "V");
        classNames.put("boolean", "Z");
        classNames.put("byte", "B");
        classNames.put("short", "S");
        classNames.put("char", "C");
        classNames.put("int", "I");
        classNames.put("long", "J");
        classNames.put("float", "F");
        classNames.put("double", "D");
        classTypes = new IntMap();
        classTypes.put("void", 0);
        classTypes.put("boolean", 1);
        classTypes.put("byte", 2);
        classTypes.put("short", 3);
        classTypes.put("char", 4);
        classTypes.put("int", 5);
        classTypes.put("long", 6);
        classTypes.put("float", 7);
        classTypes.put("double", 8);
        classTypes.put("java.lang.String", 9);
    }

    static class Named {
        String name;
        int n;
        int get = -1;
        int set = -1;
        int keys = -1;
        int remove = -1;

        Named(String string, int n) {
            this.name = string;
            this.n = n;
        }
    }
}

