/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESNumber;
import com.caucho.es.ESWrapperException;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.LiteralExpr;
import java.io.IOException;

class BinaryExpr
extends Expr {
    Expr left;
    Expr right;
    int op;
    String temp;
    boolean isSimple;

    static Expr create(Block block, Expr expr, Expr expr2, int n) throws ESException {
        ESBase eSBase;
        if (!(expr instanceof LiteralExpr) || !(expr2 instanceof LiteralExpr)) {
            return new BinaryExpr(block, expr, expr2, n);
        }
        ESBase eSBase2 = ((LiteralExpr)expr).getLiteral();
        ESBase eSBase3 = ((LiteralExpr)expr2).getLiteral();
        try {
            switch (n) {
                case 42: {
                    eSBase = ESNumber.create(eSBase2.toNum() * eSBase3.toNum());
                    break;
                }
                case 47: {
                    eSBase = ESNumber.create(eSBase2.toNum() / eSBase3.toNum());
                    break;
                }
                case 45: {
                    eSBase = ESNumber.create(eSBase2.toNum() - eSBase3.toNum());
                    break;
                }
                case 37: {
                    eSBase = ESNumber.create(eSBase2.toNum() % eSBase3.toNum());
                    break;
                }
                case 268: {
                    eSBase = ESNumber.create(eSBase2.toInt32() << eSBase3.toInt32());
                    break;
                }
                case 266: {
                    eSBase = ESNumber.create(eSBase2.toInt32() >> eSBase3.toInt32());
                    break;
                }
                case 267: {
                    eSBase = ESNumber.create(eSBase2.toInt32() >>> eSBase3.toInt32());
                    break;
                }
                case 38: {
                    eSBase = ESNumber.create(eSBase2.toInt32() & eSBase3.toInt32());
                    break;
                }
                case 124: {
                    eSBase = ESNumber.create(eSBase2.toInt32() | eSBase3.toInt32());
                    break;
                }
                case 94: {
                    eSBase = ESNumber.create(eSBase2.toInt32() ^ eSBase3.toInt32());
                    break;
                }
                case 277: {
                    eSBase = eSBase2.toBoolean() ? eSBase3 : eSBase2;
                    break;
                }
                case 278: {
                    eSBase = eSBase2.toBoolean() ? eSBase2 : eSBase3;
                    break;
                }
                case 44: {
                    eSBase = eSBase3;
                    break;
                }
                default: {
                    throw new RuntimeException("" + (char)n);
                }
            }
        }
        catch (Exception exception) {
            throw new ESWrapperException(exception);
        }
        return new LiteralExpr(block, eSBase);
    }

    int getType() {
        switch (this.op) {
            case 37: 
            case 42: 
            case 47: {
                return 3;
            }
            case 45: {
                if (this.left.getType() == 4 && this.right.getType() == 4) {
                    return 4;
                }
                return 3;
            }
            case 38: 
            case 94: 
            case 124: 
            case 266: 
            case 267: 
            case 268: {
                return 4;
            }
            case 277: 
            case 278: {
                if (this.left.getType() == this.right.getType()) {
                    return this.left.getType();
                }
                if (this.left.isNum() && this.right.isNum()) {
                    return 3;
                }
                return 1;
            }
            case 44: {
                return 1;
            }
        }
        throw new RuntimeException("" + (char)this.op + " " + this.op);
    }

    void exprStatement(Function function) throws ESException {
        switch (this.op) {
            default: 
        }
        this.left.exprStatement(function);
        this.right.exprStatement(function);
    }

    void printNumImpl() throws IOException {
        this.cl.print("(");
        switch (this.op) {
            case 37: 
            case 42: 
            case 45: 
            case 47: {
                this.left.printNum();
                this.cl.print(" " + (char)this.op + " ");
                this.right.printNum();
                break;
            }
            case 277: {
                if (this.isSimple) {
                    this.left.printBoolean();
                    this.cl.print(" ? ");
                    this.right.printNum();
                    this.cl.print(":");
                    this.left.printNum();
                    break;
                }
                this.cl.print("(" + this.temp + " = ");
                this.left.print();
                this.cl.print(").toBoolean() ? ");
                this.right.printNum();
                this.cl.print(":" + this.temp + ".toNum()");
                break;
            }
            case 278: {
                if (this.isSimple) {
                    this.left.printBoolean();
                    this.cl.print(" ? ");
                    this.left.printNum();
                    this.cl.print(":");
                    this.right.printNum();
                    break;
                }
                this.cl.print("(" + this.temp + " = ");
                this.left.print();
                this.cl.print(").toBoolean() ? " + this.temp + ".toNum() : ");
                this.right.printNum();
                break;
            }
            default: {
                throw new IOException("foo");
            }
        }
        this.cl.print(")");
    }

    void printInt32Impl() throws IOException {
        this.cl.print("(");
        switch (this.op) {
            case 45: {
                this.left.printInt32();
                this.cl.print(" " + (char)this.op + " ");
                this.right.printInt32();
                break;
            }
            case 268: {
                this.left.printInt32();
                this.cl.print(" << ");
                this.right.printInt32();
                break;
            }
            case 266: {
                this.left.printInt32();
                this.cl.print(" >> ");
                this.right.printInt32();
                break;
            }
            case 267: {
                this.left.printInt32();
                this.cl.print(" >>> ");
                this.right.printInt32();
                break;
            }
            case 38: 
            case 94: 
            case 124: {
                this.left.printInt32();
                this.cl.print(" " + (char)this.op + " ");
                this.right.printInt32();
                break;
            }
            case 277: {
                if (this.isSimple) {
                    this.left.printBoolean();
                    this.cl.print(" ? ");
                    this.right.printInt32();
                    this.cl.print(":");
                    this.left.printInt32();
                    break;
                }
                this.cl.print("(" + this.temp + " = ");
                this.left.print();
                this.cl.print(").toBoolean() ? ");
                this.right.printInt32();
                this.cl.print(":" + this.temp + ".toInt32()");
                break;
            }
            case 278: {
                if (this.isSimple) {
                    this.left.printBoolean();
                    this.cl.print(" ? ");
                    this.left.printInt32();
                    this.cl.print(":");
                    this.right.printInt32();
                    break;
                }
                this.cl.print("(" + this.temp + " = ");
                this.left.print();
                this.cl.print(").toBoolean() ? " + this.temp + ".toInt32() : ");
                this.right.printInt32();
                break;
            }
            default: {
                throw new IOException("foo");
            }
        }
        this.cl.print(")");
    }

    void printBoolean() throws IOException {
        switch (this.op) {
            case 277: {
                this.cl.print("(");
                this.left.printBoolean();
                this.cl.print(" && ");
                this.right.printBoolean();
                this.cl.print(")");
                break;
            }
            case 278: {
                this.cl.print("(");
                this.left.printBoolean();
                this.cl.print(" || ");
                this.right.printBoolean();
                this.cl.print(")");
                break;
            }
            default: {
                super.printBoolean();
            }
        }
    }

    void printBooleanImpl() throws IOException {
        this.cl.print("(");
        switch (this.op) {
            case 277: {
                this.left.printBoolean();
                this.cl.print(" && ");
                this.right.printBoolean();
                break;
            }
            case 278: {
                this.left.printBoolean();
                this.cl.print(" || ");
                this.right.printBoolean();
                break;
            }
            default: {
                throw new IOException("foo");
            }
        }
        this.cl.print(")");
    }

    void printImpl() throws IOException {
        switch (this.op) {
            case 277: {
                if (this.isSimple) {
                    this.left.printBoolean();
                    this.cl.print(" ? ");
                    this.right.print();
                    this.cl.print(":");
                    this.left.print();
                    break;
                }
                this.cl.print("((" + this.temp + " = ");
                this.left.print();
                this.cl.print(").toBoolean() ? ");
                this.right.print();
                this.cl.print(":" + this.temp + ")");
                break;
            }
            case 278: {
                if (this.isSimple) {
                    this.left.printBoolean();
                    this.cl.print(" ? ");
                    this.left.print();
                    this.cl.print(":");
                    this.right.print();
                    break;
                }
                this.cl.print("((" + this.temp + " = ");
                this.left.print();
                this.cl.print(").toBoolean() ? " + this.temp + " : ");
                this.right.print();
                this.cl.print(")");
                break;
            }
            case 44: {
                this.cl.print("_env.comma(");
                this.left.print();
                this.cl.print(", ");
                this.right.print();
                this.cl.print(")");
                break;
            }
            default: {
                throw new IOException("foo");
            }
        }
    }

    protected BinaryExpr(Block block, Expr expr, Expr expr2, int n) {
        super(block);
        this.left = expr;
        this.right = expr2;
        this.op = n;
        this.isSimple = expr.isSimple();
        if (!(n != 277 && n != 278 || this.isSimple)) {
            this.temp = block.function.getTemp();
        }
    }
}

