/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESArray;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESClosure;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESRegexp;
import com.caucho.es.ESString;
import com.caucho.es.ESThunk;
import com.caucho.es.ESWrapper;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.NativeWrapper;
import com.caucho.es.Printf;
import com.caucho.regexp.Regexp;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;

class NativeString
extends Native {
    static final int NEW = 1;
    static final int TO_STRING = 2;
    static final int FROM_CHAR_CODE = 3;
    static final int VALUE_OF = 4;
    static final int CHAR_AT = 5;
    static final int CHAR_CODE_AT = 6;
    static final int INDEX_OF = 7;
    static final int LAST_INDEX_OF = 8;
    static final int SPLIT = 9;
    static final int SUBSTRING = 10;
    static final int TO_UPPER_CASE = 11;
    static final int TO_LOWER_CASE = 12;
    static final int CONCAT = 13;
    static final int MATCH = 14;
    static final int REPLACE = 15;
    static final int SEARCH = 16;
    static final int SLICE = 17;
    static final int SUBSTR = 18;
    static final int PRINTF = 19;
    static final int CONTAINS = 20;
    static final int STARTS_WITH = 21;
    static final int ENDS_WITH = 22;
    static final int REPLACE_WS = 0;
    static final int REPLACE_DIGIT = 1;
    static final int REPLACE_ID = 2;

    static ESObject create(Global global) {
        NativeString nativeString = new NativeString("String", 1, 1);
        ESWrapper eSWrapper = new ESWrapper("String", (ESBase)global.objProto, ESString.NULL);
        NativeWrapper nativeWrapper = new NativeWrapper(global, nativeString, eSWrapper, 7);
        global.stringProto = eSWrapper;
        eSWrapper.put("length", (ESBase)ESNumber.create(0.0), 7);
        NativeString.put(eSWrapper, "valueOf", 4, 0);
        NativeString.put(eSWrapper, "toString", 2, 0);
        NativeString.put(eSWrapper, "charAt", 5, 1);
        NativeString.put(eSWrapper, "charCodeAt", 6, 1);
        NativeString.put(eSWrapper, "indexOf", 7, 2);
        NativeString.put(eSWrapper, "lastIndexOf", 8, 2);
        NativeString.put(eSWrapper, "split", 9, 1);
        NativeString.put(eSWrapper, "substring", 10, 2);
        NativeString.put(eSWrapper, "toUpperCase", 11, 0);
        NativeString.put(eSWrapper, "toLowerCase", 12, 0);
        NativeString.put(nativeWrapper, "fromCharCode", 3, 0);
        NativeString.put(eSWrapper, "concat", 13, 1);
        NativeString.put(eSWrapper, "match", 14, 1);
        NativeString.put(eSWrapper, "replace", 15, 2);
        NativeString.put(eSWrapper, "search", 16, 1);
        NativeString.put(eSWrapper, "slice", 17, 2);
        NativeString.put(eSWrapper, "substr", 18, 2);
        NativeString.put(nativeWrapper, "printf", 19, 1);
        NativeString.put(eSWrapper, "contains", 20, 1);
        NativeString.put(eSWrapper, "startsWith", 21, 1);
        NativeString.put(eSWrapper, "endsWith", 22, 1);
        eSWrapper.setClean();
        nativeWrapper.setClean();
        return nativeWrapper;
    }

    private static void put(ESObject eSObject, String string, int n, int n2) {
        ESId eSId = ESId.intern(string);
        eSObject.put(eSId, (ESBase)new NativeString(string, n, n2), 4);
    }

    public ESBase call(Call call, int n) throws Exception {
        switch (this.n) {
            case 1: {
                if (n == 0) {
                    return ESString.create("");
                }
                return call.getArg(0).toStr();
            }
            case 3: {
                return this.fromCharCode(call, n);
            }
            case 2: 
            case 4: {
                try {
                    return ((ESWrapper)call.getArg((int)-1)).value;
                }
                catch (ClassCastException classCastException) {
                    if (call.getArg(-1) instanceof ESString) {
                        return call.getArg(-1);
                    }
                    if (call.getArg(-1) instanceof ESThunk) {
                        return ((ESWrapper)((ESThunk)call.getArg((int)-1)).getObject()).value;
                    }
                    throw new ESException("toString expects string object");
                }
            }
            case 5: {
                return this.charAt(call, n);
            }
            case 6: {
                return this.charCodeAt(call, n);
            }
            case 7: {
                return this.indexOf(call, n);
            }
            case 8: {
                return this.lastIndexOf(call, n);
            }
            case 9: {
                return this.split(call, n);
            }
            case 10: {
                return this.substring(call, n);
            }
            case 11: {
                return call.getArg(-1).toStr().toUpperCase();
            }
            case 12: {
                return call.getArg(-1).toStr().toLowerCase();
            }
            case 13: {
                return this.concat(call, n);
            }
            case 14: {
                return this.match(call, n);
            }
            case 15: {
                return this.replace(call, n);
            }
            case 16: {
                return this.search(call, n);
            }
            case 17: {
                return this.slice(call, n);
            }
            case 18: {
                return this.substr(call, n);
            }
            case 19: {
                return this.printf(call, n);
            }
            case 20: {
                if (n < 1) {
                    return ESBoolean.FALSE;
                }
                return call.getArg(-1).toStr().contains(call.getArg(0));
            }
            case 21: {
                if (n < 1) {
                    return ESBoolean.FALSE;
                }
                return call.getArg(-1).toStr().startsWith(call.getArg(0));
            }
            case 22: {
                if (n < 1) {
                    return ESBoolean.FALSE;
                }
                return call.getArg(-1).toStr().endsWith(call.getArg(0));
            }
        }
        throw new ESException("Unknown object function");
    }

    public ESBase construct(Call call, int n) throws Exception {
        if (this.n != 1) {
            throw new ESException("Unknown object function");
        }
        return (ESObject)this.create(call, n);
    }

    private ESBase create(Call call, int n) throws Exception {
        ESString eSString = n == 0 ? ESString.create("") : call.getArg(0).toStr();
        return ((ESBase)eSString).toObject();
    }

    private ESBase fromCharCode(Call call, int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            int n3 = call.getArg(n2).toInt32() & 0xFFFF;
            stringBuffer.append((char)n3);
            ++n2;
        }
        return ESString.create(stringBuffer.toString());
    }

    private ESBase charAt(Call call, int n) throws Exception {
        ESString eSString = call.getArg(-1).toStr();
        if (n == 0) {
            return ESString.create("");
        }
        int n2 = (int)call.getArg(0).toNum();
        if (n2 < 0 || n2 >= eSString.length()) {
            return ESString.create("");
        }
        return ESString.create("" + eSString.charAt(n2));
    }

    private ESBase charCodeAt(Call call, int n) throws Exception {
        ESString eSString = call.getArg(-1).toStr();
        if (n == 0) {
            return ESNumber.NaN;
        }
        int n2 = (int)call.getArg(0).toNum();
        if (n2 < 0 || n2 >= eSString.length()) {
            return ESNumber.NaN;
        }
        return ESNumber.create(eSString.charAt(n2));
    }

    private ESBase indexOf(Call call, int n) throws Exception {
        ESString eSString = call.getArg(-1).toStr();
        if (n == 0) {
            return ESNumber.create(-1.0);
        }
        int n2 = 0;
        if (n > 1) {
            n2 = (int)call.getArg(1).toNum();
        }
        ESString eSString2 = call.getArg(0).toStr();
        return ESNumber.create(eSString.indexOf(eSString2, n2));
    }

    private ESBase lastIndexOf(Call call, int n) throws Exception {
        ESString eSString = call.getArg(-1).toStr();
        if (n == 0) {
            return ESNumber.create(-1.0);
        }
        int n2 = eSString.length() + 1;
        if (n > 1) {
            n2 = (int)call.getArg(1).toNum();
        }
        ESString eSString2 = call.getArg(0).toStr();
        return ESNumber.create(eSString.lastIndexOf(eSString2, n2));
    }

    private String escapeRegexp(String string) {
        CharBuffer charBuffer = new CharBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '-': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    charBuffer.append('\\');
                    charBuffer.append(c);
                    break;
                }
                default: {
                    charBuffer.append(c);
                }
            }
            ++n;
        }
        return charBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private ESBase split(Call var1_1, int var2_2) throws Exception {
        var3_3 = Global.getGlobalProto();
        var4_4 = var1_1.getArg(-1).toStr();
        var5_5 = null;
        var6_6 = false;
        var7_7 = var3_3.createArray();
        if (var2_2 == 0) {
            var7_7.setProperty(0, (ESBase)var4_4);
            return var7_7;
        }
        var5_5 = var1_1.getArg(0) instanceof ESRegexp != false ? (ESRegexp)var1_1.getArg(0) : ((var8_8 = var1_1.getArg(0).toString()).length() == 1 && var8_8.charAt(0) == ' ' ? new ESRegexp("\\s", "g") : new ESRegexp(this.escapeRegexp(var8_8), "g"));
        var8_9 = 0;
        var9_10 = 0;
        var10_11 = 0;
        var5_5.setLastIndex(0);
        var3_3.getRegexp().setRegexp(var5_5);
        while (var5_5.exec(var4_4, true)) {
            block7: {
                var11_12 = var5_5.regexp.getBegin(0);
                if (var6_6 && var11_12 == 0) {
                    var8_9 = var5_5.regexp.getEnd(0);
                    continue;
                }
                if (var8_9 != var11_12 || var5_5.regexp.length() != 1) ** GOTO lbl25
                ++var10_11;
                break block7;
lbl-1000:
                // 1 sources

                {
                    var7_7.setProperty(var9_10++, (ESBase)ESString.NULL);
                    --var10_11;
lbl25:
                    // 2 sources

                    ** while (var10_11 > 0)
                }
lbl26:
                // 1 sources

                var7_7.setProperty(var9_10++, (ESBase)var4_4.substring(var8_9, var11_12));
            }
            var8_9 = var5_5.regexp.getEnd(0);
            var12_13 = 1;
            while (var12_13 < var5_5.regexp.length()) {
                var7_7.setProperty(var9_10++, (ESBase)var4_4.substring(var5_5.regexp.getBegin(var12_13), var5_5.regexp.getEnd(var12_13)));
                ++var12_13;
            }
        }
        if (var2_2 > 0 || var8_9 != var4_4.length()) {
            while (var10_11 > 0) {
                var7_7.setProperty(var9_10++, (ESBase)ESString.NULL);
                --var10_11;
            }
            var7_7.setProperty(var9_10++, (ESBase)var4_4.substring(var8_9));
        }
        return var7_7;
    }

    private ESBase substring(Call call, int n) throws Exception {
        ESString eSString = call.getArg(-1).toStr();
        if (n == 0) {
            return eSString;
        }
        int n2 = (int)call.getArg(0).toNum();
        int n3 = eSString.length();
        if (n > 1) {
            n3 = (int)call.getArg(1).toNum();
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > eSString.length()) {
            n3 = eSString.length();
        }
        if (n2 > n3) {
            return eSString.substring(n3, n2);
        }
        return eSString.substring(n2, n3);
    }

    private ESBase concat(Call call, int n) throws Exception {
        ESString eSString = call.getArg(-1).toStr();
        if (n == 0) {
            return eSString;
        }
        CharBuffer charBuffer = new CharBuffer();
        charBuffer.append(eSString.toString());
        int n2 = 0;
        while (n2 < n) {
            ESString eSString2 = call.getArg(n2).toStr();
            charBuffer.append(eSString2.toString());
            ++n2;
        }
        return ESString.create(charBuffer);
    }

    private ESBase match(Call call, int n) throws Exception {
        if (n == 0) {
            return ESBase.esNull;
        }
        Global global = Global.getGlobalProto();
        ESString eSString = call.getArg(-1).toStr();
        ESBase eSBase = call.getArg(0);
        ESRegexp eSRegexp = eSBase instanceof ESRegexp ? (ESRegexp)eSBase : (n > 1 ? new ESRegexp(eSBase.toStr(), call.getArg(1).toStr()) : new ESRegexp(eSBase.toStr(), ESString.NULL));
        IntArray intArray = new IntArray();
        global.getRegexp().setRegexp(eSRegexp);
        eSRegexp.setLastIndex(0);
        if (!eSRegexp.exec(eSString)) {
            return ESBase.esNull;
        }
        ESArray eSArray = global.createArray();
        if (!eSRegexp.regexp.isGlobal()) {
            int n2 = 0;
            while (n2 < eSRegexp.regexp.length()) {
                eSArray.setProperty(n2, (ESBase)eSString.substring(eSRegexp.regexp.getBegin(n2), eSRegexp.regexp.getEnd(n2)));
                ++n2;
            }
            return eSArray;
        }
        int n3 = 0;
        do {
            eSArray.setProperty(n3, (ESBase)eSString.substring(eSRegexp.regexp.getBegin(0), eSRegexp.regexp.getEnd(0)));
            ++n3;
        } while (eSRegexp.exec(eSString));
        return eSArray;
    }

    private void replaceFun(CharBuffer charBuffer, String string, ESRegexp eSRegexp, ESBase eSBase) throws Exception {
        Call call = Global.getGlobalProto().getCall();
        call.top = 1;
        call.setThis(eSRegexp);
        int n = 0;
        while (n < eSRegexp.regexp.length()) {
            int n2 = eSRegexp.regexp.getBegin(n);
            int n3 = eSRegexp.regexp.getEnd(n);
            call.setArg(n, ESString.create(string.substring(n2, n3)));
            ++n;
        }
        ESBase eSBase2 = eSBase.call(call, eSRegexp.regexp.length());
        Global.getGlobalProto().freeCall(call);
        String string2 = eSBase2.toStr().toString();
        charBuffer.append(string2);
    }

    private void replaceString(CharBuffer charBuffer, String string, Regexp regexp, String string2) throws Exception {
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c == '$' && n2 + 1 < n) {
                int n3;
                int n4;
                if ((c = string2.charAt(++n2)) >= '0' && c <= '9') {
                    n4 = c - 48;
                    if (n4 < regexp.length()) {
                        n3 = regexp.getBegin(n4);
                        int n5 = regexp.getEnd(n4);
                        charBuffer.append(string.substring(n3, n5));
                    }
                } else if (c == '$') {
                    charBuffer.append('$');
                } else if (c == '&') {
                    n4 = regexp.getBegin(0);
                    n3 = regexp.getEnd(0);
                    charBuffer.append(string.substring(n4, n3));
                } else if (c == '+') {
                    n4 = regexp.getBegin(regexp.length() - 1);
                    n3 = regexp.getEnd(regexp.length() - 1);
                    charBuffer.append(string.substring(n4, n3));
                } else if (c == '`') {
                    n4 = 0;
                    n3 = regexp.getBegin(0);
                    charBuffer.append(string.substring(n4, n3));
                } else if (c == '\'') {
                    n4 = regexp.getEnd(0);
                    n3 = string.length();
                    charBuffer.append(string.substring(n4, n3));
                } else {
                    charBuffer.append('$');
                    charBuffer.append(c);
                }
            } else {
                charBuffer.append(c);
            }
            ++n2;
        }
    }

    private ESBase replace(Call call, int n) throws Exception {
        ESString eSString = call.getArg(-1).toStr();
        if (n < 1) {
            return eSString;
        }
        Global global = Global.getGlobalProto();
        ESBase eSBase = call.getArg(0);
        ESRegexp eSRegexp = eSBase instanceof ESRegexp ? (ESRegexp)eSBase : new ESRegexp(eSBase.toStr(), ESString.NULL);
        IntArray intArray = new IntArray();
        String string = eSString.toString();
        ESBase eSBase2 = null;
        String string2 = null;
        if (n > 1) {
            eSBase2 = call.getArg(1);
        }
        int n2 = 0;
        CharBuffer charBuffer = new CharBuffer();
        global.getRegexp().setRegexp(eSRegexp);
        if (eSRegexp.regexp.isGlobal()) {
            eSRegexp.setLastIndex(0);
        }
        while (eSRegexp.exec(eSString)) {
            charBuffer.append(string.substring(n2, eSRegexp.regexp.getBegin(0)));
            n2 = eSRegexp.regexp.getEnd(0);
            if (eSBase2 instanceof ESClosure) {
                this.replaceFun(charBuffer, string, eSRegexp, eSBase2);
            } else {
                if (string2 == null) {
                    string2 = eSBase2 == null ? "" : eSBase2.toString();
                }
                this.replaceString(charBuffer, string, eSRegexp.regexp, string2);
            }
            if (!eSRegexp.regexp.isGlobal()) break;
        }
        charBuffer.append(string.substring(n2));
        return ESString.create(charBuffer);
    }

    private ESBase search(Call call, int n) throws Exception {
        if (n == 0) {
            return ESNumber.create(-1.0);
        }
        ESString eSString = call.getArg(-1).toStr();
        ESBase eSBase = call.getArg(0);
        ESRegexp eSRegexp = eSBase instanceof ESRegexp ? (ESRegexp)eSBase : (n > 1 ? new ESRegexp(eSBase.toStr(), call.getArg(1).toStr()) : new ESRegexp(eSBase.toStr(), ESString.NULL));
        Global.getGlobalProto().getRegexp().setRegexp(eSRegexp);
        if (!eSRegexp.exec(eSString, false)) {
            return ESNumber.create(-1.0);
        }
        return ESNumber.create(eSRegexp.regexp.getBegin(0));
    }

    private ESBase slice(Call call, int n) throws Exception {
        ESString eSString = call.getArg(-1).toStr();
        if (n == 0) {
            return eSString;
        }
        int n2 = (int)call.getArg(0).toNum();
        int n3 = eSString.length();
        if (n > 1) {
            n3 = (int)call.getArg(1).toNum();
        }
        if (n2 < 0) {
            n2 += eSString.length();
        }
        if (n3 < 0) {
            n3 += eSString.length();
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > eSString.length()) {
            n2 = eSString.length();
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > eSString.length()) {
            n3 = eSString.length();
        }
        if (n2 <= n3) {
            return eSString.substring(n2, n3);
        }
        return ESString.NULL;
    }

    private ESBase substr(Call call, int n) throws Exception {
        ESString eSString = call.getArg(-1).toStr();
        if (n == 0) {
            return eSString;
        }
        int n2 = (int)call.getArg(0).toNum();
        int n3 = eSString.length();
        if (n > 1) {
            n3 = (int)call.getArg(1).toNum();
        }
        if (n2 < 0) {
            n2 += eSString.length();
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > eSString.length()) {
            n2 = eSString.length();
        }
        if (n3 <= 0) {
            return ESString.NULL;
        }
        int n4 = n2 + n3;
        if (n4 > eSString.length()) {
            n4 = eSString.length();
        }
        return eSString.substring(n2, n4);
    }

    private ESBase printf(Call call, int n) throws Exception {
        if (n == 0) {
            return ESString.NULL;
        }
        ESString eSString = call.getArg(0).toStr();
        CharBuffer charBuffer = new CharBuffer();
        Printf.printf(charBuffer, eSString, call, n);
        return ESString.create(charBuffer.toString());
    }

    private NativeString(String string, int n, int n2) {
        super(string, n2);
        this.n = n;
    }
}

