/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESArray;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESRegexp;
import com.caucho.es.ESRegexpWrapper;
import com.caucho.es.ESString;
import com.caucho.es.ESThunk;
import com.caucho.es.Global;
import com.caucho.es.Native;

class NativeRegexp
extends Native {
    static ESId INDEX = ESId.intern("index");
    static ESId INPUT = ESId.intern("input");
    static final int NEW = 1;
    static final int COMPILE = 2;
    static final int EXEC = 3;
    static final int TEST = 4;
    static final int TO_STRING = 5;

    static ESRegexpWrapper create(Global global) {
        ESRegexp eSRegexp;
        NativeRegexp nativeRegexp = new NativeRegexp("Regexp", 1, 1);
        try {
            eSRegexp = new ESRegexp("", "");
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
        eSRegexp.prototype = global.objProto;
        global.regexpProto = eSRegexp;
        ESRegexpWrapper eSRegexpWrapper = new ESRegexpWrapper(global, nativeRegexp, eSRegexp);
        NativeRegexp.put(eSRegexp, "exec", 3, 1);
        NativeRegexp.put(eSRegexp, "compile", 2, 2);
        NativeRegexp.put(eSRegexp, "test", 4, 1);
        NativeRegexp.put(eSRegexp, "toString", 5, 0);
        eSRegexp.setClean();
        eSRegexpWrapper.setClean();
        return eSRegexpWrapper;
    }

    private static void put(ESObject eSObject, String string, int n, int n2) {
        ESId eSId = ESId.intern(string);
        NativeRegexp nativeRegexp = new NativeRegexp(string, n, n2);
        eSObject.put(eSId, (ESBase)nativeRegexp, 4);
    }

    public ESBase call(Call call, int n) throws Exception {
        switch (this.n) {
            case 1: {
                return this.create(call, n);
            }
            case 5: {
                try {
                    ESRegexp eSRegexp = (ESRegexp)call.getThis();
                    String string = eSRegexp.pattern.toString();
                    String string2 = eSRegexp.flags.toString();
                    return ESString.create("/" + string + "/" + string2);
                }
                catch (ClassCastException classCastException) {
                    throw new ESException("toString expected regexp object");
                }
            }
            case 3: {
                return NativeRegexp.exec(call, n);
            }
            case 2: {
                return this.compile(call, n);
            }
            case 4: {
                return this.test(call, n);
            }
        }
        throw new ESException("Unknown object function");
    }

    private ESBase create(Call call, int n) throws Exception {
        ESString eSString = null;
        ESString eSString2 = n == 0 ? ESString.NULL : call.getArg(0).toStr();
        eSString = n > 1 ? call.getArg(1).toStr() : ESString.NULL;
        ESRegexp eSRegexp = new ESRegexp(eSString2, eSString);
        return eSRegexp;
    }

    private ESBase compile(Call call, int n) throws Exception {
        ESString eSString = null;
        ESBase eSBase = call.getArg(-1);
        if (eSBase instanceof ESThunk) {
            eSBase = ((ESThunk)eSBase).toObject();
        }
        if (!(eSBase instanceof ESRegexp)) {
            throw new ESException("compile must be bound to regexp");
        }
        ESRegexp eSRegexp = (ESRegexp)eSBase;
        if (n == 0) {
            return ESBase.esUndefined;
        }
        ESString eSString2 = call.getArg(0).toStr();
        eSString = n > 1 ? call.getArg(1).toStr() : ESString.NULL;
        eSRegexp.compile(eSString2, eSString);
        return eSRegexp;
    }

    static ESBase exec(Call call, int n) throws Exception {
        ESString eSString;
        ESBase eSBase = call.getArg(-1);
        if (eSBase instanceof ESThunk) {
            eSBase = ((ESThunk)eSBase).toObject();
        }
        ESRegexp eSRegexp = eSBase instanceof ESRegexp ? (ESRegexp)eSBase : new ESRegexp(eSBase.toStr(), ESString.NULL);
        if (eSRegexp.prototype == null) {
            throw new RuntimeException();
        }
        Global global = Global.getGlobalProto();
        if (n == 0) {
            ESRegexpWrapper eSRegexpWrapper = global.getRegexp();
            global.getRegexp();
            eSString = eSRegexpWrapper.getProperty(ESRegexpWrapper.INPUT).toStr();
        } else {
            eSString = call.getArg(0).toStr();
        }
        global.getRegexp().setRegexp(eSRegexp);
        if (!eSRegexp.exec(eSString)) {
            return ESBase.esNull;
        }
        ESArray eSArray = global.createArray();
        int n2 = 0;
        while (n2 < eSRegexp.regexp.length()) {
            int n3;
            int n4 = eSRegexp.regexp.getBegin(n2);
            if (n4 < (n3 = eSRegexp.regexp.getEnd(n2)) && n4 >= 0) {
                eSArray.setProperty(n2, (ESBase)eSString.substring(n4, n3));
            } else {
                eSArray.setProperty(n2, (ESBase)ESString.create(""));
            }
            ++n2;
        }
        eSArray.setProperty(INDEX, (ESBase)ESNumber.create(eSRegexp.regexp.getBegin(0)));
        eSArray.setProperty(INPUT, (ESBase)eSString);
        return eSArray;
    }

    private ESBase test(Call call, int n) throws Exception {
        ESBase eSBase = call.getArg(-1);
        if (eSBase instanceof ESThunk) {
            eSBase = ((ESThunk)eSBase).toObject();
        }
        ESRegexp eSRegexp = eSBase instanceof ESRegexp ? (ESRegexp)eSBase : new ESRegexp(eSBase.toStr(), ESString.NULL);
        if (eSRegexp.prototype == null) {
            throw new RuntimeException();
        }
        ESRegexpWrapper eSRegexpWrapper = Global.getGlobalProto().getRegexp();
        ESString eSString = n == 0 ? eSRegexpWrapper.getProperty(ESRegexpWrapper.INPUT).toStr() : call.getArg(0).toStr();
        eSRegexpWrapper.setRegexp(eSRegexp);
        return ESBoolean.create(eSRegexp.exec(eSString));
    }

    private NativeRegexp(String string, int n, int n2) {
        super(string, n2);
        this.n = n;
    }
}

