/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESClosure;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.ESWrapper;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.NativeWrapper;
import com.caucho.util.IntMap;

class NativeObject
extends Native {
    static final int TO_OBJECT = 2;
    static final int TO_STRING = 3;
    static final int VALUE_OF = 4;
    static final int TO_SOURCE = 5;
    static final int WATCH = 6;
    static final int UNWATCH = 7;

    static ESObject create(Global global) {
        NativeObject nativeObject = new NativeObject("Object", 2, 1);
        global.objProto = new ESObject("Object", ESBase.esBase);
        NativeWrapper nativeWrapper = new NativeWrapper(global, nativeObject, global.objProto, 1);
        NativeObject.put(global.objProto, "toString", 3, 0, 4);
        NativeObject.put(global.objProto, "valueOf", 4, 0, 4);
        NativeObject.put(global.objProto, "toSource", 5, 0, 4);
        NativeObject.put(global.objProto, "watch", 6, 0, 4);
        NativeObject.put(global.objProto, "unwatch", 7, 0, 4);
        global.objProto.setClean();
        nativeWrapper.setClean();
        return nativeWrapper;
    }

    private static void put(ESObject eSObject, String string, int n, int n2, int n3) {
        ESId eSId = ESId.intern(string);
        NativeObject nativeObject = new NativeObject(string, n, n2);
        try {
            eSObject.put(eSId, (ESBase)nativeObject, n3);
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    public ESBase call(Call call, int n) throws Exception {
        switch (this.n) {
            case 3: {
                ESBase eSBase = call.getArg(-1);
                if (eSBase instanceof ESObject) {
                    return NativeObject.toString((ESObject)eSBase);
                }
                return NativeObject.toString(eSBase.toObject());
            }
            case 4: {
                ESBase eSBase = call.getArg(-1);
                if (eSBase instanceof ESWrapper) {
                    ESWrapper eSWrapper = (ESWrapper)eSBase;
                    if (eSWrapper.value instanceof ESBase) {
                        return eSWrapper.value;
                    }
                    return eSWrapper.toStr();
                }
                return eSBase;
            }
            case 2: {
                ESBase eSBase;
                if (n <= 0 || (eSBase = call.getArg(0)) == ESBase.esNull || eSBase == ESBase.esUndefined || eSBase == ESBase.esEmpty) {
                    return Global.getGlobalProto().createObject();
                }
                if (n > 1) {
                    return this.createObjectLiteral(call, n);
                }
                return eSBase.toObject();
            }
            case 5: {
                ESObject eSObject = call.getThis();
                Global.getGlobalProto().clearMark();
                IntMap intMap = new IntMap();
                ((ESBase)eSObject).toSource(intMap, true);
                return ((ESBase)eSObject).toSource(intMap, false);
            }
            case 6: {
                if (n < 2) {
                    throw new ESException("watch expects two arguments");
                }
                ESObject eSObject = call.getThis();
                ESString eSString = call.getArg(0).toStr();
                ESBase eSBase = call.getArg(1);
                if (!(eSBase instanceof ESClosure) && !(eSBase instanceof Native)) {
                    throw new ESException("watch requires function");
                }
                eSObject.watch(eSString, eSBase);
                return ESBase.esUndefined;
            }
            case 7: {
                if (n < 1) {
                    throw new ESException("unwatch expects one argument");
                }
                ESObject eSObject = call.getThis();
                ESString eSString = call.getArg(0).toStr();
                eSObject.unwatch(eSString);
                return ESBase.esUndefined;
            }
        }
        throw new RuntimeException("Unknown object function");
    }

    public ESBase construct(Call call, int n) throws Exception {
        if (this.n != 2) {
            return super.construct(call, n);
        }
        if (n == 0 || call.getArg(0) == ESBase.esNull || call.getArg(0) == ESBase.esUndefined || call.getArg(0) == ESBase.esEmpty) {
            return Global.getGlobalProto().createObject();
        }
        if (n > 1) {
            return this.createObjectLiteral(call, n);
        }
        return call.getArg(0).toObject();
    }

    private ESBase createObjectLiteral(Call call, int n) throws Exception {
        ESObject eSObject = Global.getGlobalProto().createObject();
        int n2 = 0;
        while (n2 + 1 < n) {
            ESString eSString = call.getArg(n2, n).toStr();
            ESBase eSBase = call.getArg(n2 + 1, n);
            eSObject.setProperty(eSString, eSBase);
            n2 += 2;
        }
        return eSObject;
    }

    public static ESBase toString(ESObject eSObject) throws ESException {
        return ESString.create("[object " + eSObject.getClassName() + "]");
    }

    private NativeObject(String string, int n, int n2) {
        super(string, n2);
        this.n = n;
    }
}

