/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESArray;
import com.caucho.es.ESBase;
import com.caucho.es.ESBeanWrapper;
import com.caucho.es.ESDate;
import com.caucho.es.ESException;
import com.caucho.es.ESGlobal;
import com.caucho.es.ESId;
import com.caucho.es.ESJavaWrapper;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESPackage;
import com.caucho.es.ESRegexp;
import com.caucho.es.ESRegexpWrapper;
import com.caucho.es.ESString;
import com.caucho.es.NativeArray;
import com.caucho.es.NativeBoolean;
import com.caucho.es.NativeDate;
import com.caucho.es.NativeFile;
import com.caucho.es.NativeFunction;
import com.caucho.es.NativeGlobal;
import com.caucho.es.NativeMath;
import com.caucho.es.NativeNumber;
import com.caucho.es.NativeObject;
import com.caucho.es.NativeRegexp;
import com.caucho.es.NativeString;
import com.caucho.es.Script;
import com.caucho.es.parser.Parser;
import com.caucho.es.wrapper.Wrapper;
import com.caucho.java.LineMap;
import com.caucho.util.FreeList;
import com.caucho.util.IntMap;
import com.caucho.util.LruCache;
import com.caucho.util.SimpleClassLoader;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.util.Date;
import java.util.HashMap;

public class Global
extends ESBase {
    private static Integer LOCK = new Integer(0);
    private static WriteStream dbg;
    private static final int OBJECT = 0;
    private static final int FUNCTION = 1;
    private static final int ARRAY = 2;
    private static final int STRING = 3;
    private static final int BOOL = 4;
    private static final int NUM = 5;
    private static final int DATE = 6;
    private static final int MATH = 7;
    private static final int REGEXP = 8;
    private static final int PACKAGES = 9;
    private static final int CAUCHO = 10;
    private static final int JAVA = 11;
    private static Global goldGlobal;
    private static IntMap propertyMap;
    private static HashMap globals;
    private static Thread lastThread;
    private static Global lastGlobal;
    private static LruCache staticWraps;
    private static LruCache staticClassWraps;
    private static FreeList freeCalls;
    private ESGlobal global;
    private Global root;
    ESObject objProto;
    ESObject object;
    ESObject funProto;
    ESObject fun;
    ESObject arrayProto;
    ESObject array;
    ESObject stringProto;
    ESObject string;
    ESObject boolProto;
    ESObject bool;
    ESObject numProto;
    ESObject num;
    ESObject dateProto;
    ESObject date;
    ESObject math;
    ESRegexp regexpProto;
    ESRegexpWrapper regExp;
    ESPackage pkg;
    HashMap properties;
    HashMap globalProperties;
    private ClassLoader parentLoader;
    private ClassLoader loader;
    private Path[] scriptPath;
    private HashMap importScripts;
    private HashMap importGlobals;
    int markCount;

    void addProperty(ESId eSId, ESBase eSBase) {
        this.globalProperties.put(eSId, eSBase);
    }

    public ESBase getProperty(ESString eSString) throws Exception {
        Object v;
        ESBase eSBase;
        int n = propertyMap.get(eSString);
        switch (n) {
            case 0: {
                return this.snap(eSString, this.object);
            }
            case 1: {
                return this.snap(eSString, this.fun);
            }
            case 2: {
                return this.snap(eSString, this.array);
            }
            case 3: {
                return this.snap(eSString, this.string);
            }
            case 4: {
                return this.snap(eSString, this.bool);
            }
            case 5: {
                return this.snap(eSString, this.num);
            }
            case 6: {
                return this.snap(eSString, this.date);
            }
            case 7: {
                return this.snap(eSString, this.math);
            }
            case 8: {
                return this.snap(eSString, this.getRegexp());
            }
            case 9: {
                return this.snap(eSString, this.pkg);
            }
            case 10: {
                return this.snap(eSString, this.pkg.getProperty("com").getProperty("caucho"));
            }
            case 11: {
                return this.snap(eSString, this.pkg.getProperty("java"));
            }
        }
        ESBase eSBase2 = eSBase = this.prototype == null ? null : this.prototype.getProperty(eSString);
        if (eSBase != null && eSBase != ESBase.esEmpty) {
            return this.snap(eSString, eSBase);
        }
        if (this.properties != null && (v = this.properties.get(eSString.toString())) != null) {
            return this.snap(eSString, this.objectWrap(v));
        }
        eSBase = (ESBase)this.globalProperties.get(eSString);
        if (eSBase != null) {
            return this.snap(eSString, eSBase);
        }
        return ESBase.esEmpty;
    }

    private ESBase snap(ESString eSString, ESBase eSBase) {
        if (eSBase == null) {
            throw new RuntimeException();
        }
        this.global.put(eSString, eSBase, 4);
        return eSBase;
    }

    ESRegexpWrapper getRegexp() {
        if (this.regExp != null) {
            return this.regExp;
        }
        if (this.root.regExp != null) {
            this.regExp = this.root.regExp;
            return this.regExp;
        }
        this.initRegexp();
        return this.regExp;
    }

    ESRegexp getRegexpProto() {
        if (this.regexpProto != null) {
            return this.regexpProto;
        }
        if (this.root.regexpProto != null) {
            this.regexpProto = this.root.regexpProto;
            return this.regexpProto;
        }
        this.initRegexp();
        return this.regexpProto;
    }

    private void initRegexp() {
        this.root.regexpProto = (ESRegexp)Global.goldGlobal.regexpProto.resinCopy();
        this.root.regexpProto.prototype = this.root.objProto;
        this.root.regExp = (ESRegexpWrapper)Global.goldGlobal.regExp.resinCopy();
        this.root.regExp.prototype = this.root.funProto;
        this.root.regExp.regexp = this.root.regexpProto;
        this.regexpProto = this.root.regexpProto;
        this.regExp = this.root.regExp;
    }

    public static Global getGlobalProto() {
        HashMap hashMap = globals;
        synchronized (hashMap) {
            Thread thread = Thread.currentThread();
            if (lastThread != thread) {
                lastThread = thread;
                lastGlobal = (Global)globals.get(thread);
            }
            Global global = lastGlobal;
            Object var1_3 = null;
            return global;
        }
    }

    static LineMap getLineMap(String string) {
        Script script = Global.findScript(string);
        if (script == null) {
            return null;
        }
        return script.getLineMap();
    }

    static Script findScript(String string) {
        return Parser.loadScript(string, null);
    }

    Global begin() {
        Global global;
        HashMap hashMap = globals;
        synchronized (hashMap) {
            lastThread = Thread.currentThread();
            global = (Global)globals.get(lastThread);
            lastGlobal = this;
            globals.put(lastThread, this);
        }
        return global;
    }

    static void end(Global global) {
        HashMap hashMap = globals;
        synchronized (hashMap) {
            lastThread = null;
            globals.put(Thread.currentThread(), global);
        }
    }

    Call getCall() {
        Call call = (Call)freeCalls.allocate();
        if (call == null) {
            return new Call();
        }
        call.clear();
        return call;
    }

    void freeCall(Call call) {
        call.clear();
        freeCalls.free(call);
    }

    ESBase objectWrap(Object object) {
        ESBase eSBase;
        if (object == null) {
            return ESBase.esNull;
        }
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        if (object instanceof ESBase) {
            return (ESBase)object;
        }
        if (string.equals("java.lang.String")) {
            return new ESString(object.toString());
        }
        if (string.equals("java.lang.Double")) {
            return ESNumber.create((Double)object);
        }
        if (string.equals("java.util.Date")) {
            return this.convertDate(object);
        }
        LruCache lruCache = staticWraps;
        synchronized (lruCache) {
            eSBase = (ESBase)staticWraps.get(clazz);
        }
        if (eSBase == null) {
            ESBase[] eSBaseArray = Wrapper.bean(this, clazz);
            if (eSBaseArray == null) {
                return ESBase.esNull;
            }
            ESBase eSBase2 = eSBaseArray[0];
            eSBase = eSBaseArray[1];
            LruCache lruCache2 = staticWraps;
            synchronized (lruCache2) {
                staticClassWraps.put(clazz, eSBase2);
                staticWraps.put(clazz, eSBase);
            }
        }
        if (eSBase instanceof ESJavaWrapper) {
            return ((ESJavaWrapper)eSBase).wrap(object);
        }
        return ((ESBeanWrapper)eSBase).wrap(object);
    }

    private ESBase convertDate(Object object) {
        return ESDate.create(((Date)object).getTime());
    }

    public static ESBase wrap(Object object) {
        return Global.getGlobalProto().objectWrap(object);
    }

    ESBase classWrap(Class clazz) {
        ESBase eSBase;
        if (clazz == null) {
            throw new RuntimeException();
        }
        LruCache lruCache = staticWraps;
        synchronized (lruCache) {
            eSBase = (ESBase)staticClassWraps.get(clazz);
        }
        if (eSBase == null) {
            ESBase[] eSBaseArray = Wrapper.bean(this, clazz);
            eSBase = eSBaseArray[0];
            ESBase eSBase2 = eSBaseArray[1];
            LruCache lruCache2 = staticWraps;
            synchronized (lruCache2) {
                staticWraps.put(clazz, eSBase2);
                staticClassWraps.put(clazz, eSBase);
            }
        }
        return eSBase;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public ClassLoader getParentLoader() {
        return this.parentLoader;
    }

    public void importScript(ESObject eSObject, String string) throws Exception {
        if (this.importScripts == null) {
            this.importScripts = new HashMap();
            this.importGlobals = new HashMap();
        }
        Script script = (Script)this.importScripts.get(string);
        ESGlobal eSGlobal = (ESGlobal)this.importGlobals.get(string);
        if (script == null) {
            script = Parser.parse(string, this.scriptPath, this.loader);
            eSGlobal = new ESGlobal(this);
            this.importScripts.put(string, script);
            this.importGlobals.put(string, eSGlobal);
            script.execute(this, eSGlobal);
        }
        script.export(eSObject, eSGlobal);
    }

    ESGlobal getGlobal() {
        return this.global;
    }

    public Object toJavaObject() throws ESException {
        Object object = this.prototype.toJavaObject();
        return object == null ? this : object;
    }

    public ESObject createObject() {
        return new ESObject("Object", this.objProto);
    }

    ESArray createArray() {
        ESArray eSArray = new ESArray();
        eSArray.prototype = this.arrayProto;
        return eSArray;
    }

    void clearMark() {
        this.markCount = 0;
    }

    int addMark() {
        return ++this.markCount;
    }

    private Global(boolean bl) {
        ESBase.init(null);
        if (dbg == null) {
            dbg = LogStream.open("/caucho.com/es/main");
            globals = new HashMap();
            staticWraps = new LruCache(256);
            staticClassWraps = new LruCache(256);
            ESId.intern("foo");
        }
        propertyMap = new IntMap();
        propertyMap.put(ESId.intern("Object"), 0);
        propertyMap.put(ESId.intern("Function"), 1);
        propertyMap.put(ESId.intern("Array"), 2);
        propertyMap.put(ESId.intern("String"), 3);
        propertyMap.put(ESId.intern("Boolean"), 4);
        propertyMap.put(ESId.intern("Number"), 5);
        propertyMap.put(ESId.intern("Date"), 6);
        propertyMap.put(ESId.intern("Math"), 7);
        propertyMap.put(ESId.intern("RegExp"), 8);
        propertyMap.put(ESId.intern("Packages"), 9);
        propertyMap.put(ESId.intern("caucho"), 10);
        propertyMap.put(ESId.intern("java"), 11);
        this.globalProperties = new HashMap();
        this.object = NativeObject.create(this);
        this.fun = NativeFunction.create(this);
        this.object.prototype = this.funProto;
        int n = 4;
        int n2 = 7;
        this.array = NativeArray.create(this);
        this.string = NativeString.create(this);
        this.bool = NativeBoolean.create(this);
        this.num = NativeNumber.create(this);
        this.math = NativeMath.create(this);
        this.date = NativeDate.create(this);
        this.regExp = NativeRegexp.create(this);
        this.pkg = ESPackage.create();
        NativeGlobal.create(this);
        NativeFile.create(this);
        this.globalProperties.put(ESId.intern("NaN"), ESNumber.create(Double.NaN));
        this.globalProperties.put(ESId.intern("Infinity"), ESNumber.create(Double.POSITIVE_INFINITY));
    }

    Global(HashMap hashMap, Object object, Path path, Path[] pathArray, ClassLoader classLoader) {
        Integer n = LOCK;
        synchronized (n) {
            if (goldGlobal == null) {
                goldGlobal = new Global(true);
            }
        }
        this.global = new ESGlobal(this);
        this.root = this;
        this.parentLoader = classLoader;
        this.loader = SimpleClassLoader.create(classLoader, path, null);
        this.scriptPath = pathArray;
        this.objProto = Global.goldGlobal.objProto.resinCopy();
        this.object = Global.goldGlobal.object.resinCopy();
        this.funProto = Global.goldGlobal.funProto.resinCopy();
        this.funProto.prototype = this.objProto;
        this.object.prototype = this.funProto;
        this.fun = Global.goldGlobal.fun.resinCopy();
        this.fun.prototype = this.funProto;
        this.arrayProto = Global.goldGlobal.arrayProto.resinCopy();
        this.arrayProto.prototype = this.objProto;
        this.array = Global.goldGlobal.array.resinCopy();
        this.array.prototype = this.funProto;
        this.stringProto = Global.goldGlobal.stringProto.resinCopy();
        this.stringProto.prototype = this.objProto;
        this.string = Global.goldGlobal.string.resinCopy();
        this.string.prototype = this.funProto;
        this.boolProto = Global.goldGlobal.boolProto.resinCopy();
        this.boolProto.prototype = this.objProto;
        this.bool = Global.goldGlobal.bool.resinCopy();
        this.bool.prototype = this.funProto;
        this.numProto = Global.goldGlobal.numProto.resinCopy();
        this.numProto.prototype = this.objProto;
        this.num = Global.goldGlobal.num.resinCopy();
        this.num.prototype = this.funProto;
        this.math = Global.goldGlobal.math.resinCopy();
        this.math.prototype = this.objProto;
        this.dateProto = Global.goldGlobal.dateProto.resinCopy();
        this.dateProto.prototype = this.objProto;
        this.date = Global.goldGlobal.date.resinCopy();
        this.date.prototype = this.funProto;
        this.pkg = ESPackage.create();
        if (object != null) {
            this.prototype = this.objectWrap(object);
            this.prototype.prototype = this.objProto;
        } else {
            this.prototype = this.objProto;
        }
        if (hashMap != null) {
            this.properties = hashMap;
        }
        this.globalProperties = Global.goldGlobal.globalProperties;
    }

    Global(Global global) {
        this.global = new ESGlobal(this);
        this.root = global;
        this.objProto = global.objProto;
        this.object = global.object;
        this.funProto = global.funProto;
        this.fun = global.fun;
        this.arrayProto = global.arrayProto;
        this.array = global.array;
        this.stringProto = global.stringProto;
        this.string = global.string;
        this.boolProto = global.boolProto;
        this.bool = global.bool;
        this.numProto = global.numProto;
        this.num = global.num;
        this.math = global.math;
        this.dateProto = global.dateProto;
        this.date = global.date;
        this.regexpProto = global.regexpProto;
        this.regExp = global.regExp;
        this.pkg = global.pkg;
        this.properties = global.properties;
        this.prototype = global.prototype;
        this.globalProperties = global.globalProperties;
    }

    static {
        freeCalls = new FreeList(2);
    }
}

