/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESClosure;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNullException;
import com.caucho.es.ESString;
import com.caucho.es.ESThunk;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.PropertyEnumeration;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import java.util.HashMap;
import java.util.Iterator;

public class ESObject
extends ESBase {
    static ESId TO_STRING = ESId.intern("toString");
    static ESId VALUE_OF = ESId.intern("valueOf");
    static ESId CALL = ESId.intern("call");
    static ESId CONSTRUCT = ESId.intern("construct");
    static int DIRTY = 0;
    static int CLEAN = DIRTY + 1;
    static int COW = CLEAN + 1;
    int copyState = DIRTY;
    ESString[] propNames;
    ESBase[] propValues;
    ESBase[] propWatch;
    int[] propFlags;
    int size;
    int fill;
    int mask;
    int mark;
    protected boolean snapPrototype;

    private void init(String string, ESBase eSBase, int n) {
        if (eSBase == null) {
            Global global = Global.getGlobalProto();
            ESBase eSBase2 = eSBase = global == null ? null : global.objProto;
        }
        if (string == null && eSBase != null) {
            string = eSBase.className;
        }
        this.prototype = eSBase;
        this.propNames = new ESString[n];
        this.propValues = new ESBase[n];
        this.propFlags = new int[n];
        this.mask = this.propNames.length - 1;
        this.size = 0;
        this.fill = 0;
        this.copyState = DIRTY;
        this.className = string == null ? "Object" : string;
    }

    void init(String string, ESBase eSBase) {
        this.init(string, eSBase, 16);
    }

    void setClean() {
        this.copyState = CLEAN;
    }

    private void resize(int n) {
        ESString[] eSStringArray = new ESString[n];
        ESBase[] eSBaseArray = new ESBase[n];
        int[] nArray = new int[n];
        ESBase[] eSBaseArray2 = null;
        if (this.propWatch != null) {
            eSBaseArray2 = new ESBase[n];
        }
        this.mask = eSStringArray.length - 1;
        int n2 = 0;
        while (n2 < this.propNames.length) {
            if (this.propValues[n2] != null || (this.propFlags[n2] & 8) != 0) {
                int n3 = this.propNames[n2].hashCode() & this.mask;
                while (true) {
                    if (eSStringArray[n3] == null) {
                        eSStringArray[n3] = this.propNames[n2];
                        eSBaseArray[n3] = this.propValues[n2];
                        nArray[n3] = this.propFlags[n2];
                        if (eSBaseArray2 == null) break;
                        eSBaseArray2[n3] = this.propWatch[n2];
                        break;
                    }
                    n3 = n3 + 1 & this.mask;
                }
            }
            ++n2;
        }
        this.propNames = eSStringArray;
        this.propValues = eSBaseArray;
        this.propFlags = nArray;
        this.propWatch = eSBaseArray2;
        this.fill = this.size;
    }

    private void refill() {
        int n = 0;
        while (n < this.propNames.length) {
            if (this.propValues[n] == null && (this.propFlags[n] & 8) == 0) {
                this.propNames[n] = null;
            } else {
                int n2 = this.propNames[n].hashCode() & this.mask;
                while (true) {
                    if (this.propValues[n2] == null && (this.propFlags[n2] & 8) == 0) {
                        this.propNames[n2] = this.propNames[n];
                        this.propValues[n2] = this.propValues[n];
                        this.propFlags[n2] = this.propFlags[n];
                        this.propNames[n] = null;
                        this.propValues[n] = null;
                        this.propFlags[n] = 0;
                        break;
                    }
                    n2 = n2 + 1 & this.mask;
                }
            }
            ++n;
        }
        this.fill = this.size;
    }

    public ESBase getProperty(ESString eSString) throws Exception {
        int n = eSString.hashCode() & this.mask;
        while (true) {
            ESString eSString2;
            if ((eSString2 = this.propNames[n]) == eSString || eSString.equals(eSString2)) {
                ESBase eSBase = this.propValues[n];
                return eSBase == null ? this.prototype.getProperty(eSString) : eSBase;
            }
            if (eSString2 == null) {
                ESBase eSBase = this.prototype.getProperty(eSString);
                if (this.snapPrototype) {
                    this.setProperty(eSString, eSBase);
                }
                return eSBase;
            }
            n = n + 1 & this.mask;
        }
    }

    protected boolean canPut(ESString eSString) {
        int n = eSString.hashCode() & this.mask;
        ESString eSString2;
        while (!eSString.equals(eSString2 = this.propNames[n]) || this.propValues[n] == null) {
            if (eSString2 == null) {
                if (this.prototype instanceof ESObject) {
                    return ((ESObject)this.prototype).canPut(eSString);
                }
                return true;
            }
            n = n + 1 & this.mask;
        }
        return (this.propFlags[n] & 1) == 0;
    }

    public void setProperty(ESString eSString, ESBase eSBase) throws Exception {
        if (this.copyState != DIRTY) {
            if (this.copyState == COW) {
                this.copyAll();
            }
            this.copyState = DIRTY;
        }
        if (eSBase == ESBase.esEmpty) {
            eSBase = ESBase.esUndefined;
        }
        int n = eSString.hashCode() & this.mask;
        while (true) {
            ESString eSString2 = this.propNames[n];
            if (this.propValues[n] == null) {
                if (!this.prototype.canPut(eSString)) {
                    return;
                }
                if (eSString2 == null) {
                    ++this.fill;
                }
                this.propNames[n] = eSString;
                this.propValues[n] = eSBase;
                this.propFlags[n] = 0;
                ++this.size;
                if (this.propNames.length <= 4 * this.size) {
                    this.resize(4 * this.propNames.length);
                } else if (this.propNames.length <= 2 * this.fill) {
                    this.refill();
                }
                return;
            }
            if (eSString2 == eSString || eSString2.equals(eSString)) break;
            n = n + 1 & this.mask;
        }
        if ((this.propFlags[n] & 1) != 0) {
            return;
        }
        this.propValues[n] = eSBase;
    }

    public void put(ESString eSString, ESBase eSBase, int n) {
        int n2 = eSString.hashCode() & this.mask;
        while (true) {
            ESString eSString2;
            if ((eSString2 = this.propNames[n2]) == null || this.propValues[n2] == null || eSString2.equals(eSString)) {
                if (eSString2 == null) {
                    ++this.fill;
                }
                if (this.propValues[n2] == null) {
                    ++this.size;
                }
                this.propNames[n2] = eSString;
                this.propValues[n2] = eSBase;
                this.propFlags[n2] = n;
                if (this.propNames.length <= 4 * this.size) {
                    this.resize(4 * this.propNames.length);
                } else if (this.propNames.length <= 2 * this.fill) {
                    this.refill();
                }
                return;
            }
            n2 = n2 + 1 & this.mask;
        }
    }

    public void put(String string, ESBase eSBase, int n) {
        ESId eSId = ESId.intern(string);
        this.put(eSId, eSBase, n);
    }

    public ESBase delete(ESString eSString) throws Exception {
        if (this.copyState != DIRTY) {
            if (this.copyState == COW) {
                this.copyAll();
            }
            this.copyState = DIRTY;
        }
        int n = eSString.hashCode() & this.mask;
        ESString eSString2;
        while ((eSString2 = this.propNames[n]) != null) {
            if (this.propValues[n] != null && eSString2.equals(eSString)) {
                if ((this.propFlags[n] & 2) != 0) {
                    return ESBoolean.FALSE;
                }
                this.propValues[n] = null;
                --this.size;
                return ESBoolean.TRUE;
            }
            n = n + 1 & this.mask;
        }
        return ESBoolean.FALSE;
    }

    public void watch(ESString eSString, ESBase eSBase) {
        if (this.copyState != DIRTY) {
            if (this.copyState == COW) {
                this.copyAll();
            }
            this.copyState = DIRTY;
        }
        int n = eSString.hashCode() & this.mask;
        while (true) {
            ESString eSString2 = this.propNames[n];
            if (this.propValues[n] == null) {
                if (!this.prototype.canPut(eSString)) {
                    return;
                }
                if (eSString2 == null) {
                    ++this.fill;
                }
                this.propNames[n] = eSString;
                this.propValues[n] = ESBase.esEmpty;
                this.propFlags[n] = 8;
                if (this.propWatch == null) {
                    this.propWatch = new ESBase[this.propFlags.length];
                }
                this.propWatch[n] = eSBase;
                ++this.size;
                if (this.propNames.length <= 4 * this.size) {
                    this.resize(4 * this.propNames.length);
                } else if (this.propNames.length <= 2 * this.fill) {
                    this.refill();
                }
                return;
            }
            if (eSString2 == eSString || eSString2.equals(eSString)) break;
            n = n + 1 & this.mask;
        }
        if ((this.propFlags[n] & 1) != 0) {
            return;
        }
        int n2 = n;
        this.propFlags[n2] = this.propFlags[n2] | 8;
        if (this.propWatch == null) {
            this.propWatch = new ESBase[this.propFlags.length];
        }
        this.propWatch[n] = eSBase;
    }

    public void unwatch(ESString eSString) {
        ESString eSString2;
        if (this.copyState != DIRTY) {
            if (this.copyState == COW) {
                this.copyAll();
            }
            this.copyState = DIRTY;
        }
        int n = eSString.hashCode() & this.mask;
        do {
            if ((eSString2 = this.propNames[n]) != null) continue;
            return;
        } while (!eSString2.equals(eSString));
        int n2 = n;
        this.propFlags[n2] = this.propFlags[n2] & 0xFFFFFFF7;
    }

    public void put(int n, ESBase eSBase, int n2) {
        this.put(ESString.create(n), eSBase, n2);
    }

    public Iterator keys() throws ESException {
        return new PropertyEnumeration(this);
    }

    public ESBase typeof() throws ESException {
        return ESString.create("object");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ESBase toPrimitive(int n) throws Exception {
        ESBase eSBase;
        Global global = Global.getGlobalProto();
        Call call = global.getCall();
        call.global = global.getGlobal();
        try {
            ESBase eSBase2;
            ESBase eSBase3 = this.hasProperty(n == 1 ? TO_STRING : VALUE_OF);
            if (eSBase3 instanceof ESClosure || eSBase3 instanceof Native) {
                call.stack[0] = this;
                call.top = 1;
                eSBase2 = eSBase3.call(call, 0);
                if (eSBase2 instanceof ESBase && !(eSBase2 instanceof ESObject)) {
                    ESBase eSBase4 = eSBase2;
                    Object var5_8 = null;
                    global.freeCall(call);
                    return eSBase4;
                }
            }
            if (!((eSBase3 = this.hasProperty(n == 1 ? VALUE_OF : TO_STRING)) instanceof ESClosure) && !(eSBase3 instanceof Native)) throw new ESException("cannot convert object to primitive type");
            call.stack[0] = this;
            call.top = 1;
            eSBase2 = eSBase3.call(call, 0);
            if (!(eSBase2 instanceof ESBase) || eSBase2 instanceof ESObject) throw new ESException("cannot convert object to primitive type");
            eSBase = eSBase2;
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            global.freeCall(call);
            throw throwable;
        }
        Object var5_9 = null;
        global.freeCall(call);
        return eSBase;
    }

    public ESObject toObject() {
        return this;
    }

    public Object toJavaObject() throws ESException {
        return this;
    }

    public double toNum() throws Exception {
        ESBase eSBase = this.toPrimitive(2);
        if (eSBase instanceof ESObject) {
            throw new ESException("toPrimitive must return primitive");
        }
        return eSBase.toNum();
    }

    public ESString toStr() throws Exception {
        ESBase eSBase = this.toPrimitive(1);
        if (eSBase instanceof ESObject) {
            throw new ESException("toPrimitive must return primitive");
        }
        return eSBase.toStr();
    }

    public ESString toSource(IntMap intMap, boolean bl) throws Exception {
        CharBuffer charBuffer = new CharBuffer();
        Global global = Global.getGlobalProto();
        int n = intMap.get(this);
        if (n > 0 && bl) {
            return null;
        }
        if (n > 0) {
            charBuffer.append("#" + n + "=");
            intMap.put(this, -n);
        } else {
            if (n == 0 && bl) {
                intMap.put(this, global.addMark());
                return null;
            }
            if (n < 0 && !bl) {
                return ESString.create("#" + -n + "#");
            }
        }
        charBuffer.append("{");
        if (bl) {
            intMap.put(this, 0);
        }
        Iterator iterator = this.keys();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            if (!bl2) {
                charBuffer.append(", ");
            }
            bl2 = false;
            ESString eSString = (ESString)iterator.next();
            charBuffer.append(eSString);
            charBuffer.append(":");
            ESBase eSBase = this.getProperty(eSString);
            if (bl) {
                eSBase.toSource(intMap, bl);
                continue;
            }
            charBuffer.append(eSBase.toSource(intMap, bl));
        }
        charBuffer.append("}");
        return new ESString(charBuffer.toString());
    }

    public boolean toBoolean() {
        return true;
    }

    ESObject dup() {
        return new ESObject();
    }

    public Object copy(HashMap hashMap) {
        Object v = hashMap.get(this);
        if (v != null) {
            return v;
        }
        ESObject eSObject = this.dup();
        hashMap.put(this, eSObject);
        this.copy(hashMap, eSObject);
        return eSObject;
    }

    private void copyAll() {
        this.copyState = DIRTY;
        int n = this.propValues.length;
        ESString[] eSStringArray = new ESString[n];
        int[] nArray = new int[n];
        ESBase[] eSBaseArray = new ESBase[n];
        System.arraycopy(this.propNames, 0, eSStringArray, 0, n);
        System.arraycopy(this.propFlags, 0, nArray, 0, n);
        System.arraycopy(this.propValues, 0, eSBaseArray, 0, n);
        this.propNames = eSStringArray;
        this.propFlags = nArray;
        this.propValues = eSBaseArray;
        if (this.propWatch != null) {
            ESBase[] eSBaseArray2 = new ESBase[n];
            System.arraycopy(this.propWatch, 0, eSBaseArray2, 0, n);
            this.propWatch = eSBaseArray2;
        }
    }

    ESObject resinCopy() {
        ESObject eSObject = this.dup();
        this.copy(eSObject);
        return eSObject;
    }

    protected void copy(Object object) {
        ESObject eSObject = (ESObject)object;
        eSObject.prototype = this.prototype;
        eSObject.className = this.className;
        eSObject.propNames = this.propNames;
        eSObject.propValues = this.propValues;
        eSObject.propFlags = this.propFlags;
        eSObject.propWatch = this.propWatch;
        eSObject.size = this.size;
        eSObject.fill = this.fill;
        eSObject.mask = this.mask;
        eSObject.copyState = this.copyState;
        if (eSObject.copyState == DIRTY) {
            throw new RuntimeException();
        }
        if (this.copyState == CLEAN) {
            this.copyState = COW;
            eSObject.copyState = COW;
        }
    }

    protected void copy(HashMap hashMap, Object object) {
        ESObject eSObject = (ESObject)object;
        eSObject.prototype = (ESBase)this.prototype.copy(hashMap);
        eSObject.className = this.className;
        eSObject.propNames = this.propNames;
        eSObject.propValues = this.propValues;
        eSObject.propFlags = this.propFlags;
        eSObject.propWatch = this.propWatch;
        eSObject.size = this.size;
        eSObject.fill = this.fill;
        eSObject.mask = this.mask;
        eSObject.copyState = this.copyState;
        if (eSObject.copyState == DIRTY) {
            eSObject.copyAll();
        } else if (this.copyState == CLEAN) {
            this.copyState = COW;
            eSObject.copyState = COW;
        }
    }

    ESObject shallowCopy() {
        ESObject eSObject = this.dup();
        this.shallowCopy(eSObject);
        return eSObject;
    }

    protected void shallowCopy(Object object) {
        ESObject eSObject = (ESObject)object;
        eSObject.prototype = this.prototype;
        eSObject.className = this.className;
        int n = this.propValues.length;
        if (this.propWatch != null) {
            eSObject.propWatch = new ESBase[n];
            System.arraycopy(this.propWatch, 0, eSObject.propWatch, 0, n);
        }
        eSObject.propNames = new ESString[n];
        eSObject.propFlags = new int[n];
        eSObject.propValues = new ESBase[n];
        ESString[] eSStringArray = eSObject.propNames;
        ESString[] eSStringArray2 = this.propNames;
        ESBase[] eSBaseArray = eSObject.propValues;
        ESBase[] eSBaseArray2 = this.propValues;
        int[] nArray = eSObject.propFlags;
        int[] nArray2 = this.propFlags;
        int n2 = 0;
        while (n2 < n) {
            eSStringArray[n2] = eSStringArray2[n2];
            eSBaseArray[n2] = eSBaseArray2[n2];
            nArray[n2] = nArray2[n2];
            ++n2;
        }
        eSObject.size = this.size;
        eSObject.mask = this.mask;
        eSObject.fill = this.fill;
        eSObject.copyState = DIRTY;
    }

    public boolean ecmaEquals(ESBase eSBase) throws Exception {
        if (eSBase instanceof ESObject || eSBase instanceof ESThunk) {
            return this == eSBase;
        }
        return this.toPrimitive(0).ecmaEquals(eSBase);
    }

    public ESBase call(Call call, int n) throws Exception {
        ESBase eSBase = this.hasProperty(CALL);
        if (eSBase != null) {
            call.setThis(this);
            return eSBase.call(call, n);
        }
        throw new ESNullException(this.toStr() + " is not a function");
    }

    public ESBase construct(Call call, int n) throws Exception {
        ESBase eSBase = this.hasProperty(CONSTRUCT);
        if (eSBase != null) {
            call.setThis(this);
            return eSBase.construct(call, n);
        }
        throw new ESNullException(this.toStr() + " is not a constructor");
    }

    protected ESObject() {
    }

    public ESObject(String string, ESBase eSBase) {
        this.init(string, eSBase, 16);
    }

    protected ESObject(String string, ESBase eSBase, int n) {
        this.init(string, eSBase, n < 16 ? 16 : n);
    }
}

