/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Iterator;

public class ArrayList
extends AbstractList {
    Object[] data;
    int length;

    public void clear() {
        while (this.length > 0) {
            this.data[--this.length] = null;
        }
    }

    private final void expand(int n) {
        while (n > this.data.length) {
            Object[] objectArray = new Object[this.data.length * 2];
            int n2 = 0;
            while (n2 < this.data.length) {
                objectArray[n2] = this.data[n2];
                ++n2;
            }
            this.data = objectArray;
        }
    }

    public int size() {
        return this.length;
    }

    public boolean add(Object object) {
        this.expand(this.length + 1);
        this.data[this.length++] = object;
        return true;
    }

    public void add(int n, Object object) {
        if (n < 0 || n > this.length) {
            throw new IndexOutOfBoundsException(n + " " + this.length);
        }
        this.expand(this.length + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.length - n);
        ++this.length;
        this.data[n] = object;
    }

    public Object remove(int n) {
        Object object = this.data[n];
        --this.length;
        int n2 = n;
        while (n2 < this.length) {
            this.data[n2] = this.data[n2 + 1];
            ++n2;
        }
        this.data[this.length] = null;
        return object;
    }

    public boolean remove(Object object) {
        int n = 0;
        while (n < this.length) {
            if (this.data[n] == object) {
                this.remove(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public void ensureCapacity(int n) {
        if (n < this.length) {
            return;
        }
        this.expand(n);
    }

    public Object get(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException(n + " " + this.length);
        }
        return this.data[n];
    }

    public Iterator iterator() {
        ArrayList arrayList = this;
        if (arrayList == null) {
            throw null;
        }
        return arrayList.new ArrayListIterator();
    }

    public int indexOf(Object object) {
        int n = 0;
        while (n < this.length) {
            if (this.data[n] == object || this.data[n] != null && this.data[n].equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Object elementAt(int n) {
        return this.data[n];
    }

    public Object last() {
        return this.length == 0 ? null : this.data[this.length - 1];
    }

    public Object set(int n, Object object) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException(n + " " + this.length);
        }
        Object object2 = this.data[n];
        this.data[n] = object;
        return object2;
    }

    public boolean contains(Object object) {
        int n = 0;
        while (n < this.length) {
            if (this.data[n] == object || this.data[n] != null && this.data[n].equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isSubset(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.length) {
            if (!this.contains(arrayList.data[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void union(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.length) {
            if (!this.contains(arrayList.data[n])) {
                this.add(arrayList.data[n]);
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ArrayList[");
        int n = 0;
        while (n < this.size()) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.get(n));
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        ArrayList arrayList = new ArrayList(this.data.length);
        arrayList.length = this.length;
        int n = 0;
        while (n < this.length) {
            arrayList.data[n] = this.data[n];
            ++n;
        }
        return arrayList;
    }

    public ArrayList() {
        this.data = new Object[16];
        this.length = 0;
    }

    private ArrayList(int n) {
        if (n < 16) {
            n = 16;
        }
        this.data = new Object[n];
        this.length = 0;
    }

    class ArrayListIterator
    implements Iterator {
        int index;

        public boolean hasNext() {
            return this.index < ArrayList.this.length;
        }

        public Object next() {
            return ArrayList.this.data[this.index++];
        }

        public void remove() {
            ArrayList.this.remove(this.index--);
        }

        ArrayListIterator() {
        }
    }
}

