package udmTemplate;
# GPL
# author: Rohan Baxter, Ultimode Inc. rohan@ultimode.com

use strict;
#use diagnostics;
use udmDB;

# input: a template file
# output: a ref to a template hash, each hash entry is a template
# Side-Effect: sets ENV according to variables in template file
sub read_template(){
	my $fname = shift;
	open(TEMPLATE,"<$fname") or
	  die "Could not open $fname\n";
	my $where = "";

	my %templates; # stores the template entries
	my $line = "";
	while (defined($line = <TEMPLATE>)){
#	  print "checking: $line \n";
	  if ($line =~ m/<!--(\w+)/){ # found start of a template
	    $where = $1;
	    $templates{$where} = "";
	    next;
	  } elsif ($line =~ m/\/(\w+)-->/) { # found end of a template
	    $where = "";
	    next;
	  } elsif (defined($where) && ($where eq 'variables')){ 
	    # do ENV variable assignment
	    (my $var, my $value) = split('=',$line);
	    if (defined($var) && defined($value)){
	      $value =~ s/\s+//g;
	      $ENV{$var} = $value;
	    }
	  } elsif ($where ne ""){ #Must be line in a template
	    $templates{$where} = $templates{$where} . $line;
	  } else { # catch-all
	     #print "did nothing with this line: $line \n";
	  }
	}
	return \%templates;
      }

sub print_template{
  my %template = %{shift()};
  my $part = shift;
  my %template_env = %{shift()};

	#print "print_template: $part \n";
	my $str = "";
	$str = $template{ $part };
	
	$str =~ s/\$f/$template_env{from1}/gs;	
	$str =~ s/\$l/$template_env{to}/gs;	
	$str =~ s/\$t/$template_env{found}/gs;	
	$str =~ s/\$A/$template_env{self}/gs;	
	$str =~ s/\$Q/$template_env{query}/gs;	
	$str =~ s/\$E/$template_env{error}/gs;	
	$str =~ s/\$V/$template_env{nav}/gs;	
	$str =~ s/\$W/$template_env{words_info}/gs;	
	$str =~ s/\$DT/$template_env{title}/gs;	
	$str =~ s/\$DR/$template_env{rating}/gs;	
# <innominate>
	# output only 100 charactes of text, cause it can be _very_ long
	# this is not very elegant, the text should be truncated somewhere before, on the query layer maybe.
	# but for now it works like this
	$template_env{text} =sprintf ("%.100s",$template_env{text});
	
	# newvariables 
	$str =~ s/\$DI/$template_env{rec_id}/gs;	
	$str =~ s/\$DA/$template_env{date}/gs;	

	# build different url. point to message.pl
	my $tmpquery = $template_env{query};
	$tmpquery =~ s/\&/ /g;
	$tmpquery =~ s/\|/ /g;
	$tmpquery =~ s/\~/ /g;
	$tmpquery =~ s/\(/ /g;
	$tmpquery =~ s/\)/ /g;
	$tmpquery =~ s/^\s+//g; # leading whitespace
	$tmpquery =~ s/\s+$//g; # trailing whitespace
	$tmpquery =~ s/\s+/\+/g;# compress whitespace

	my $db_url = "message.pl?rec_id=$template_env{rec_id}\&query=$tmpquery";
	$str =~ s/\$DU/$db_url/gs;	
	# print warning if indexer is currently running on same machine
	$str =~ s/\$DW/$template_env{indexer_warning}/gs;	

# </innominate>
	$str =~ s/\$DX/$template_env{text}/gs;	
	$str =~ s/\$DC/$template_env{contype}/gs;	
	$str =~ s/\$DM/$template_env{lastmod}/gs;	
	$str =~ s/\$DS/$template_env{docsize}/gs;	
	$str =~ s/\$DN/$template_env{ndoc}/gs;	
	$str =~ s/\$DD/$template_env{desc}/gs;	
	$str =~ s/\$DK/$template_env{keyw}/gs;	

	# get random r prefix variables
	# this does banner ad stuff
	
	$template_env{clon} = "";
	# if has clone entry: CL

	if ( ($str =~ m/\$CL/s) && ($part eq "res")){


		if (defined($template_env{crc})){ # if crc is not null


			my $sth = &udmDB::get_clones( $template_env{dbh}, 
					$template_env{crc}, 
					$template_env{rec_id} );	
			
		if ($sth->rows() > 0){
		open(FILE,">/tmp/tmp.template");
		print FILE "starting ()\n";
			print FILE "\ncrc: $template_env{crc} \n";
			
			while (my @row = $sth->fetchrow_array){ 
				my %template_env_clone = %template_env;
			print FILE "$row[0] vs $template_env{rec_id} \n";
			print FILE "$row[1] vs $template_env{crc} \n";
				$template_env_clone{url} = $row[0];
				$template_env_clone{contype} = $row[1];
				$template_env_clone{lastmod} = $row[2];

				$template_env{clon} .= print_template(\%template,'clone',\%template_env_clone);
			}

		print FILE "finishing ...$template_env{clon}... \n";
		close(FILE);
		}
			$sth->finish();
		}	
	$str =~ s/\$CL/$template_env{clon}/gs;	
	}
	return $str;
}

sub print_error{
  my $err_str = shift;
  my %template = %{shift()};
  my %template_env = %{shift()};
  my $string = "";
  $template_env{"error"} = $err_str; # set error string
  $string .= &udmTemplate::print_template(\%template,"error",\%template_env);
  $string .= &udmTemplate::print_template(\%template,"bottom",\%template_env);
  return $string;
}


1;
