#!/usr/bin/perl

# GPL
# author: Heiko Stoermer, innominate AG, stoermer@innominate.de
# based on search.pl by Rohan Baxter, Ultimode Inc. rohan@ultimode.com
# uses udmDB.pm by Rohan Baxter
#
# !
#
# This is just a fast hack. No proper error-handling etc. 
#
# !
# CGI-script args:
#	rec_id: record-id of message
#	msg_id: message-id of message
#
#
#use strict;
use diagnostics;

use udmDB; 
use DBI();
use CGI();

$ENV{MySQLDB} = 'udmsearch';
$ENV{MySQLHost} = 'localhost';
$ENV{MySQLUser} = 'foo';
$ENV{MySQLPass} = 'bar';

$self = 'message.pl';
# Connect to Database
my $dbh = &udmDB::dbconnect($ENV{MySQLDB},$ENV{MySQLHost},
			    $ENV{MySQLUser},$ENV{MySQLPass});
my $sth;


#-------------
# main
#-------------
#
# main entry point
#
&main;
sub main
{
	# print out header straight-away
	print "Content-type: text/html\n\n";
	
	my $nntpserver = "news://news/";
	my $template_file = "message.html";
	
	# Read in Template (will set $ENV{} variables as side-effect)!
	
	# Query Processing
	
	# Query string is taken from CGI param
	my $cgi = new CGI;
	my $rec_id_param = $cgi->param("rec_id");
	my $msg_id_param = $cgi->param("msg_id");
	my $showtree_param = $cgi->param("tree") || 0;
	my $querywordstring = $cgi->param("query") || "";
	my @querywords = split(/ /,$querywordstring);

	# CGI Issue: what about htmlspecialchars?
	# If user supplies &amp;&quot;&gt;%lt
	
	 
			    
	# get message handle			    
	if($rec_id_param)
	{
		$sth = &udmDB::get_doc_by_id($dbh, $rec_id_param);
	}
	elsif($msg_id_param)
	{
		$sth = &udmDB::get_doc_by_url($dbh, $msg_id_param);
	}
	else
	{
		print "<h2>Error</h2>";
		print "Missing variables<br>";
		print "Please supply rec_id or msg_id<br>";
		exit 1;
	}
	my @data = ();
	my @refs = ();
	my ($url, $title, $text, $keywords, $contype, $docsize, $lastmod, $keyw, $desc, $crc, $rating, $query);
	my ($date,$subject,$from,$group,$refs);

	open(TEMPLATE,"<$template_file") || print "Could not load template - exiting\n<br>";
	my $template;
	while(<TEMPLATE>)
	{
		$template .= $_;
	}	
	# we need no while-loop because there is only one message
	@data = $sth->fetchrow_array;
	$sth->finish();
	my($word);	
	$url = $data[0];
	$title = $data[1];
	$text = $data[2];
	$date = $data[3];
	$subject = $data[4];
	$from = $data[5];
	$group = $data[6];
	$refs = $data[7];
	$message_id = $data[8];
	$message_id_link = "\<A HREF=\"" . $nntpserver . $message_id . "\"\>" . $message_id . "\</A\>";
	#
	# now get references to url
	#

	# thread functions
	# build tree
	my $ref_tree = "";
	my $viewtree_link = "";
	# if the user has selected to view the message tree
	if($showtree_param > 0)
	{
		$viewtree_link = "<a href=$self?rec_id=$rec_id_param\&tree=0\&query=$querywordstring>Hide Threads</a>";
		$ref_tree = &NewsTree($rec_id_param,\@data);
	}	
	else
	{
		$viewtree_link = "<a href=$self?rec_id=$rec_id_param\&tree=1\&query=$querywordstring>Show Threads</a>";
	}

	# do some character replacement
	$text =~ s/\r//g;
	$text =~ s/\</\&lt;/g;
	$text =~ s/\>/\&gt;/g;
	$subject =~ s/\</\&lt;/g;
	$subject =~ s/\>/\&gt;/g;
	$from =~ s/\</\&lt;/g;
	$from =~ s/\>/\&gt;/g;

	#
	# do matchwords highlighting
	# (also highlight longer words that contain a searchword)
	#
	for $word (@querywords)
	{
		$text =~ s/(\w*$word\w*)/\<font color\=E52B00\>\<b\>$1\<\/b\>\<\/font\>/gi;
	}
	
	if (!$text) {
		$text = "\</PRE\>\<BR\>This message could not be stored please click \<A HREF=\"" . $nntpserver . $message_id . "\"\>here\</A\> to attempt to retreive the posting from the news server.";
	}

	# 
	# replace template vars
	#
	#
	$template =~ s/<db_title\/>/$title/g;
	$template =~ s/<db_text\/>/$text/g;
	$template =~ s/<db_group\/>/$group/g;
	$template =~ s/<db_from\/>/$from/g;
	$template =~ s/<db_date\/>/$date/g;
	$template =~ s/<db_view_tree\/>/$viewtree_link/g;
	$template =~ s/<db_ref_tree\/>/$ref_tree/g;
	$template =~ s/<db_message_id\/>/$message_id/g;
	$template =~ s/<message_id_link\/>/$message_id_link/g;


	# It might be better to "dribble" output so that results can be seen
	# straightaway
	$dbh->disconnect();
	print $template."\n";
}

#-------------------
# NewsTree(rec_id,mydata)
#-------------------
# Builds a complete tree for usenet news
# starts at any message-id and builds the complete tree for its root node
sub NewsTree
{
	my $me = shift; 	# the node to start with, myself
	my $myDataRef = shift;	# my own document data
	my $refs = $myDataRef->[7];
	#
	# build the link for the root node of the thread
	#
	# find root first
	my @parents;
	my @msg_data;
	my $root;
	if(length($refs))
	{
		@parents = split(/ /,$refs);
		$root = $parents[0];
		$root =~ s/\<//g;
		$root =~ s/\>//g;
		# now we have the root node's message_id in $root
		# get its rec_id and other display data from db
		@msg_data = &udmDB::doc_data($dbh, $root);
	}
	else
	{
		# I have no parents, so I'm the root now myself
		# map my own data to result array msg_data so that we do not need
		# another database query
		$msg_data[0] = $me;
		$msg_data[1] = $myDataRef->[0];
		$msg_data[2] = $myDataRef->[1];
		$msg_data[3] = $myDataRef->[3];
		$msg_data[4] = $myDataRef->[4];
		$msg_data[5] = $myDataRef->[5];
		
	}
	my $highlight_start = "";
	my $highlight_end = "";
	if($me eq $msg_data[0])
	{
		$highlight_start = "<b><i>";
		$highlight_end = "</i></b>";
		
	}
	my $rootstring = "$highlight_start <a href=$self?tree=1\&rec_id=$msg_data[0]>$msg_data[2]</a>$highlight_end, $msg_data[5] <small>[$msg_data[3]]</small> <br>\n";
	#
	# now initiate recursion
	#
	my $treestring = &processThisNode($msg_data[0],"$rootstring\n",0,$me);
	$treestring .= "\n";
	return $treestring;
}

#
# processThisNode(node_id,resultstring,level,current_id)
# recursion over tree
# modifies global (from this scope) string $res
#
sub processThisNode
{
	my $node = shift; 
	$res = shift;
	my $level = shift;
	my $current = shift;
	my $indent = "";
	++$level;
	my ( $sth,@kid, $elmnt);
	# get all child nodes to this message
	$sth = &udmDB::childs_to_doc($dbh, $node);
	# do some indentation stuff for html output
	for(my $i=0; $i <= $level; ++$i) { $indent .= "&nbsp; &nbsp; &nbsp; &nbsp; "; }
	# now recurse over children
	while(@kid = $sth->fetchrow_array())
	{
		# do some highlighting for the current element
		if($current eq $kid[0])
		{
			$highlight_start = "<b><i>";
			$highlight_end = "</i></b>";
			
		}
		$res .= "$highlight_start $indent <a href=$self?tree=1\&rec_id=$kid[0]>$kid[1]</a>$highlight_end, $kid[3] <small>[$kid[2]]</small> <br>\n";
		$highlight_start = "";
		$highlight_end = "";
		# recurse over child nodes
		&processThisNode($kid[0],$res,$level,$current)
	}
	return $res;
}
# helper
sub escape
{
	my $string = shift;
	$string =~ s/\$/\\\$/g;
	return $string;
}
