/* REXX Script to install Ini2URLs on the desktop */

	call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	call SysLoadFuncs

	rc = SysSetIcon(DIRECTORY() || "\INI2URLS.CMD", "INI2URLS.ICO")
	if SysCreateObject("WPProgram", "Ini2URLs", "<WP_DESKTOP>", "EXENAME=" || DIRECTORY() || "\INI2URLS.CMD", "replace") Then
		Say 'Created the Ini2URLs object on your desktop'
	else do
		Say 'Failed to create the Ini2URLs object on your desktop'
		Exit
	end

	destination = ''
	arg destination
	if destination = '' then do
		destination = '<WP_DESKTOP>'
		resultline = 'Created the folder WebXURLs on the desktop for the URL objects'
	end
	else
		resultline = 'Created the folder WebXURLs for the URL objects'
	

	If SysCreateObject("WPFolder", "My_URLs", destination, "CCVIEW=YES;OBJECTID=<WEBXURLS>;ALWAYSSORT=YES;DEFAULTVIEW=ICON;ICONVIEW=NONFLOWED,MINI", "fail") Then
		Say resultline
	Else Do
		Say 'Could not create the WebXURLs folder.'
		Say 'Send the name of an EXISTING path you wish to put the'
		Say 'URLs into as the first parameter to this program.'
		Say 'If this still does not work, email jroepcke@compusmart.ab.ca'
		Say 'for free support.'
		Exit
	End
	
