/* REXX Script to convert EXPLORE.INI to WebExplorer_Url objects */

	call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	call SysLoadFuncs

	found = 'false'
	call SysQueryClassList "list."
	do i = 1 to list.0
			if left(list.i, 15) = "WebExplorer_Url" Then do
				found = 'true'
				Say 'Found the WebExplorer_Url object class in the WPS Object registy'
			End
		if found = 'true' then
			Leave
	End
            
	if found = 'false' then do
		Say 'The WebExplorer_Url object class is not registered with the'
		Say 'Workplace Shell.  This program cannot continue'
		Say 'email jroepcke@compusmart.ab.ca for free support.'
		Exit
	end

	If SysSetObjectData("<WEBXURLS>", "NOTVISIBLE=NO") Then Do
		Say 'I found your URLs folder and can continue.'
		rc = SysOpenObject("<WEBXURLS>", "Icon", 1)
	End
	Else Do
		Say 'Could not find your URLs folder.  You should run _install.cmd.'
		Say 'email jroepcke@compusmart.ab.ca for free support.'
		Exit
	End


	destination = '<WEBXURLS>'
	homedest = destination
	fspec = ''
	urlname = ''
	urlaref = ''

	fspec = SysSearchPath('ETC', 'Explore.Ini')

	if fspec <> '' Then Do
		rc = stream(fspec, 'c', 'open read')
		if rc <> 'READY:' then do
			Say 'But I cannot open Explore.Ini.  Terminating...'
			Exit
		End

		DO WHILE lineread <> '[quicklist]'
			if stream(fspec, 's') = 'READY' Then
				lineread = LINEIN(fspec)
			else
				Leave
		END
		DO WHILE stream(fspec, 's') = 'READY'
			lineread = ''
			urlname = ''
			urlaref = ''

			tempstring = LINEIN(fspec)
			if tempstring = '' then
				Leave

			urlaref = LINEIN(fspec)	
			if urlaref = '' then
				Leave
			If LEFT(urlaref, 2) <> '--' Then Do
				urlname = SUBSTR(tempstring, 12, length(tempstring) - 11)
				urlname = SPACE(urlname, 1, '_')

				If SysCreateObject("WebExplorer_Url", urlname, destination, "LOCATOR=" || urlaref, "replace") Then
					Say 'Successfully Created the object for ' || urlname
				Else
					Say 'Failure creating object for ' || urlname
			End
			Else Do
				urlname = SUBSTR(tempstring, 12, length(tempstring) - 11)
				urlname = STRIP(urlname, 'B', '-')
				urlname = SPACE(urlname, 1, '_')

				If SysCreateObject("WPFolder", urlname, homedest, "CCVIEW=YES;ALWAYSSORT=YES;DEFAULTVIEW=ICON;ICONVIEW=NONFLOWED,MINI;OBJECTID=<WEBX_" || urlname || "_FOLDER>", "update") Then Do
					Say 'Successfully Created the folder for ' || urlname
					destination = "<WEBX_" || urlname || "_FOLDER>"
				End
				Else
					Say 'Failure creating object for ' || urlname
			End		
		End
		stream(fspec, 'c' 'close')
		Say 'Finished the conversion!  Happy surfing!'
	End
Exit	
