/************************************************************************/
/*      Copyright 1994 by Chuck Musciano and Harris Corporation         */
/*                                                                      */
/*      Full ownership of this software, and all rights pertaining to   */
/*      the for-profit distribution of this software, are retained by   */
/*      Chuck Musciano and Harris Corporation.  You are permitted to    */
/*      use this software without fee.  This software is provided "as   */
/*      is" without express or implied warranty.  You may redistribute  */
/*      this software, provided that this copyright notice is retained, */
/*      and that the software is not distributed for profit.  If you    */
/*      wish to use this software in a profit-making venture, you must  */
/*      first license this code and its underlying technology from      */
/*      Harris Corporation.                                             */
/*                                                                      */
/*      Bottom line: you can have this software, you can use it, you    */
/*      can give it away.  You just can't sell any or all parts of it   */
/*      without prior permission from Harris Corporation.               */
/************************************************************************/

/************************************************************************/
/*                                                                      */
/*      access_count.c  update and print HTML document access counts    */
/*                                                                      */
/************************************************************************/

/* #include        <unistd.h> */
#define         INCL_DOS
#include        <os2.h>
#include        <time.h>
#include        <stdlib.h>
#include        <string.h>
#include        <stdio.h>
#include        <fcntl.h>
#include        <sys\stat.h>
#include        <share.h>
#include        <io.h>

/************************************************************************/
/* Make sure these values are want you need for your system.            */
/************************************************************************/

/************************************************************************/
/* Set COUNTS to the pathname of the file containing the document       */
/* counts.  I put it in a file named ".counts" in my server document    */
/* directory.  Put it anywhere you want; just make sure it is world-    */
/* writable.                                                            */
#define         COUNTS          "\\os2httpd\\docs\\counts"
#define         DCOUNTS         "\\os2httpd\\docs\\dcounts"

/************************************************************************/
/* I have a policy that *my* accesses to my server aren't counted.      */
/* (This seems fairer, don't you think?)  Set IGNORED_HOST to your      */
/* machine's name *as it is presented to your server when you fetch a   */
/* document*.  In my case, that is the unqualified hostname "melmac".   */
/* That is probably the case with your machine, too, but it may not be. */
/* If you notice that the counts are incrementing each time you view a  */
/* page, you got this name wrong.                                       */
/*                                                                      */
/* If you want to count your accesses, too, just define this to be "".  */
/* But don't be bragging about how high your access counts are, either! */
#define         IGNORED_HOST    "abs"

/************************************************************************/
/* It seems a bit quicker to staticly allocate the array of document    */
/* names and counts.  If you have more than this many documents on your */
/* server, change the value accordingly.                                */
#define         MAX_DOCS        1024

/************************************************************************/
/* The code must have exclusive access to the COUNTS file.  If the file */
/* is locked when this program tries to gain access, it will sleep 2    */
/* seconds and then retry this many times.  Making this number smaller  */
/* means you run the risk of not inserting the access count on heavily  */
/* loaded servers; making it larger make increase the time a client     */
/* to get the document.  In practice, unless your server is really      */
/* loaded, you won't get any lock collisions anyway.                    */
#define         RETRIES         5

/************************************************************************/
/* I wrote this code on a System V system (Solaris 2.3, to be exact).   */
/* If you are running on a System V system, leave the following define  */
/* alone.  If you are running a BSD system, comment it out to get the   */
/* correct support for file locking.                                    */
#define         SYSV

/************************************************************************/
/* Everything from here on out should be OK :-)                         */
/************************************************************************/

#ifndef SYSV
#include        <sys/file.h>
#endif

static  int     count[MAX_DOCS];
static  int     tcount[MAX_DOCS];
static  char    *name[MAX_DOCS];
static  char    *today[MAX_DOCS];


int     main(int argc, char **argv)

{       char    *remote_host, *document, buf[512], buf1[512], buf2[512];
        FILE    *f;
        FILE    *ft;
        int     fh=0,fht=0;
        int     i, j, k;
        time_t  ltime;
        char    *str_time;
        char    dow[4], month[4];
        int     day, hour, min, sec, year;
        char    daytoday[10];


        if ((remote_host = getenv("REMOTE_HOST")) == NULL)
           {
           printf("REMOTE_HOST");
           exit(0);
           }

        if ((document = getenv("DOCUMENT_URI")) == NULL)
           {
           printf("DOCUMENT_URI");
           exit(0);
           }

        time(&ltime);
        str_time = ctime(&ltime);
        sscanf(str_time,"%s %s %d %d:%d:%d %d", dow, month, &day, &hour, &min, &sec, &year);
        sprintf(daytoday, "%.3s%02d%04d", month, day, year);



        for (i=0; i<RETRIES && fh <= 0; i++) {
           fh = _sopen(COUNTS, O_RDWR | O_TEXT, SH_DENYWR);

           if (fh <= 0)
              DosSleep(100);

        } /* endfor */


        if (fh > 0 && (f = _fdopen(fh, "r+"))) {

              for (i = 0; i < MAX_DOCS && fgets(buf, 512, f); i++)
                 if (sscanf(buf, "%d %s %d %s", &count[i], buf1, &tcount[i], buf2) == 4)
                    {
                    name[i] = strdup(buf1);
                    today[i] = strdup(buf2);
                    }

              for (j = 0; j < i; j++)
                 if (name[j] && stricmp(document, name[j]) == 0)
                    break;

              if (j >= i) {
                 name[j]   = document;
                 today[j]  = daytoday;
                 count[j]  = 0;
                 tcount[j] = 0;
                 i++;
                 }



              if (today[j] && strcmp(today[j], daytoday) != 0)
                {
                sprintf(daytoday, "%.3s %02d %04d", month, day, year);

                ft = fopen(DCOUNTS, "a+");
                fprintf(ft, "%s, %8d, %s, %8d, %-3.3s %-2.2s %-4.4s\n", daytoday, count[j], name[j], tcount[j], &today[j][0], &today[j][3], &today[j][5]);
                fclose(ft);

                sprintf(today[j], "%.3s%02d%04d", month, day, year);
                tcount[j] = 0;
                } /* endif */

              if (strcmp(remote_host, IGNORED_HOST) != 0)
                 {
                 count[j]++;
                 tcount[j]++;
                 }

              rewind(f);
              for (k = 0; k < i; k++)
                 fprintf(f, "%8d %s %8d %s\n", count[k], name[k], tcount[k], today[k]);
              rewind(f);
              fclose(f);

              if (argc <= 1 || (argc > 1 && argv[1][0] != 'N')) {
                if (tcount[j] > 999999)
                   printf("%d,%03d,%03d", tcount[j] / 1000000, (tcount[j] % 1000000) / 1000, tcount[j] % 1000);
                else if (tcount[j] > 999)
                   printf("%d,%03d", tcount[j] / 1000, tcount[j] % 1000);
                else
                   printf("%d", tcount[j]);
                printf(" access%s today. ", tcount[j] != 1? "es" : "");
              } /* endif */

              if (count[j] > 999999)
                 printf("%d,%03d,%03d", count[j] / 1000000, (count[j] % 1000000) / 1000, count[j] % 1000);
              else if (count[j] > 999)
                 printf("%d,%03d", count[j] / 1000, count[j] % 1000);
              else
                 printf("%d", count[j]);
              printf(" Total access%s.", count[j] != 1? "es" : "");
           }
        exit(0);
}
