/***************************************************************************
 *  CGI-BIN - REXX script for CGI Interface
 *
 *  Author:  Andy Wysocki <awysocki@bearsoft.com> 04/11/95
 *
 *  $Header$
 *
 *  $Log$
 **************************************************************************/
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs


/*------------------------------------------------------*/
/* Global Variables                                     */
/*------------------------------------------------------*/
env = "OS2ENVIRONMENT"
maillog = '..\logs\email.log'
trailer = '..\docs\abs.html'
sendtof = '\OS2HTTPD\MAIL\mail????.fil'
hello   = '\OS2HTTPD\MAIL\welcome.txt'
e_sup   = 'xxx@network.com'          /* Who supports e-mail requests         */
e_from  = 'xxx@network.com'


/*------------------------------------------------------*/
/* Parse the Input                                      */
/*------------------------------------------------------*/
  PI_rc=1               /* Set up a BAD return code     */
  Call ParInp

/*------------------------------------------------------*/
/* Do any checking of PARM here                         */
/*------------------------------------------------------*/



/*------------------------------------------------------*/
/* Write to a LOG file                                  */
/*------------------------------------------------------*/
  junk = Lineout(maillog, '----------------------------')
  junk = Lineout(maillog, 'Date Posted: ' || date() || '  ' || time())
  junk = Lineout(maillog, name)
  junk = Lineout(maillog, addr1)
  junk = Lineout(maillog, addr2)
  junk = Lineout(maillog, city || ', ' || state || ' ' || zip)
  junk = Lineout(maillog, phone)
  junk = Lineout(maillog, email)
  junk = Lineout(maillog, mailtype)
  junk = Lineout(maillog, ' ')
  junk = Lineout(maillog)



/*------------------------------------------------------*/
/* Create the E-Mail file                               */
/*------------------------------------------------------*/

  sendto=SysTempFileName(sendtof)

  junk = Lineout(sendto, 'To: ' || e_sup)
  junk = Lineout(sendto, 'From:' || e_from)
  junk = Lineout(sendto, 'Subject: Information Request')
  junk = Lineout(sendto, 'Date: ' || date() || ' ' || time())
  junk = Lineout(sendto, '--------------------------------------')

/*------------------------------------------------------*/
/* Copy in some generic text                            */
/*------------------------------------------------------*/
  linecount = 0
  linecount = Linein(hello)
  DO linecount
    junk = Linein(hello)
    junk = Lineout(sendto, junk)
  END

  junl = Lineout(sendto)                /* Close the file               */

/*------------------------------------------------------*/
/* Create the .CMD file for the                         */
/* WATCHDOG process to execute                          */
/* YOU SHOULDN'T HAVE TO CHANGE THIS!!!!!               */
/*------------------------------------------------------*/
  mailfile = sendto
  sendto = OVERLAY('cmd', sendto ,LENGTH(sendto) - 2)
  junk = Lineout(sendto, '/* REXX Send Mail to */')
  junk = "'sendmail -af " mailfile ' -t -f' e_from "'"
  junk = Lineout(sendto, junk)
  junk = Lineout(sendto, "'@del " || mailfile || "'")
  junk = Lineout(sendto, "'@del " || sendto   || "'")
  junk = Lineout(sendto)



/*------------------------------------------------------*/
/* Now set up the HTML to send back                     */
/*------------------------------------------------------*/
  Say "Content-type: text/html"
  Say

  Say '<HTML>'
  Say '<TITLE>Request for Information</TITLE>'
  Say '<HR>'
  Say '<IMG SRC="/icons/info.gif" ALIGN=CENTER>'
  Say '<H2>Thank you <I>' || name || '</I>, your information has been logged...</H2>'

  Say '<ADDRESS>'
    Say name        || br
    Say addr1       || br
    Say addr2       || br
    Say city || ', ' || state || ' ' || zip || br
    Say phone       || br
    Say email       || br
    Say mailtype    || br
  Say '</ADDRESS>'



  Say '<H3><I>'
  Say 'Thank you for your input.'
  Say '</I></H3>'



/*------------------------------------------------------*/
/* Write out the Trailer information                    */
/* this stuff doesn't have any sub. variables           */
/*------------------------------------------------------*/
i = 0
DO WHILE i = 0
  outstr = LINEIN(trailer)
  IF outstr <> '' THEN
    Say outstr
  ELSE
    i = 1
END

  Say '</HTML>'
  Say
  Say
RETURN

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/* DO NOT CHANGE ANY FUNCTION FROM THIS POINT ON !!!!!!!                     */
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/* PARSEINPUT : Parse the input string                                       */
/*                                                                           */
/* PI_fields = List of Fields in the CGI Script                              */
/* PI_rc     = Return code                                                   */
/*                                                                           */
/*                                                                           */
/*                                                                           */
/*---------------------------------------------------------------------------*/
ParInp:

  method = value("REQUEST_METHOD",,env)

  IF (method == "GET") Then
    Do
    PI_input = value("QUERY_STRING",,env)
    PI_inputlen = LENGTH(PI_input)
    PI_rc = 0
    End

  ELSE IF (method == "POST") Then
    Do
    PI_inputlen = VALUE("CONTENT_LENGTH",,env)
    PI_input = CHARIN('STDIN:', , PI_inputlen)
    PI_rc = 0
    End

  ELSE
    Do
    PI_rc = 1
    RETURN
    End

  PI_fields = ''
  PI_findfrom = 1

  '@if exist ' savereq 'del ' savereq
  PI_junk = Lineout(savereq, PI_input, 1)

  PI_pos = POS('&', PI_input, PI_findfrom)

  IF PI_pos <> 0 THEN
    DO
      DO WHILE PI_pos <> 0

        PI_pv = SUBSTR(PI_input, PI_findfrom, PI_pos - PI_findfrom)

        PARSE VAR PI_pv PI_name '=' PI_value

        CALL PI_CvtStr

        PI_junk = VALUE(PI_name, PI_value)
        PI_fields = PI_fields || PI_name || ' '

        PI_findfrom = PI_pos + 1

        PI_pos = POS('&', PI_input, PI_findfrom)

      END

      PI_pv = SUBSTR(PI_input, PI_findfrom, PI_inputlen - PI_findfrom + 1)
    END
  ELSE
    DO
      PI_pv = PI_input
    END

  PARSE VAR PI_pv PI_name '=' PI_value

  CALL PI_CvtStr

  PI_junk = VALUE(PI_name, PI_value)
  PI_fields = PI_fields || PI_name || ' '


  PI_w = 1
  DO WHILE WORD(PI_fields, PI_w) <> ''
    PI_name = WORD(PI_fields, PI_w)
    PI_w = PI_w + 1
  END
RETURN

/*---------------------------------------------------------------------------*/
/* PI_CVTSTR - Remove '+' and % signs                                        */
/*---------------------------------------------------------------------------*/
PI_CvtStr:

  CS_start = 1

  CS_pos = POS('%', PI_value, CS_start)
  DO WHILE CS_pos <> 0

    PI_value = OVERLAY(X2C(SUBSTR(PI_value, CS_pos + 1, 2)), PI_value, CS_pos)
    PI_value = DELSTR(PI_value, CS_pos+1, 2)
    CS_start = CS_pos+1
    CS_pos = POS('%', PI_value, CS_start)

  END

  PI_Value = TRANSLATE(PI_Value, ' ', '+')
  PI_Value = TRANSLATE(PI_Value, ' ', D2C(13))
  PI_Value = TRANSLATE(PI_Value, ' ', D2C(10))


RETURN
/* End of the REXX Program */
