/***************************************************************************
 *  TEST-CGI.CMD - a REXX script to test CGI interface
 *
 *  Author:  Frankie Fan <kfan@netcom.com>  7/11/94
 *
 *  $Header$
 *
 *  $Log$
 **************************************************************************/
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Parse Arg Argv

env = "OS2ENVIRONMENT"
vtab = ""
lead = "<LI>"
Argc = Words(Argv)



Say "Content-type: text/html"
Say

Say "<H1>CGI/1.0 test script report:</H1>"  || vtab

Say "<UL>"

Say lead || "argc = " Argc || vtab
Say lead || "argv = " Argv || vtab
Say lead || "SERVER_SOFTWARE = " value("SERVER_SOFTWARE",,env) || vtab
Say lead || "SERVER_NAME = " value("SERVER_NAME",,env) || vtab
Say lead || "GATEWAY_INTERFACE = " value("GATEWAY_INTERFACE",,env) || vtab
Say lead || "SERVER_PROTOCOL = " value("SERVER_PROTOCOL",,env) || vtab
Say lead || "SERVER_PORT = " value("SERVER_PORT",,env) || vtab
Say lead || "REQUEST_METHOD = " value("REQUEST_METHOD",,env) || vtab
Say lead || "HTTP_ACCEPT = " value("HTTP_ACCEPT",,env) || vtab
Say lead || "PATH_INFO = " value("PATH_INFO",,env) || vtab
Say lead || "PATH_TRANSLATED = " value("PATH_TRANSLATED",,env) || vtab
Say lead || "SCRIPT_NAME = " value("SCRIPT_NAME",,env) || vtab
Say lead || "QUERY_STRING = " value("QUERY_STRING",,env) || vtab
Say lead || "REMOTE_HOST = " value("REMOTE_HOST",,env) || vtab
Say lead || "REMOTE_ADDR = " value("REMOTE_ADDR",,env) || vtab
Say lead || "REMOTE_USER = " value("REMOTE_USER",,env) || vtab
Say lead || "AUTH_TYPE = " value("AUTH_TYPE",,env) || vtab
Say lead || "LAST_MODIFIED = " value("LAST_MODIFIED",,env) || vtab
Say lead || "CONTENT_TYPE = " value("CONTENT_TYPE",,env) || vtab
len = value("CONTENT_LENGTH",,env)
Say lead || "CONTENT_LENGTH = " || len || vtab

method = value("REQUEST_METHOD",,env)
Say "</UL>"

  Call ParInp

Say "Fields parsed = " || PI_fields


RETURN

/*---------------------------------------------------------------------------*/
/* PARSEINPUT : Parse the input string                                       */
/*---------------------------------------------------------------------------*/
ParInp:

  PI_method = value("REQUEST_METHOD",,env)

  IF (PI_method == "GET") Then
    Do
    PI_input = value("QUERY_STRING",,env)
    PI_inputlen = LENGTH(PI_input)
    PI_rc = 0
    End

  ELSE IF (PI_method == "POST") Then
    Do
    PI_inputlen = VALUE("CONTENT_LENGTH",,env)
    PI_input = CHARIN('STDIN:', , PI_inputlen)
    PI_rc = 0
    End

  ELSE
    Do
    PI_rc = 1
    RETURN
    End

  IF PI_inputlen == 0 THEN
    RETURN


  PI_fields = ''
  PI_findfrom = 1

  '@if exist ' savereq 'del ' savereq
  PI_junk = Lineout(savereq, PI_input, 1)

  PI_pos = POS('&', PI_input, PI_findfrom)

  IF PI_pos <> 0 THEN
    DO
      DO WHILE PI_pos <> 0

        PI_pv = SUBSTR(PI_input, PI_findfrom, PI_pos - PI_findfrom)

        PARSE VAR PI_pv PI_name '=' PI_value

        CALL PI_CvtStr

        PI_junk = VALUE(PI_name, PI_value)
        PI_fields = PI_fields || PI_name || ' '

        PI_findfrom = PI_pos + 1

        PI_pos = POS('&', PI_input, PI_findfrom)

      END

      PI_pv = SUBSTR(PI_input, PI_findfrom, PI_inputlen - PI_findfrom + 1)
    END
  ELSE
    DO
      PI_pv = PI_input
    END

  PARSE VAR PI_pv PI_name '=' PI_value

  CALL PI_CvtStr

  PI_junk = VALUE(PI_name, PI_value)
  PI_fields = PI_fields || PI_name || ' '


  PI_w = 1
  DO WHILE WORD(PI_fields, PI_w) <> ''
    PI_name = WORD(PI_fields, PI_w)
    PI_w = PI_w + 1
  END
RETURN

/*---------------------------------------------------------------------------*/
/* PI_CVTSTR - Remove '+' and % signs                                        */
/*---------------------------------------------------------------------------*/
PI_CvtStr:

  CS_start = 1

  PI_Value = TRANSLATE(PI_Value, ' ', '+')
  PI_Value = TRANSLATE(PI_Value, ' ', D2C(13))
  PI_Value = TRANSLATE(PI_Value, ' ', D2C(10))


  CS_pos = POS('%', PI_value, CS_start)
  DO WHILE CS_pos <> 0

    PI_value = OVERLAY(X2C(SUBSTR(PI_value, CS_pos + 1, 2)), PI_value, CS_pos)
    PI_value = DELSTR(PI_value, CS_pos+1, 2)
    CS_start = CS_pos+1
    CS_pos = POS('%', PI_value, CS_start)

  END


RETURN
/* End of the REXX Program */

