/*
** RCS_ID = $Id: config.h,v 1.3 1999/02/25 17:58:10 siebert Exp $
**
** config.h	per-site configuration for http-analyze.
**
** Copyright  1996, 1997 by Stefan Stapelberg, <stefan@rent-a-guru.de>
**
*/

/*
** Macros for customization
**
** NO_GETHOSTNAME
**	Don't use gethostname(2) to obtain the system name.
**	Normally, http-analyze tries to obtain the server
**	name using gethostname(3), since this function returns
**	the full qualified domain name if the system is set up
**	properly. Define this macro if your system does not
**	have the gethostname function.
**
** NO_UNAME
**	Don't use uname(2) to obtain system name and platform/OS.
**	This functions also returns the system name, but without
**	domain. Define this macro if you have no uname(2) function.
**	neither uname nor gethostname is available, you can still
**	set the server name via the -S command line option.
**
** FAST_CTYPE
**	If defined, use own character classification functions
**	rather than them from the C stdlib. On an Indy our own
**	functions are much faster than the ones from the stdlib.
**
** USE_FGETS
**	Use fgets(3) from the stdlib to read lines. If left
**	undefined, the program uses a highly optimized read
**	function which processes its input in big chunks.
**	The following two macros are significant only if
**	USE_FGETS is left undefined.
**
** USE_STBLKSIZE
**	If stat(2) returns a st_blksize (best I/O block size)
**	field, use it's value for the size of the I/O buffer.
**	
** BEST_IO_SIZE  (1024*64)
**	Defines best size for the I/O buffers. Although
**	it can be any value between 1024 and the biggest
**	number of bytes your system can transfer per read(2)
**	system call, it should not be smaller than the line
**	buffer size (currently 10KB). If left undefined,
**	the default of 64KB is used for BEST_IO_SIZE. If
**	USE_STBLKSIZE is defined also, http-analyze uses
**	stat(2) to dynamically adapt to the best I/O size
**	dependent of the actual input stream (file/pipe).
**
** VRML
**	Include code for generation of VRML model.
**	May be set to the following values:
**	  (defined)	include VRML code
**	  OLD_LAYOUT	use old layout (two separate VRML models)
**	Note: The type of the window (extern/intern) is now defined
**	by an option or a configureation setting.
**
** LOGF_DEFAULT
**	Defines the default format of the logfile. Usually
**	set in the config file or via command line option.
**	If left undefined, http-analyze tries to recognize
**	the Common Logfile Format (CLF) and the Extended
**	Logfile Format (ELF) automatically. Therefore you
**	do not need to define this macro.
**
** TIME_STATS
**	If defined includes code for performance analysis.
**
**
** Supporting functions in support.c (define the appropriate
** macro to include them):
**
** NEED_GETOPT		include own getopt(3)
** NEED_STRCASECMP	include own strcasecmp(3)
** NEED_STRERROR	include own strerror(3)
** NEED_WAITPID		simulate waitpid(2)
*/

/*
** Predefined configurations:
**	IRIX	SGI IRIX 5.X/6.X/7.X
**	SVR4	System V Release 4
**	SYSV	System V
**	linux	Linux
**	BSD	BSD flavours
**	HPUX	HP's Unix
**	SUN	SunOS/Solaris
**
** Compatibility kludges:
**	NOT_REALLY_ANSI_C on SunOS/gcc combinations:
**		lacks strerror(3)
*/

#define VRML

#if defined(IRIX) || defined(SVR4)
# define USE_STBLKSIZE
# define FAST_CTYPE
# define MEMCMP_FASTER_STRCMP

#elif defined(SVR4)
# define USE_STBLKSIZE
# define FAST_CTYPE

#elif defined(SVR3)
# define USE_FGETS
# define FAST_CTYPE
# define NO_GETHOSTNAME
# define NEED_STRERROR
# define NEED_STRCASECMP
# define NEED_WAITPID

#elif defined(linux)
# define USE_STBLKSIZE
# define FAST_CTYPE

#elif defined(BSD)
# define USE_STBLKSIZE
# define FAST_CTYPE

#elif defined(HPUX)
# define USE_STBLKSIZE
# define FAST_CTYPE

#elif defined(SUN)
# define USE_STBLKSIZE
# define FAST_CTYPE
# if defined(NOT_REALLY_ANSI_C)
#  define NEED_STRERROR
# endif

#elif defined(__NT__) || defined(WIN32)
# undef  WIN32
# define WIN32
# define NEED_GETOPT
# define NO_UNAME

/* Note: the NETWARE port is not supported yet */
#elif defined(__NETWARE__) || defined(NETWARE)
# undef  NETWARE
# define NETWARE
# define NEED_GETOPT
# define NO_UNAME

#elif defined(__EMX__)
# define FAST_CTYPE
# define NO_GETHOSTNAME
# undef  NO_UNAME
# undef  USE_FGETS
# undef  USE_STBLKSIZE
# define BEST_IO_SIZE (1024*64)
# undef  NEED_GETOPT
# undef  NEED_STRCASECMP
# undef  NEED_STRERROR
# undef  NEED_WAITPID

#elif defined(configure_your_platform_here)
# define FAST_CTYPE
# define NO_GETHOSTNAME
# undef  NO_UNAME
# undef  USE_FGETS
# define USE_STBLKSIZE
# define BEST_IO_SIZE (1024*64)
# undef  NEED_GETOPT
# undef  NEED_STRCASECMP
# undef  NEED_STRERROR
# undef  NEED_WAITPID

#else
# error "Define the appropriate platform in the Makefile: IRIX/SVR4/SYSV/BSD/HPUX/SUN/linux/WIN32/OS2"
#endif

#if !defined(HA_LIBDIR)
# define HA_LIBDIR	"/usr/local/lib/http-analyze"
#endif

#if !defined(WIN32)
# define REGID_FILE	"REGID"
#else
# define REGID_FILE	"SOFTWARE\\Rent-A-Guru\\Http-Analyze 2.2"
#endif

/* End of user configuration section. */
