/*
 * Decompiled with CFR 0.152.
 */
package hfalk.print;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;

public class PrintDocument {
    private Frame frame;
    PrintJob pjob;
    public Dimension pageDimension;
    private Graphics pg;
    String defaultFontName;
    int defaultFontStyle;
    int defaultFontSize;
    String appName;
    boolean hasHeader;
    String headerLeft;
    String headerRight;
    boolean hasFooter;
    String footerLeft;
    String footerRight;

    public PrintDocument(Frame frame, String string) throws Exception {
        this.frame = frame;
        this.pjob = this.frame.getToolkit().getPrintJob(this.frame, string, null);
        if (this.pjob == null) {
            throw new Exception("Could not allocate printjob!");
        }
        this.hasHeader = false;
        this.hasFooter = false;
        this.defaultFontName = "SansSerif";
        this.defaultFontStyle = 0;
        this.defaultFontSize = 12;
    }

    public PrintDocument(Frame frame, String string, String string2) throws Exception {
        this.frame = frame;
        this.pjob = this.frame.getToolkit().getPrintJob(this.frame, string, null);
        if (this.pjob == null) {
            throw new Exception("Could not allocate printjob!");
        }
        this.hasHeader = false;
        this.hasFooter = false;
        this.defaultFontName = "SansSerif";
        this.defaultFontStyle = 0;
        this.defaultFontSize = 12;
    }

    public boolean newPage() {
        if (this.pjob != null) {
            this.pg = this.pjob.getGraphics();
            if (this.pg != null) {
                this.pageDimension = this.pjob.getPageDimension();
            } else {
                System.out.println("Could not get graphic context!");
                this.pjob = null;
            }
            Font font = new Font("SansSerif", 0, 12);
            this.pg.setFont(font);
            this.pg.setColor(Color.black);
            FontMetrics fontMetrics = this.pg.getFontMetrics(font);
            String string = this.appName != null ? String.valueOf(this.appName) + " - (c)Henrik Falk Software 1998" : "(c)Henrik Falk Software 1998";
            int n = fontMetrics.stringWidth(string);
            this.pg.drawString(string, this.pageDimension.width / 2 - n / 2, this.pageDimension.height - 30);
        }
        return true;
    }

    public boolean setHeader(String string, String string2) {
        this.headerLeft = string;
        this.headerRight = string2;
        this.hasHeader = true;
        return true;
    }

    public boolean setFooter(String string, String string2) {
        this.footerLeft = string;
        this.footerRight = string2;
        this.hasFooter = true;
        return true;
    }

    public void printHeader() {
        Font font = new Font("SansSerif", 0, 12);
        this.pg.setFont(font);
        this.pg.setColor(Color.black);
        FontMetrics fontMetrics = this.pg.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        this.pg.drawLine(70, 10 + n + 8, this.pageDimension.width - 40, 10 + n + 8);
        this.pg.drawString(this.headerLeft, 74, 10 + n + 4);
        int n2 = fontMetrics.stringWidth(this.headerRight) + 4;
        this.pg.drawString(this.headerRight, this.pageDimension.width - 40 - n2, 10 + n + 4);
    }

    public void printFooter() {
        Font font = new Font("SansSerif", 0, 12);
        this.pg.setFont(font);
        this.pg.setColor(Color.black);
        FontMetrics fontMetrics = this.pg.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        this.pg.drawLine(70, this.pageDimension.height - 70, this.pageDimension.width - 40, this.pageDimension.height - 70);
        this.pg.drawString(this.footerLeft, 74, this.pageDimension.height - 70 + n + 4);
        int n2 = fontMetrics.stringWidth(this.footerRight) + 4;
        this.pg.drawString(this.footerRight, this.pageDimension.width - 40 - n2, this.pageDimension.height - 70 + n + 4);
    }

    public void formFeed() {
        this.pg.dispose();
    }

    public void print() {
        this.pjob.end();
    }

    public Graphics getGraphics() {
        if (this.pjob != null) {
            return this.pg;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.pjob != null) {
            return new Rectangle(70, 40, this.pageDimension.width - 110, this.pageDimension.height - 50 - 70);
        }
        return null;
    }

    public void setApplicationName(String string) {
        this.appName = string;
    }
}

